/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.dsig.ExclusiveCanonicalizer;
import com.ibm.ws.wssecurity.dsig.STRDTKeyInfoResolver;
import com.ibm.ws.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STRDereferenceTransformer
extends Transform {
    private static final TraceComponent tc = Tr.register(STRDereferenceTransformer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = STRDereferenceTransformer.class.getName();
    private static final QName ALGORITHM_Q = new QName("", "Algorithm");
    private static final QName PREFIXLIST_Q = new QName("", "PrefixList");
    private static final QName URI_Q = new QName("", "URI");
    private static final QName VALUETYPE_Q = new QName("", "ValueType");
    public static final String STRT = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
    private String _nsWsse = Constants.NS_WSSE;
    private OMDocument _document;
    private IDResolver _idResolver;
    private STRDTKeyInfoResolver _kiResolver;
    private String _c14nMethod;
    private Hashtable _prefixList;

    @Override
    public String getURI() {
        return STRT;
    }

    @Override
    public OMElement createTransformElement(OMFactory oMFactory, IndentConfig indentConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTransformElement(OMFactory factory[" + oMFactory + "]," + "IndentConfig iconf[" + indentConfig + "])");
        }
        OMElement oMElement = super.createTransformElement(oMFactory, indentConfig);
        if (this._c14nMethod != null) {
            Object object;
            Object object2 = null;
            if (("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this._c14nMethod) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this._c14nMethod)) && this._prefixList != null) {
                object = ExclusiveCanonicalizer.serializePrefixList(this._prefixList);
                object2 = oMFactory.createOMElement("InclusiveNamespaces", "http://www.w3.org/2001/10/xml-exc-c14n#", "");
                object2.declareDefaultNamespace("http://www.w3.org/2001/10/xml-exc-c14n#");
                object2.addAttribute("PrefixList", (String)object, null);
            }
            object = oMFactory.createOMElement("CanonicalizationMethod", Constants.NS_DSIG, "");
            object.addAttribute("Algorithm", this._c14nMethod, null);
            if (object2 != null) {
                object.addChild((OMNode)object2);
            }
            object2 = object;
            String string = DOMUtils.getNamespacePrefix(oMElement, this._nsWsse);
            boolean bl = false;
            if (string == null) {
                string = "wsse";
                bl = true;
            }
            object = oMFactory.createOMElement("TransformationParameters", this._nsWsse, string);
            if (bl) {
                object.declareNamespace(this._nsWsse, "wsse");
            }
            object.addChild((OMNode)object2);
            oMElement.addChild((OMNode)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTransformElement(OMFactory factory,IndentConfig iconf) returns Element[" + oMElement + "]");
        }
        return oMElement;
    }

    @Override
    public void setParameter(OMNode oMNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter(OMNode node[" + DOMUtils.getDisplayName(oMNode) + "])");
        }
        this._c14nMethod = null;
        this._prefixList = null;
        for (OMNode oMNode2 = oMNode; oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
            String string;
            String string2;
            OMElement oMElement;
            if (oMNode2.getType() != 1 || !DOMUtils.equals(oMElement = (OMElement)oMNode2, string2 = this._nsWsse, string = "TransformationParameters")) continue;
            OMElement oMElement2 = DOMUtils.getFirstElement(oMElement);
            while (oMElement2 != null) {
                string2 = Constants.NS_DSIG;
                string = "CanonicalizationMethod";
                if (DOMUtils.equals(oMElement2, string2, string)) {
                    this._c14nMethod = oMElement2.getAttributeValue(ALGORITHM_Q);
                    if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this._c14nMethod) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this._c14nMethod)) {
                        OMElement oMElement3 = DOMUtils.getFirstElement(oMElement2);
                        while (oMElement3 != null) {
                            string2 = "http://www.w3.org/2001/10/xml-exc-c14n#";
                            string = "InclusiveNamespaces";
                            if (DOMUtils.equals(oMElement3, string2, string)) {
                                String string3 = oMElement3.getAttributeValue(PREFIXLIST_Q);
                                this._prefixList = ExclusiveCanonicalizer.parsePrefixList(string3);
                            }
                            oMElement3 = DOMUtils.getNextElement(oMElement3);
                        }
                    }
                }
                oMElement2 = DOMUtils.getNextElement(oMElement2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter(OMNode node)");
        }
    }

    @Override
    public void transform(TransformContext transformContext) throws TransformException {
        Object object;
        SignatureContext signatureContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transform(TransformContext context[" + transformContext + "])");
        }
        if ((signatureContext = transformContext.getSignatureContext()) instanceof WSSSignatureContext) {
            object = (WSSSignatureContext)signatureContext;
            this._document = ((WSSSignatureContext)object).getDocument();
            this._idResolver = ((SignatureContext)object).getIDResolver();
            this._kiResolver = ((WSSSignatureContext)object).getSTRDTKeyInfoResolver();
            int n = ((WSSSignatureContext)object).getWssVersion();
            this._nsWsse = Constants.NAMESPACES[0][n];
        }
        object = null;
        switch (transformContext.getType()) {
            case 0: 
            case 1: {
                object = XPathCanonicalizer.toNodeset(transformContext.getDocument().getOMDocumentElement(), null, true);
                break;
            }
            case 3: {
                object = XPathCanonicalizer.toNodeset(transformContext.getNode(), null, true);
                break;
            }
            case 2: {
                object = transformContext.getNodeset();
            }
        }
        byte[] byArray = null;
        if (object != null) {
            this.typeCheck((ArrayList)object);
            try {
                byArray = this.transform((ArrayList)object);
            }
            catch (RuntimeException runtimeException) {
                Tr.processException((Throwable)runtimeException, clsName + ".transform", "215", this);
                throw runtimeException;
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, clsName + ".transform", "218", this);
                throw TransformException.create(exception);
            }
        }
        transformContext.setContent(byArray, "UTF-8");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transform(TransformContext context)");
        }
    }

    private byte[] transform(ArrayList arrayList) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transform(ArrayList nodeSet[" + arrayList + "])");
        }
        Map<OMNode, ArrayList> map = this.dereferenceSTR(arrayList);
        byte[] byArray = this.serializeNodeSet(arrayList, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transform(ArrayList nodeSet)");
        }
        return byArray;
    }

    private Map<OMNode, ArrayList> dereferenceSTR(ArrayList arrayList) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceSTR(NodeList nodeSet[" + arrayList + "])");
        }
        HashMap<OMNode, ArrayList> hashMap = new HashMap<OMNode, ArrayList>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            OMElement oMElement;
            Object e = arrayList.get(i);
            if (!(e instanceof OMElement) || !DOMUtils.equals(oMElement = (OMElement)e, Constants.NS_WSSE, "SecurityTokenReference")) continue;
            ArrayList<OMNode> arrayList2 = this.dereferenceSTR(oMElement);
            arrayList2 = this.convertToNodeSet(arrayList2);
            hashMap.put(oMElement, arrayList2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceSTR(NodeList nodeSet), returns Map[" + hashMap + "]");
        }
        return hashMap;
    }

    private byte[] serializeNodeSet(ArrayList arrayList, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeNodeSet(ArrayList nodeSet[" + arrayList + "]," + "Map replNodeSets[" + map + "])");
        }
        byte[] byArray = null;
        if (this._c14nMethod == null) {
            throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s01");
        }
        if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(this._c14nMethod)) {
            byArray = Canonicalizer.serializeSubset(arrayList, false, map);
        } else if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments".equals(this._c14nMethod)) {
            byArray = Canonicalizer.serializeSubset(arrayList, true, map);
        } else if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this._c14nMethod)) {
            byArray = ExclusiveCanonicalizer.serializeSubset(this._prefixList, arrayList, false, map);
        } else if ("http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this._c14nMethod)) {
            byArray = ExclusiveCanonicalizer.serializeSubset(this._prefixList, arrayList, true, map);
        } else {
            throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s02", this._c14nMethod);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeNodeSet(ArrayList nodeSet, Map replNodeSets)");
        }
        return byArray;
    }

    private ArrayList dereferenceSTR(OMElement oMElement) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceSTR(OMElement secTokenRef[" + DOMUtils.getDisplayName(oMElement) + "])");
        }
        Object object = this.dereferenceToST(oMElement);
        ArrayList arrayList = this.wrapInNodeList(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceSTR(OMElement secTokenRef)");
        }
        return arrayList;
    }

    private Object dereferenceToST(OMElement oMElement) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceToST(OMElement secTokenRef[" + DOMUtils.getDisplayName(oMElement) + "])");
        }
        Object object = null;
        OMElement oMElement2 = DOMUtils.getFirstElement(oMElement);
        if (DOMUtils.equals(oMElement2, this._nsWsse, "Embedded")) {
            object = this.dereferenceEmbedded(oMElement2);
        } else if (DOMUtils.equals(oMElement2, this._nsWsse, "Reference")) {
            object = this.dereferenceReference(oMElement2);
        } else if (DOMUtils.equals(oMElement2, this._nsWsse, "KeyIdentifier")) {
            object = this.dereferenceOthers(oMElement, "KEYID");
        } else if (DOMUtils.equals(oMElement2, Constants.NS_DSIG, "X509Data")) {
            object = this.dereferenceOthers(oMElement, "X509ISSUER");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceToST(OMElement secTokenRef)");
        }
        return object;
    }

    private ArrayList<OMNode> dereferenceEmbedded(OMElement oMElement) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceEmbedded(OMElement embedded[" + DOMUtils.getDisplayName(oMElement) + "])");
        }
        ArrayList<OMNode> arrayList = null;
        for (OMNode oMNode = oMElement.getFirstOMChild(); oMNode != null; oMNode = oMNode.getNextOMSibling()) {
            if (arrayList == null) {
                arrayList = new ArrayList<OMNode>();
            }
            arrayList.add(oMNode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceEmbedded(OMElement embedded) returns Object[" + arrayList + "]");
        }
        return arrayList;
    }

    private OMElement dereferenceReference(OMElement oMElement) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceReference(Element ref[" + DOMUtils.getDisplayName(oMElement) + "])");
        }
        String string = null;
        string = oMElement.getAttributeValue(URI_Q);
        QName qName = null;
        qName = DOMUtils.getQName(oMElement, oMElement.getAttributeValue(VALUETYPE_Q));
        OMElement oMElement2 = this.resolveURI(string, qName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceReference(Element ref) returns OMElement[" + oMElement2 + "]");
        }
        return oMElement2;
    }

    private OMElement resolveURI(String string, QName qName) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveURI(String uri[" + string + "]," + "QName valType[" + qName + "])");
        }
        OMElement oMElement = null;
        if (string != null) {
            if (string.length() < 2 || string.charAt(0) != '#') {
                throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s04", string);
            }
            String string2 = string.substring(1);
            if (this._idResolver == null) {
                throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s03");
            }
            OMElement oMElement2 = this._idResolver.resolveID(this._document, string2);
            if (oMElement2 != null) {
                oMElement = oMElement2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveURI(String uri, QName valType) returns OMElement[" + oMElement + "]");
        }
        return oMElement;
    }

    private OMElement dereferenceOthers(OMElement oMElement, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceOthers(OMElement secTokenRef[" + DOMUtils.getDisplayName(oMElement) + "]," + "String keyInfoType[" + string + "])");
        }
        OMElement oMElement2 = null;
        if (this._kiResolver != null) {
            oMElement2 = this._kiResolver.resolve(oMElement, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceOthers(OMElement secTokenRef,String keyInfoType) returns OMElement[" + oMElement2 + "]");
        }
        return oMElement2;
    }

    private ArrayList wrapInNodeList(Object object) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "wrapInNodeList(Object secToken[" + object + "])");
        }
        ArrayList<OMElement> arrayList = null;
        if (object instanceof OMElement) {
            ArrayList<OMElement> arrayList2 = new ArrayList<OMElement>(1);
            arrayList2.add((OMElement)object);
            arrayList = arrayList2;
        } else if (object instanceof ArrayList) {
            arrayList = (ArrayList<OMElement>)object;
        } else {
            throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s05");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "wrapInNodeList(Object secToken) returns ArrayList[" + arrayList + "]");
        }
        return arrayList;
    }

    private ArrayList<OMNode> convertToNodeSet(ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToNodeSet(ArrayList apexNodes[" + arrayList + "])");
        }
        ArrayList<OMNode> arrayList2 = new ArrayList<OMNode>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList3 = XPathCanonicalizer.toNodeset((OMNode)arrayList.get(i), null, true);
            int n2 = arrayList3.size();
            for (int j = 0; j < n2; ++j) {
                arrayList2.add((OMNode)arrayList3.get(j));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToNodeSet(ArrayList apexNodes) returns ArrayList[" + arrayList2 + "]");
        }
        return arrayList2;
    }

    private void typeCheck(ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "typeIsOk(ArrayList nodeset)");
        }
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof OMElement) || !DOMUtils.equals((OMElement)e, Constants.NS_DSIG, "KeyInfo")) continue;
            bl = true;
            break;
        }
        if (!bl && tc.isDebugEnabled()) {
            Tr.debug(tc, "The nodeset to be signed doesn't include ds:KeyInfo element.");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "typeIsOk(ArrayList nodeset)");
        }
    }
}

