/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.wssecurity.dsig.XMLDTKeyInfoResolver;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.util.CertificateUtil;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.wssapi.OMStructure;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STRDTKeyInfoResolver {
    private static final TraceComponent tc = Tr.register(STRDTKeyInfoResolver.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private Collection<Configuration> _dsigKinfoSet;
    private Collection<Configuration> _encKinfoSet;
    private boolean _generation = false;
    private Map<Object, Object> _context;
    private Map<Object, Object> _selectors;
    private Collection<SecurityTokenWrapper> _stokens = null;
    private Result[] _results = null;
    private boolean _storedToken = false;

    protected STRDTKeyInfoResolver() {
    }

    protected void setDsigKeyInfoSet(Collection<Configuration> collection) {
        this._dsigKinfoSet = collection;
    }

    protected void setEncKeyInfoSet(Collection<Configuration> collection) {
        this._encKinfoSet = collection;
    }

    protected void setGeneration(boolean bl) {
        this._generation = bl;
    }

    protected void setContext(Map<Object, Object> map) {
        this._context = map;
    }

    protected void setSelectors(Map<Object, Object> map) {
        this._selectors = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OMElement resolve(OMElement oMElement, String string) throws SoapSecurityException {
        Serializable serializable;
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("resolve(");
            ((StringBuffer)object).append("OMElement secTokenRef[").append(DOMUtils.getDisplayName(oMElement)).append("],");
            ((StringBuffer)object).append("String keyInfoType[").append(string).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = (SecurityTokenManagerImpl)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        OMElement oMElement2 = null;
        try {
            serializable = new HashMap<Object, Object>();
            int n = 0;
            Object object2 = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
            if (object2 != null && object2 instanceof Integer) {
                n = (Integer)object2;
            }
            String string2 = Constants.NAMESPACES[0][n];
            if (this._generation) {
                oMElement2 = STRDTKeyInfoResolver.getElementInSubject(oMElement, string, string2, (SecurityTokenManagerImpl)object);
            } else {
                if (!this._storedToken) {
                    this._stokens = XMLDTKeyInfoResolver.storeSubject((SecurityTokenManagerImpl)object);
                    this._results = XMLDTKeyInfoResolver.storeResult(this._context);
                    this._storedToken = true;
                }
                if ((oMElement2 = STRDTKeyInfoResolver.getElementInSubject(oMElement, string, string2, (SecurityTokenManagerImpl)object)) == null) {
                    oMElement2 = STRDTKeyInfoResolver.getElement(oMElement, this._dsigKinfoSet, this._encKinfoSet, serializable, this._selectors, (SecurityTokenManagerImpl)object, this._context);
                }
            }
        }
        finally {
            if (this._storedToken) {
                XMLDTKeyInfoResolver.restoreSubject((SecurityTokenManagerImpl)object, this._stokens);
                XMLDTKeyInfoResolver.restoreResult(this._context, this._results);
                this._storedToken = false;
            }
        }
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("resolve(");
            ((StringBuffer)serializable).append("OMElement, String)");
            ((StringBuffer)serializable).append(" returns OMElement[").append(DOMUtils.getDisplayName(oMElement2)).append("]");
            Tr.exit(tc, ((StringBuffer)serializable).toString());
        }
        return oMElement2;
    }

    private static OMElement getElementInSubject(OMElement oMElement, String string, String string2, SecurityTokenManagerImpl securityTokenManagerImpl) throws SoapSecurityException {
        CharSequence charSequence;
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getElementInSubject(");
            ((StringBuffer)object).append("OMElement secTokenRef[").append(DOMUtils.getDisplayName(oMElement)).append("],");
            ((StringBuffer)object).append("String keyInfoType[").append(string).append("], ");
            ((StringBuffer)object).append("String nsWsse[").append(string2).append("], ");
            ((StringBuffer)object).append("SecurityTokenManagerImpl securityTokenManager)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        Collection<SecurityToken> collection = securityTokenManagerImpl.getTokens();
        if (collection != null && (charSequence = STRDTKeyInfoResolver.getIdInSubject(oMElement, string, string2)) != null) {
            for (SecurityToken securityToken : collection) {
                OMStructure oMStructure;
                if (!((String)charSequence).equals(securityToken.getId()) || (oMStructure = (OMStructure)securityToken.getXML()) == null) continue;
                object = oMStructure.getNode();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("getElementInSubject(");
            ((StringBuffer)charSequence).append("OMElement, String, String, ");
            ((StringBuffer)charSequence).append("SecurityTokenManagerImpl)");
            ((StringBuffer)charSequence).append(" returns OMElement[").append(DOMUtils.getDisplayName((OMNode)object)).append("]");
            Tr.exit(tc, ((StringBuffer)charSequence).toString());
        }
        return object;
    }

    private static String getIdInSubject(OMElement oMElement, String string, String string2) throws SoapSecurityException {
        CharSequence charSequence;
        CharSequence charSequence2;
        if (tc.isEntryEnabled()) {
            charSequence2 = new StringBuffer("getIdInSubject(");
            ((StringBuffer)charSequence2).append("OMElement secTokenRef[").append(DOMUtils.getDisplayName(oMElement)).append("],");
            ((StringBuffer)charSequence2).append("String keyInfoType[").append(string).append("], ");
            ((StringBuffer)charSequence2).append("String nsWsse[").append(string2).append("])");
            Tr.entry(tc, ((StringBuffer)charSequence2).toString());
        }
        charSequence2 = null;
        OMElement oMElement2 = null;
        if (ConfigUtil.isKeyInfoKeyid(string) || ConfigUtil.isKeyInfoThumbprint(string)) {
            oMElement2 = DOMUtils.getOneElement(oMElement, string2, "KeyIdentifier");
            charSequence2 = DOMUtils.getStringValue(oMElement2);
        } else if (ConfigUtil.isKeyInfoX509issuer(string)) {
            String string3;
            oMElement2 = DOMUtils.getOneElement(oMElement, Constants.NS_DSIG, "X509IssuerName");
            charSequence = DOMUtils.getStringValue(oMElement2);
            if (charSequence != null) {
                charSequence = KeyInfo.X509Data.encodeDName((String)charSequence);
            }
            if ((string3 = DOMUtils.getStringValue(oMElement2 = DOMUtils.getOneElement(oMElement, Constants.NS_DSIG, "X509SerialNumber"))) != null) {
                try {
                    new BigInteger(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        BigInteger bigInteger = CertificateUtil.convertSerialNumber(string3);
                        string3 = bigInteger.toString();
                    }
                    catch (ParseException parseException) {
                        throw SoapSecurityException.format("security.wssecurity.X509LoginModule.s04", string3, (Throwable)parseException);
                    }
                }
            }
            charSequence2 = (String)charSequence + ":" + string3;
        }
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("getIdInSubject(");
            ((StringBuffer)charSequence).append("OMElement, String, String)");
            ((StringBuffer)charSequence).append(" returns String[").append((String)charSequence2).append("]");
            Tr.exit(tc, ((StringBuffer)charSequence).toString());
        }
        return charSequence2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OMElement getElement(OMElement oMElement, Collection<Configuration> collection, Collection<Configuration> collection2, Map<Object, Object> map, Map<Object, Object> map2, SecurityTokenManagerImpl securityTokenManagerImpl, Map<Object, Object> map3) throws SoapSecurityException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            object2 = new StringBuffer("getElement(");
            ((StringBuffer)object2).append("OMElement secTokenRef[").append(DOMUtils.getDisplayName(oMElement)).append("],");
            ((StringBuffer)object2).append("Collection dsigKinfoSet, Collection encKinfoSet, Map type, ");
            ((StringBuffer)object2).append("Map properties, SecurityTokenManagerImpl securityTokenManager, ");
            ((StringBuffer)object2).append("Map context)");
            Tr.entry(tc, ((StringBuffer)object2).toString());
        }
        object2 = null;
        Collection<SecurityTokenWrapper> collection3 = STRDTKeyInfoResolver.lockTokenWrappers(securityTokenManagerImpl);
        try {
            object = STRDTKeyInfoResolver.getKeyInfoElement(oMElement);
            KeyInfoResult keyInfoResult = STRDTKeyInfoResolver.callKeyInfoConsumer(collection, collection2, map, map2, (OMElement)object, map3);
            if (keyInfoResult == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WEARNING: Unable to get the KeyInfoResult.");
                }
            } else {
                String string = keyInfoResult.getIdInSubject();
                SecurityToken securityToken = securityTokenManagerImpl.getToken(keyInfoResult.getKeyInfoContentConsumer().getTokenConsumer(), string);
                SecurityTokenWrapper securityTokenWrapper = securityTokenManagerImpl.getTokenWrapper(securityToken);
                if (securityTokenWrapper == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WEARNING: Unable to extract the token with the token identifier [" + string + "].");
                    }
                } else {
                    if (securityTokenWrapper.getError() != null) {
                        throw securityTokenWrapper.getError();
                    }
                    OMStructure oMStructure = (OMStructure)securityToken.getXML();
                    if (oMStructure != null) {
                        object2 = oMStructure.getNode();
                    }
                }
            }
        }
        finally {
            STRDTKeyInfoResolver.restoreTokenWrappers(securityTokenManagerImpl, collection3);
            STRDTKeyInfoResolver.removeKeyInfoResults(map3);
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getElement(");
            ((StringBuffer)object).append("OMElement, Collection, Collection, Map, Map, ");
            ((StringBuffer)object).append("SecurityTokenManagerImpl, Map)");
            ((StringBuffer)object).append(" returns OMElement[").append(DOMUtils.getDisplayName((OMNode)object2)).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return object2;
    }

    private static OMElement getKeyInfoElement(OMNode oMNode) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getKeyInfoElement(");
            ((StringBuffer)object).append("OMNode node[").append(DOMUtils.getDisplayName(oMNode)).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        OMContainer oMContainer = oMNode.getParent();
        if (oMContainer != null && oMContainer instanceof OMElement) {
            object = DOMUtils.equals((OMElement)oMContainer, Constants.NS_DSIG, "KeyInfo") ? (OMElement)oMContainer : STRDTKeyInfoResolver.getKeyInfoElement((OMElement)oMContainer);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getKeyInfoElement(OMNode)");
            stringBuffer.append(" returns OMElement[").append(DOMUtils.getDisplayName((OMNode)object)).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    private static KeyInfoResult callKeyInfoConsumer(Collection<Configuration> collection, Collection<Configuration> collection2, Map<Object, Object> map, Map<Object, Object> map2, OMElement oMElement, Map<Object, Object> map3) throws SoapSecurityException {
        Object object2;
        if (tc.isEntryEnabled()) {
            object2 = new StringBuffer("callKeyInfoConsumer(");
            ((StringBuffer)object2).append("Collection dsigKinfoSet, Collection encKinfoSet, Map type, ");
            ((StringBuffer)object2).append("Map properties, ");
            ((StringBuffer)object2).append("OMElement target[").append(DOMUtils.getDisplayName(oMElement)).append("],");
            ((StringBuffer)object2).append("Map context)");
            Tr.entry(tc, ((StringBuffer)object2).toString());
        }
        object2 = null;
        boolean bl = false;
        Exception exception = null;
        for (KeyInfoConsumerConfig object3 : collection) {
            try {
                SignatureConsumer.callKeyInfoConsumer(object3, "VerifyingKey", map, map2, oMElement, map3);
                bl = true;
                break;
            }
            catch (Exception exception2) {
                exception = exception2;
                STRDTKeyInfoResolver.removeKeyInfoResults(map3);
            }
        }
        if (bl) {
            KeyInfoResult[] keyInfoResultArray = SignatureConsumer.getKeyInfoResults(map3);
            object2 = STRDTKeyInfoResolver.getProcessedResult(keyInfoResultArray, collection);
        } else {
            for (KeyInfoConsumerConfig keyInfoConsumerConfig : collection2) {
                try {
                    SignatureConsumer.callKeyInfoConsumer(keyInfoConsumerConfig, "DecryptingKey", map, map2, oMElement, map3);
                    bl = true;
                    break;
                }
                catch (Exception exception3) {
                    exception = exception3;
                    STRDTKeyInfoResolver.removeKeyInfoResults(map3);
                }
            }
        }
        if (!bl) {
            throw SoapSecurityException.format("security.wssecurity.DTKeyInfoResolver.s01", new String[]{exception.getMessage()}, (Throwable)exception);
        }
        KeyInfoResult[] keyInfoResultArray = SignatureConsumer.getKeyInfoResults(map3);
        object2 = STRDTKeyInfoResolver.getProcessedResult(keyInfoResultArray, collection2);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("callKeyInfoConsumer(");
            stringBuffer.append("Collection, Collection, Map, Map, OMElement, Map)");
            stringBuffer.append(" returns KeyInfoResult[").append(object2).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object2;
    }

    private static KeyInfoResult getProcessedResult(KeyInfoResult[] keyInfoResultArray, Collection collection) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getProcessedResult(");
            ((StringBuffer)object).append("KeyInfoResult[] results, Collection keyInfoSet)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        if (keyInfoResultArray != null) {
            for (int i = 0; i < keyInfoResultArray.length; ++i) {
                KeyInfoResult keyInfoResult = keyInfoResultArray[i];
                KeyInfoContentConsumerConfig keyInfoContentConsumerConfig = keyInfoResult.getKeyInfoContentConsumer();
                for (KeyInfoConsumerConfig keyInfoConsumerConfig : collection) {
                    if (!keyInfoConsumerConfig.getContentConsumers().contains(keyInfoContentConsumerConfig) || keyInfoResult.getError() != null) continue;
                    object = keyInfoResult;
                    break;
                }
                if (object != null) break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getProcessedResult(");
            stringBuffer.append("KeyInfoResult[], Collection)");
            stringBuffer.append(" returns KeyInfoResult[").append(object).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    private static Collection<SecurityTokenWrapper> lockTokenWrappers(SecurityTokenManagerImpl securityTokenManagerImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lockTokenWrappers(SecurityTokenManagerImpl securityTokenManager)");
        }
        HashSet<SecurityTokenWrapper> hashSet = new HashSet<SecurityTokenWrapper>(securityTokenManagerImpl.getTokenWrappers());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lockTokenWrappers(SecurityTokenManagerImpl)");
        }
        return hashSet;
    }

    private static void removeKeyInfoResults(Map<Object, Object> map) {
        Result[] resultArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeKeyInfoResults(Map)");
        }
        if ((resultArray = ResultPool.get(map, KeyInfoResult.class)) != null && resultArray.length > 0) {
            ResultPool.remove(map, resultArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeKeyInfoResults(Map context)");
        }
    }

    private static void restoreTokenWrappers(SecurityTokenManagerImpl securityTokenManagerImpl, Collection<SecurityTokenWrapper> collection) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("restoreTokenWrappers(");
            stringBuffer.append("SecurityTokenManagerImpl securityTokenManager, ");
            stringBuffer.append("Collection tokenWrappers)");
            Tr.entry(tc, stringBuffer.toString());
        }
        securityTokenManagerImpl.removeAllTokens();
        securityTokenManagerImpl.addTokenWrappers(collection);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreTokenWrappers(SecurityTokenManagerImpl, Collection)");
        }
    }
}

