/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMAttributeWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;

class ExclusiveCanonicalizer {
    private static final TraceComponent tc = Tr.register(ExclusiveCanonicalizer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = ExclusiveCanonicalizer.class.getName();

    private ExclusiveCanonicalizer() {
    }

    public static void serializeSubset(Hashtable hashtable, ArrayList arrayList, boolean bl, Map map, Writer writer) throws IOException {
        ExclusiveCanonicalizer.serializeSubset(hashtable, arrayList, bl, map, writer, null);
    }

    private static void serializeSubset(Hashtable hashtable, ArrayList arrayList, boolean bl, Map map, Writer writer, Set set) throws IOException {
        int n;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeSubset(Hashtable prefixList[" + hashtable + ", ArrayList nodeList[" + arrayList + "], boolean withComments[" + bl + "], Map replNodeSets[" + map + "], Writer wr[" + writer + "], Set apexNodes[" + set + "])");
        }
        Vector<Object> vector = new Vector<Object>(arrayList.size());
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            Object e;
            object = arrayList.get(i);
            if (map.containsKey(object)) {
                vector.add(new Canonicalizer.ReplacedNode((OMNode)object));
                int n2 = arrayList.size();
                for (n = i + 1; n <= n2; ++n) {
                    if (n < n2 && DOMUtil.isDescendantNode(arrayList.get(n), (OMNode)object)) continue;
                    i = n - 1;
                    continue block0;
                }
                continue;
            }
            if (object instanceof OMNode) {
                Object e2;
                Hashtable hashtable2;
                OMNode oMNode = (OMNode)object;
                vector.addElement(oMNode);
                if (oMNode.getType() != 1) continue;
                Hashtable hashtable3 = new Hashtable();
                if (i + 1 < arrayList.size() && (e = arrayList.get(i + 1)) instanceof OMNamespace && Canonicalizer.isOwnerElement(oMNode, (OMNamespace)e)) {
                    ++i;
                    while (i < arrayList.size() && (hashtable2 = arrayList.get(i)) instanceof OMNamespace && Canonicalizer.isOwnerElement(oMNode, (OMNamespace)((Object)hashtable2))) {
                        hashtable3.put(((OMNamespace)((Object)hashtable2)).getPrefix(), hashtable2);
                        ++i;
                    }
                    if (hashtable3.containsKey("") && ((OMNamespace)hashtable3.get("")).getName().length() == 0) {
                        hashtable3.remove("");
                    }
                    --i;
                }
                vector.addElement(new Canonicalizer.OMNamespaces(oMNode, hashtable3));
                hashtable2 = new Hashtable();
                if (i + 1 < arrayList.size() && (e2 = arrayList.get(i + 1)) instanceof OMAttribute && Canonicalizer.isOwnerElement(oMNode, (OMAttribute)e2)) {
                    Object e3;
                    ++i;
                    while (i < arrayList.size() && (e3 = arrayList.get(i)) instanceof OMAttribute && Canonicalizer.isOwnerElement(oMNode, (OMAttribute)e3)) {
                        hashtable2.put(((OMAttribute)e3).getQName(), e3);
                        ++i;
                    }
                    --i;
                }
                vector.addElement(new Canonicalizer.OMAttributes(oMNode, hashtable2));
                continue;
            }
            if (object instanceof OMNamespaceWithOwner) {
                OMElement oMElement = ((OMNamespaceWithOwner)object).getOwnerElement();
                Hashtable hashtable4 = new Hashtable();
                while (i < arrayList.size() && (e = arrayList.get(i)) instanceof OMNamespaceWithOwner && oMElement == ((OMNamespaceWithOwner)e).getOwnerElement()) {
                    hashtable4.put(((OMNamespace)e).getPrefix(), e);
                    ++i;
                }
                vector.addElement(new Canonicalizer.OMNamespaces(oMElement, hashtable4));
                --i;
                continue;
            }
            if (!(object instanceof OMAttributeWithOwner)) continue;
            OMElement oMElement = ((OMAttributeWithOwner)object).getOwnerElement();
            Hashtable hashtable5 = new Hashtable();
            while (i < arrayList.size() && (e = arrayList.get(i)) instanceof OMAttributeWithOwner && oMElement == ((OMAttributeWithOwner)e).getOwnerElement()) {
                hashtable5.put(((OMAttribute)e).getQName(), e);
                ++i;
            }
            vector.addElement(new Canonicalizer.OMAttributes(oMElement, hashtable5));
            --i;
        }
        Stack stack = new Stack();
        object = new Stack();
        for (n = 0; n < vector.size(); ++n) {
            ExclusiveCanonicalizer.serializeSubset(stack, object, hashtable, vector, n, bl, map, writer, set);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeSubset(Hashtable prefixList, ArrayList nodeList, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes)");
        }
    }

    private static void serializeSubset(Stack stack, Stack stack2, Hashtable hashtable, Vector vector, int n, boolean bl, Map map, Writer writer, Set set) throws IOException {
        OMContainer oMContainer;
        String string;
        Object e;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeSubset(Stack nStack[" + stack + "], Stack aStack[" + stack2 + "], Hashtable prefixList{" + hashtable + "], ArrayList nodeVector[" + vector + "], int i[" + n + "], boolean withComments[" + bl + "], Map replNodeSets[" + map + "], Writer wr[" + writer + "], Set apexNodes[" + set + "])");
        }
        if ((e = vector.elementAt(n)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serializeSubset(Stack nStack, Stack aStack, Hashtable prefixList, ArrayList nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes)");
            }
            return;
        }
        if (e instanceof Canonicalizer.OMNamespaces) {
            vector.setElementAt(null, n);
            ((Canonicalizer.OMNamespaces)e).serialize(null, hashtable, null, writer);
            return;
        }
        if (e instanceof Canonicalizer.OMAttributes) {
            vector.setElementAt(null, n);
            ((Canonicalizer.OMAttributes)e).serialize(null, hashtable, null, writer);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serializeSubset(Stack nStack, Stack aStack, Hashtable prefixList, ArrayList nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes)");
            }
            return;
        }
        if (e instanceof Canonicalizer.ReplacedNode) {
            OMNode oMNode = ((Canonicalizer.ReplacedNode)e).getNode();
            ArrayList arrayList = (ArrayList)map.get(oMNode);
            HashSet<OMNode> hashSet = new HashSet<OMNode>();
            int n2 = 0;
            int n3 = arrayList.size();
            block0: while (n2 < n3) {
                OMNode oMNode2 = (OMNode)arrayList.get(n2);
                hashSet.add(oMNode2);
                for (int i = n2 + 1; i <= n3; ++i) {
                    if (i < n3 && DOMUtil.isDescendantNode(arrayList.get(i), oMNode2)) continue;
                    n2 = i;
                    continue block0;
                }
            }
            ExclusiveCanonicalizer.serializeSubset(hashtable, arrayList, false, map, writer, hashSet);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serializeSubset(Stack nStack, Stack aStack, Hashtable prefixList, ArrayList nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes)");
            }
            return;
        }
        OMNode oMNode = (OMNode)e;
        int n4 = oMNode.getType();
        if (n4 != 1) {
            Canonicalizer.serializeNode(null, oMNode, null, bl, true, writer);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serializeSubset(Stack nStack, Stack aStack, Hashtable prefixList, ArrayList nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes)");
            }
            return;
        }
        writer.write("<");
        OMElement oMElement = (OMElement)oMNode;
        String string2 = string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getPrefix();
        if (string != null && string.length() != 0) {
            writer.write(string);
            writer.write(":");
        }
        writer.write(oMElement.getLocalName());
        Canonicalizer.OMNamespaces oMNamespaces = stack.empty() ? null : (Canonicalizer.OMNamespaces)stack.peek();
        Canonicalizer.OMNamespaces oMNamespaces2 = null;
        int n5 = n + 1;
        boolean bl2 = hashtable == null || hashtable.get("") == null ? string == null : true;
        if (n5 >= vector.size() || vector.elementAt(n5) instanceof OMNode || vector.elementAt(n5) instanceof Canonicalizer.ReplacedNode) {
            oMContainer = oMElement.getParent();
            if (set != null && set.contains(oMNode) || bl2 && !(oMContainer instanceof OMDocument) && oMNamespaces != null && oMNamespaces.contains("")) {
                writer.write(" xmlns=\"\"");
            }
        } else if (vector.elementAt(n5) instanceof Canonicalizer.OMNamespaces) {
            oMNamespaces2 = (Canonicalizer.OMNamespaces)vector.elementAt(n5);
            if (!oMNamespaces2.contains("")) {
                oMContainer = oMElement.getParent();
                if (set != null && set.contains(oMNode) || bl2 && !(oMContainer instanceof OMDocument) && oMNamespaces != null && oMNamespaces.contains("")) {
                    writer.write(" xmlns=\"\"");
                }
            }
            if (string == null) {
                string = "";
            }
            oMNamespaces2.serialize(stack, hashtable, string, writer);
            vector.setElementAt(null, n5);
            ++n5;
        }
        oMContainer = stack2.empty() ? null : (Canonicalizer.OMAttributes)stack2.peek();
        Canonicalizer.OMAttributes oMAttributes = null;
        if (n5 < vector.size() && vector.elementAt(n5) instanceof Canonicalizer.OMAttributes) {
            oMAttributes = (Canonicalizer.OMAttributes)vector.elementAt(n5);
            if (string == null) {
                string = "";
            }
            oMAttributes.serialize(stack2, hashtable, string, writer);
            vector.setElementAt(null, n5);
        }
        writer.write(">");
        stack.push(oMNamespaces2);
        stack2.push(oMAttributes);
        while (n5 < vector.size()) {
            if (vector.elementAt(n5) == null) {
                ++n5;
                continue;
            }
            if (!Canonicalizer.isAncestor(vector.elementAt(n5), oMNode)) break;
            ExclusiveCanonicalizer.serializeSubset(stack, stack2, hashtable, vector, n5, bl, map, writer, set);
            vector.setElementAt(null, n5++);
        }
        stack.pop();
        stack2.pop();
        writer.write("</");
        if (string != null && string.length() != 0) {
            writer.write(string);
            writer.write(":");
        }
        writer.write(oMElement.getLocalName());
        writer.write(">");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeSubset(Stack nStack, Stack aStack, Hashtable prefixList, ArrayList nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes)");
        }
    }

    public static byte[] serializeSubset(Hashtable hashtable, ArrayList arrayList, boolean bl, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeSubset(Hashtable prefixList[" + hashtable + ", ArrayList nodeList[" + arrayList + "], boolean withComments[" + bl + "], Map replNodeSets[" + map + "])");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            ExclusiveCanonicalizer.serializeSubset(hashtable, arrayList, bl, map, outputStreamWriter);
            ((Writer)outputStreamWriter).close();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serializeSubset(Hashtable prefixList, ArrayList nodeList, boolean withComments, Map replNodeSets)");
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            RuntimeException runtimeException = new RuntimeException("Internal Error: " + iOException);
            runtimeException.initCause(iOException);
            throw runtimeException;
        }
    }

    public static Hashtable parsePrefixList(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parsePrefixList(String ssv[" + string + "])");
        }
        Hashtable<String, String> hashtable = null;
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>();
            }
            if (string2.equals("#default")) {
                string2 = "";
            }
            hashtable.put(string2, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parsePrefixList(String ssv) returns prefixList[" + hashtable + "]");
        }
        return hashtable;
    }

    public static String serializePrefixList(Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializePrefixList(Hashtable prefixList[" + hashtable + "])");
        }
        String string = null;
        if (hashtable != null && !hashtable.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if ("".equals(string2)) {
                    string2 = "#default";
                }
                if (bl) {
                    stringBuffer.append(" ");
                } else {
                    bl = true;
                }
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString();
        }
        return string;
    }
}

