/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.C14nUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMAttributeWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceProxy;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;

class Canonicalizer {
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";

    Canonicalizer() {
    }

    public static byte[] serializeSubset(ArrayList arrayList, boolean bl, Map map) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            Canonicalizer.serializeSubset(arrayList, bl, map, outputStreamWriter);
            ((Writer)outputStreamWriter).close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            RuntimeException runtimeException = new RuntimeException("Internal Error: " + iOException);
            runtimeException.initCause(iOException);
            throw runtimeException;
        }
    }

    public static void serializeSubset(ArrayList arrayList, boolean bl, Map map, Writer writer) throws IOException {
        Canonicalizer.serializeSubset(arrayList, bl, map, writer, null);
    }

    static void serializeSubset(ArrayList arrayList, boolean bl, Map map, Writer writer, Set set) throws IOException {
        int n;
        Object object;
        Vector<Object> vector = new Vector<Object>(arrayList.size());
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            Object e;
            object = arrayList.get(i);
            if (map.containsKey(object)) {
                vector.add(new ReplacedNode((OMNode)object));
                int n2 = arrayList.size();
                for (n = i + 1; n <= n2; ++n) {
                    if (n < n2 && DOMUtil.isDescendantNode(arrayList.get(n), (OMNode)object)) continue;
                    i = n - 1;
                    continue block0;
                }
                continue;
            }
            if (object instanceof OMNode) {
                Object e2;
                Hashtable hashtable;
                OMNode oMNode = (OMNode)object;
                vector.addElement(oMNode);
                if (oMNode.getType() != 1) continue;
                Hashtable hashtable2 = null;
                if (i + 1 < arrayList.size() && (e = arrayList.get(i + 1)) instanceof OMNamespace && Canonicalizer.isOwnerElement(oMNode, (OMNamespace)e)) {
                    if (hashtable2 == null) {
                        hashtable2 = new Hashtable();
                    }
                    ++i;
                    while (i < arrayList.size() && (hashtable = arrayList.get(i)) instanceof OMNamespace && Canonicalizer.isOwnerElement(oMNode, (OMNamespace)((Object)hashtable))) {
                        hashtable2.put(((OMNamespace)((Object)hashtable)).getPrefix(), hashtable);
                        ++i;
                    }
                    if (hashtable2.containsKey("") && ((OMNamespace)hashtable2.get("")).getName().length() == 0) {
                        hashtable2.remove("");
                    }
                    --i;
                    vector.addElement(new OMNamespaces(oMNode, hashtable2));
                } else if (hashtable2 != null) {
                    vector.addElement(new OMNamespaces(oMNode, hashtable2));
                }
                hashtable = Canonicalizer.collectXMLPrefixAttributesInAncestors(oMNode);
                if (i + 1 < arrayList.size() && (e2 = arrayList.get(i + 1)) instanceof OMAttribute && Canonicalizer.isOwnerElement(oMNode, (OMAttribute)e2)) {
                    Object e3;
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                    }
                    ++i;
                    while (i < arrayList.size() && (e3 = arrayList.get(i)) instanceof OMAttribute && Canonicalizer.isOwnerElement(oMNode, (OMAttribute)e3)) {
                        hashtable.put(((OMAttribute)e3).getQName(), e3);
                        ++i;
                    }
                    --i;
                    vector.addElement(new OMAttributes(oMNode, hashtable));
                    continue;
                }
                if (hashtable == null) continue;
                vector.addElement(new OMAttributes(oMNode, hashtable));
                continue;
            }
            if (object instanceof OMNamespaceWithOwner) {
                OMElement oMElement = ((OMNamespaceWithOwner)object).getOwnerElement();
                Hashtable hashtable = new Hashtable();
                while (i < arrayList.size() && (e = arrayList.get(i)) instanceof OMNamespaceWithOwner && oMElement == ((OMNamespaceWithOwner)e).getOwnerElement()) {
                    hashtable.put(((OMNamespace)e).getPrefix(), e);
                    ++i;
                }
                vector.addElement(new OMNamespaces(oMElement, hashtable));
                --i;
                continue;
            }
            if (!(object instanceof OMAttributeWithOwner)) continue;
            OMElement oMElement = ((OMAttributeWithOwner)object).getOwnerElement();
            Hashtable hashtable = new Hashtable();
            while (i < arrayList.size() && (e = arrayList.get(i)) instanceof OMAttributeWithOwner && oMElement == ((OMAttributeWithOwner)e).getOwnerElement()) {
                hashtable.put(((OMAttribute)e).getQName(), e);
                ++i;
            }
            vector.addElement(new OMAttributes(oMElement, hashtable));
            --i;
        }
        Stack stack = new Stack();
        object = new Stack();
        for (n = 0; n < vector.size(); ++n) {
            Canonicalizer.serializeSubset(stack, object, vector, n, bl, map, writer, set);
        }
    }

    private static void serializeSubset(Stack stack, Stack stack2, Vector vector, int n, boolean bl, Map map, Writer writer, Set set) throws IOException {
        OMContainer oMContainer;
        String string;
        Object e = vector.elementAt(n);
        if (e == null) {
            return;
        }
        if (e instanceof OMNamespaces) {
            vector.setElementAt(null, n);
            ((OMNamespaces)e).serialize(null, writer);
            return;
        }
        if (e instanceof OMAttributes) {
            vector.setElementAt(null, n);
            ((OMAttributes)e).serialize(null, writer);
            return;
        }
        if (e instanceof ReplacedNode) {
            ArrayList arrayList = (ArrayList)map.get(((ReplacedNode)e).getNode());
            HashSet<OMNode> hashSet = new HashSet<OMNode>();
            int n2 = 0;
            int n3 = arrayList.size();
            block0: while (n2 < n3) {
                OMNode oMNode = (OMNode)arrayList.get(n2);
                hashSet.add(oMNode);
                for (int i = n2 + 1; i <= n3; ++i) {
                    if (i < n3 && DOMUtil.isDescendantNode(arrayList.get(i), oMNode)) continue;
                    n2 = i;
                    continue block0;
                }
            }
            Canonicalizer.serializeSubset(arrayList, false, map, writer, hashSet);
            return;
        }
        OMNode oMNode = (OMNode)e;
        int n4 = oMNode.getType();
        if (n4 != 1) {
            Canonicalizer.serializeNode(null, oMNode, null, bl, true, writer);
            return;
        }
        writer.write("<");
        OMElement oMElement = (OMElement)oMNode;
        String string2 = string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getPrefix();
        if (string != null && string.length() != 0) {
            writer.write(string);
            writer.write(":");
        }
        writer.write(oMElement.getLocalName());
        OMNamespaces oMNamespaces = stack.empty() ? null : (OMNamespaces)stack.peek();
        OMNamespaces oMNamespaces2 = null;
        int n5 = n + 1;
        if (n5 >= vector.size() || vector.elementAt(n5) instanceof OMNode || vector.elementAt(n5) instanceof ReplacedNode) {
            oMContainer = oMNode.getParent();
            if (!(oMContainer instanceof OMDocument) && oMNamespaces != null && oMNamespaces.contains("") || set != null && set.contains(oMNode)) {
                writer.write(" xmlns=\"\"");
            }
        } else if (vector.elementAt(n5) instanceof OMNamespaces) {
            oMNamespaces2 = (OMNamespaces)vector.elementAt(n5);
            if (!oMNamespaces2.contains("") && (!((oMContainer = oMNode.getParent()) instanceof OMDocument) && oMNamespaces != null && oMNamespaces.contains("") || set != null && set.contains(oMNode))) {
                writer.write(" xmlns=\"\"");
            }
            oMNamespaces2.serialize(oMNamespaces, writer);
            vector.setElementAt(null, n5);
            ++n5;
        }
        oMContainer = stack2.empty() ? null : (OMAttributes)stack2.peek();
        OMAttributes oMAttributes = null;
        if (n5 < vector.size() && vector.elementAt(n5) instanceof OMAttributes) {
            oMAttributes = (OMAttributes)vector.elementAt(n5);
            oMAttributes.serialize((OMAttributes)((Object)oMContainer), writer);
            vector.setElementAt(null, n5);
        }
        writer.write(">");
        stack.push(oMNamespaces2);
        stack2.push(oMAttributes);
        while (n5 < vector.size()) {
            if (vector.elementAt(n5) == null) {
                ++n5;
                continue;
            }
            if (!Canonicalizer.isAncestor(vector.elementAt(n5), oMNode)) break;
            Canonicalizer.serializeSubset(stack, stack2, vector, n5, bl, map, writer, set);
            vector.setElementAt(null, n5++);
        }
        stack.pop();
        stack2.pop();
        writer.write("</");
        if (string != null && string.length() != 0) {
            writer.write(string);
            writer.write(":");
        }
        writer.write(oMElement.getLocalName());
        writer.write(">");
    }

    static boolean isAncestor(Object object, OMNode oMNode) {
        OMNode oMNode2 = object instanceof OMAttributes ? ((OMAttributes)object).parent : (object instanceof OMNamespaces ? ((OMNamespaces)object).parent : (object instanceof ReplacedNode ? ((ReplacedNode)object).getNode() : (OMNode)object));
        while (oMNode2 != oMNode) {
            OMContainer oMContainer = oMNode2.getParent();
            if (oMContainer instanceof OMDocument) {
                return false;
            }
            oMNode2 = (OMNode)((Object)oMContainer);
        }
        return true;
    }

    static boolean isOwnerElement(OMNode oMNode, OMAttribute oMAttribute) {
        if (!(oMNode instanceof OMElement)) {
            return false;
        }
        if (oMAttribute instanceof OMAttributeWithOwner && ((OMAttributeWithOwner)oMAttribute).getOwnerElement() == oMNode) {
            return true;
        }
        OMElement oMElement = (OMElement)oMNode;
        Iterator iterator = oMElement.getAllAttributes();
        while (iterator.hasNext()) {
            if (oMAttribute != iterator.next()) continue;
            return true;
        }
        return false;
    }

    static boolean isOwnerElement(OMNode oMNode, OMNamespace oMNamespace) {
        if (!(oMNode instanceof OMElement)) {
            return false;
        }
        if (oMNamespace instanceof OMNamespaceWithOwner && ((OMNamespaceWithOwner)oMNamespace).getOwnerElement() == oMNode) {
            return true;
        }
        OMElement oMElement = (OMElement)oMNode;
        Iterator iterator = oMElement.getAllDeclaredNamespaces();
        while (iterator.hasNext()) {
            if (oMNamespace != iterator.next()) continue;
            return true;
        }
        return false;
    }

    static void serializeNode(OMNode oMNode, OMNode oMNode2, OMNode oMNode3, boolean bl, boolean bl2, Writer writer) throws IOException {
        Canonicalizer.serializeNode(oMNode, null, null, oMNode2, oMNode3, bl, bl2, writer);
    }

    private static void serializeNode(OMNode oMNode, Stack stack, Stack stack2, OMNode oMNode2, OMNode oMNode3, boolean bl, boolean bl2, Writer writer) throws IOException {
        if (oMNode3 == oMNode2) {
            return;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        switch (oMNode2.getType()) {
            case 1: {
                String string;
                if (stack == null) {
                    stack = new Stack();
                }
                if (stack2 == null) {
                    stack2 = new Stack();
                }
                writer.write("<");
                OMElement oMElement = (OMElement)oMNode2;
                String string2 = string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getPrefix();
                if (string != null && string.length() != 0) {
                    writer.write(string);
                    writer.write(":");
                }
                writer.write(oMElement.getLocalName());
                Canonicalizer.serializeNamespaces(oMNode, stack, oMElement, writer);
                Canonicalizer.serializeAttributes(oMNode, stack2, oMElement, bl2, writer);
                writer.write(">");
                for (OMNode oMNode4 = oMElement.getFirstOMChild(); oMNode4 != null; oMNode4 = oMNode4.getNextOMSibling()) {
                    Canonicalizer.serializeNode(oMNode, stack, stack2, oMNode4, oMNode3, bl, bl2, writer);
                }
                stack.pop();
                stack2.pop();
                writer.write("</");
                if (string != null && string.length() != 0) {
                    writer.write(string);
                    writer.write(":");
                }
                writer.write(oMElement.getLocalName());
                writer.write(">");
                break;
            }
            case 4: 
            case 12: {
                String string = ((OMText)oMNode2).getText();
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '<') {
                        writer.write("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        writer.write("&gt;");
                        continue;
                    }
                    if (c == '&') {
                        writer.write("&amp;");
                        continue;
                    }
                    if (c == '\r') {
                        writer.write("&#xD;");
                        continue;
                    }
                    writer.write(c);
                }
                break;
            }
            case 9: {
                for (OMNode oMNode5 = ((OMElement)oMNode2).getFirstOMChild(); oMNode5 != null; oMNode5 = oMNode5.getNextOMSibling()) {
                    Canonicalizer.serializeNode(oMNode, stack, stack2, oMNode5, oMNode3, bl, bl2, writer);
                }
                break;
            }
            case 3: {
                OMNode oMNode6;
                if (oMNode2.getParent() instanceof OMDocument) {
                    oMNode6 = oMNode2;
                    while ((oMNode6 = oMNode6.getPreviousOMSibling()) != null && oMNode6.getType() != 1) {
                    }
                    if (oMNode6 == null) {
                        bl3 = true;
                    } else {
                        bl4 = true;
                    }
                }
                oMNode6 = (OMProcessingInstruction)oMNode2;
                if (bl4) {
                    writer.write("\n");
                }
                writer.write("<?");
                writer.write(oMNode6.getTarget());
                if (oMNode6.getValue() != null && oMNode6.getValue().length() > 0) {
                    writer.write(" ");
                    String string = oMNode6.getValue();
                    int n = 0;
                    for (int i = 0; i < string.length(); ++i) {
                        if (string.charAt(i) != '\r') continue;
                        if (i > n) {
                            writer.write(string, n, i - n);
                        }
                        writer.write("&#xD;");
                        n = i + 1;
                    }
                    if (n < string.length()) {
                        writer.write(string, n, string.length() - n);
                    }
                }
                writer.write("?>");
                if (!bl3) break;
                writer.write("\n");
                break;
            }
            case 5: {
                if (!bl) break;
                if (oMNode2.getParent() instanceof OMDocument) {
                    OMNode oMNode7 = oMNode2;
                    while ((oMNode7 = oMNode7.getPreviousOMSibling()) != null && oMNode7.getType() != 1) {
                    }
                    if (oMNode7 == null) {
                        bl3 = true;
                    } else {
                        bl4 = true;
                    }
                }
                if (bl4) {
                    writer.write("\n");
                }
                writer.write("<!--");
                writer.write(((OMComment)oMNode2).getValue());
                writer.write("-->");
                if (!bl3) break;
                writer.write("\n");
            }
        }
    }

    private static boolean isTopElement(OMNode oMNode, OMElement oMElement) {
        if (oMNode == oMElement) {
            return true;
        }
        OMContainer oMContainer = oMElement.getParent();
        if (oMContainer != null) {
            if (oMContainer instanceof OMDocument) {
                return true;
            }
            if (oMContainer instanceof OMElement) {
                return false;
            }
            throw new RuntimeException("Internal Error: Unexpected node type: " + ((OMNode)((Object)oMContainer)).getType());
        }
        return true;
    }

    private static void serializeAttributes(OMNode oMNode, Stack stack, OMElement oMElement, boolean bl, Writer writer) throws IOException {
        String[] stringArray;
        Object object;
        Hashtable<QName, Object> hashtable = new Hashtable<QName, Object>();
        Iterator iterator = oMElement.getAllAttributes();
        while (iterator.hasNext()) {
            object = (OMAttribute)iterator.next();
            hashtable.put(object.getQName(), object);
        }
        if (bl && (object = Canonicalizer.collectXMLPrefixAttributesInAncestors(oMElement)) != null) {
            Enumeration enumeration = ((Hashtable)object).elements();
            while (enumeration.hasMoreElements()) {
                stringArray = (String[])enumeration.nextElement();
                hashtable.put(stringArray.getQName(), stringArray);
            }
        }
        object = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(hashtable);
        int n = hashtable.size();
        stringArray = new String[n];
        int[] nArray = new int[n];
        OMAttribute[] oMAttributeArray = new OMAttribute[n];
        int n2 = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            OMAttribute oMAttribute = (OMAttribute)enumeration.nextElement();
            nArray[n2] = n2;
            oMAttributeArray[n2] = oMAttribute;
            stringArray[n2] = Canonicalizer.createSortedString(oMAttribute, (OMNode)oMElement);
            ++n2;
        }
        C14nUtil.heapSort(nArray, stringArray, n);
        for (int i = 0; i < n; ++i) {
            OMAttribute oMAttribute;
            OMAttribute oMAttribute2 = oMAttributeArray[nArray[i]];
            QName qName = oMAttribute2.getQName();
            if (qName.getPrefix() != null && qName.getPrefix().equals("xml") && object != null && (oMAttribute = (OMAttribute)((Hashtable)object).get(qName)) != null && oMAttribute.getAttributeValue() != null && oMAttribute.getAttributeValue().equals(oMAttribute2.getAttributeValue())) continue;
            Canonicalizer.serializeAttribute(oMAttribute2, writer);
        }
    }

    private static void serializeNamespaces(OMNode oMNode, Stack stack, OMElement oMElement, Writer writer) throws IOException {
        OMNamespace oMNamespace;
        Hashtable hashtable = Canonicalizer.collectNamespaceNodesInAncestors(oMElement, false);
        Iterator iterator = oMElement.getAllDeclaredNamespaces();
        while (iterator.hasNext()) {
            oMNamespace = (OMNamespace)iterator.next();
            hashtable.put(oMNamespace.getPrefix(), oMNamespace);
        }
        oMNamespace = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(hashtable);
        int n = hashtable.size();
        String[] stringArray = new String[n];
        int[] nArray = new int[n];
        OMNamespace[] oMNamespaceArray = new OMNamespace[n];
        int n2 = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            OMNamespace oMNamespace2 = (OMNamespace)enumeration.nextElement();
            nArray[n2] = n2;
            oMNamespaceArray[n2] = oMNamespace2;
            stringArray[n2] = Canonicalizer.createSortedString(oMNamespace2, (OMNode)oMElement);
            ++n2;
        }
        C14nUtil.heapSort(nArray, stringArray, n);
        for (int i = 0; i < n; ++i) {
            OMNamespace oMNamespace3;
            OMNamespace oMNamespace4 = oMNamespaceArray[nArray[i]];
            String string = oMNamespace4.getPrefix();
            if (string.equals("xml")) continue;
            if (string.length() == 0 && (oMNamespace4.getName() == null || oMNamespace4.getName().length() == 0)) {
                if (Canonicalizer.isTopElement(oMNode, oMElement)) continue;
                boolean bl = false;
                for (int j = stack.size() - 1; j >= 0; --j) {
                    Hashtable hashtable2 = (Hashtable)stack.elementAt(j);
                    OMNamespace oMNamespace5 = (OMNamespace)hashtable2.get("");
                    if (oMNamespace5 == null || oMNamespace5.getName() == null || oMNamespace5.getName().length() <= 0) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            if (oMNamespace != null && (oMNamespace3 = (OMNamespace)((Hashtable)((Object)oMNamespace)).get(string)) != null && oMNamespace3.getName() != null && oMNamespace3.getName().equals(oMNamespace4.getName())) continue;
            Canonicalizer.serializeNamespace(oMNamespace4, writer);
        }
    }

    private static void serializeAttribute(OMAttribute oMAttribute, Writer writer) throws IOException {
        String string = oMAttribute.getNamespace() == null ? null : oMAttribute.getNamespace().getPrefix();
        writer.write(" ");
        if (string != null && string.length() != 0) {
            writer.write(string);
            writer.write(":");
        }
        writer.write(oMAttribute.getLocalName());
        writer.write("=\"");
        String string2 = oMAttribute.getAttributeValue();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '&') {
                writer.write("&amp;");
                continue;
            }
            if (c == '<') {
                writer.write("&lt;");
                continue;
            }
            if (c == '\"') {
                writer.write("&quot;");
                continue;
            }
            if (c == '\t') {
                writer.write("&#x9;");
                continue;
            }
            if (c == '\n') {
                writer.write("&#xA;");
                continue;
            }
            if (c == '\r') {
                writer.write("&#xD;");
                continue;
            }
            writer.write(c);
        }
        writer.write("\"");
    }

    private static void serializeNamespace(OMNamespace oMNamespace, Writer writer) throws IOException {
        String string = oMNamespace.getPrefix();
        if (string != null && string.length() != 0) {
            writer.write(" xmlns:");
            writer.write(string);
        } else {
            writer.write(" xmlns");
        }
        writer.write("=\"");
        String string2 = oMNamespace.getName();
        boolean bl = false;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '&') {
                writer.write("&amp;");
                continue;
            }
            if (c == '<') {
                writer.write("&lt;");
                continue;
            }
            if (c == '\"') {
                writer.write("&quot;");
                continue;
            }
            if (c == '\t') {
                writer.write("&#x9;");
                continue;
            }
            if (c == '\n') {
                writer.write("&#xA;");
                continue;
            }
            if (c == '\r') {
                writer.write("&#xD;");
                continue;
            }
            if (c == ':') {
                bl = true;
            } else if (c == '/' && !bl) {
                throw new RuntimeException("Found a relative URI: " + string2);
            }
            writer.write(c);
        }
        if (string2.length() > 0 && !bl) {
            throw new RuntimeException("Found a relative URI: " + string2);
        }
        writer.write("\"");
    }

    public static Hashtable collectNamespaceNodesInAncestors(OMNode oMNode, boolean bl) {
        Object object;
        OMNode oMNode2 = oMNode;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        OMFactory oMFactory = oMNode.getOMFactory();
        if (oMNode2.getType() == 1 && ((OMElement)oMNode2).findNamespaceURI("xml") == null) {
            if (bl) {
                hashtable.put("xml", new OMNamespaceProxy(oMNode, oMFactory, XML_NAMESPACE, "xml"));
            } else {
                object = oMFactory.createOMNamespace(XML_NAMESPACE, "xml");
                hashtable.put("xml", object);
            }
        }
        if (oMNode2.getType() != 1) {
            object = oMNode2.getParent();
            oMNode2 = object instanceof OMDocument ? null : (OMElement)object;
        }
        while (oMNode2 != null) {
            Object object2;
            object = ((OMElement)oMNode2).getAllDeclaredNamespaces();
            if (object != null) {
                while (object.hasNext()) {
                    OMNamespace oMNamespace;
                    object2 = (OMNamespace)object.next();
                    String string = object2.getPrefix();
                    if (hashtable.containsKey(string)) continue;
                    if (oMNode2 == oMNode) {
                        hashtable.put(string, object2);
                        continue;
                    }
                    if (bl) {
                        oMNamespace = new OMNamespaceProxy(oMNode, oMFactory, object2.getName(), string);
                        hashtable.put(string, oMNamespace);
                        continue;
                    }
                    oMNamespace = oMFactory.createOMNamespace(object2.getName(), string);
                    hashtable.put(string, oMNamespace);
                }
            }
            if ((object2 = oMNode2.getParent()) instanceof OMDocument) {
                oMNode2 = null;
                continue;
            }
            oMNode2 = (OMNode)object2;
        }
        return hashtable;
    }

    public static Hashtable collectXMLPrefixAttributesInAncestors(OMNode oMNode) {
        Object object;
        Object object2;
        Hashtable<QName, Object> hashtable = null;
        Object object3 = oMNode.getParent();
        while (object3 instanceof OMElement) {
            object2 = ((OMElement)object3).getAllAttributes();
            if (object2 != null) {
                while (object2.hasNext()) {
                    object = (OMAttribute)object2.next();
                    QName qName = object.getQName();
                    if (!"xml".equals(qName.getPrefix()) || hashtable != null && hashtable.containsKey(qName)) continue;
                    if (hashtable == null) {
                        hashtable = new Hashtable<QName, Object>();
                    }
                    hashtable.put(qName, object);
                }
            }
            object3 = ((OMElement)object3).getParent();
        }
        if (hashtable != null && (object3 = ((OMElement)oMNode).getAllAttributes()) != null) {
            while (object3.hasNext()) {
                object2 = (OMAttribute)object3.next();
                object = object2.getQName();
                if (!"xml".equals(((QName)object).getPrefix()) || !hashtable.containsKey(object)) continue;
                hashtable.remove(object);
            }
        }
        return hashtable;
    }

    private static String createSortedString(OMAttribute oMAttribute, OMNode oMNode) {
        String string = oMAttribute.getLocalName();
        String string2 = oMAttribute.getNamespace() == null ? null : oMAttribute.getNamespace().getName();
        String string3 = string2 == null || string2.length() == 0 ? "\u0001" + string : string2 + "\u0001" + string;
        return string3;
    }

    private static String createSortedString(OMNamespace oMNamespace, OMNode oMNode) {
        String string = oMNamespace.getPrefix();
        if (string == null || string.length() == 0) {
            return "\u0000";
        }
        return "\u0000" + string;
    }

    static class ReplacedNode {
        private OMNode fNode;

        ReplacedNode(OMNode oMNode) {
            this.fNode = oMNode;
        }

        OMNode getNode() {
            return this.fNode;
        }
    }

    static class OMNamespaces {
        OMNode parent;
        Hashtable namespaces;

        OMNamespaces(OMNode oMNode, Hashtable hashtable) {
            this.parent = oMNode;
            this.namespaces = hashtable;
            if (this.namespaces == null) {
                this.namespaces = new Hashtable();
            }
        }

        boolean contains(String string) {
            return this.namespaces.containsKey(string);
        }

        void serialize(OMNamespaces oMNamespaces, Writer writer) throws IOException {
            OMNamespace oMNamespace;
            int n;
            int n2 = this.namespaces.size();
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            OMNamespace[] oMNamespaceArray = new OMNamespace[n2];
            Enumeration enumeration = this.namespaces.elements();
            for (n = 0; n < n2; ++n) {
                oMNamespace = (OMNamespace)enumeration.nextElement();
                nArray[n] = n;
                oMNamespaceArray[n] = oMNamespace;
                stringArray[n] = Canonicalizer.createSortedString(oMNamespace, this.parent);
            }
            C14nUtil.heapSort(nArray, stringArray, n2);
            for (n = 0; n < n2; ++n) {
                oMNamespace = oMNamespaceArray[nArray[n]];
                String string = oMNamespace.getPrefix();
                if (string.equals("xml") || oMNamespaces != null && oMNamespaces.contains(string) && oMNamespaces.get(string).getName().equals(oMNamespace.getName())) continue;
                Canonicalizer.serializeNamespace(oMNamespace, writer);
            }
        }

        Enumeration enumeration() {
            return this.namespaces.elements();
        }

        OMNamespace get(String string) {
            return (OMNamespace)this.namespaces.get(string);
        }

        private void remove(String string) {
            Object v = this.namespaces.remove(string);
            if (v == null) {
                System.err.println("Internal logic error: No prefix named " + string);
            }
        }

        private boolean usePrefix(String string) {
            if (string.length() == 0) {
                return false;
            }
            Enumeration enumeration = this.enumeration();
            while (enumeration.hasMoreElements()) {
                OMNamespace oMNamespace = (OMNamespace)enumeration.nextElement();
                String string2 = oMNamespace.getPrefix();
                if (string2 == null || !string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        static boolean inAncestors(Stack stack, String string, String string2) {
            if (stack == null || stack.isEmpty()) {
                return false;
            }
            for (int i = stack.size() - 1; i >= 0; --i) {
                OMNamespaces oMNamespaces = (OMNamespaces)stack.elementAt(i);
                if (!oMNamespaces.contains(string) || !oMNamespaces.get(string).getName().equals(string2)) continue;
                return true;
            }
            return false;
        }

        void serialize(Stack stack, Hashtable hashtable, String string, Writer writer) throws IOException {
            OMNamespace oMNamespace;
            int n;
            int n2 = this.namespaces.size();
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            OMNamespace[] oMNamespaceArray = new OMNamespace[n2];
            Enumeration enumeration = this.namespaces.elements();
            for (n = 0; n < n2; ++n) {
                oMNamespace = (OMNamespace)enumeration.nextElement();
                nArray[n] = n;
                oMNamespaceArray[n] = oMNamespace;
                stringArray[n] = Canonicalizer.createSortedString(oMNamespace, this.parent);
            }
            C14nUtil.heapSort(nArray, stringArray, n2);
            for (n = 0; n < n2; ++n) {
                oMNamespace = oMNamespaceArray[nArray[n]];
                String string2 = oMNamespace.getPrefix();
                if (string2.equals("xml")) {
                    this.remove(string2);
                    continue;
                }
                if (OMNamespaces.inAncestors(stack, string2, oMNamespace.getName())) {
                    this.remove(string2);
                    continue;
                }
                if (!(hashtable != null && hashtable.get(string2) != null || string == null || string.equals(string2) || this.usePrefix(string2))) {
                    this.remove(string2);
                    continue;
                }
                Canonicalizer.serializeNamespace(oMNamespace, writer);
            }
        }

        public String toString() {
            return "OMNamespaces[#=" + this.namespaces.size() + "]";
        }
    }

    static class OMAttributes {
        OMNode parent;
        Hashtable attributes;

        OMAttributes(OMNode oMNode, Hashtable hashtable) {
            this.parent = oMNode;
            this.attributes = hashtable;
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            }
        }

        boolean contains(QName qName) {
            return this.attributes.containsKey(qName);
        }

        void serialize(OMAttributes oMAttributes, Writer writer) throws IOException {
            OMAttribute oMAttribute;
            int n;
            int n2 = this.attributes.size();
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            OMAttribute[] oMAttributeArray = new OMAttribute[n2];
            Enumeration enumeration = this.attributes.elements();
            for (n = 0; n < n2; ++n) {
                oMAttribute = (OMAttribute)enumeration.nextElement();
                nArray[n] = n;
                oMAttributeArray[n] = oMAttribute;
                stringArray[n] = Canonicalizer.createSortedString(oMAttribute, this.parent);
            }
            C14nUtil.heapSort(nArray, stringArray, n2);
            for (n = 0; n < n2; ++n) {
                String string;
                oMAttribute = oMAttributeArray[nArray[n]];
                QName qName = oMAttribute.getQName();
                String string2 = string = oMAttribute.getNamespace() == null ? null : oMAttribute.getNamespace().getPrefix();
                if (string != null && string.equals("xml") && oMAttributes != null && oMAttributes.contains(qName) && oMAttributes.get(qName).getAttributeValue().equals(oMAttribute.getAttributeValue())) continue;
                Canonicalizer.serializeAttribute(oMAttribute, writer);
            }
        }

        Enumeration enumeration() {
            return this.attributes.elements();
        }

        OMAttribute get(QName qName) {
            return (OMAttribute)this.attributes.get(qName);
        }

        private void remove(QName qName) {
            Object v = this.attributes.remove(qName);
            if (v == null) {
                System.err.println("Internal logic error: No attribute named " + qName);
            }
        }

        private boolean usePrefix(String string) {
            if (string.length() == 0) {
                return false;
            }
            Enumeration enumeration = this.enumeration();
            while (enumeration.hasMoreElements()) {
                OMAttribute oMAttribute = (OMAttribute)enumeration.nextElement();
                String string2 = oMAttribute.getNamespace() == null ? null : oMAttribute.getNamespace().getPrefix();
                if (string2 == null || !string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        static boolean inAncestors(Stack stack, QName qName, String string) {
            if (stack == null || stack.isEmpty()) {
                return false;
            }
            for (int i = stack.size() - 1; i >= 0; --i) {
                OMAttributes oMAttributes = (OMAttributes)stack.elementAt(i);
                if (!oMAttributes.contains(qName) || !oMAttributes.get(qName).getAttributeValue().equals(string)) continue;
                return true;
            }
            return false;
        }

        void serialize(Stack stack, Hashtable hashtable, String string, Writer writer) throws IOException {
            OMAttribute oMAttribute;
            int n;
            int n2 = this.attributes.size();
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            OMAttribute[] oMAttributeArray = new OMAttribute[n2];
            Enumeration enumeration = this.attributes.elements();
            for (n = 0; n < n2; ++n) {
                oMAttribute = (OMAttribute)enumeration.nextElement();
                nArray[n] = n;
                oMAttributeArray[n] = oMAttribute;
                stringArray[n] = Canonicalizer.createSortedString(oMAttribute, this.parent);
            }
            C14nUtil.heapSort(nArray, stringArray, n2);
            for (n = 0; n < n2; ++n) {
                oMAttribute = oMAttributeArray[nArray[n]];
                Canonicalizer.serializeAttribute(oMAttribute, writer);
            }
        }

        public String toString() {
            return "OMAttributes[#=" + this.attributes.size() + "]";
        }
    }
}

