/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.core.token.TokenGeneratorComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.wssecurity.platform.util.PasswordUtilFactory;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.BasicAuth;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CRL;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CallbackHandler;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertPathSettings;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertStoreList;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertStoreRef;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CollectionCertStores;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.DataEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.EncryptionInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.JAASConfig;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Key;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyStore;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.LdapCertStores;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.LdapServer;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Parameters;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBinding;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityOutboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityTokenReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningPartReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenGenerator;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Transform;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.ValueType;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.X509Certificates;
import java.io.File;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class WSSecurityDefaultGeneratorConfig
extends PrivateGeneratorConfig {
    private static final TraceComponent tc = Tr.register(WSSecurityDefaultGeneratorConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityDefaultGeneratorConfig.class.getName();
    private static SecurityBindings securityBindings;

    public WSSecurityDefaultGeneratorConfig(SecurityBindings securityBindings) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSecurityDefaultGeneratorConfig(Generator):", new Object[]{securityBindings});
        }
        this.init(securityBindings);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSecurityDefaultGeneratorConfig(Generator)");
        }
    }

    protected final void init(SecurityBindings securityBindings) throws SoapSecurityException {
        PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfoGeneratorConfImpl;
        PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl keyInfoContentGeneratorConfImpl;
        int n;
        int n2;
        Object object;
        List<Transform> list;
        List<SigningKeyInfo> list2;
        Object object2;
        Object object3;
        String string;
        PrivateGeneratorConfig.TokenGeneratorConfImpl tokenGeneratorConfImpl;
        Object object4;
        Object object5;
        int n3;
        Object object6;
        List<Parameters> list3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Generator", new Object[]{securityBindings});
        }
        Object v = null;
        SecurityOutboundBindingConfig securityOutboundBindingConfig = null;
        PrivateCommonConfig.CallbackHandlerConfImpl callbackHandlerConfImpl = null;
        HashMap<String, PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl> hashMap = new HashMap<String, PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl>();
        this._properties = new HashMap();
        WSSFactory wSSFactory = WSSFactory.getInstance("soap");
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        WSSecurityDefaultGeneratorConfig.securityBindings = securityBindings;
        List<SecurityBinding> list4 = WSSecurityDefaultGeneratorConfig.securityBindings.getSecurityBinding();
        VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
        this.processPrivateConfig(DOMUtils.getPrivateConfig());
        SecurityBinding securityBinding = null;
        for (int i = 0; i < list4.size(); ++i) {
            securityBinding = list4.get(i);
            if (!securityBinding.getName().equals("application")) continue;
            securityOutboundBindingConfig = securityBinding.getSecurityOutboundBindingConfig();
        }
        List<EncryptionInfo> list5 = null;
        List<KeyInfo> list6 = null;
        List<SigningInfo> list7 = null;
        List<TokenGenerator> list8 = null;
        CertStoreList certStoreList = null;
        HashMap<String, PrivateGeneratorConfig.TokenGeneratorConfImpl> hashMap3 = new HashMap<String, PrivateGeneratorConfig.TokenGeneratorConfImpl>();
        Map<Object, Object> map = null;
        Map<Object, Object> map2 = null;
        if (securityBinding != null) {
            list3 = securityBinding.getParameters();
            if (list3 != null) {
                map2 = ConfigConstants.getProperties(list3, variableExpander);
            }
            if (map2 != null) {
                this._properties.putAll(map2);
            }
            if (securityOutboundBindingConfig != null && (object6 = securityOutboundBindingConfig.getProperties()) != null && (map = ConfigConstants.getProperties(object6, variableExpander)) != null) {
                this._properties.putAll(map);
            }
        }
        if (securityOutboundBindingConfig != null) {
            list5 = securityOutboundBindingConfig.getEncryptionInfo();
            certStoreList = securityOutboundBindingConfig.getCertStoreList();
            list6 = securityOutboundBindingConfig.getKeyInfo();
            list7 = securityOutboundBindingConfig.getSigningInfo();
            list8 = securityOutboundBindingConfig.getTokenGenerator();
            if (tc.isDebugEnabled()) {
                list3 = map2 == null ? "null" : map2.toString();
                object6 = map == null ? "null" : map.toString();
                Tr.debug(tc, "Default Outbound Binding (SigningInfos, EncryptionInfos, KeyInfos, TokenGenerators, Parameters, Property):", new Object[]{list7, list5, list6, list8, list3, object6});
            }
        }
        this._clientSetMustUnderstand = ConfigUtil.getIsFalseProperty(this._properties, Constants.WSSECURITY_SET_MUSTUNDERSTAND);
        boolean bl = ConfigUtil.getIsTrueProperty(this._properties, Constants.WSSECURITY_GET_MUSTUNDERSTAND);
        boolean bl2 = this._serviceGetMustUnderstand = !bl;
        if (list8 != null) {
            n3 = list8.size();
            for (int i = 0; i < n3; ++i) {
                object5 = list8.get(i);
                ValueType valueType = ((TokenGenerator)object5).getValueType();
                if (valueType == null) {
                    throw new SoapSecurityException("The valueType field for the token generator named " + ((TokenGenerator)object5).getName() + " is missing");
                }
                QName qName = new QName(ConfigUtil.trim(valueType.getUri()), ConfigUtil.trim(valueType.getLocalName()));
                object4 = ((TokenGenerator)object5).getSecurityTokenReference();
                tokenGeneratorConfImpl = null;
                if (object4 != null && (string = ConfigUtil.trim(((SecurityTokenReference)object4).getReference())) != null && string.length() > 0) {
                    if (tokenGeneratorConfImpl == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", string);
                    }
                    if (!tokenGeneratorConfImpl.getType().equals(qName)) {
                        throw SoapSecurityException.format("Expecting TokenGenerator with QName: " + qName.toString() + " received Unmatched QName: " + tokenGeneratorConfImpl.getType().toString());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + string);
                    }
                }
                if (tokenGeneratorConfImpl == null) {
                    tokenGeneratorConfImpl = new PrivateGeneratorConfig.TokenGeneratorConfImpl();
                    tokenGeneratorConfImpl._type = qName;
                }
                tokenGeneratorConfImpl._className = ConfigUtil.trim(((TokenGenerator)object5).getClassname());
                if (!this._defaultTokenGenerators.contains(tokenGeneratorConfImpl._className)) {
                    this._userDefinedComponentsUsed = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "userDefinedComponentsUsed set to true; token generator = " + tokenGeneratorConfImpl._className);
                    }
                }
                if ((object3 = ((TokenGenerator)object5).getCallbackHandler()) != null) {
                    Object object7;
                    callbackHandlerConfImpl = new PrivateCommonConfig.CallbackHandlerConfImpl();
                    callbackHandlerConfImpl._className = ConfigUtil.trim(((CallbackHandler)object3).getClassname());
                    if (!this._defaultCallbackHandlers.contains(callbackHandlerConfImpl._className)) {
                        this._userDefinedComponentsUsed = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "userDefinedComponentsUsed set to true; callback handler = " + callbackHandlerConfImpl._className);
                        }
                    }
                    if ((object2 = ((CallbackHandler)object3).getKeyStore()) != null) {
                        PrivateCommonConfig.KeyStoreConfImpl keyStoreConfImpl = new PrivateCommonConfig.KeyStoreConfImpl();
                        keyStoreConfImpl._type = ConfigUtil.trim(((KeyStore)object2).getType());
                        keyStoreConfImpl._path = ConfigUtil.expandInstallLocation(ConfigUtil.trim(((KeyStore)object2).getPath()));
                        keyStoreConfImpl._password = PasswordUtilFactory.getInstance().passwordDecode(ConfigUtil.trim(((KeyStore)object2).getStorepass()));
                        keyStoreConfImpl._ksRef = ConfigUtil.trim(((KeyStore)object2).getKeyStoreRef());
                        callbackHandlerConfImpl._keyStore = keyStoreConfImpl;
                        if (keyStoreConfImpl._ksRef != null && keyStoreConfImpl._ksRef.length() != 0) {
                            tokenGeneratorConfImpl._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", keyStoreConfImpl._ksRef);
                        }
                    }
                    if ((list2 = ((CallbackHandler)object3).getKey()) != null) {
                        PrivateCommonConfig.KeyInformationConfImpl keyInformationConfImpl = new PrivateCommonConfig.KeyInformationConfImpl();
                        keyInformationConfImpl._alias = ConfigUtil.trim(((Key)((Object)list2)).getAlias());
                        keyInformationConfImpl._keypass = PasswordUtilFactory.getInstance().passwordDecode(ConfigUtil.trim(((Key)((Object)list2)).getKeypass()));
                        keyInformationConfImpl._name = ConfigUtil.trim(((Key)((Object)list2)).getName());
                        callbackHandlerConfImpl._keyInformation = keyInformationConfImpl;
                    }
                    if ((list = ((CallbackHandler)object3).getCertPathSettings()) != null && (object7 = ((CertPathSettings)((Object)list)).getCertStoreRef()) != null) {
                        object = new ArrayList();
                        Provider provider = null;
                        if (object7 != null) {
                            string = ConfigUtil.trim(((CertStoreRef)object7).getReference());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "CertStoreRef = " + string);
                            }
                            boolean bl3 = false;
                            if (certStoreList != null) {
                                Object object8;
                                Object object9;
                                List<Object> list9;
                                Object object10;
                                Object object11;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                List<Object> list10 = certStoreList.getLdapCertStoresOrCollectionCertStores();
                                n2 = list10.size();
                                if (n2 > 0) {
                                    Object object12 = list10.get(0);
                                    if (object12 instanceof CollectionCertStores) {
                                        bl5 = true;
                                    } else if (object12 instanceof LdapCertStores) {
                                        bl4 = true;
                                    }
                                }
                                if (bl5) {
                                    for (int j = 0; j < n2; ++j) {
                                        File file;
                                        CertificateFactory certificateFactory;
                                        String string2;
                                        Object object13;
                                        object11 = (CollectionCertStores)list10.get(j);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "collectionCertStore.get(" + j + ") = " + ((CollectionCertStores)object11).getName());
                                        }
                                        if (string == null || !string.equals(ConfigUtil.trim(((CollectionCertStores)object11).getName()))) continue;
                                        provider = Security.getProvider(ConfigUtil.trim(((CollectionCertStores)object11).getProvider()));
                                        boolean bl6 = false;
                                        boolean bl7 = false;
                                        HashMap<String, CertificateFactory> hashMap4 = new HashMap<String, CertificateFactory>();
                                        object10 = new HashSet();
                                        list9 = ((CollectionCertStores)object11).getX509CertificatesOrCRL();
                                        n = list9.size();
                                        if (n > 0) {
                                            object9 = list9.get(0);
                                            if (object9 instanceof X509Certificates) {
                                                bl6 = true;
                                            } else if (object9 instanceof CRL) {
                                                bl7 = true;
                                            }
                                        }
                                        if (bl6) {
                                            for (int k = 0; k < n; ++k) {
                                                object13 = (X509Certificates)list9.get(k);
                                                object8 = null;
                                                object8 = ConfigUtil.expandInstallLocation(ConfigUtil.trim(((X509Certificates)object13).getPath()));
                                                string2 = "";
                                                certificateFactory = (CertificateFactory)hashMap4.get(string2);
                                                if (certificateFactory == null) {
                                                    certificateFactory = ConfigUtil.createCertificateFactory(string2);
                                                    hashMap4.put(string2, certificateFactory);
                                                }
                                                file = new File((String)object8);
                                                object10.add(ConfigUtil.getX509Certificate(file, certificateFactory));
                                                if (!tc.isDebugEnabled()) continue;
                                                Tr.debug(tc, "Adding the X509 certificate: " + (String)object8);
                                            }
                                        }
                                        if (bl7) {
                                            for (int k = 0; k < n; ++k) {
                                                object13 = (CRL)list9.get(k);
                                                object8 = null;
                                                object8 = ConfigUtil.expandInstallLocation(ConfigUtil.trim(((CRL)object13).getPath()));
                                                string2 = "";
                                                certificateFactory = (CertificateFactory)hashMap4.get(string2);
                                                if (certificateFactory == null) {
                                                    certificateFactory = ConfigUtil.createCertificateFactory(string2);
                                                    hashMap4.put(string2, certificateFactory);
                                                }
                                                file = new File((String)object8);
                                                object10.add(ConfigUtil.getX509CRL(file, certificateFactory));
                                                if (!tc.isDebugEnabled()) continue;
                                                Tr.debug(tc, "Adding the X509 CRL: " + (String)object8);
                                            }
                                        }
                                        object9 = "Collection";
                                        object13 = null;
                                        try {
                                            object13 = new CollectionCertStoreParameters((Collection<?>)object10);
                                            object8 = null;
                                            object8 = provider == null ? CertStore.getInstance((String)object9, (CertStoreParameters)object13) : CertStore.getInstance((String)object9, (CertStoreParameters)object13, provider);
                                            object.add(object8);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Found CertStore for " + string);
                                            }
                                            bl3 = true;
                                            break;
                                        }
                                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                            string2 = "security.wssecurity.CommonReceiverConfig.s20";
                                            Tr.error(tc, string2, new Object[]{object9});
                                            throw SoapSecurityException.format(string2, (String)object9, (Throwable)noSuchAlgorithmException);
                                        }
                                        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                                            string2 = "security.wssecurity.CommonReceiverConfig.s21";
                                            Tr.error(tc, string2, new Object[]{((CollectionCertStoreParameters)object13).toString() == null ? "" : ((CollectionCertStoreParameters)object13).toString()});
                                            throw SoapSecurityException.format(string2, ((CollectionCertStoreParameters)object13).toString() == null ? "" : ((CollectionCertStoreParameters)object13).toString(), (Throwable)invalidAlgorithmParameterException);
                                        }
                                        catch (Throwable throwable) {
                                            string2 = "security.wssecurity.load.collectioncertstore.failed";
                                            Tr.error(tc, string2, new String[]{((CollectionCertStores)object11).getName(), throwable.getMessage()});
                                            throw SoapSecurityException.format(string2, new String[]{((CollectionCertStores)object11).getName(), throwable.getMessage()}, throwable);
                                        }
                                    }
                                }
                                if (!bl3 && bl4) {
                                    for (int j = 0; j < n2; ++j) {
                                        int n4;
                                        object11 = (LdapCertStores)list10.get(j);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "ldapCertStores.get(" + j + ") = " + ((LdapCertStores)object11).getName());
                                        }
                                        if (string == null || !string.equals(ConfigUtil.trim(((LdapCertStores)object11).getName()))) continue;
                                        LdapServer ldapServer = ((LdapCertStores)object11).getLdapServer();
                                        String string3 = ConfigUtil.trim(ldapServer.getHost());
                                        try {
                                            n4 = Integer.parseInt(ldapServer.getPort());
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            list9 = "security.wssecurity.PrivateGeneratorConfig.s19";
                                            object9 = ldapServer.getPort();
                                            Tr.processException((Throwable)numberFormatException, clsName + ".PolicyOutboundConfig", "1632", this);
                                            Tr.error(tc, (String)((Object)list9), object9);
                                            throw SoapSecurityException.format((String)((Object)list9), (String)object9, (Throwable)numberFormatException);
                                        }
                                        object10 = "LDAP";
                                        provider = Security.getProvider(ConfigUtil.trim(((LdapCertStores)object11).getProvider()));
                                        object9 = new LDAPCertStoreParameters(string3, n4);
                                        try {
                                            list9 = provider == null ? CertStore.getInstance((String)object10, (CertStoreParameters)object9) : CertStore.getInstance((String)object10, (CertStoreParameters)object9, provider);
                                        }
                                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                            object8 = "security.wssecurity.PrivateGeneratorConfig.s20";
                                            Tr.processException((Throwable)noSuchAlgorithmException, clsName + ".PolicyOutboundConfig", "1649", this);
                                            Tr.error(tc, (String)object8, object10);
                                            throw SoapSecurityException.format((String)object8, (String)object10);
                                        }
                                        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                                            object8 = "security.wssecurity.PrivateGeneratorConfig.s21";
                                            Tr.processException((Throwable)invalidAlgorithmParameterException, clsName + ".PolicyOutboundConfig", "1654", this);
                                            Tr.error(tc, (String)object8, ((LDAPCertStoreParameters)object9).toString());
                                            throw SoapSecurityException.format((String)object8, ((LDAPCertStoreParameters)object9).toString());
                                        }
                                        object.add(list9);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Found CertStore for " + string);
                                        }
                                        bl3 = true;
                                        break;
                                    }
                                }
                            }
                        }
                        callbackHandlerConfImpl._provider = provider;
                        callbackHandlerConfImpl._certStores = object;
                    }
                    if ((object7 = ((CallbackHandler)object3).getBasicAuth()) != null) {
                        string = ConfigUtil.trim(((BasicAuth)object7).getUserid());
                        if (string != null && string.length() > 0) {
                            callbackHandlerConfImpl._userId = string;
                        }
                        if ((string = PasswordUtilFactory.getInstance().passwordDecode(ConfigUtil.trim(((BasicAuth)object7).getPassword()))) != null && string.length() > 0) {
                            callbackHandlerConfImpl._userPassword = string.toCharArray();
                        }
                    }
                    ConfigConstants.getProperties(callbackHandlerConfImpl._properties, ((CallbackHandler)object3).getProperties(), variableExpander);
                    tokenGeneratorConfImpl._callbackHandler = callbackHandlerConfImpl;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the callback handler: " + callbackHandlerConfImpl.getClassName());
                    }
                }
                if ((object2 = ((TokenGenerator)object5).getJAASConfig()) == null) {
                    throw new SoapSecurityException("The jaasConfig in the binding not defined ");
                }
                tokenGeneratorConfImpl._jaasConfig = ConfigUtil.trim(((JAASConfig)object2).getConfigName());
                if (!this._defaultJAASConfigs.contains(tokenGeneratorConfImpl._jaasConfig)) {
                    this._userDefinedComponentsUsed = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "userDefinedComponentsUsed set to true; JAAS config = " + tokenGeneratorConfImpl._jaasConfig);
                    }
                }
                ConfigConstants.getProperties(tokenGeneratorConfImpl._jaasConfigProperties, ((JAASConfig)object2).getProperties(), variableExpander);
                ConfigConstants.getProperties(tokenGeneratorConfImpl._properties, ((TokenGenerator)object5).getProperties(), variableExpander);
                hashMap2.clear();
                hashMap2.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
                hashMap2.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", tokenGeneratorConfImpl._className);
                if (v != null) {
                    hashMap2.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", v);
                }
                list2 = new HashMap();
                try {
                    tokenGeneratorConfImpl._instance = (TokenGeneratorComponent)wSSFactory.createGenerator(hashMap2, (Map<Object, Object>)((Object)list2));
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.warning(tc, "security.wssecurity.Instantiate", new Object[]{tokenGeneratorConfImpl._className});
                }
                this._tokenGenerators.add(tokenGeneratorConfImpl);
                string = ConfigUtil.trim(((TokenGenerator)object5).getName());
                if (string == null || string.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s26");
                }
                if (hashMap3.containsKey(string) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: token generator [" + string + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding token generator: " + string);
                }
                hashMap3.put(string, tokenGeneratorConfImpl);
                tokenGeneratorConfImpl._name = string;
            }
        }
        if (list6 != null) {
            n3 = list6.size();
            for (int i = 0; i < n3; ++i) {
                object5 = list6.get(i);
                keyInfoContentGeneratorConfImpl = new PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl();
                keyInfoContentGeneratorConfImpl._className = ConfigUtil.trim(((KeyInfo)object5).getClassname());
                boolean bl8 = true;
                boolean bl9 = false;
                if (!this._defaultKeyInfoContentGenerators.contains(keyInfoContentGeneratorConfImpl._className)) {
                    this._userDefinedComponentsUsed = true;
                    bl8 = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "userDefinedComponentsUsed set to true; key info content generator = " + keyInfoContentGeneratorConfImpl._className);
                    }
                }
                keyInfoContentGeneratorConfImpl._keyInfoType = ConfigUtil.trim(((KeyInfo)object5).getType());
                object4 = ((KeyInfo)object5).getTokenReference();
                if (object4 != null) {
                    string = ConfigUtil.trim(((TokenReference)object4).getReference());
                    if (string != null && string.length() > 0) {
                        keyInfoContentGeneratorConfImpl._tokenGenerator = (PrivateGeneratorConfig.TokenGeneratorConfImpl)hashMap3.get(string);
                        if (keyInfoContentGeneratorConfImpl._tokenGenerator == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s31", string);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got the token reference: " + string);
                        }
                        if (!bl9) {
                            tokenGeneratorConfImpl = keyInfoContentGeneratorConfImpl._tokenGenerator;
                            object3 = (String)tokenGeneratorConfImpl._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                            if (object3 != null) {
                                keyInfoContentGeneratorConfImpl._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", object3);
                            }
                        }
                    } else if (keyInfoContentGeneratorConfImpl._className.equals("com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentGenerator")) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s29");
                    }
                } else if (keyInfoContentGeneratorConfImpl._className.equals("com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentGenerator")) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s29");
                }
                ConfigConstants.getProperties(keyInfoContentGeneratorConfImpl._properties, ((KeyInfo)object5).getProperties(), variableExpander);
                hashMap2.clear();
                hashMap2.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
                hashMap2.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", keyInfoContentGeneratorConfImpl._className);
                if (keyInfoContentGeneratorConfImpl._className == null || keyInfoContentGeneratorConfImpl._className.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s03");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeyInfoContentGenerator classname = " + keyInfoContentGeneratorConfImpl._className);
                }
                if (bl8) {
                    hashMap2.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", this.getClass().getClassLoader());
                } else if (v != null) {
                    hashMap2.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", v);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ClassLoader used = " + hashMap2.get("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader"));
                }
                object3 = new HashMap<Object, Object>();
                try {
                    keyInfoContentGeneratorConfImpl._instance = (KeyInfoContentGeneratorComponent)wSSFactory.createGenerator((Map<Object, Object>)hashMap2, (Map<Object, Object>)object3);
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.warning(tc, "security.wssecurity.Instantiate", new Object[]{keyInfoContentGeneratorConfImpl._className});
                }
                string = ConfigUtil.trim(((KeyInfo)object5).getName());
                if (string == null || string.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s28");
                }
                if (hashMap.containsKey(string) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: key info [" + string + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key info: " + string);
                }
                hashMap.put(string, keyInfoContentGeneratorConfImpl);
            }
        }
        if (list5 != null) {
            n3 = list5.size();
            for (int i = 0; i < n3; ++i) {
                object5 = list5.get(i);
                PrivateGeneratorConfig.EncryptionGeneratorConfImpl encryptionGeneratorConfImpl = new PrivateGeneratorConfig.EncryptionGeneratorConfImpl();
                keyInfoGeneratorConfImpl = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
                String string4 = null;
                String string5 = ((EncryptionInfo)object5).getOrder();
                if (string5 == null) {
                    throw SoapSecurityException.format("Order is a required attribute for encryption information on outbound bindings.");
                }
                object4 = Integer.parseInt(string5);
                encryptionGeneratorConfImpl._properties.put("com.ibm.ws.wssecurity.constants.order", object4);
                object4 = ((EncryptionInfo)object5).getKeyEncryptionKeyInfo();
                if (object4 != null && object4.size() == 1) {
                    encryptionGeneratorConfImpl._isKeyEncryption = true;
                    object3 = object4.get(0);
                    string = ConfigUtil.trim(((KeyEncryptionKeyInfo)object3).getReference());
                    if (string != null && string.length() > 0) {
                        keyInfoContentGeneratorConfImpl = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)hashMap.get(string);
                        if (keyInfoContentGeneratorConfImpl == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s31", string);
                        }
                        string4 = (String)keyInfoContentGeneratorConfImpl._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        tokenGeneratorConfImpl = keyInfoContentGeneratorConfImpl._tokenGenerator;
                        if (tokenGeneratorConfImpl != null) {
                            tokenGeneratorConfImpl._usedForEncryption = true;
                        }
                        keyInfoGeneratorConfImpl._contentGenerator = keyInfoContentGeneratorConfImpl;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got the key info reference: " + string);
                        }
                    }
                }
                if (((EncryptionInfo)object5).getEncryptionPartReference() != null && (object3 = ((EncryptionInfo)object5).getEncryptionPartReference().getDataEncryptionKeyInfo()) != null && object3.size() == 1) {
                    encryptionGeneratorConfImpl._isKeyEncryption = false;
                    object2 = (DataEncryptionKeyInfo)object3.get(0);
                    string = ConfigUtil.trim(((DataEncryptionKeyInfo)object2).getReference());
                    if (string != null && string.length() > 0) {
                        keyInfoContentGeneratorConfImpl = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)hashMap.get(string);
                        if (keyInfoContentGeneratorConfImpl == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", string);
                        }
                        string4 = (String)keyInfoContentGeneratorConfImpl._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        tokenGeneratorConfImpl = keyInfoContentGeneratorConfImpl._tokenGenerator;
                        if (tokenGeneratorConfImpl != null) {
                            tokenGeneratorConfImpl._usedForEncryption = true;
                        }
                        keyInfoGeneratorConfImpl._contentGenerator = keyInfoContentGeneratorConfImpl;
                        encryptionGeneratorConfImpl._encryptionKeyInfo = keyInfoGeneratorConfImpl;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got the key info reference: " + string);
                        }
                    }
                }
                encryptionGeneratorConfImpl._encryptionKeyInfo = keyInfoGeneratorConfImpl;
                if (string4 != null && ConfigUtil.isHWKeyStore(string4)) {
                    encryptionGeneratorConfImpl._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", string4);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Hardware KeyStore is used: " + string4);
                    }
                }
                ConfigConstants.getProperties(encryptionGeneratorConfImpl._properties, ((EncryptionInfo)object5).getProperties(), variableExpander);
                this._operationGenerators.add(encryptionGeneratorConfImpl);
            }
        }
        if (list7 != null) {
            n3 = list7.size();
            for (int i = 0; i < n3; ++i) {
                PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl;
                object5 = list7.get(i);
                PrivateGeneratorConfig.SignatureGeneratorConfImpl signatureGeneratorConfImpl = new PrivateGeneratorConfig.SignatureGeneratorConfImpl();
                Object var35_38 = null;
                Object var36_42 = null;
                object4 = ((SigningInfo)object5).getOrder();
                if (object4 == null) {
                    throw SoapSecurityException.format("Order is a required attribute for signing information on outbound bindings.");
                }
                object3 = Integer.parseInt((String)object4);
                signatureGeneratorConfImpl._properties.put("com.ibm.ws.wssecurity.constants.order", object3);
                object3 = ((SigningInfo)object5).getSigningPartReference();
                if (object3 != null) {
                    n2 = object3.size();
                    for (int j = 0; j < n2; ++j) {
                        list2 = (SigningPartReference)((Object)object3.get(j));
                        PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl = new PrivateCommonConfig.SigningReferenceConfImpl();
                        list = ((SigningPartReference)((Object)list2)).getTransform();
                        if (list != null) {
                            n = list.size();
                            for (int k = 0; k < n; ++k) {
                                object = list.get(k);
                                if (object == null) continue;
                                algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                                algorithmConfImpl._algorithm = ConfigUtil.trim(((Transform)object).getAlgorithm());
                                ConfigConstants.getProperties(algorithmConfImpl._properties, ((Transform)object).getProperties(), variableExpander);
                                if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(algorithmConfImpl._algorithm)) {
                                    signingReferenceConfImpl._transforms.add(0, algorithmConfImpl);
                                    continue;
                                }
                                signingReferenceConfImpl._transforms.add(algorithmConfImpl);
                            }
                        }
                        signatureGeneratorConfImpl._references.add(signingReferenceConfImpl);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: PartReference not found on SigningInfo. PartReference is required in order to retrieve the signature algorithms from Policy.");
                }
                algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                algorithmConfImpl._algorithm = var35_38;
                signatureGeneratorConfImpl._canonicalizationMethod = algorithmConfImpl;
                algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                algorithmConfImpl._algorithm = var36_42;
                signatureGeneratorConfImpl._signatureMethod = algorithmConfImpl;
                keyInfoGeneratorConfImpl = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
                object2 = null;
                list2 = ((SigningInfo)object5).getSigningKeyInfo();
                if ((list2 != null || list2.size() == 1) && (string = ConfigUtil.trim(((SigningKeyInfo)((Object)(list = list2.get(0)))).getReference())) != null && string.length() > 0) {
                    keyInfoContentGeneratorConfImpl = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)hashMap.get(string);
                    if (keyInfoContentGeneratorConfImpl == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s31", string);
                    }
                    object2 = (String)keyInfoContentGeneratorConfImpl._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                    tokenGeneratorConfImpl = keyInfoContentGeneratorConfImpl._tokenGenerator;
                    if (tokenGeneratorConfImpl != null) {
                        tokenGeneratorConfImpl._usedForSignature = true;
                    }
                    keyInfoGeneratorConfImpl._contentGenerator = keyInfoContentGeneratorConfImpl;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the key info reference: " + string);
                    }
                }
                signatureGeneratorConfImpl._signingKeyInfo = keyInfoGeneratorConfImpl;
                if (object2 != null && ConfigUtil.isHWKeyStore((String)object2)) {
                    signatureGeneratorConfImpl._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", object2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Hardware KeyStore is used: " + (String)object2);
                    }
                }
                ConfigConstants.getProperties(signatureGeneratorConfImpl._properties, ((SigningInfo)object5).getProperties(), variableExpander);
                this._operationGenerators.add(signatureGeneratorConfImpl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Consumer, HashMap):", new Object[]{securityBindings, variableExpander});
        }
    }
}

