/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.ThreadContextMigrator;

public class WSSecurityContextMigrator
implements ThreadContextMigrator {
    private static final TraceComponent tc = Tr.register(WSSecurityContextMigrator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityContextMigrator.class.getName();
    private final String WSSECURITY_INITIAL_SENDER_SUBJECT = "com.ibm.ws.wssecurity.initial.sender.subject";
    private final String WSSECURITY_INITIAL_SENDER_CERTIFICATE = "com.ibm.ws.wssecurity.initial.sender.x509certificate";
    private final String WSSECURITY_INITIAL_SENDER = "com.ibm.ws.wssecurity.initial.sender";

    public void migrateContextToThread(MessageContext messageContext) throws AxisFault {
        ContextManager contextManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "migrateContextToThread(MessageContext mc)" + messageContext.getMessageID());
        }
        if ((contextManager = ContextManagerFactory.getInstance()) == null) {
            Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
        } else {
            Serializable serializable;
            HashMap hashMap = (HashMap)messageContext.getProperty("com.ibm.ws.wssecurity.initial.sender");
            if (hashMap == null || hashMap.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no Initial sender need migration.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "migrateContextToThread(MessageContext mc)" + messageContext.getMessageID());
                }
                return;
            }
            if (hashMap.containsKey("com.ibm.ws.wssecurity.initial.sender.subject")) {
                serializable = (Subject)hashMap.get("com.ibm.ws.wssecurity.initial.sender.subject");
                if (serializable != null) {
                    contextManager.put("com.ibm.wsspi.wssecurity.username.initialSenderId", serializable);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Initial Sender is set to TLS.");
                    }
                }
            } else if (contextManager.get("com.ibm.wsspi.wssecurity.username.initialSenderId") != null) {
                contextManager.put("com.ibm.wsspi.wssecurity.username.initialSenderId", null);
            }
            if (hashMap.containsKey("com.ibm.ws.wssecurity.initial.sender.x509certificate")) {
                serializable = (X509Certificate)hashMap.get("com.ibm.ws.wssecurity.initial.sender.x509certificate");
                if (serializable != null) {
                    contextManager.put("com.ibm.wsspi.wssecurity.username.initialSenderCert", serializable);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Initial Cert is set to TLS.");
                    }
                }
            } else if (contextManager.get("com.ibm.wsspi.wssecurity.username.initialSenderCert") != null) {
                contextManager.put("com.ibm.wsspi.wssecurity.username.initialSenderCert", null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "migrateContextToThread((MessageContext mc))" + messageContext.getMessageID());
        }
    }

    public void cleanupThread(MessageContext messageContext) {
        ContextManager contextManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupThread(MessageContext[" + messageContext.getMessageID() + "])");
        }
        if ((contextManager = ContextManagerFactory.getInstance()) == null) {
            Tr.error(tc, "com.ibm.ws.security.core.ContextManagerFactory.getInstance() returned null");
        } else {
            if (contextManager.get("com.ibm.wsspi.wssecurity.username.initialSenderId") != null) {
                contextManager.put("com.ibm.wsspi.wssecurity.username.initialSenderId", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSSECURITY_INITIAL_SENDER_ID removed from contextManager");
                }
            }
            if (contextManager.get("com.ibm.wsspi.wssecurity.username.initialSenderCert") != null) {
                contextManager.put("com.ibm.wsspi.wssecurity.username.initialSenderCert", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSSECURITY_INITIAL_SENDER_CERT removed from contextManager");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupThread(MessageContext[" + messageContext.getMessageID() + "])");
        }
    }

    public void migrateThreadToContext(MessageContext messageContext) throws AxisFault {
        ContextManager contextManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "migrateThreadToContext(MessageContext mc)" + messageContext.getMessageID());
        }
        if ((contextManager = ContextManagerFactory.getInstance()) == null) {
            Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
        } else {
            X509Certificate x509Certificate;
            HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
            Subject subject = (Subject)contextManager.get("com.ibm.wsspi.wssecurity.username.initialSenderId");
            if (subject != null) {
                hashMap.put("com.ibm.ws.wssecurity.initial.sender.subject", subject);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initial Sender is set to context.");
                }
            } else if (hashMap.get("com.ibm.ws.wssecurity.initial.sender.subject") != null) {
                hashMap.put("com.ibm.ws.wssecurity.initial.sender.subject", null);
            }
            if ((x509Certificate = (X509Certificate)contextManager.get("com.ibm.wsspi.wssecurity.username.initialSenderCert")) != null) {
                hashMap.put("com.ibm.ws.wssecurity.initial.sender.x509certificate", x509Certificate);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initial Cert is set to context.");
                }
            } else if (hashMap.get("com.ibm.ws.wssecurity.initial.sender.x509certificate") != null) {
                hashMap.put("com.ibm.ws.wssecurity.initial.sender.x509certificate", null);
            }
            if (!hashMap.isEmpty()) {
                messageContext.setProperty("com.ibm.ws.wssecurity.initial.sender", hashMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "migrateThreadToContext((MessageContext mc))" + messageContext.getMessageID());
        }
    }

    public void cleanupContext(MessageContext messageContext) {
    }
}

