/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.wssecurity.core.SecurityTokenServiceAdmin;
import com.ibm.ws.wssecurity.platform.websphere.auth.WSSDistributedCache;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.wsspi.runtime.component.WsComponentImpl;

public class WSSecurityComponentImpl
extends WsComponentImpl {
    private static final String COMP_NAME = "security.wssecurity";
    private static final String CLASS_NAME = WSSecurityComponentImpl.class.getName();
    private static final TraceComponent tc = Tr.register(WSSecurityComponentImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        super.start();
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Registering SecurityTokenServiceAdmin MBean");
            }
            SecurityTokenServiceAdmin securityTokenServiceAdmin = new SecurityTokenServiceAdmin();
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(securityTokenServiceAdmin, "SecurityTokenServiceAdmin");
            mBeanFactory.activateMBean("SecurityTokenServiceAdmin", defaultRuntimeCollaborator, mBeanFactory.getConfigId("SecurityTokenServiceAdmin"), "com/ibm/ws/management/descriptor/xml/SecurityTokenServiceAdmin.xml");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SecurityTokenServiceAdmin MBean registered");
            }
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, CLASS_NAME + ".start", "69", this);
            Tr.error(tc, "security.wssecurity.CWWSS0111E", new Object[]{exception});
        }
        WSSDistributedCache.initializeClient();
        WSSDistributedCache.initializeService();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        HWKeyCache.removeAllEntries();
        super.stop();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        super.initialize(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
            Tr.exit(tc, "destroy");
        }
        super.destroy();
    }
}

