/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.ws.wssecurity.common.RequestPool;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.RequestMessagePool;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.core.WSSGeneratorComponent;
import com.ibm.ws.wssecurity.core.token.TokenGeneratorComponent;
import com.ibm.ws.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.wssecurity.enc.EncryptionGenerator;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoGenerator;
import com.ibm.ws.wssecurity.time.TimestampGenerator;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.SetupJCEProviders;
import com.ibm.ws.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.wssecurity.util.XPathElementSelector;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.wssapi.OMStructure;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMNodeImpl;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSSGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(WSSGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private Map<String, Object> _handlerOption = new HashMap<String, Object>();
    private Map<Object, Object> _properties = new HashMap<Object, Object>();
    private boolean _initialized = false;

    public void setHandlerOption(String string, Object object) {
        this._handlerOption.put(string, object);
    }

    public Object getHandlerOption(String string) {
        return this._handlerOption.get(string);
    }

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this.setInitialProperties();
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMDocument oMDocument, OMElement oMElement, Map<Object, Object> map) throws SoapSecurityException {
        int n;
        Object object;
        boolean bl;
        HashMap<Object, Object> hashMap;
        MessageContext messageContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Document doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "Element parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "Map context)");
        }
        if ((messageContext = (MessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext")) == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        RequestPool.initialize(map);
        boolean bl2 = WSSGenerator.adjustContext(messageContext, map);
        SecurityTokenManagerImpl securityTokenManagerImpl = new SecurityTokenManagerImpl(map);
        RequestMessagePool.initialize(map);
        Object object2 = messageContext.getProperty("com.ibm.ws.wssecurity.constants.wssVersion");
        int n2 = 0;
        if (object2 != null && object2 instanceof Integer) {
            n2 = (Integer)object2;
            map.put("com.ibm.ws.wssecurity.constants.wssVersion", object2);
        }
        WSSGeneratorConfig wSSGeneratorConfig = (WSSGeneratorConfig)map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSSGeneratorConfig [" + wSSGeneratorConfig + "].");
        }
        TimestampGeneratorConfig timestampGeneratorConfig = wSSGeneratorConfig.getTimestampGenerator();
        String string = (String)messageContext.getProperty("com.ibm.ws.wssecurity.EnforceStrictLayout");
        if (string != null) {
            hashMap = (HashMap<Object, Object>)wSSGeneratorConfig.getProperties();
            hashMap.put("com.ibm.ws.wssecurity.EnforceStrictLayout", string);
        }
        hashMap = new HashMap<Object, Object>(this._properties);
        map.put(NonceManager.class, wSSGeneratorConfig.getNonceManager());
        boolean bl3 = wSSGeneratorConfig.isRequest();
        boolean bl4 = wSSGeneratorConfig.isSignatureConfirmationRequired();
        boolean bl5 = wSSGeneratorConfig.isTimestampEnabled();
        boolean bl6 = bl = wSSGeneratorConfig.isTokenEnabled() || wSSGeneratorConfig.isSignatureEnabled() || wSSGeneratorConfig.isEncryptionEnabled() || bl5 && !timestampGeneratorConfig.isSOAPHeaderElement() || bl2;
        if (!bl5 && !bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc, Element parent, Map context)");
            }
            return;
        }
        String string2 = null;
        if (messageContext.getTo() != null) {
            object = messageContext.getTo().getAddress();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The Target end point address = " + (String)object);
            }
            if (((String)object).equals(com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS_ANONYMOUS[0]) || ((String)object).equals(com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS_ANONYMOUS[1])) {
                string2 = messageContext.getWSAAction();
                if (string2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting the action as Target end point address = " + string2);
                    }
                    map.put("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress", string2);
                }
            } else {
                map.put("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress", object);
            }
        }
        object = messageContext.getEnvelope();
        if (oMDocument == null) {
            oMDocument = DOMUtil.getOwnerDocument((OMNode)object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The original message to be processed by WSSGenerator: " + DOMUtils.toString(oMDocument.getOMDocumentElement()));
        }
        if (oMElement == null) {
            oMElement = WSSGenerator.getHeader(oMDocument, true);
        } else {
            n = NamespaceUtil.checkSoapVersion(oMElement, -1, "Header");
            if (n < 0) {
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", DOMUtils.getQualifiedName(oMElement), "Header");
            }
        }
        n = NamespaceUtil.isSoap(oMElement.getNamespace() == null ? null : oMElement.getNamespace().getNamespaceURI());
        map.put("com.ibm.ws.wssecurity.constants.soapVersion", new Integer(n));
        boolean bl7 = true;
        boolean bl8 = Axis2Util.isServiceProvider(messageContext);
        if (!bl) {
            if (bl5) {
                bl7 = this.checkMustUnderstand(wSSGeneratorConfig, messageContext, bl8);
                WSSGenerator.callTimestampGenerator(timestampGeneratorConfig, hashMap, oMDocument, oMElement, map);
            }
        } else {
            Object object3;
            AbstractCollection abstractCollection;
            Set<TokenGeneratorConfig> set;
            bl7 = this.checkMustUnderstand(wSSGeneratorConfig, messageContext, bl8);
            OMElement oMElement2 = WSSGenerator.addSecurityHeader(oMDocument, oMElement, n, n2, wSSGeneratorConfig.getTargetActor(), bl7);
            String string3 = null;
            String string4 = null;
            if (n == 1) {
                string4 = oMElement2.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP12_ROLE_Q);
            } else if (n == 0) {
                string4 = oMElement2.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP11_ACTOR_Q);
            }
            if (bl4 && (string3 = WSSGenerator.getRMAction(oMElement, messageContext, string4, n)) != null) {
                if (!bl3) {
                    if (string3.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[0]) || string3.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[2]) || string3.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[3]) || string3.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[5])) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Not doing SignatureConfirmation generation since this is a CreateSequence or SequenceAcknowledgement from provider");
                        }
                        bl4 = false;
                    }
                } else if (string3.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[1]) || string3.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[4])) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not doing SignatureConfirmation generation since this is a CreateSequenceResponse from client");
                    }
                    bl4 = false;
                }
            }
            if (bl4 && !bl3) {
                WSSGenerator.callSignatureConfirmationGenerator(oMDocument.getOMDocumentElement().getOMFactory(), oMElement2, map, messageContext);
            }
            if (bl5) {
                WSSGenerator.callTimestampGenerator(timestampGeneratorConfig, hashMap, oMDocument, oMElement2, map);
            }
            if ((set = wSSGeneratorConfig.getTokenGenerators()).size() > 0) {
                this.retrieveCachedInformation(messageContext, map);
            }
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                WSSGenerator.callTokenGenerator((TokenGeneratorConfig)iterator.next(), oMDocument, oMElement2, map);
            }
            Collection<SecurityToken> collection = securityTokenManagerImpl.getTokens();
            if (collection != null && collection.size() > 0) {
                abstractCollection = new HashSet();
                for (final SecurityToken object42 : collection) {
                    if (object42 instanceof UsernameToken) {
                        object3 = AccessController.doPrivileged(new PrivilegedAction<XMLStructure>(){

                            @Override
                            public XMLStructure run() {
                                XMLStructure xMLStructure = object42.getXML();
                                return xMLStructure;
                            }
                        });
                        if (object3 == null) continue;
                        abstractCollection.add(((OMStructure)object3).getNode());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Added the element of stand-alone token [" + object42 + "].");
                        continue;
                    }
                    if (object42.getXML() == null) continue;
                    abstractCollection.add(((OMStructure)object42.getXML()).getNode());
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added the element of stand-alone token [" + object42 + "].");
                }
                map.put("com.ibm.ws.wssecurity.constants.standAloneElements", abstractCollection);
            }
            abstractCollection = null;
            if (bl4 && bl3) {
                abstractCollection = new ArrayList();
                map.put("com.ibm.ws.wssecurity.constants.signatureConfirmationCache", abstractCollection);
            }
            List<Configuration> list = wSSGeneratorConfig.getOperationGenerators();
            for (Configuration configuration : list) {
                if (configuration instanceof SignatureGeneratorConfig) {
                    WSSGenerator.callSignatureGenerator((SignatureGeneratorConfig)configuration, hashMap, oMDocument, oMElement2, map);
                    continue;
                }
                if (configuration instanceof EncryptionGeneratorConfig) {
                    WSSGenerator.callEncryptionGenerator((EncryptionGeneratorConfig)configuration, hashMap, oMDocument, oMElement2, map);
                    continue;
                }
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s04", configuration.getClass().getName());
            }
            object3 = (List)map.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
            if (object3 != null && object3.size() > 0) {
                if (tc.isDebugEnabled()) {
                    int hashMap2 = object3.size();
                    Tr.debug(tc, "client side , Signature_Confirmation cache size = " + hashMap2);
                    for (int hashMap3 = 0; hashMap3 < hashMap2; ++hashMap3) {
                        String string5 = (String)object3.get(hashMap3);
                        Tr.debug(tc, "client side , Signature_Confirmation value = " + string5);
                    }
                }
                HashMap<String, Object> hashMap2 = null;
                hashMap2 = (HashMap<String, Object>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<String, Object>();
                }
                HashMap<String, Object> hashMap3 = null;
                hashMap3 = (HashMap<String, Object>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                if (hashMap3 == null) {
                    hashMap3 = new HashMap<String, Object>();
                }
                hashMap2.put("com.ibm.ws.wssecurity.constants.signatureConfirmationCache", object3);
                messageContext.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", hashMap2);
                hashMap3.put("com.ibm.ws.wssecurity.constants.signatureConfirmationCache", object3);
                messageContext.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", hashMap3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Stored SIGNATURE_CONFIRMATION_CACHE on msg ctx in WSS_PROPERTYMAP and WSS_RAMP_PROPERTYMAP properties");
                }
                map.remove("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
            }
        }
        if (bl5) {
            TimestampGenerator.moveTimestamp(oMDocument, wSSGeneratorConfig.getTimestampGenerator(), hashMap, map);
        }
        if (wSSGeneratorConfig.isUserDefinedComponentsUsed()) {
            IdUtils.getInstance().checkIdUniqueness(oMDocument);
        }
        securityTokenManagerImpl.finalizeSubject();
        RequestPool.finalize(map);
        RequestMessagePool.finalize(map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMDocument doc, OMElement parent, Map context)");
        }
    }

    public void onFault(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onFault(SOAPMessageContext context)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onFault(SOAPMessageContext context)");
        }
    }

    private void setInitialProperties() throws SoapSecurityException {
        this._properties.put(ConfidentialDialectElementSelector.class, new ConfidentialDialectElementSelector());
        this._properties.put(IntegralDialectElementSelector.class, new IntegralDialectElementSelector());
        this._properties.put(TimestampDialectElementSelector.class, new TimestampDialectElementSelector());
        this._properties.put(QNameHeaderSelector.class, new QNameHeaderSelector());
        this._properties.put(WSPFunctionElementSelector.class, new WSPFunctionElementSelector());
        this._properties.put(XPathElementSelector.class, new XPathElementSelector());
        this._properties.put("com.ibm.ws.wssecurity.util.selector.IDResolver", IdUtils.getInstance());
        WSSFactory wSSFactory = WSSFactory.getInstance("soap");
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.timestamp");
        this._properties.put(TimestampGenerator.class, wSSFactory.createGenerator(hashMap, this._properties));
        hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.signature");
        this._properties.put(SignatureGenerator.class, wSSFactory.createGenerator(hashMap, this._properties));
        hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.encryption");
        this._properties.put(EncryptionGenerator.class, wSSFactory.createGenerator(hashMap, this._properties));
        hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.keyinfo");
        this._properties.put(KeyInfoGenerator.class, wSSFactory.createGenerator(hashMap, this._properties));
    }

    private static boolean adjustContext(MessageContext messageContext, Map<Object, Object> map) throws SoapSecurityException {
        return false;
    }

    public abstract void retrieveCachedInformation(MessageContext var1, Map<Object, Object> var2) throws SoapSecurityException;

    public static OMElement getHeader(OMDocument oMDocument, boolean bl) throws SoapSecurityException {
        OMNamespace oMNamespace;
        OMElement oMElement;
        OMElement oMElement2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHeader(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "boolean creation[" + bl + "})");
        }
        if ((oMElement2 = DOMUtils.getFirstElement(oMElement, (oMNamespace = (oMElement = oMDocument.getOMDocumentElement()).getNamespace()) == null ? null : oMNamespace.getNamespaceURI(), "Header")) == null && bl) {
            OMNode oMNode;
            OMFactory oMFactory = oMElement.getOMFactory();
            if (oMFactory instanceof SOAPFactory) {
                oMElement2 = ((SOAPFactory)oMFactory).createSOAPHeader();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Header found, so creating SOAPHeader.");
                }
            } else {
                oMElement2 = oMFactory.createOMElement("Header", oMNamespace);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Header found, so creating OMElement named Header.");
                }
            }
            if ((oMNode = oMElement.getFirstOMChild()) == null) {
                oMElement.addChild(oMElement2);
            } else {
                oMNode.insertSiblingBefore(oMElement2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getheader(OMDocument doc) returns Element[", DOMUtils.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    private static OMElement addSecurityHeader(OMDocument oMDocument, OMElement oMElement, int n, int n2, String string, boolean bl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSecurityHeader(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "OMElement header[" + DOMUtils.getDisplayName(oMElement) + "]," + "int soapVersion[" + n + "]," + "int wssVersion[" + n2 + "]," + "String actor[" + string + "]," + "boolean mustUnderstand[" + bl + "])");
        }
        OMFactory oMFactory = oMDocument.getOMDocumentElement().getOMFactory();
        OMElement oMElement2 = null;
        oMElement2 = WSSGenerator.getSecurityHeader(oMElement, n, n2, string, bl);
        if (oMElement2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addSecurityHeader Uses existing wsse:Security element");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addSecurityHeader(Document doc,Element header,int soapVersion,int wssVersion,String actor,boolean mustUnderstand) returns Element[" + DOMUtils.getDisplayName(oMElement2) + "]");
            }
            return oMElement2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addSecurityHeader Creates new wsse:Security element");
        }
        oMElement2 = oMFactory instanceof SOAPFactory ? ((SOAPFactory)oMFactory).createSOAPHeaderBlock("Security", oMFactory.createOMNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "wsse")) : oMFactory.createOMElement("Security", com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "wsse");
        oMElement2.declareNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "wsse");
        OMNode oMNode = oMElement.getFirstOMChild();
        if (oMNode == null) {
            oMElement.addChild(oMElement2);
        } else {
            if (oMNode.getPreviousOMSibling() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addSecurityHeader: First child points to himself. Attempting to correct.");
                }
                if (oMNode instanceof OMNodeImpl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "addSecurityHeader: First node is an OMNodeImpl, setting previousOMSibling to null.");
                    }
                    ((OMNodeImpl)oMNode).setPreviousOMSibling(null);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addSecurityHeader: First node is not OMNodeImpl, cannot fix. Type is " + oMNode.getClass().getName());
                }
            }
            oMNode.insertSiblingBefore(oMElement2);
        }
        String string2 = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getPrefix();
        String string3 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[2][n];
        if (string != null) {
            String string4 = n == 0 ? "actor" : "role";
            if (string2 == null || string2.length() <= 0) {
                string2 = "env";
                oMElement2.declareNamespace(string3, string2);
            }
            oMElement2.addAttribute(string4, string, oMFactory.createOMNamespace(string3, string2));
        }
        if (bl) {
            if (string2 == null || string2.length() <= 0) {
                string2 = "env";
                oMElement2.declareNamespace(string3, string2);
            }
            oMElement2.addAttribute("mustUnderstand", "1", oMFactory.createOMNamespace(string3, string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSecurityHeader(Document doc,Element header,int soapVersion,int wssVersion,String actor,boolean mustUnderstand) returns Element[" + DOMUtils.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    public static OMElement getSecurityHeader(OMElement oMElement, int n, int n2, String string, boolean bl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchForSecurityHeader(Element header[" + DOMUtils.getDisplayName(oMElement) + "]," + "int soapVersion[" + n + "]," + "int wssVersion[" + n2 + "]," + "String actor[" + string + "]," + "boolean mustUnderstand[" + bl + "])");
        }
        OMElement oMElement2 = DOMUtils.getFirstElement(oMElement);
        while (oMElement2 != null) {
            String string2 = oMElement2.getNamespace() == null ? null : oMElement2.getNamespace().getNamespaceURI();
            String string3 = oMElement2.getLocalName();
            if ((n2 < 0 || NamespaceUtil.isWsse(string2) == n2) && "Security".equals(string3)) {
                String string4;
                String string5;
                if (n == 1) {
                    string5 = oMElement2.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP12_ROLE_Q);
                    string4 = oMElement2.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP12_MU_Q);
                } else if (n == 0) {
                    string5 = oMElement2.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP11_ACTOR_Q);
                    string4 = oMElement2.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP11_MU_Q);
                } else {
                    throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s11", Integer.toString(n));
                }
                if (!(string != null && string.length() != 0 ? !string.equals(string5) : string5 != null && string5.trim().length() != 0)) {
                    if (bl) {
                        boolean bl2 = false;
                        if (string4 != null && !"".equals(string4)) {
                            bl2 = ConfigUtil.isTrue(string4);
                        }
                        if (!bl2) {
                            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s12", string4, Boolean.toString(bl));
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSecurityHeader(Element header,int soapVersion,int wssVersion,String actor,boolean mustUnderstand) returns Element[" + oMElement2 + "]");
                    }
                    return oMElement2;
                }
            }
            oMElement2 = DOMUtils.getNextElement(oMElement2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityHeader(Element header,int soapVersion,int wssVersion,String actor,boolean mustUnderstand) returns null");
        }
        return null;
    }

    private static void callSignatureConfirmationGenerator(OMFactory oMFactory, OMElement oMElement, Map<Object, Object> map, MessageContext messageContext) throws SoapSecurityException {
        Object object;
        OMElement oMElement2;
        Object object2;
        Object object3;
        Object object4;
        OperationContext operationContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callSignatureConfirmationGenerator(OMFactory document[" + oMFactory + "]," + "OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "Map context, " + "MessageContext messageContext)");
        }
        boolean bl = false;
        String string = DOMUtils.getNamespacePrefix(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSSE11);
        if (string == null) {
            bl = true;
            string = "wsse11";
        }
        if ((operationContext = messageContext.getOperationContext()) == null) {
            operationContext = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
        }
        ArrayList arrayList = null;
        if (operationContext != null) {
            List list;
            MessageContext messageContext2;
            Map.Entry entry;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Valid operation context to look for Signature_Confirmation cache");
            }
            object4 = operationContext.getMessageContexts();
            object3 = ((HashMap)object4).entrySet();
            object2 = object3.iterator();
            oMElement2 = null;
            object = null;
            while (object2.hasNext()) {
                entry = (Map.Entry)object2.next();
                messageContext2 = (MessageContext)entry.getValue();
                object = (HashMap)messageContext2.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                if (object == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found the WSS_PROPERTYMAP in the msg ctx with key: " + entry.getKey());
                }
                if ((oMElement2 = ((HashMap)object).get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache")) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found SIGNATURE_CONFIRMATION_CACHE in WSS_PROPERTYMAP property map.");
                    }
                    list = null;
                    if (oMElement2 instanceof List) {
                        list = (List)((Object)oMElement2);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found SIGNATURE_CONFIRMATION_CACHE, but it is not a List: " + oMElement2);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Classname of SIGNATURE_CONFIRMATION_CACHE: " + oMElement2.getClass().getName());
                        }
                    }
                    if (list != null) {
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        arrayList.addAll(list);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing Signature_Confirmation Cache from the WSS_PROPERTYMAP");
                    }
                    ((HashMap)object).remove("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
                    messageContext2.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", object);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Did NOT find SIGNATURE_CONFIRMATION_CACHE in WSS_PROPERTYMAP property map.");
            }
            if (oMElement2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not find Signature_Confirmation Cache or the WSS_PROPERTYMAP in any message context.Try to find WSS_RAMP_PROPERTYMAP. ");
                }
                while (object2.hasNext()) {
                    entry = (Map.Entry)object2.next();
                    messageContext2 = (MessageContext)entry.getValue();
                    object = (HashMap)messageContext2.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                    if (object == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found the WSS_RAMP_PROPERTYMAP in the msg ctx with key: " + entry.getKey());
                    }
                    if ((oMElement2 = ((HashMap)object).get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache")) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found SIGNATURE_CONFIRMATION_CACHE in WSS_RAMP_PROPERTYMAP property map.");
                        }
                        list = null;
                        if (oMElement2 instanceof List) {
                            list = (List)((Object)oMElement2);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found SIGNATURE_CONFIRMATION_CACHE, but it is not a List: " + oMElement2);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Classname of SIGNATURE_CONFIRMATION_CACHE: " + oMElement2.getClass().getName());
                            }
                        }
                        if (list != null) {
                            if (arrayList == null) {
                                arrayList = new ArrayList();
                            }
                            arrayList.addAll(list);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing Signature_Confirmation Cache from the WSS_RAMP_PROPERTYMAP");
                        }
                        ((HashMap)object).remove("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
                        messageContext2.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", object);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Did NOT find SIGNATURE_CONFIRMATION_CACHE in WSS_RAMP_PROPERTYMAP property map.");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "OperationContext was null, cannot look for SIGNATURE_CONFIRMATION_CACHE in WSS_PROPERTYMAP.");
        }
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                object2 = (String)arrayList.get(i);
                oMElement2 = oMFactory.createOMElement("SignatureConfirmation", com.ibm.ws.wssecurity.common.Constants.NS_WSSE11, string);
                if (bl) {
                    oMElement2.declareNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSSE11, "wsse11");
                }
                oMElement2.addAttribute("Value", (String)object2, null);
                object = oMElement.getFirstOMChild();
                if (object == null) {
                    oMElement.addChild(oMElement2);
                } else {
                    object.insertSiblingBefore(oMElement2);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding SignatureConfirmation with value attribute: " + (String)object2);
            }
        } else {
            object4 = oMFactory.createOMElement("SignatureConfirmation", com.ibm.ws.wssecurity.common.Constants.NS_WSSE11, string);
            if (bl) {
                object4.declareNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSSE11, "wsse11");
            }
            if ((object3 = oMElement.getFirstOMChild()) == null) {
                oMElement.addChild((OMNode)object4);
            } else {
                object3.insertSiblingBefore((OMNode)object4);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding SignatureConfirmation with no value attribute.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callSignatureConfirmationGenerator(Document document,Element parent,Map context, MessageContext messageContext)");
        }
    }

    private static void callTimestampGenerator(TimestampGeneratorConfig timestampGeneratorConfig, Map<Object, Object> map, OMDocument oMDocument, OMElement oMElement, Map<Object, Object> map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callTimestampGenerator(TimestampGeneratorConfig config,Map selectors,Document document[" + DOMUtils.getDisplayName(oMDocument.getOMDocumentElement()) + "]," + "Element parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "Map context)");
        }
        TimestampGenerator timestampGenerator = (TimestampGenerator)map.get(TimestampGenerator.class);
        map2.put("com.ibm.ws.wssecurity.impl.config.timestampGenerator.configKey", timestampGeneratorConfig);
        timestampGenerator.invoke(oMDocument, oMElement, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callTimestampGenerator(TimestampGeneratorConfig config,Map selectors,Document document,Element parent,Map context)");
        }
    }

    private static void callTokenGenerator(TokenGeneratorConfig tokenGeneratorConfig, OMDocument oMDocument, OMElement oMElement, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callTokenGenerator(TokenGeneratorConfig config,Document document[" + DOMUtils.getDisplayName(oMDocument.getOMDocumentElement()) + "]," + "Element parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "Map context)");
        }
        if (tokenGeneratorConfig.isStandAlone()) {
            PrivateGeneratorConfig.TokenGeneratorConfImpl tokenGeneratorConfImpl = (PrivateGeneratorConfig.TokenGeneratorConfImpl)tokenGeneratorConfig;
            TokenGeneratorComponent tokenGeneratorComponent = tokenGeneratorConfImpl.getInstance();
            if (tokenGeneratorComponent == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get the TokenGenerator object: [" + tokenGeneratorConfig + "].");
                }
            } else {
                map.put("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey", tokenGeneratorConfig);
                tokenGeneratorComponent.invoke(oMDocument, oMElement, map);
                map.remove(Constants.WSSECURITY_TOKEN_LOGININFO);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callTokenGenerator(TokenGeneratorConfig config,Document document,Element parent,Map context)");
        }
    }

    private static void callSignatureGenerator(SignatureGeneratorConfig signatureGeneratorConfig, Map<Object, Object> map, OMDocument oMDocument, OMElement oMElement, Map<Object, Object> map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callSignatureGenerator(SignatureGeneratorConfig config,Map selectors,Document document[" + DOMUtils.getDisplayName(oMDocument.getOMDocumentElement()) + "]," + "Element parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "Map context)");
        }
        SignatureGenerator signatureGenerator = (SignatureGenerator)map.get(SignatureGenerator.class);
        map2.put("com.ibm.ws.wssecurity.impl.config.signatureGenerator.configKey", signatureGeneratorConfig);
        signatureGenerator.invoke(oMDocument, oMElement, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callSignatureGenerator(WSSFactory factory,SignatureGeneratorConfig config,Map type,Map selectors,Document document,Element parent,Map context)");
        }
    }

    private static void callEncryptionGenerator(EncryptionGeneratorConfig encryptionGeneratorConfig, Map<Object, Object> map, OMDocument oMDocument, OMElement oMElement, Map<Object, Object> map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callEncryptionGenerator(EncryptionGeneratorConfig config,Map selectors,Document document[" + DOMUtils.getDisplayName(oMDocument.getOMDocumentElement()) + "]," + "Element parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "Map context)");
        }
        EncryptionGenerator encryptionGenerator = (EncryptionGenerator)map.get(EncryptionGenerator.class);
        map2.put("com.ibm.ws.wssecurity.impl.config.encryptionGenerator.configKey", encryptionGeneratorConfig);
        encryptionGenerator.invoke(oMDocument, oMElement, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callEncryptionGenerator(EncryptionGeneratorConfig config,Map selectors,Document document,Element parent,Map context)");
        }
    }

    public static String getRMAction(OMElement oMElement, MessageContext messageContext, String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMAction()");
        }
        boolean bl = false;
        ArrayList arrayList = null;
        String string2 = null;
        if (messageContext.getWSAAction() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found wsa:Action[" + string2 + "] in the message context.");
            }
            string2 = messageContext.getWSAAction();
        } else {
            OMElement oMElement2;
            arrayList = com.ibm.ws.wssecurity.util.DOMUtil.getHeadersForNamespace(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[0], "Action", string, n);
            if (arrayList == null || arrayList.size() <= 0) {
                arrayList = com.ibm.ws.wssecurity.util.DOMUtil.getHeadersForNamespace(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[1], "Action", string, n);
            }
            if (arrayList != null && arrayList.size() > 0 && (oMElement2 = (OMElement)arrayList.get(0)) != null) {
                string2 = oMElement2.getText();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRMAction returns = " + string2);
        }
        return string2;
    }

    protected UsernameToken getClientCacheUsernameTokenKeyFromMessage(MessageContext messageContext) {
        Parameter parameter;
        UsernameToken usernameToken = null;
        if (messageContext == null) {
            return null;
        }
        if (messageContext.getAxisService() != null && (parameter = messageContext.getAxisService().getParameter(com.ibm.ws.wssecurity.common.Constants.WSSECURITY_USERNAMETOKEN_IDENTIFIER)) != null) {
            usernameToken = (UsernameToken)parameter.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "the username token from cache in AxisService Context value of par.getValue -> usernametoken" + parameter.getValue() + ":->" + usernameToken);
            }
        }
        return usernameToken;
    }

    public static void addClientCacheUsernameTokenKeyToMessage(MessageContext messageContext, UsernameToken usernameToken) {
        if (usernameToken != null && messageContext != null) {
            Parameter parameter = new Parameter(com.ibm.ws.wssecurity.common.Constants.WSSECURITY_USERNAMETOKEN_IDENTIFIER, usernameToken);
            try {
                if (messageContext.getAxisService() != null) {
                    messageContext.getAxisService().addParameter(parameter);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the username token from cache in AxisService Context value of par :: usernametoken" + parameter + "::" + usernameToken);
                }
            }
            catch (Exception exception) {
                Tr.debug(tc, "Unable to add usernameToken session to AxisContext. ", exception);
            }
        }
    }

    public static void removeClientCacheUsernameTokenKeyFromMessage(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeClientCacheUsernameTokenKeyFromMessage");
        }
        if (messageContext == null) {
            return;
        }
        AxisService axisService = messageContext.getAxisService();
        if (axisService != null) {
            Parameter parameter = axisService.getParameter(com.ibm.ws.wssecurity.common.Constants.WSSECURITY_USERNAMETOKEN_IDENTIFIER);
            if (parameter != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing cached UsernameToken");
                }
                try {
                    axisService.removeParameter(parameter);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to remove UsernameToken from the cache.  Exception=" + exception);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No cached UsernameTokens found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeClientCacheUsernameTokenKeyFromMessage");
        }
    }

    private boolean checkMustUnderstand(WSSGeneratorConfig wSSGeneratorConfig, MessageContext messageContext, boolean bl) {
        boolean bl2 = true;
        if (bl) {
            boolean bl3 = wSSGeneratorConfig.getServiceGetMustUnderstand();
            if (bl3) {
                bl2 = Axis2Util.getMustUnderstand(messageContext);
            }
        } else {
            bl2 = wSSGeneratorConfig.getClientSetMustUnderstand();
        }
        Axis2Util.setMustUnderstand(messageContext, bl2);
        return bl2;
    }

    static {
        if (System.getProperty("setup-jce") != null) {
            SetupJCEProviders.setup();
        }
    }
}

