/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.wssecurity.core.WSSComponent;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.wssecurity.enc.EncryptionConsumer;
import com.ibm.ws.wssecurity.enc.EncryptionGenerator;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoGenerator;
import com.ibm.ws.wssecurity.time.TimestampConsumer;
import com.ibm.ws.wssecurity.time.TimestampGenerator;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSFactorySOAPImpl
extends WSSFactory {
    private static final TraceComponent tc = Tr.register(WSSFactorySOAPImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";

    protected WSSFactorySOAPImpl() {
    }

    @Override
    public WSSComponent createGenerator(Map<Object, Object> map, final Map<Object, Object> map2) throws SoapSecurityException {
        ClassLoader classLoader;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createGenerator(Map type, Map properties)");
        }
        Object object = map.get("com.ibm.ws.wssecurity.impl.core.wssfactory.type");
        Object object2 = map.get("com.ibm.ws.wssecurity.impl.core.wssfactory.classname");
        ClassLoader classLoader2 = classLoader = map.containsKey("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader") ? (ClassLoader)map.get("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader") : null;
        if (tc.isDebugEnabled()) {
            if (classLoader != null) {
                Tr.debug(tc, "type [" + map + "], classname [" + object2 + "], classloader [" + classLoader.getClass().getName() + "].");
            } else {
                Tr.debug(tc, "type [" + map + "], classname [" + object2 + "].");
            }
        }
        WSSComponent wSSComponent = null;
        if (object == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s01");
        }
        if (object.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.timestamp")) {
            wSSComponent = new TimestampGenerator();
        } else if (object.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.signature")) {
            wSSComponent = new SignatureGenerator();
        } else if (object.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.encryption")) {
            wSSComponent = new EncryptionGenerator();
        } else if (object.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.keyinfo")) {
            wSSComponent = new KeyInfoGenerator();
        } else if (!object.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.custom")) {
            throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s02", object.toString());
        }
        if (wSSComponent == null) {
            if (object2 == null) {
                throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s03");
            }
            final String string = object2.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Instantiating the component [" + string + "]...");
            }
            try {
                wSSComponent = (WSSComponent)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws SoapSecurityException {
                        WSSComponent wSSComponent = (WSSComponent)ConfigUtil.instantiate(string, WSSComponent.class, map2, classLoader);
                        return wSSComponent;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof SoapSecurityException) {
                    throw (SoapSecurityException)throwable;
                }
                throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s04", string, throwable);
            }
        } else {
            wSSComponent.init(map2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createGenerator(Map type, Map properties) returns " + wSSComponent);
        }
        return wSSComponent;
    }

    @Override
    public WSSComponent createConsumer(Map<Object, Object> map, final Map<Object, Object> map2) throws SoapSecurityException {
        ClassLoader classLoader;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConsumer(Map type, Map properties)");
        }
        Object object = map.get("com.ibm.ws.wssecurity.impl.core.wssfactory.type");
        Object object2 = map.get("com.ibm.ws.wssecurity.impl.core.wssfactory.classname");
        ClassLoader classLoader2 = classLoader = map.containsKey("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader") ? (ClassLoader)map.get("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader") : null;
        if (tc.isDebugEnabled()) {
            if (classLoader != null) {
                Tr.debug(tc, "type [" + map + "], classname [" + object2 + "], classloader [" + classLoader.getClass().getName() + "].");
            } else {
                Tr.debug(tc, "type [" + map + "], classname [" + object2 + "].");
            }
        }
        WSSComponent wSSComponent = null;
        if (object == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s01");
        }
        if (object.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.timestamp")) {
            wSSComponent = new TimestampConsumer();
        } else if (object.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.encryption")) {
            wSSComponent = new EncryptionConsumer();
        } else if (object.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.signature")) {
            wSSComponent = new SignatureConsumer();
        } else if (object.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.keyinfo")) {
            wSSComponent = new KeyInfoConsumer();
        } else if (!object.equals("com.ibm.ws.wssecurity.impl.core.wssfactory.custom")) {
            throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s02");
        }
        if (wSSComponent == null) {
            if (object2 == null) {
                throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s03");
            }
            final String string = object2.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Instantiating the component [" + string + "]...");
            }
            try {
                wSSComponent = (WSSComponent)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws SoapSecurityException {
                        WSSComponent wSSComponent = (WSSComponent)ConfigUtil.instantiate(string, WSSComponent.class, map2, classLoader);
                        return wSSComponent;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof SoapSecurityException) {
                    throw (SoapSecurityException)throwable;
                }
                throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s04", string, throwable);
            }
        } else {
            wSSComponent.init(map2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConsumer(Map type, Map properties) returns " + wSSComponent);
        }
        return wSSComponent;
    }
}

