/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.wssecurity.core.WSSComponent;
import com.ibm.ws.wssecurity.core.WSSFactorySOAPImpl;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSSFactory {
    public static final String TYPE = "com.ibm.ws.wssecurity.impl.core.wssfactory.type";
    public static final String TIMESTAMP = "com.ibm.ws.wssecurity.impl.core.wssfactory.timestamp";
    public static final String SIGNATURE = "com.ibm.ws.wssecurity.impl.core.wssfactory.signature";
    public static final String ENCRYPTION = "com.ibm.ws.wssecurity.impl.core.wssfactory.encryption";
    public static final String KEYINFO = "com.ibm.ws.wssecurity.impl.core.wssfactory.keyinfo";
    public static final String PLUGGABLE = "com.ibm.ws.wssecurity.impl.core.wssfactory.custom";
    public static final String CLASSNAME = "com.ibm.ws.wssecurity.impl.core.wssfactory.classname";
    public static final String CLASSLOADER = "com.ibm.ws.wssecurity.impl.core.wssfactory.classloader";
    private static final String TYPE_SOAP = "soap";
    private static final TraceComponent tc = Tr.register(WSSFactory.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static Map<String, WSSFactory> _instances = new Hashtable<String, WSSFactory>();

    public static WSSFactory getInstance(String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance(String type[" + string + "])");
        }
        WSSFactory wSSFactory = null;
        if (string.equals(TYPE_SOAP)) {
            wSSFactory = _instances.get(TYPE_SOAP);
            if (wSSFactory == null) {
                wSSFactory = new WSSFactorySOAPImpl();
                _instances.put(TYPE_SOAP, wSSFactory);
            }
        } else {
            throw SoapSecurityException.format("security.wssecurity.WSSFactory.s01", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance(String type) returns " + wSSFactory);
        }
        return wSSFactory;
    }

    public abstract WSSComponent createGenerator(Map<Object, Object> var1, Map<Object, Object> var2) throws SoapSecurityException;

    public abstract WSSComponent createConsumer(Map<Object, Object> var1, Map<Object, Object> var2) throws SoapSecurityException;
}

