/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.websphere.wssecurity.wssapi.token.DerivedKeyToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.CallerConfig;
import com.ibm.ws.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.core.ResultMessagePool;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.core.WSSGenerator;
import com.ibm.ws.wssecurity.core.token.TokenConsumerComponent;
import com.ibm.ws.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.wssecurity.dsig.VerificationResult;
import com.ibm.ws.wssecurity.dsig.VerifiedPartChecker;
import com.ibm.ws.wssecurity.enc.DecryptedPartChecker;
import com.ibm.ws.wssecurity.enc.DecryptionResult;
import com.ibm.ws.wssecurity.enc.EncryptionConsumer;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.time.TimestampChecker;
import com.ibm.ws.wssecurity.time.TimestampConsumer;
import com.ibm.ws.wssecurity.token.AuthResult;
import com.ibm.ws.wssecurity.token.CertCacheManager;
import com.ibm.ws.wssecurity.token.LoginProcessor;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.wssecurity.util.XPathElementSelector;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(WSSConsumer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSConsumer.class.getName();
    private static final QName URI_Q = new QName("", "URI");
    private static final QName VALUETYPE_Q = new QName("", "ValueType");
    private Map<String, Object> _handlerOption = new HashMap<String, Object>();
    private Map<Object, Object> _properties = new HashMap<Object, Object>();
    private boolean _initialized = false;

    public void setHandlerOption(String string, Object object) {
        this._handlerOption.put(string, object);
    }

    public Object getHandlerOption(String string) {
        return this._handlerOption.get(string);
    }

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this.setInitialProperties();
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void invoke(OMNode var1_1, Map<Object, Object> var2_2) throws SoapSecurityException {
        block168: {
            block155: {
                if (WSSConsumer.tc.isEntryEnabled()) {
                    var3_3 = new StringBuffer("invoke(");
                    var3_3.append("OMNode target[").append(DOMUtils.getDisplayName(var1_1)).append("], ");
                    var3_3.append("Map context)");
                    Tr.entry(WSSConsumer.tc, var3_3.toString());
                }
                var3_3 = new HashMap<K, V>();
                var4_4 = new HashMap<K, V>();
                var5_5 = new HashMap<K, V>();
                var6_6 = new HashMap<K, V>();
                var7_7 = new HashMap<String, Object>();
                var2_2.put("com.ibm.ws.wssecurity.constants.tokenCache", var3_3);
                var2_2.put("com.ibm.ws.wssecurity.constants.securityHeadersCache", var4_4);
                var2_2.put("com.ibm.ws.wssecurity.constants.tokenCacheType", var5_5);
                var2_2.put("com.ibm.ws.wssecurity.constants.viTokensHash", var6_6);
                var2_2.put("com.ibm.ws.wssecurity.constants.timestampVerificationHash", var7_7);
                var8_8 = (MessageContext)var2_2.get("com.ibm.wsspi.wssecurity.core.messageContext");
                if (var8_8 == null) {
                    throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
                }
                ResultPool.initialize(var2_2);
                WSSConsumer.adjustContext(var8_8, var2_2);
                var9_9 = new SecurityTokenManagerImpl(var2_2);
                ResultMessagePool.initialize(var2_2);
                var10_10 = (WSSConsumerConfig)var2_2.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
                if (WSSConsumer.tc.isDebugEnabled()) {
                    Tr.debug(WSSConsumer.tc, "WSSConsumerConfig [" + var10_10 + "].");
                }
                var11_11 = var10_10.getTimestampConsumer();
                var12_12 = (String)var8_8.getProperty("com.ibm.ws.wssecurity.EnforceStrictLayout");
                if (var12_12 != null) {
                    var13_13 = (HashMap<Object, Object>)var10_10.getProperties();
                    var13_13.put("com.ibm.ws.wssecurity.EnforceStrictLayout", var12_12);
                }
                var13_13 = new HashMap<Object, Object>(this._properties);
                var2_2.put(NonceManager.class, var10_10.getNonceManager());
                var2_2.put(CertCacheManager.class, var10_10.getCertManager());
                if (WSSConsumer.tc.isDebugEnabled()) {
                    Tr.debug(WSSConsumer.tc, "Finished initializing the subject.");
                }
                var14_14 = var10_10.isRequest();
                var15_15 = var10_10.isSignatureConfirmationRequired();
                var16_16 = var10_10.isTokenRequired() != false || var10_10.isVerificationRequired() != false || var10_10.isDecryptionRequired() != false || var10_10.isLoginRequired() != false || var10_10.isTimestampRequired() != false;
                var17_17 = var8_8.getEnvelope();
                var18_18 = DOMUtil.getOwnerDocument(var17_17);
                if (WSSConsumer.tc.isDebugEnabled()) {
                    Tr.debug(WSSConsumer.tc, "The original message to be processed by WSSConsumer: " + DOMUtils.toString(var18_18.getOMDocumentElement()));
                }
                if (!var16_16) {
                    if (WSSConsumer.tc.isEntryEnabled()) {
                        Tr.exit(WSSConsumer.tc, "invoke(Element target, Map context)");
                    }
                    return;
                }
                if (WSSConsumer.tc.isDebugEnabled()) {
                    Tr.debug(WSSConsumer.tc, "Starts WS-Security operation.");
                }
                var19_19 = var18_18.getOMDocumentElement();
                var20_20 = WSSGenerator.getHeader(var18_18, false);
                if (var20_20 == null) break block155;
                var21_21 = NamespaceUtil.isSoap(var20_20.getNamespace() == null ? null : var20_20.getNamespace().getNamespaceURI());
                var22_23 = new Integer(var21_21);
                var2_2.put("com.ibm.ws.wssecurity.constants.soapVersion", var22_23);
                if (WSSConsumer.tc.isDebugEnabled()) {
                    var23_24 = null;
                    var23_24 = var21_21 == 0 ? "The spec of SOAP is SOAP1.1." : (var21_21 == 1 ? "The spec of SOAP is SOAP1.2." : ("Unknown spec of SOAP: " + var20_20.getNamespace() == null ? null : var20_20.getNamespace().getNamespaceURI()));
                    Tr.debug(WSSConsumer.tc, (String)var23_24);
                }
                var23_24 = WSSConsumer.getSecurityHeaders(var20_20, var21_21, var10_10.isUltimateReceiver(), var10_10.getMyActor());
                if (WSSConsumer.tc.isDebugEnabled()) {
                    Tr.debug(WSSConsumer.tc, var23_24.size() + " security headers found");
                }
                if (var23_24.size() == 0) {
                    Tr.warning(WSSConsumer.tc, "security.wssecurity.WSSConsumer.s38", var10_10.getMyActor());
                }
                var24_25 = false;
                var25_26 = (String)var8_8.getProperty("com.ibm.ws.wssecurity.constants.checkIdUniqueness");
                if (var25_26 != null && var25_26.equals("true")) {
                    var24_25 = true;
                }
                if (!var24_25) {
                    if (WSSConsumer.tc.isDebugEnabled()) {
                        Tr.debug(WSSConsumer.tc, "Skipping the Id uniqueness check.");
                    }
                } else {
                    if (WSSConsumer.tc.isDebugEnabled()) {
                        Tr.debug(WSSConsumer.tc, "Performing the Id uniqueness check.");
                    }
                    IdUtils.getInstance().checkIdUniqueness(var18_18);
                }
                var26_27 = -1;
                if (var16_16 && var23_24.size() == 0 && WSSConsumer.countSecurityHeaders(var20_20) > 0) {
                    if (var10_10.getMyActor() == null || var10_10.getMyActor().trim().length() == 0) {
                        if (WSSConsumer.tc.isDebugEnabled()) {
                            Tr.debug(WSSConsumer.tc, "The Application Server expected a Security header with the " + com.ibm.ws.wssecurity.common.Constants.NS_WSSE + " namespace, but it was not found.");
                        }
                        throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s39");
                    }
                    if (WSSConsumer.tc.isDebugEnabled()) {
                        Tr.debug(WSSConsumer.tc, "The Application Server expected a Security header with the " + com.ibm.ws.wssecurity.common.Constants.NS_WSSE + " namespace and the " + var10_10.getMyActor() + " actor, but it was not found.");
                    }
                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s40", var10_10.getMyActor());
                }
                if (var10_10.isTimestampRequired()) {
                    if (WSSConsumer.tc.isDebugEnabled()) {
                        Tr.debug(WSSConsumer.tc, "Processing the timestamp.");
                    }
                    var27_28 = null;
                    var27_28 = WSSConsumer.getTimestampHeader(var20_20, -1, false);
                    if (WSSConsumer.tc.isDebugEnabled()) {
                        Tr.debug(WSSConsumer.tc, var27_28.size() + " timestamp headers found.");
                    }
                    if (var27_28.size() > 0) {
                        var28_30 = (OMElement)var27_28.get(0);
                        var29_31 = var28_30.getNamespace() == null ? null : var28_30.getNamespace().getNamespaceURI();
                        var26_27 = NamespaceUtil.isWsu(var29_31);
                        var2_2.put("com.ibm.ws.wssecurity.constants.wssVersion", new Integer(var26_27));
                        var8_8.setProperty("com.ibm.ws.wssecurity.constants.wssVersion", new Integer(var26_27));
                        for (var30_33 = 0; var30_33 < var27_28.size(); ++var30_33) {
                            var31_35 = (OMElement)var27_28.get(var30_33);
                            WSSConsumer.callTimestampConsumer(var11_11, var13_13, (OMElement)var31_35, var2_2);
                        }
                        if (WSSConsumer.tc.isDebugEnabled()) {
                            Tr.debug(WSSConsumer.tc, "Checking the required timestamp.");
                        }
                        WSSConsumer.checkRequiredTimestamp(var18_18, var10_10.getTimestampConsumer(), var13_13, var2_2);
                    }
                }
                for (var27_29 = 0; var27_29 < var23_24.size(); ++var27_29) {
                    var28_30 = (OMElement)var23_24.get(var27_29);
                    var29_32 = false;
                    var30_34 = var28_30.getAttributeValue(new QName(var20_20.getNamespace().getNamespaceURI(), "mustUnderstand"));
                    if (var30_34 != null && !"".equals(var30_34)) {
                        var29_32 = ConfigUtil.isTrue(var30_34);
                    }
                    Axis2Util.setMustUnderstand(var8_8, var29_32);
                    var31_35 = null;
                    if (var21_21 == 1) {
                        var31_35 = var28_30.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP12_ROLE_Q);
                    } else if (var21_21 == 0) {
                        var31_35 = var28_30.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP11_ACTOR_Q);
                    }
                    var32_36 = 0;
                    var33_37 = 0;
                    var34_38 = null;
                    var35_39 = null;
                    if (var15_15 && (var35_39 = WSSGenerator.getRMAction(var20_20, var8_8, (String)var31_35, var21_21)) != null) {
                        if (!var14_14) {
                            if (var35_39.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[0]) || var35_39.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[2]) || var35_39.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[3]) || var35_39.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[5])) {
                                if (WSSConsumer.tc.isDebugEnabled()) {
                                    Tr.debug(WSSConsumer.tc, "Not doing SignatureConfirmation processing since this is a CreateSequence or SequenceAcknowledgement from provider");
                                }
                                var15_15 = false;
                            }
                        } else if (var35_39.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[1]) || var35_39.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[4])) {
                            if (WSSConsumer.tc.isDebugEnabled()) {
                                Tr.debug(WSSConsumer.tc, "Not doing SignatureConfirmation processing since this is a CreateSequenceResponse from client");
                            }
                            var15_15 = false;
                        }
                    }
                    if (var15_15) {
                        if (!var14_14) {
                            var36_41 = var8_8.getOperationContext();
                            if (var36_41 == null) {
                                var36_41 = (OperationContext)var8_8.getProperty("unverifiedOperationContext");
                            }
                            if (var36_41 != null) {
                                if (WSSConsumer.tc.isDebugEnabled()) {
                                    Tr.debug(WSSConsumer.tc, "Valid Operation context to look for Signature_Confirmation cache");
                                }
                                var37_43 = var36_41.getMessageContexts();
                                var38_44 = var37_43.entrySet();
                                var39_47 = var38_44.iterator();
                                var40_52 = null;
                                var41_56 = null;
                                while (var39_47.hasNext()) {
                                    var42_62 = (Map.Entry)var39_47.next();
                                    var43_63 = (MessageContext)var42_62.getValue();
                                    var41_56 = (HashMap)var43_63.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                                    if (var41_56 == null) continue;
                                    if (WSSConsumer.tc.isDebugEnabled()) {
                                        Tr.debug(WSSConsumer.tc, "Found the WSS_PROPERTYMAP property map in the msg ctx with key: " + var42_62.getKey());
                                    }
                                    if ((var40_52 = var41_56.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache")) != null) {
                                        if (WSSConsumer.tc.isDebugEnabled()) {
                                            Tr.debug(WSSConsumer.tc, "Found SIGNATURE_CONFIRMATION_CACHE in WSS_PROPERTYMAP property map.");
                                        }
                                        var44_64 = null;
                                        if (var40_52 instanceof List) {
                                            var44_64 = (List)var40_52;
                                        } else {
                                            if (WSSConsumer.tc.isDebugEnabled()) {
                                                Tr.debug(WSSConsumer.tc, "Found SIGNATURE_CONFIRMATION_CACHE, but it is not a List: " + var40_52);
                                            }
                                            if (WSSConsumer.tc.isDebugEnabled()) {
                                                Tr.debug(WSSConsumer.tc, "Classname of SIGNATURE_CONFIRMATION_CACHE: " + var40_52.getClass().getName());
                                            }
                                        }
                                        if (var44_64 != null) {
                                            if (var34_38 == null) {
                                                var34_38 = new ArrayList<E>();
                                            }
                                            var34_38.addAll(var44_64);
                                        }
                                        var41_56.remove("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
                                        var43_63.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", var41_56);
                                        continue;
                                    }
                                    if (!WSSConsumer.tc.isDebugEnabled()) continue;
                                    Tr.debug(WSSConsumer.tc, "Did NOT find SIGNATURE_CONFIRMATION_CACHE in WSS_PROPERTYMAP property map.");
                                }
                                if (var40_52 == null) {
                                    if (WSSConsumer.tc.isDebugEnabled()) {
                                        Tr.debug(WSSConsumer.tc, "Did not find WSS_PROPERTYMAP in prev outbound message contexts from the operation context. Try to find WSS_RAMP_PROPERTYMAP and Signature_Confirmation cache");
                                    }
                                    while (var39_47.hasNext()) {
                                        var42_62 = (Map.Entry)var39_47.next();
                                        var43_63 = (MessageContext)var42_62.getValue();
                                        var41_56 = (HashMap)var43_63.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                                        if (var41_56 == null) continue;
                                        if (WSSConsumer.tc.isDebugEnabled()) {
                                            Tr.debug(WSSConsumer.tc, "Found the WSS_RAMP_PROPERTYMAP property map in the msg ctx with key: " + var42_62.getKey());
                                        }
                                        if ((var40_52 = var41_56.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache")) != null) {
                                            if (WSSConsumer.tc.isDebugEnabled()) {
                                                Tr.debug(WSSConsumer.tc, "Found SIGNATURE_CONFIRMATION_CACHE in WSS_RAMP_PROPERTYMAP property map.");
                                            }
                                            var44_64 = null;
                                            if (var40_52 instanceof List) {
                                                var44_64 = (List)var40_52;
                                            } else {
                                                if (WSSConsumer.tc.isDebugEnabled()) {
                                                    Tr.debug(WSSConsumer.tc, "Found SIGNATURE_CONFIRMATION_CACHE, but it is not a List: " + var40_52);
                                                }
                                                if (WSSConsumer.tc.isDebugEnabled()) {
                                                    Tr.debug(WSSConsumer.tc, "Classname of SIGNATURE_CONFIRMATION_CACHE: " + var40_52.getClass().getName());
                                                }
                                            }
                                            if (var44_64 != null) {
                                                if (var34_38 == null) {
                                                    var34_38 = new ArrayList<E>();
                                                }
                                                var34_38.addAll(var44_64);
                                            }
                                            var41_56.remove("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
                                            var43_63.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", var41_56);
                                            continue;
                                        }
                                        if (!WSSConsumer.tc.isDebugEnabled()) continue;
                                        Tr.debug(WSSConsumer.tc, "Did NOT find SIGNATURE_CONFIRMATION_CACHE in WSS_RAMP_PROPERTYMAP property map.");
                                    }
                                }
                            } else {
                                if (WSSConsumer.tc.isDebugEnabled()) {
                                    Tr.debug(WSSConsumer.tc, "Null Operation context, looking in the current message context for WSS_PROPERTYMAP and Signature_Confirmation cache");
                                }
                                var37_43 = null;
                                var38_44 = (HashMap)var8_8.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                                if (var38_44 != null) {
                                    if (WSSConsumer.tc.isDebugEnabled()) {
                                        Tr.debug(WSSConsumer.tc, "Found the WSS_PROPERTYMAP property map on current MessageContext");
                                    }
                                    if ((var37_43 = var38_44.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache")) != null) {
                                        if (WSSConsumer.tc.isDebugEnabled()) {
                                            Tr.debug(WSSConsumer.tc, "Found SIGNATURE_CONFIRMATION_CACHE in WSS_PROPERTYMAP property map on current MessageContext.");
                                        }
                                        var39_48 = null;
                                        if (var37_43 instanceof List) {
                                            var39_48 = (List)var37_43;
                                        } else {
                                            if (WSSConsumer.tc.isDebugEnabled()) {
                                                Tr.debug(WSSConsumer.tc, "Found SIGNATURE_CONFIRMATION_CACHE, but it is not a List: " + var37_43);
                                            }
                                            if (WSSConsumer.tc.isDebugEnabled()) {
                                                Tr.debug(WSSConsumer.tc, "Classname of SIGNATURE_CONFIRMATION_CACHE: " + var37_43.getClass().getName());
                                            }
                                        }
                                        if (var39_48 != null) {
                                            if (var34_38 == null) {
                                                var34_38 = new ArrayList<E>();
                                            }
                                            var34_38.addAll(var39_48);
                                        }
                                        var38_44.remove("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
                                        var8_8.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", var38_44);
                                    } else if (WSSConsumer.tc.isDebugEnabled()) {
                                        Tr.debug(WSSConsumer.tc, "Did NOT find SIGNATURE_CONFIRMATION_CACHE in WSS_PROPERTYMAP property map on current MessageContext.");
                                    }
                                }
                                if (var37_43 == null) {
                                    if (WSSConsumer.tc.isDebugEnabled()) {
                                        Tr.debug(WSSConsumer.tc, "Did not find WSS_PROPERTYMAP in the current message context, Try to find WSS_RAMP_PROPERTYMAP to look for SIGNATURE_CONFIRMATION_CACHE");
                                    }
                                    if ((var38_44 = (HashMap)var8_8.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP")) != null) {
                                        if (WSSConsumer.tc.isDebugEnabled()) {
                                            Tr.debug(WSSConsumer.tc, "Found the WSS_RAMP_PROPERTYMAP property map on current MessageContext");
                                        }
                                        if ((var37_43 = var38_44.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache")) != null) {
                                            if (WSSConsumer.tc.isDebugEnabled()) {
                                                Tr.debug(WSSConsumer.tc, "Found SIGNATURE_CONFIRMATION_CACHE in WSS_RAMP_PROPERTYMAP property map on current MessageContext.");
                                            }
                                            var39_49 = null;
                                            if (var37_43 instanceof List) {
                                                var39_49 = (List)var37_43;
                                            } else {
                                                if (WSSConsumer.tc.isDebugEnabled()) {
                                                    Tr.debug(WSSConsumer.tc, "Found SIGNATURE_CONFIRMATION_CACHE, but it is not a List: " + var37_43);
                                                }
                                                if (WSSConsumer.tc.isDebugEnabled()) {
                                                    Tr.debug(WSSConsumer.tc, "Classname of SIGNATURE_CONFIRMATION_CACHE: " + var37_43.getClass().getName());
                                                }
                                            }
                                            if (var39_49 != null) {
                                                if (var34_38 == null) {
                                                    var34_38 = new ArrayList<E>();
                                                }
                                                var34_38.addAll(var39_49);
                                            }
                                            var38_44.remove("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
                                            var8_8.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", var38_44);
                                        } else if (WSSConsumer.tc.isDebugEnabled()) {
                                            Tr.debug(WSSConsumer.tc, "Did NOT find SIGNATURE_CONFIRMATION_CACHE in WSS_RAMP_PROPERTYMAP property map on current MessageContext.");
                                        }
                                    }
                                }
                            }
                            if (var34_38 != null) {
                                var33_37 = var34_38.size();
                                if (WSSConsumer.tc.isDebugEnabled()) {
                                    for (var27_29 = 0; var27_29 < var33_37; ++var27_29) {
                                        var37_43 = (String)var34_38.get(var27_29);
                                        Tr.debug(WSSConsumer.tc, "SignatureConfirmation value from the cache = " + (String)var37_43);
                                    }
                                }
                            }
                            if (WSSConsumer.tc.isDebugEnabled()) {
                                Tr.debug(WSSConsumer.tc, "SignatureConfirmation is enabled on replies. The number of signature values in the cache is " + var33_37);
                            }
                        } else if (WSSConsumer.tc.isDebugEnabled()) {
                            Tr.debug(WSSConsumer.tc, "SignatureConfirmation is enabled on requests.");
                        }
                    }
                    try {
                        var36_40 = NamespaceUtil.isWsse(var28_30.getNamespace() == null ? null : var28_30.getNamespace().getNamespaceURI());
                        if (var26_27 < 0) {
                            var26_27 = var36_40;
                            var2_2.put("com.ibm.ws.wssecurity.constants.wssVersion", new Integer(var26_27));
                            var8_8.setProperty("com.ibm.ws.wssecurity.constants.wssVersion", new Integer(var26_27));
                        } else if (var36_40 != var26_27) {
                            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s06");
                        }
                        if (WSSConsumer.tc.isDebugEnabled()) {
                            var37_43 = null;
                            var37_43 = var26_27 == 0 ? "The spec of WS-Security is 2004/01 ver." : ("Unknown spec of WS-Security: " + var28_30.getNamespace() == null ? null : var28_30.getNamespace().getNamespaceURI());
                            Tr.debug(WSSConsumer.tc, (String)var37_43);
                        }
                        var37_43 = null;
                        if (var15_15 && var14_14) {
                            var37_43 = new ArrayList<E>();
                            var2_2.put("com.ibm.ws.wssecurity.constants.signatureConfirmationCache", var37_43);
                        }
                        var38_44 = DOMUtils.getFirstElement(var28_30);
                        while (var38_44 != null) {
                            block159: {
                                block166: {
                                    block167: {
                                        block164: {
                                            block165: {
                                                block160: {
                                                    block161: {
                                                        block163: {
                                                            block162: {
                                                                block156: {
                                                                    block157: {
                                                                        block158: {
                                                                            var39_47 = var38_44.getLocalName();
                                                                            var40_52 = var38_44.getNamespace() == null ? null : var38_44.getNamespace().getNamespaceURI();
                                                                            var36_40 = NamespaceUtil.isWsu(var40_52);
                                                                            if (var36_40 < 0) break block156;
                                                                            if (var36_40 != var26_27) break block157;
                                                                            if (!var39_47.equals("Timestamp")) break block158;
                                                                            var41_57 = var38_44.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.WSU_ID);
                                                                            var7_7.put(var41_57, var38_44);
                                                                            break block159;
                                                                        }
                                                                        throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtils.getQualifiedName((OMNode)var38_44), DOMUtils.getQualifiedName(var28_30));
                                                                    }
                                                                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s05", var40_52);
                                                                }
                                                                var36_40 = NamespaceUtil.isWsse(var40_52);
                                                                if (var36_40 < 0) break block160;
                                                                if (var36_40 != var26_27) break block161;
                                                                if (!var39_47.equals("UsernameToken")) break block162;
                                                                WSSConsumer.callTokenConsumer(var10_10.getCallers(), var10_10.getTokenConsumers(), var19_19, var28_30, (OMElement)var38_44, var9_9, var2_2, true, false, var26_27, false);
                                                                break block159;
                                                            }
                                                            if (!var39_47.equals("BinarySecurityToken")) break block163;
                                                            WSSConsumer.callTokenConsumer(var10_10.getCallers(), var10_10.getTokenConsumers(), var19_19, var28_30, (OMElement)var38_44, var9_9, var2_2, false, true, var26_27, false);
                                                            break block159;
                                                        }
                                                        throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtils.getQualifiedName((OMNode)var38_44), DOMUtils.getQualifiedName(var28_30));
                                                    }
                                                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s05", var40_52);
                                                }
                                                if (!com.ibm.ws.wssecurity.common.Constants.NS_DSIG.equals(var40_52)) break block164;
                                                if (!var39_47.equals("Signature")) break block165;
                                                var41_58 = false;
                                                var42_62 = DOMUtils.getNextElement((OMNode)var38_44);
                                                while (var42_62 != null) {
                                                    var43_63 = var42_62.getNamespace() == null ? null : var42_62.getNamespace().getNamespaceURI();
                                                    var44_64 = var42_62.getLocalName();
                                                    if (com.ibm.ws.wssecurity.common.Constants.NS_ENC.equals(var43_63) && ("EncryptedKey".equals(var44_64) || "ReferenceList".equals(var44_64))) {
                                                        var41_58 = true;
                                                    }
                                                    var42_62 = DOMUtils.getNextElement((OMNode)var42_62);
                                                }
                                                WSSConsumer.callSignatureConsumer(var10_10.getSignatureConsumers(), var13_13, (OMElement)var38_44, var41_58, var2_2, var28_30);
                                                break block159;
                                            }
                                            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtils.getQualifiedName((OMNode)var38_44), DOMUtils.getQualifiedName(var28_30));
                                        }
                                        if (!com.ibm.ws.wssecurity.common.Constants.NS_WSSE11.equals(var40_52)) break block166;
                                        if (!var39_47.equals("SignatureConfirmation")) break block167;
                                        if (!var15_15) ** GOTO lbl379
                                        ++var32_36;
                                        if (!var14_14) {
                                            var41_59 = null;
                                            var41_59 = var38_44.getAttributeValue(new QName("", "Value"));
                                            if (var41_59 != null) {
                                                if (var34_38 == null || !var34_38.contains(var41_59)) {
                                                    if (WSSConsumer.tc.isDebugEnabled()) {
                                                        Tr.debug(WSSConsumer.tc, "SignatureConfirmation value attribute does not match one in cache. The value is: " + var41_59);
                                                    }
                                                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s42");
                                                }
                                            } else if (var33_37 != 0) {
                                                if (WSSConsumer.tc.isDebugEnabled()) {
                                                    Tr.debug(WSSConsumer.tc, "SignatureConfirmation did not have value attribute. The value attribute is required.");
                                                }
                                                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s41");
                                            }
                                        } else {
                                            if (WSSConsumer.tc.isDebugEnabled()) {
                                                Tr.debug(WSSConsumer.tc, "SignatureConfirmation element found on the request message. SignatureConfirmation element should only be found on the response message.");
                                            }
                                            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtils.getQualifiedName((OMNode)var38_44), DOMUtils.getQualifiedName(var28_30));
lbl379:
                                            // 1 sources

                                            Tr.warning(WSSConsumer.tc, "security.wssecurity.WSSConsumer.s46");
                                        }
                                        break block159;
                                    }
                                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtils.getQualifiedName((OMNode)var38_44), DOMUtils.getQualifiedName(var28_30));
                                }
                                if (!com.ibm.ws.wssecurity.common.Constants.NS_ENC.equals(var40_52)) ** GOTO lbl389
                                if (var39_47.equals("EncryptedKey") || var39_47.equals("ReferenceList")) {
                                    WSSConsumer.callEncryptionConsumer(var10_10.getEncryptionConsumers(), var13_13, (OMElement)var38_44, var2_2, var28_30);
                                } else {
                                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtils.getQualifiedName((OMNode)var38_44), DOMUtils.getQualifiedName(var28_30));
lbl389:
                                    // 1 sources

                                    WSSConsumer.callTokenConsumer(var10_10.getCallers(), var10_10.getTokenConsumers(), var19_19, var28_30, (OMElement)var38_44, var9_9, var2_2, false, false, var26_27, false);
                                }
                            }
                            var38_44 = DOMUtils.getNextElement((OMNode)var38_44);
                        }
                        if (!var3_3.isEmpty()) {
                            var38_44 = var3_3.keySet().toArray();
                            var39_50 = true;
                            for (var40_53 = 0; var40_53 < ((Object[])var38_44).length; ++var40_53) {
                                var41_60 = (String)var38_44[var40_53];
                                WSSConsumer.callStoredTokenConsumer(var2_2, var9_9, var41_60, var39_50);
                            }
                            if (!var3_3.isEmpty()) {
                                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s02");
                            }
                        }
                        if (var15_15) {
                            if (!var14_14) {
                                if (var33_37 != var32_36) {
                                    if (var33_37 != 0 || var32_36 != 1) {
                                        var38_45 = var33_37;
                                        if (var33_37 == 0) {
                                            var38_45 = 1;
                                        }
                                        throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s43", "" + var38_45, "" + var32_36);
                                    }
                                } else if (var33_37 == 0 && var32_36 != 1) {
                                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s44");
                                }
                            } else {
                                var38_44 = (List)var2_2.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
                                if (var38_44 != null && var38_44.size() > 0) {
                                    var39_51 = null;
                                    var39_51 = (HashMap<String, Object>)var8_8.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                                    if (var39_51 == null) {
                                        var39_51 = new HashMap<String, Object>();
                                    }
                                    var40_54 = null;
                                    var40_54 = (HashMap<String, Object>)var8_8.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                                    if (var40_54 == null) {
                                        var40_54 = new HashMap<String, Object>();
                                    }
                                    var39_51.put("com.ibm.ws.wssecurity.constants.signatureConfirmationCache", var38_44);
                                    var8_8.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", var39_51);
                                    var40_54.put("com.ibm.ws.wssecurity.constants.signatureConfirmationCache", var38_44);
                                    var8_8.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", var40_54);
                                    var2_2.remove("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
                                    if (WSSConsumer.tc.isDebugEnabled()) {
                                        Tr.debug(WSSConsumer.tc, "Stored SIGNATURE_CONFIRMATION_CACHE on msg ctx in WSS_PROPERTYMAP and WSS_RAMP_PROPERTYMAP property");
                                    }
                                }
                            }
                        }
                        var38_44 = com.ibm.ws.wssecurity.util.DOMUtil.getHeadersForNamespace(var20_20, com.ibm.ws.wssecurity.common.Constants.NS_WSSE11, "EncryptedHeader", (String)var31_35, var21_21);
                        var39_46 = 0;
                        while (var27_29 < var38_44.size()) {
                            var40_55 = (OMElement)var38_44.get(var39_46);
                            var41_61 = false;
                            var42_62 = var40_55.getAttributeValue(new QName("", "mustUnderstand"));
                            if (var42_62 != null && !"".equals(var42_62)) {
                                var41_61 = ConfigUtil.isTrue((String)var42_62);
                            }
                            if (var29_32 && var41_61) {
                                throw SoapSecurityException.format(new QName(com.ibm.ws.wssecurity.common.Constants.NS_SOAP, "MustUnderstand.securityException"), "security.wssecurity.WSSConsumer.s45");
                            }
                            ++var39_46;
                        }
                        continue;
                    }
                    catch (SoapSecurityException var36_42) {
                        Tr.processException((Throwable)var36_42, WSSConsumer.clsName + ".invoke", "516", this);
                        Tr.error(WSSConsumer.tc, "security.wssecurity.WSSConsumer.s23", var36_42);
                        if (!var29_32) {
                            Tr.debug(WSSConsumer.tc, "An exception has occurred when mustUnderstand=0.");
                            Tr.debug(WSSConsumer.tc, "The mustUnderstand=0 attribute may be honored when there is no inbound WSSecurity configuration for the elements being processed.");
                        }
                        throw var36_42;
                    }
                }
                break block168;
            }
            Tr.debug(WSSConsumer.tc, "SOAP Header is null. Bypassed consuming of security header.");
        }
        if (WSSConsumer.tc.isDebugEnabled()) {
            Tr.debug(WSSConsumer.tc, "All security handlers is processed.");
        }
        WSSConsumer.cleanSubject(var9_9, var2_2);
        if (var10_10.isVerificationRequired()) {
            if (WSSConsumer.tc.isDebugEnabled()) {
                Tr.debug(WSSConsumer.tc, "Checking the required integrity.");
            }
            WSSConsumer.checkRequiredIntegrity(var18_18, var13_13, var2_2);
        }
        if (var10_10.isDecryptionRequired()) {
            if (WSSConsumer.tc.isDebugEnabled()) {
                Tr.debug(WSSConsumer.tc, "Checking the required confidentiality.");
            }
            WSSConsumer.checkRequiredConfidentiality(var18_18, var13_13, var2_2);
        }
        if (var10_10.isTokenRequired()) {
            if (WSSConsumer.tc.isDebugEnabled()) {
                Tr.debug(WSSConsumer.tc, "Checking the required security token.");
            }
            WSSConsumer.checkRequiredSecurityToken(var10_10.getRequiredSecurityTokens(), var10_10.getCallers(), var9_9);
        }
        if (var10_10.isLoginRequired()) {
            if (WSSConsumer.tc.isDebugEnabled()) {
                Tr.debug(WSSConsumer.tc, "Checking the caller.");
            }
            WSSConsumer.checkCaller(var13_13, var2_2);
        }
        if (var20_20 == null) {
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf11", "SOAP Header");
        }
        this.mapSignedPartsToMessageContext(var8_8, var2_2);
        this.mapEncryptedPartsToMessageContext(var8_8, var2_2);
        WSSConsumer.copyContextSubjectToMessageContext(var8_8, var2_2);
        WSSConsumer.mapTokenToMessageContext(var8_8, var9_9, var2_2);
        var21_22 = NamespaceUtil.getWsseHeaderByName(var17_17, var10_10.getMyActor(), "Security");
        if (var21_22 != null) {
            if (WSSConsumer.tc.isDebugEnabled()) {
                Tr.debug(WSSConsumer.tc, "Security header is processed.");
            }
            var21_22.setProcessed();
        }
        if ((var21_22 = NamespaceUtil.getWsuHeaderByName(var17_17, var10_10.getMyActor(), "Timestamp")) != null) {
            if (WSSConsumer.tc.isDebugEnabled()) {
                Tr.debug(WSSConsumer.tc, "Timestamp header is processed.");
            }
            var21_22.setProcessed();
        }
        var9_9.finalizeSubject();
        ResultPool.finalize(var2_2);
        ResultMessagePool.finalize(var2_2);
        if (WSSConsumer.tc.isEntryEnabled()) {
            Tr.exit(WSSConsumer.tc, "invoke(OMNode, Map)");
        }
    }

    public void onFault(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onFault(MessageContext context)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onFault(MessageContext)");
        }
    }

    private void setInitialProperties() throws SoapSecurityException {
        this._properties.put(ConfidentialDialectElementSelector.class, new ConfidentialDialectElementSelector());
        this._properties.put(IntegralDialectElementSelector.class, new IntegralDialectElementSelector());
        this._properties.put(TimestampDialectElementSelector.class, new TimestampDialectElementSelector());
        this._properties.put(QNameHeaderSelector.class, new QNameHeaderSelector());
        this._properties.put(WSPFunctionElementSelector.class, new WSPFunctionElementSelector());
        this._properties.put(XPathElementSelector.class, new XPathElementSelector());
        this._properties.put("com.ibm.ws.wssecurity.util.selector.IDResolver", IdUtils.getInstance());
        this._properties.put(NonceUtil.class, new NonceUtil());
        WSSFactory wSSFactory = WSSFactory.getInstance("soap");
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.timestamp");
        this._properties.put(TimestampConsumer.class, wSSFactory.createConsumer(hashMap, this._properties));
        hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.signature");
        this._properties.put(SignatureConsumer.class, wSSFactory.createConsumer(hashMap, this._properties));
        hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.encryption");
        this._properties.put(EncryptionConsumer.class, wSSFactory.createConsumer(hashMap, this._properties));
        hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.keyinfo");
        this._properties.put(KeyInfoConsumer.class, wSSFactory.createConsumer(hashMap, this._properties));
        WSSConsumerComponent wSSConsumerComponent = new VerifiedPartChecker();
        wSSConsumerComponent.init(this._properties);
        this._properties.put(VerifiedPartChecker.class, wSSConsumerComponent);
        wSSConsumerComponent = new DecryptedPartChecker();
        wSSConsumerComponent.init(this._properties);
        this._properties.put(DecryptedPartChecker.class, wSSConsumerComponent);
        wSSConsumerComponent = new TimestampChecker();
        wSSConsumerComponent.init(this._properties);
        this._properties.put(TimestampChecker.class, wSSConsumerComponent);
        wSSConsumerComponent = new LoginProcessor();
        wSSConsumerComponent.init(this._properties);
        this._properties.put(LoginProcessor.class, wSSConsumerComponent);
    }

    private static boolean adjustContext(MessageContext messageContext, Map<Object, Object> map) throws SoapSecurityException {
        return false;
    }

    public static ArrayList getSecurityHeaders(OMElement oMElement, int n, boolean bl, String string) throws SoapSecurityException {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getSecurityHeaders(");
            ((StringBuffer)serializable).append("OMElement header[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)serializable).append("int soapVersion[").append(n).append("], ");
            ((StringBuffer)serializable).append("boolean untimateReceiver[").append(bl).append("], ");
            ((StringBuffer)serializable).append("String actor[").append(string).append("])");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = new ArrayList();
        Object object = DOMUtils.getFirstElement(oMElement);
        while (object != null) {
            block11: {
                block13: {
                    String string2;
                    block12: {
                        String string3 = object.getNamespace() == null ? null : object.getNamespace().getNamespaceURI();
                        String string4 = object.getLocalName();
                        if (NamespaceUtil.isWsse(string3) < 0 || !"Security".equals(string4)) break block11;
                        if (n == 1) {
                            string2 = object.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP12_ROLE_Q);
                        } else if (n == 0) {
                            string2 = object.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP11_ACTOR_Q);
                        } else {
                            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s11", Integer.toString(n));
                        }
                        if (string2 != null && string2.trim().length() != 0) break block12;
                        if (string != null && string.trim().length() != 0) break block11;
                        break block13;
                    }
                    if (n == 1 ? com.ibm.ws.wssecurity.common.Constants.SOAP12_ROLE_NONE.equals(string2) || (com.ibm.ws.wssecurity.common.Constants.SOAP12_ROLE_RECEIVER.equals(string2) ? !string2.equals(string) : !com.ibm.ws.wssecurity.common.Constants.SOAP12_ROLE_NEXT.equals(string2) && !string2.equals(string)) : !com.ibm.ws.wssecurity.common.Constants.SOAP11_ACTOR_NEXT.equals(string2) && !string2.equals(string)) break block11;
                }
                ((ArrayList)serializable).add(object);
            }
            object = DOMUtils.getNextElement((OMNode)object);
        }
        if (((ArrayList)serializable).size() > 1) {
            throw SoapSecurityException.format("security.wssecurity.WSEC6832E");
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getSecurityHeaders(");
            ((StringBuffer)object).append("OMElement, int, boolean, String)");
            ((StringBuffer)object).append(" returns NodeList [").append(serializable).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return serializable;
    }

    private static int countSecurityHeaders(OMElement oMElement) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("countSecurityHeaders(");
            stringBuffer.append("OMElement header[").append(DOMUtils.getDisplayName(oMElement)).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        int n = 0;
        Object object = DOMUtils.getFirstElement(oMElement);
        while (object != null) {
            if ("Security".equals(object.getLocalName())) {
                ++n;
            }
            object = DOMUtils.getNextElement((OMNode)object);
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("countSecurityHeaders(Element)");
            ((StringBuffer)object).append(" returns int [").append(n).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return n;
    }

    public static QName getId(OMNode oMNode) throws SoapSecurityException {
        Object object;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getId(");
            ((StringBuffer)serializable).append("OMNode node[").append(DOMUtils.getDisplayName(oMNode)).append("])");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = null;
        if (oMNode.getType() == 1) {
            object = (OMElement)oMNode;
            serializable = IdUtils.getInstance().getIdAttributeName((OMElement)object);
        }
        if (serializable == null && oMNode.getType() == 1) {
            object = (OMElement)oMNode;
            for (OMNode oMNode2 = object.getFirstOMChild(); oMNode2 != null && (oMNode2.getType() != 1 && oMNode2.getType() != 9 || (serializable = WSSConsumer.getId(oMNode2)) == null); oMNode2 = oMNode2.getNextOMSibling()) {
            }
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getId(OMNode)");
            ((StringBuffer)object).append(" returns QName [").append(serializable).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return serializable;
    }

    private static ArrayList getTimestampHeader(OMElement oMElement, int n, boolean bl) throws SoapSecurityException {
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("getTimestampHeader(");
            ((StringBuffer)charSequence).append("OMElement root[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)charSequence).append("int wssVersion[").append(n).append("], ");
            ((StringBuffer)charSequence).append("boolean trace[").append(bl).append("])");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        charSequence = bl ? "TimestampTrace" : "Timestamp";
        ArrayList<OMElement> arrayList = new ArrayList<OMElement>();
        ArrayList<OMNode> arrayList2 = n < 0 ? NamespaceUtil.getWsuElementsByTagName(oMElement, (String)charSequence) : DOMUtils.getOneOrMoreElements(oMElement, com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n], (String)charSequence);
        for (int i = 0; i < arrayList2.size(); ++i) {
            OMElement oMElement2 = (OMElement)arrayList2.get(i);
            if (oMElement2.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.WAS_EXTENTION_Q) != null) continue;
            arrayList.add(oMElement2);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getTimestampHeader(");
            stringBuffer.append("OMElement, int, boolean)");
            stringBuffer.append(" returns NodeList [").append(arrayList2).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return arrayList;
    }

    private static void callTimestampConsumer(TimestampConsumerConfig timestampConsumerConfig, Map<Object, Object> map, OMElement oMElement, Map<Object, Object> map2) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("callTimestampConsumer(");
            ((StringBuffer)object).append("TimestampConsumerConfig config, Map selectors, ");
            ((StringBuffer)object).append("OMElement target[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)object).append("Map context)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = (TimestampConsumer)map.get(TimestampConsumer.class);
        map2.put("com.ibm.ws.wssecurity.impl.config.timestampConsumer.configKey", timestampConsumerConfig);
        ((TimestampConsumer)object).invoke(oMElement, map2);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("callTimestampConsumer(");
            stringBuffer.append("TimestampConsumerConfig, Map, OMElement, Map)");
            Tr.exit(tc, stringBuffer.toString());
        }
    }

    public static void callStoredTokenConsumer(TokenConsumerConfig tokenConsumerConfig, Map<Object, Object> map, String string) throws SoapSecurityException {
        SecurityTokenManagerImpl securityTokenManagerImpl = (SecurityTokenManagerImpl)map.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        Set<CallerConfig> set = wSSConsumerConfig.getCallers();
        SoapSecurityException soapSecurityException = null;
        MessageContext messageContext = (MessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
        HashMap hashMap = (HashMap)map.get("com.ibm.ws.wssecurity.constants.tokenCache");
        HashMap hashMap2 = (HashMap)map.get("com.ibm.ws.wssecurity.constants.securityHeadersCache");
        HashMap hashMap3 = (HashMap)map.get("com.ibm.ws.wssecurity.constants.tokenCacheType");
        HashMap hashMap4 = (HashMap)map.get("com.ibm.ws.wssecurity.constants.viTokensHash");
        OMElement oMElement = (OMElement)hashMap.get(string);
        Integer n = (Integer)hashMap3.get(string);
        try {
            Boolean bl;
            WSSConsumer.callTokenConsumer(tokenConsumerConfig, oMElement, map);
            final SecurityTokenWrapper securityTokenWrapper = securityTokenManagerImpl.getUnprocessedTokenWrapper();
            if (securityTokenWrapper != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unprocessed token [" + securityTokenWrapper + "] found.");
                }
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        securityTokenWrapper.setProcessed(true);
                        return null;
                    }
                });
                if (set != null) {
                    WSSConsumer.checkCaller(set, tokenConsumerConfig, securityTokenWrapper, securityTokenManagerImpl, map);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "All tokens are processed.");
                }
                if (set != null) {
                    WSSConsumer.checkCaller(set, tokenConsumerConfig, securityTokenManagerImpl, map);
                }
            }
            if ((bl = (Boolean)hashMap4.get(string)) == null) {
                bl = false;
            }
            if (n == com.ibm.ws.wssecurity.common.Constants.BINARY_TOKEN_TYPE && bl.booleanValue()) {
                boolean bl2 = true;
                String string2 = (String)wSSConsumerConfig.getProperties().get("com.ibm.ws.wssecurity.consumeX509Errata10Token");
                if (string2 != null && string2.equals("false")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found X509 Errata token in the message, but token consumer has com.ibm.ws.wssecurity.consumeX509Errata10Token property set to false in bindings. Consumption will not take place and message will likely not be processed.");
                    }
                    bl2 = false;
                }
                if (bl2) {
                    messageContext = (MessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
                    HashMap<String, Boolean> hashMap5 = null;
                    hashMap5 = (HashMap<String, Boolean>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                    if (hashMap5 == null) {
                        hashMap5 = new HashMap<String, Boolean>();
                    }
                    HashMap<String, Boolean> hashMap6 = null;
                    hashMap6 = (HashMap<String, Boolean>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                    if (hashMap6 == null) {
                        hashMap6 = new HashMap<String, Boolean>();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Copying useErrata boolean to message context");
                    }
                    hashMap5.put("com.ibm.ws.wssecurity.generateX509Errata10Token".toString(), bl);
                    messageContext.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", hashMap5);
                    hashMap6.put("com.ibm.ws.wssecurity.generateX509Errata10Token".toString(), bl);
                    messageContext.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", hashMap6);
                }
            }
        }
        catch (Exception exception) {
            soapSecurityException = exception instanceof SoapSecurityException ? (SoapSecurityException)exception : SoapSecurityException.format("security.wssecurity.WSSConsumer.s34", new String[]{exception.getMessage()}, (Throwable)exception);
            Object object = map.remove(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING);
            if (object != null && object instanceof SecurityToken) {
                SecurityToken securityToken = (SecurityToken)object;
                if (!tokenConsumerConfig.isUsedForDecryption() && !tokenConsumerConfig.isUsedForVerification()) {
                    securityTokenManagerImpl.removeToken(securityToken);
                } else {
                    SecurityTokenWrapper securityTokenWrapper = new SecurityTokenWrapper(securityToken);
                    securityTokenWrapper.setUsedTokenConsumer(tokenConsumerConfig.hashCode(), tokenConsumerConfig.getClass().getName().hashCode());
                    securityTokenWrapper.setKeyInfoType(null);
                    securityTokenWrapper.setError(soapSecurityException);
                    securityTokenWrapper.setProcessed(true);
                    securityTokenManagerImpl.addTokenWrapper(securityTokenWrapper);
                }
            }
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s13", soapSecurityException);
        }
        hashMap.remove(string);
        hashMap2.remove(string);
        hashMap3.remove(string);
        hashMap4.remove(string);
    }

    public static void callStoredTokenConsumer(Map<Object, Object> map, SecurityTokenManagerImpl securityTokenManagerImpl, String string, boolean bl) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            object3 = new StringBuffer("callStoredTokenConsumer(");
            ((StringBuffer)object3).append("Map context, SecurityTokenManagerImpl securityTokenManager, ");
            ((StringBuffer)object3).append("String id[").append(string).append("], ");
            ((StringBuffer)object3).append("boolean tryAllCandidates[").append(bl).append("])");
            Tr.entry(tc, ((StringBuffer)object3).toString());
        }
        object3 = null;
        int n = 0;
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        MessageContext messageContext = (MessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (messageContext != null && (object2 = messageContext.getEnvelope()) != null && (object = DOMUtil.getOwnerDocument((OMNode)object2)) != null) {
            object3 = object.getOMDocumentElement();
        }
        if ((object2 = (Integer)messageContext.getProperty("com.ibm.ws.wssecurity.constants.wssVersion")) != null) {
            n = (Integer)object2;
        }
        object = (HashMap)map.get("com.ibm.ws.wssecurity.constants.tokenCache");
        HashMap hashMap = (HashMap)map.get("com.ibm.ws.wssecurity.constants.securityHeadersCache");
        HashMap hashMap2 = (HashMap)map.get("com.ibm.ws.wssecurity.constants.tokenCacheType");
        HashMap hashMap3 = (HashMap)map.get("com.ibm.ws.wssecurity.constants.viTokensHash");
        OMElement oMElement = (OMElement)((HashMap)object).get(string);
        OMElement oMElement2 = (OMElement)hashMap.get(string);
        Integer n2 = (Integer)hashMap2.get(string);
        if (n2 == com.ibm.ws.wssecurity.common.Constants.BINARY_TOKEN_TYPE) {
            WSSConsumer.callTokenConsumer(wSSConsumerConfig.getCallers(), wSSConsumerConfig.getTokenConsumers(), (OMElement)object3, oMElement2, oMElement, securityTokenManagerImpl, map, false, true, n, bl);
            Boolean bl2 = (Boolean)hashMap3.get(string);
            if (bl2 == null) {
                bl2 = false;
            }
            if (bl2.booleanValue()) {
                boolean bl3 = true;
                String string2 = (String)wSSConsumerConfig.getProperties().get("com.ibm.ws.wssecurity.consumeX509Errata10Token");
                if (string2 != null && string2.equals("false")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found X509 Errata token in the message, but token consumer has com.ibm.ws.wssecurity.consumeX509Errata10Token property set to false in bindings. Consumption will not take place and message will likely not be processed.");
                    }
                    bl3 = false;
                }
                if (bl3) {
                    messageContext = (MessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
                    HashMap<String, Boolean> hashMap4 = null;
                    hashMap4 = (HashMap<String, Boolean>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                    if (hashMap4 == null) {
                        hashMap4 = new HashMap<String, Boolean>();
                    }
                    HashMap<String, Boolean> hashMap5 = null;
                    hashMap5 = (HashMap<String, Boolean>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                    if (hashMap5 == null) {
                        hashMap5 = new HashMap<String, Boolean>();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Copying useErrata boolean to message context");
                    }
                    hashMap4.put("com.ibm.ws.wssecurity.consumeX509Errata10Token".toString(), bl2);
                    messageContext.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", hashMap4);
                    hashMap5.put("com.ibm.ws.wssecurity.consumeX509Errata10Token".toString(), bl2);
                    messageContext.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", hashMap5);
                }
            }
        } else if (n2 == com.ibm.ws.wssecurity.common.Constants.USERNAME_TOKEN_TYPE) {
            WSSConsumer.callTokenConsumer(wSSConsumerConfig.getCallers(), wSSConsumerConfig.getTokenConsumers(), (OMElement)object3, oMElement2, oMElement, securityTokenManagerImpl, map, true, false, n, bl);
        } else {
            WSSConsumer.callTokenConsumer(wSSConsumerConfig.getCallers(), wSSConsumerConfig.getTokenConsumers(), (OMElement)object3, oMElement2, oMElement, securityTokenManagerImpl, map, false, false, n, bl);
        }
        ((HashMap)object).remove(string);
        hashMap.remove(string);
        hashMap2.remove(string);
    }

    public static void callTokenConsumer(Collection<CallerConfig> collection, Collection<TokenConsumerConfig> collection2, OMElement oMElement, OMElement oMElement2, OMElement oMElement3, SecurityTokenManagerImpl securityTokenManagerImpl, Map<Object, Object> map, boolean bl, boolean bl2, int n, boolean bl3) throws SoapSecurityException {
        int n2;
        Object object;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("callTokenConsumer(");
            ((StringBuffer)serializable).append("Collection cconfigs, Collection tconfigs, ");
            ((StringBuffer)serializable).append("OMElement envelope[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)serializable).append("OMElement security[").append(DOMUtils.getDisplayName(oMElement2)).append("], ");
            ((StringBuffer)serializable).append("OMElement target[").append(DOMUtils.getDisplayName(oMElement3)).append("], ");
            ((StringBuffer)serializable).append("SecurityTokenManagerImpl securityTokenManager, Map context, ");
            ((StringBuffer)serializable).append("boolean isUT[").append(bl).append("], ");
            ((StringBuffer)serializable).append("boolean isBST[").append(bl2).append("], ");
            ((StringBuffer)serializable).append("int wssVersion[").append(n).append("], ");
            ((StringBuffer)serializable).append("boolean tryAllCandidates[").append(bl3).append("])");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = (HashMap)map.get("com.ibm.ws.wssecurity.constants.tokenCache");
        HashMap hashMap = (HashMap)map.get("com.ibm.ws.wssecurity.constants.securityHeadersCache");
        HashMap hashMap2 = (HashMap)map.get("com.ibm.ws.wssecurity.constants.tokenCacheType");
        HashMap hashMap3 = (HashMap)map.get("com.ibm.ws.wssecurity.constants.viTokensHash");
        Boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = false;
        if ("SecurityContextToken".equals(oMElement3.getLocalName())) {
            bl6 = true;
        } else if ("DerivedKeyToken".equals(oMElement3.getLocalName())) {
            bl7 = true;
        }
        QName qName = null;
        String string = oMElement3.getAttributeValue(VALUETYPE_Q);
        if (string != null) {
            qName = DOMUtils.getQName(oMElement3, string, n);
        }
        if (qName != null && NamespaceUtil.equals(qName, com.ibm.ws.wssecurity.common.Constants.X509V3)) {
            bl4 = true;
        }
        String string2 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][n];
        String string3 = ConfigUtil.trim(IdUtils.getInstance().getId(oMElement3));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Target's value type is [" + qName + "].");
            Tr.debug(tc, "UsernameToken flag is [" + bl + "].");
            Tr.debug(tc, "BinarySecurityToken flag is [" + bl2 + "].");
            Tr.debug(tc, "SecurityContextToken flag is [" + bl6 + "].");
            Tr.debug(tc, "DerivedKeyToken flag is [" + bl7 + "].");
            Tr.debug(tc, "The identifier is [" + string3 + "].");
        }
        TokenConsumerConfig tokenConsumerConfig2 = null;
        Iterator<TokenConsumerConfig> iterator = null;
        HashSet<TokenConsumerConfig> hashSet = new HashSet<TokenConsumerConfig>();
        boolean bl8 = true;
        boolean bl9 = true;
        int n3 = 0;
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        boolean bl10 = false;
        if (bl && (object = DOMUtils.getZeroOrOneElement(oMElement3, string2, "Password")) == null) {
            bl10 = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isIDAIdentityToken=" + bl10);
        }
        if (oMElement != null && oMElement2 != null && (bl2 || bl || bl7)) {
            bl8 = false;
            bl9 = false;
            n3 = WSSConsumer.getUsedFor(oMElement, oMElement2, string2, string3);
            if (n3 == 1) {
                bl9 = true;
            } else if (n3 == 2) {
                bl8 = true;
            }
            if (tc.isDebugEnabled()) {
                if (bl9) {
                    Tr.debug(tc, "The token is used for signature verification.");
                } else if (bl8) {
                    Tr.debug(tc, "The token is used for decryption.");
                } else {
                    Tr.debug(tc, "The token is maybe stand-alone.");
                }
            }
            for (TokenConsumerConfig tokenConsumerConfig2 : collection2) {
                if (tc.isDebugEnabled()) {
                    if (tokenConsumerConfig2.isUsedForVerification()) {
                        Tr.debug(tc, "The configuration of token consumers is used for signature verification.");
                    } else if (tokenConsumerConfig2.isUsedForDecryption()) {
                        Tr.debug(tc, "The configuration of token consumers is used for decryption.");
                    } else {
                        Tr.debug(tc, "The configuration of token consumers is maybe used for stand-alone tokens.");
                    }
                }
                if (!(bl9 && tokenConsumerConfig2.isUsedForVerification() || bl8 && tokenConsumerConfig2.isUsedForDecryption()) && (bl9 || tokenConsumerConfig2.isUsedForVerification() || bl8 || tokenConsumerConfig2.isUsedForDecryption())) continue;
                object = tokenConsumerConfig2.getType();
                if (bl) {
                    if (!com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(object) && !com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(object)) continue;
                    boolean bl11 = true;
                    if (wSSConsumerConfig.getUntOptimize() && tokenConsumerConfig2.getProperties().get("com.ibm.ws.wssecurity.token.ourLoginConfig") != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Our UNT token consumer");
                        }
                        bl11 = false;
                        n2 = 0;
                        if (tokenConsumerConfig2.getProperties().get("com.ibm.ws.wssecurity.token.isUntIdaConsumer") != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "UNT Identity token consumer");
                            }
                            n2 = 1;
                        }
                        if (bl10 && n2 != 0) {
                            bl11 = true;
                        } else if (!bl10 && n2 == 0) {
                            bl11 = true;
                        }
                    }
                    if (!bl11) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added a config for [" + object + "].");
                    }
                    hashSet.add(tokenConsumerConfig2);
                    continue;
                }
                if (bl2) {
                    if (NamespaceUtil.equals(qName, (QName)object)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Added a config for [" + object + "].");
                        }
                        hashSet.add(tokenConsumerConfig2);
                        continue;
                    }
                    if (!bl4.booleanValue()) continue;
                    bl5 = true;
                    String string4 = (String)tokenConsumerConfig2.getProperties().get("com.ibm.ws.wssecurity.consumeX509Errata10Token");
                    if (string4 != null && string4.equals("false")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found X509 Errata token in the message, but token consumer has com.ibm.ws.wssecurity.consumeX509Errata10Token property set to false in bindings. Consumption will not take place and message will likely not be processed.");
                        }
                        bl5 = false;
                    }
                    if (!NamespaceUtil.equals((QName)object, com.ibm.ws.wssecurity.common.Constants.X509V3_OLD) || !NamespaceUtil.equals(qName, com.ibm.ws.wssecurity.common.Constants.X509V3) || !bl5) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added a config for [" + object + "], which will consume Errata token[" + qName + "]");
                    }
                    hashSet.add(tokenConsumerConfig2);
                    continue;
                }
                if (bl6) {
                    if (!com.ibm.ws.wssecurity.common.Constants.SCT.equals(object)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding a config for [" + object + "].");
                    }
                    hashSet.add(tokenConsumerConfig2);
                    break;
                }
                if (bl7) {
                    if (!com.ibm.ws.wssecurity.common.Constants.SCT.equals(object)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding a config for [" + object + "].");
                    }
                    hashSet.add(tokenConsumerConfig2);
                    continue;
                }
                QName qName2 = new QName(oMElement3.getNamespace() == null ? null : oMElement3.getNamespace().getNamespaceURI(), oMElement3.getLocalName());
                if (!((QName)object).equals(qName2)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added a config for [" + object + "].");
                }
                hashSet.add(tokenConsumerConfig2);
            }
        }
        if (hashSet.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Since it can't select configuration of token cosumers based on the message, it uses all candidates.");
            }
            for (TokenConsumerConfig tokenConsumerConfig2 : collection2) {
                object = tokenConsumerConfig2.getType();
                if (bl) {
                    if (!com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(object) && !com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(object)) continue;
                    boolean bl12 = true;
                    if (wSSConsumerConfig.getUntOptimize() && tokenConsumerConfig2.getProperties().get("com.ibm.ws.wssecurity.token.ourLoginConfig") != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Our UNT token consumer");
                        }
                        bl12 = false;
                        n2 = 0;
                        if (tokenConsumerConfig2.getProperties().get("com.ibm.ws.wssecurity.token.isUntIdaConsumer") != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "UNT Identity token consumer");
                            }
                            n2 = 1;
                        }
                        if (bl10 && n2 != 0) {
                            bl12 = true;
                        } else if (!bl10 && n2 == 0) {
                            bl12 = true;
                        }
                    }
                    if (!bl12) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added a config for [" + object + "].");
                    }
                    hashSet.add(tokenConsumerConfig2);
                    continue;
                }
                if (bl2) {
                    if (NamespaceUtil.equals(qName, (QName)object)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Added a config for [" + object + "].");
                        }
                        hashSet.add(tokenConsumerConfig2);
                        continue;
                    }
                    if (!bl4.booleanValue()) continue;
                    bl5 = true;
                    String string5 = (String)tokenConsumerConfig2.getProperties().get("com.ibm.ws.wssecurity.consumeX509Errata10Token");
                    if (string5 != null && string5.equals("false")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found X509 Errata token in the message, but token consumer has com.ibm.ws.wssecurity.consumeX509Errata10Token property set to false in bindings. Consumption will not take place and message will likely not be processed.");
                        }
                        bl5 = false;
                    }
                    if (!NamespaceUtil.equals((QName)object, com.ibm.ws.wssecurity.common.Constants.X509V3_OLD) || !NamespaceUtil.equals(qName, com.ibm.ws.wssecurity.common.Constants.X509V3) || !bl5) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added a config for [" + object + "], which will consume Errata token[" + qName + "]");
                    }
                    hashSet.add(tokenConsumerConfig2);
                    continue;
                }
                if (bl6) {
                    if (!com.ibm.ws.wssecurity.common.Constants.SCT.equals(object)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding a config for [" + object + "].");
                    }
                    hashSet.add(tokenConsumerConfig2);
                    break;
                }
                if (bl7) {
                    if (!com.ibm.ws.wssecurity.common.Constants.SCT.equals(object)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding a config for [" + object + "].");
                    }
                    hashSet.add(tokenConsumerConfig2);
                    continue;
                }
                QName qName3 = new QName(oMElement3.getNamespace() == null ? null : oMElement3.getNamespace().getNamespaceURI(), oMElement3.getLocalName());
                if (!((QName)object).equals(qName3)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added a config for [" + object + "].");
                }
                hashSet.add(tokenConsumerConfig2);
            }
        }
        if (hashSet.isEmpty()) {
            if (Axis2Util.getMustUnderstand(map)) {
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(oMElement3));
            }
            Tr.debug(tc, ConfigUtil.getMessage("security.wssecurity.WSSConsumer.s03", new String[]{DOMUtils.getQualifiedName(oMElement3)}));
            Tr.debug(tc, "mustUnderstand=0.  Ignoring unexpected element.");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, hashSet.size() + " TokenConsumerConfig candidates found.");
            }
            map.remove(Constants.WSSECURITY_KEYINFO_TYPE);
            boolean bl13 = false;
            Exception[] exceptionArray = new Exception[hashSet.size()];
            n2 = 0;
            SoapSecurityException soapSecurityException = null;
            if (hashSet.size() > 1 && !bl3) {
                ((HashMap)serializable).put(string3, oMElement3);
                hashMap.put(string3, oMElement2);
                if (bl) {
                    hashMap2.put(string3, com.ibm.ws.wssecurity.common.Constants.USERNAME_TOKEN_TYPE);
                } else if (bl2) {
                    hashMap2.put(string3, com.ibm.ws.wssecurity.common.Constants.BINARY_TOKEN_TYPE);
                    hashMap3.put(string3, bl4);
                } else {
                    hashMap2.put(string3, com.ibm.ws.wssecurity.common.Constants.UNDETERMINED_TOKEN_TYPE);
                }
                bl13 = true;
            }
            if (hashSet.size() == 1 || bl3) {
                for (TokenConsumerConfig tokenConsumerConfig2 : hashSet) {
                    Serializable serializable2;
                    Object object2;
                    Object object3;
                    try {
                        WSSConsumer.callTokenConsumer(tokenConsumerConfig2, oMElement3, map);
                        final SecurityTokenWrapper securityTokenWrapper = securityTokenManagerImpl.getUnprocessedTokenWrapper();
                        if (securityTokenWrapper != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Unprocessed token [" + securityTokenWrapper + "] found.");
                            }
                            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    securityTokenWrapper.setProcessed(true);
                                    return null;
                                }
                            });
                            if (collection != null) {
                                WSSConsumer.checkCaller(collection, tokenConsumerConfig2, securityTokenWrapper, securityTokenManagerImpl, map);
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "All tokens are processed.");
                            }
                            if (collection != null) {
                                WSSConsumer.checkCaller(collection, tokenConsumerConfig2, securityTokenManagerImpl, map);
                            }
                        }
                        bl13 = true;
                        if (bl2 && bl4.booleanValue()) {
                            object3 = (String)tokenConsumerConfig2.getProperties().get("com.ibm.ws.wssecurity.consumeX509Errata10Token");
                            bl5 = true;
                            if (object3 != null && ((String)object3).equals("false")) {
                                bl5 = false;
                            }
                            if (bl5) {
                                object2 = (MessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                serializable2 = null;
                                serializable2 = (HashMap)((MessageContext)object2).getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                                if (serializable2 == null) {
                                    serializable2 = new HashMap();
                                }
                                HashMap<String, Boolean> hashMap4 = null;
                                hashMap4 = (HashMap<String, Boolean>)((MessageContext)object2).getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                                if (hashMap4 == null) {
                                    hashMap4 = new HashMap<String, Boolean>();
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Copying useErrata boolean to message context");
                                }
                                ((HashMap)serializable2).put("com.ibm.ws.wssecurity.consumeX509Errata10Token".toString(), bl4);
                                ((MessageContext)object2).setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", serializable2);
                                hashMap4.put("com.ibm.ws.wssecurity.consumeX509Errata10Token".toString(), bl4);
                                ((MessageContext)object2).setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", hashMap4);
                            }
                        }
                        if (bl8 || bl9) continue;
                        break;
                    }
                    catch (Exception exception) {
                        exceptionArray[n2++] = exception;
                        soapSecurityException = exception instanceof SoapSecurityException ? (SoapSecurityException)exception : SoapSecurityException.format("security.wssecurity.WSSConsumer.s34", new String[]{exception.getMessage()}, (Throwable)exception);
                        object3 = map.remove(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING);
                        if (object3 == null || !(object3 instanceof SecurityToken)) continue;
                        object2 = (SecurityToken)object3;
                        if (!bl8 && !bl9) {
                            securityTokenManagerImpl.removeToken((SecurityToken)object2);
                            continue;
                        }
                        serializable2 = new SecurityTokenWrapper((SecurityToken)object2);
                        ((SecurityTokenWrapper)serializable2).setUsedTokenConsumer(tokenConsumerConfig2.hashCode(), tokenConsumerConfig2.getClass().getName().hashCode());
                        ((SecurityTokenWrapper)serializable2).setKeyInfoType(null);
                        ((SecurityTokenWrapper)serializable2).setError(soapSecurityException);
                        ((SecurityTokenWrapper)serializable2).setProcessed(true);
                        securityTokenManagerImpl.addTokenWrapper((SecurityTokenWrapper)serializable2);
                    }
                }
            }
            if (!bl13) {
                if (hashSet.size() == 1) {
                    throw soapSecurityException;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, n2 + " exceptions were catched.");
                    for (int i = 0; i < n2; ++i) {
                        Tr.debug(tc, "No." + i + "'s exception: " + exceptionArray[i]);
                    }
                }
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s13", exceptionArray[n2 - 1]);
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("callTokenConsumer(");
            stringBuffer.append("Set, Set, OMElement, OMElement, OMElement, SecurityTokenManagerImpl, ");
            stringBuffer.append("Map, boolean, boolean, int, boolean)");
            Tr.exit(tc, stringBuffer.toString());
        }
    }

    private static void callTokenConsumer(TokenConsumerConfig tokenConsumerConfig, OMElement oMElement, Map<Object, Object> map) throws SoapSecurityException {
        TokenConsumerComponent tokenConsumerComponent;
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("callTokenConsumer(");
            ((StringBuffer)object).append("TokenConsumerConfig config, ");
            ((StringBuffer)object).append("OMElement target[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)object).append("Map context)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        if ((tokenConsumerComponent = ((PrivateConsumerConfig.TokenConsumerConfImpl)(object = (PrivateConsumerConfig.TokenConsumerConfImpl)tokenConsumerConfig)).getInstance()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to get the TokenConsumer object: [" + tokenConsumerConfig + "].");
            }
        } else {
            map.put("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey", tokenConsumerConfig);
            tokenConsumerComponent.invoke(oMElement, map);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("callTokenConsumer(");
            stringBuffer.append("TokenConsumerConfig, OMElement, Map)");
            Tr.exit(tc, stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callSignatureConsumer(Collection<SignatureConsumerConfig> collection, Map<Object, Object> map, OMElement oMElement, boolean bl, Map<Object, Object> map2, OMElement oMElement2) throws SoapSecurityException {
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("callSignatureConsumer(");
            ((StringBuffer)charSequence).append("Collection sconfig, Map selectors, ");
            ((StringBuffer)charSequence).append("OMElement target[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)charSequence).append("boolean copiedDOMTree[").append(bl).append("], ");
            ((StringBuffer)charSequence).append("Map context)");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        if (collection.size() <= 0) {
            if (Axis2Util.getMustUnderstand(map2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "An XML Digital signature was found in the security header, but there is no inbound signature configuration.");
                }
                charSequence = "WSWS3173E: Error: Did not understand \"MustUnderstand\" header(s): " + DOMUtils.getDisplayName(oMElement2, false);
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s16", (String)charSequence);
            }
        } else {
            boolean bl2 = false;
            Exception[] exceptionArray = new Exception[collection.size()];
            int n = 0;
            WSSConsumer.lockResults(map2, true, true);
            SignatureConsumerConfig signatureConsumerConfig2 = null;
            for (SignatureConsumerConfig signatureConsumerConfig2 : collection) {
                try {
                    WSSConsumer.callSignatureConsumer(signatureConsumerConfig2, map, oMElement, bl, map2);
                    bl2 = true;
                    break;
                }
                catch (Exception exception) {
                    exceptionArray[n++] = exception;
                }
                finally {
                    WSSConsumer.removeKeyInfoResults(map2);
                    if (bl2) continue;
                    WSSConsumer.restoreResults(map2, true);
                }
            }
            if (!bl2) {
                if (collection.size() == 1) {
                    if (exceptionArray[0] instanceof SoapSecurityException) {
                        throw (SoapSecurityException)exceptionArray[0];
                    }
                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s15", exceptionArray[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, n + " exceptions were catched.");
                    for (int i = 0; i < n; ++i) {
                        Tr.debug(tc, "No." + i + "'s exception: " + exceptionArray[i]);
                    }
                }
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s11", exceptionArray[n - 1]);
            }
            WSSConsumer.lockResults(map2, true, false);
        }
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("callSignatureConsumer(");
            ((StringBuffer)charSequence).append("Set, Map, OMElement, boolean, Map)");
            Tr.exit(tc, ((StringBuffer)charSequence).toString());
        }
    }

    private static void callSignatureConsumer(SignatureConsumerConfig signatureConsumerConfig, Map<Object, Object> map, OMElement oMElement, boolean bl, Map<Object, Object> map2) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("callSignatureConsumer(");
            ((StringBuffer)object).append("SignatureConsumerConfig config, Map properties, ");
            ((StringBuffer)object).append("OMElement target[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)object).append("boolean copiedDOMTree[").append(bl).append("], ");
            ((StringBuffer)object).append("Map context)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = (SignatureConsumer)map.get(SignatureConsumer.class);
        map2.put("com.ibm.ws.wssecurity.impl.config.signatureConsumer.configKey", signatureConsumerConfig);
        if (bl) {
            map2.put("com.ibm.ws.wssecurity.constants.copiedDOMTree", "true");
        } else {
            map2.remove("com.ibm.ws.wssecurity.constants.copiedDOMTree");
        }
        ((SignatureConsumer)object).invoke(oMElement, map2);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("callSignatureConsumer(");
            stringBuffer.append("SignatureConsumerConfig, Map, OMElement, boolean, Map)");
            Tr.exit(tc, stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callEncryptionConsumer(Collection<EncryptionConsumerConfig> collection, Map<Object, Object> map, OMElement oMElement, Map<Object, Object> map2, OMElement oMElement2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("callEncryptionConsumer(");
            stringBuffer.append("Collection econfig, Map selectors, ");
            stringBuffer.append("OMElement target[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            stringBuffer.append("Map context)");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        Exception[] exceptionArray = new Exception[collection.size()];
        int n = 0;
        if (collection.size() <= 0) {
            if (Axis2Util.getMustUnderstand(map2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Encryption information was found in the security header, but there is no inbound encryption configuration.");
                }
                String string = "WSWS3173E: Error: Did not understand \"MustUnderstand\" header(s): " + DOMUtils.getDisplayName(oMElement2, false);
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s16", string);
            }
        } else {
            WSSConsumer.lockResults(map2, false, true);
            Object object2 = null;
            for (EncryptionConsumerConfig encryptionConsumerConfig : collection) {
                try {
                    WSSConsumer.callEncryptionConsumer(encryptionConsumerConfig, map, oMElement, map2);
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    exceptionArray[n++] = exception;
                }
                finally {
                    WSSConsumer.removeKeyInfoResults(map2);
                    if (bl) continue;
                    WSSConsumer.restoreResults(map2, false);
                }
            }
            if (!bl) {
                if (collection.size() == 1) {
                    if (exceptionArray[0] instanceof SoapSecurityException) {
                        throw (SoapSecurityException)exceptionArray[0];
                    }
                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s16", exceptionArray[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, n + " exceptions were catched.");
                    for (int i = 0; i < n; ++i) {
                        Tr.debug(tc, "No." + i + "'s exception: " + exceptionArray[i]);
                    }
                }
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s12", exceptionArray[n - 1]);
            }
            WSSConsumer.lockResults(map2, false, false);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("callEncryptionConsumer(");
            stringBuffer.append("Set, Map, OMElement, Map)");
            Tr.exit(tc, stringBuffer.toString());
        }
    }

    private static void callEncryptionConsumer(EncryptionConsumerConfig encryptionConsumerConfig, Map<Object, Object> map, OMElement oMElement, Map<Object, Object> map2) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("callEncryptionConsumer(");
            ((StringBuffer)object).append("EncryptionConsumerConfig config, Map selectors, ");
            ((StringBuffer)object).append("OMElement target[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)object).append("Map context)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = (EncryptionConsumer)map.get(EncryptionConsumer.class);
        map2.put("com.ibm.ws.wssecurity.impl.config.encryptionConsumer.configKey", encryptionConsumerConfig);
        ((EncryptionConsumer)object).invoke(oMElement, map2);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("callEncryptionConsumer(");
            stringBuffer.append("EncryptionConsumerConfig, Map, OMElement, Map)");
            Tr.exit(tc, stringBuffer.toString());
        }
    }

    private static void checkRequiredIntegrity(OMDocument oMDocument, Map<Object, Object> map, Map<Object, Object> map2) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("checkRequiredIntegrity(");
            ((StringBuffer)object).append("OMDocument doc[").append(DOMUtils.getDisplayName(oMDocument)).append("], ");
            ((StringBuffer)object).append("Map selectors, Map context)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = (WSSConsumerComponent)map.get(VerifiedPartChecker.class);
        object.invoke(oMDocument.getOMDocumentElement(), map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRequiredIntegrity(OMDocument, Map, Map)");
        }
    }

    private static void checkRequiredConfidentiality(OMDocument oMDocument, Map<Object, Object> map, Map<Object, Object> map2) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("checkRequiredConfidentiality(");
            ((StringBuffer)object).append("OMDocument doc[").append(DOMUtils.getDisplayName(oMDocument)).append("], ");
            ((StringBuffer)object).append("Map selectors, Map context)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = (WSSConsumerComponent)map.get(DecryptedPartChecker.class);
        object.invoke(oMDocument.getOMDocumentElement(), map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRequiredConfidentiality(OMDocument, Map, Map)");
        }
    }

    private static void checkRequiredSecurityToken(Collection<TokenConsumerConfig> collection, Collection<CallerConfig> collection2, SecurityTokenManagerImpl securityTokenManagerImpl) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("checkRequiredSecurityToken(");
            ((StringBuffer)object).append("Collection tokens, Collection callers, ");
            ((StringBuffer)object).append("SecurityTokenManagerImpl securityTokenManager)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = securityTokenManagerImpl.getTokens();
        if (tc.isDebugEnabled()) {
            if (object == null) {
                Tr.debug(tc, "The subject has no Token object.");
            } else {
                Tr.debug(tc, object.size() + " tokens found in the subject.");
            }
        }
        boolean bl = false;
        for (TokenConsumerConfig tokenConsumerConfig : collection) {
            bl = false;
            QName qName = tokenConsumerConfig.getType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking the value type [" + qName + "]...");
            }
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    SecurityToken securityToken = (SecurityToken)iterator.next();
                    QName qName2 = securityToken.getValueType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Comparing with the value type of the Token [" + qName2 + "]...");
                    }
                    if (!qName.equals(qName2)) continue;
                    bl = true;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "A corresponding token found.");
                    break;
                }
            }
            if (bl) continue;
            throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.FAILED_CHECK, "security.wssecurity.WSSConsumer.s14", tokenConsumerConfig.getType().toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRequiredSecurityToken(Set, Set, SecurityTokenManagerImpl)");
        }
    }

    private static void checkRequiredTimestamp(OMDocument oMDocument, TimestampConsumerConfig timestampConsumerConfig, Map<Object, Object> map, Map<Object, Object> map2) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("checkRequiredTimestamp(");
            ((StringBuffer)object).append("OMDocument doc[").append(DOMUtils.getDisplayName(oMDocument)).append("], ");
            ((StringBuffer)object).append("TimestampConsumerConfig config, Map selectors, Map context)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = (WSSConsumerComponent)map.get(TimestampChecker.class);
        map2.put("com.ibm.ws.wssecurity.impl.config.timestampConsumer.configKey", timestampConsumerConfig);
        object.invoke(oMDocument.getOMDocumentElement(), map2);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("callEncryptionConsumer(");
            stringBuffer.append("OMDocument, TimestampConsumerConfig, Map, Map)");
            Tr.exit(tc, stringBuffer.toString());
        }
    }

    private static void checkCaller(Collection<CallerConfig> collection, TokenConsumerConfig tokenConsumerConfig, SecurityTokenManagerImpl securityTokenManagerImpl, Map<Object, Object> map) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("checkCaller(");
            ((StringBuffer)object).append("Collection cconfigs, TokenConsumerConfig tconfig, ");
            ((StringBuffer)object).append("SecurityTokenManagerImpl securityTokenManager, Map context)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        if (tokenConsumerConfig != null && collection != null && (object = securityTokenManagerImpl.getTokens()).size() > 0) {
            QName qName = tokenConsumerConfig.getType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, object.size() + " tokens found.");
                Tr.debug(tc, collection.size() + " CallerConfigs found, so start to process it...");
                Tr.debug(tc, "The value type of the token consumer configuration: " + qName);
            }
            for (CallerConfig callerConfig : collection) {
                boolean bl;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing a CallerConfig [" + callerConfig + "]...");
                }
                QName qName2 = callerConfig.getCallerIdentity();
                QName qName3 = callerConfig.getTrustedIdentity();
                ReferencePartConfig referencePartConfig = callerConfig.getRequiredSigningPartReference();
                boolean bl2 = qName2 != null && qName2.equals(qName) && (referencePartConfig == null || qName3 != null);
                boolean bl3 = bl = qName3 != null && qName3.equals(qName) && referencePartConfig == null;
                if (!bl2 && !bl) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    SecurityToken securityToken = (SecurityToken)iterator.next();
                    QName qName4 = securityToken.getValueType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The value type of the token: " + qName4);
                    }
                    if (bl2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking the caller identity [" + qName2 + "]...");
                        }
                        if (qName2.equals(qName4)) {
                            bl4 = true;
                        }
                    }
                    if (bl) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking the trusted identity [" + qName3 + "]...");
                        }
                        if (qName3.equals(qName4)) {
                            bl5 = true;
                        }
                    }
                    if (!bl4 && !bl5) continue;
                    SecurityTokenWrapper securityTokenWrapper = securityTokenManagerImpl.getTokenWrapper(securityToken);
                    AuthResult authResult = new AuthResult(securityTokenWrapper, callerConfig, bl4, bl5);
                    ResultPool.add(map, authResult);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added AuthResult[" + authResult + "] into the ResultPool.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("checkCaller(");
            ((StringBuffer)object).append("Set, TokenConsumerConfig, SecurityTokenManagerImpl, Map)");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
    }

    private static void checkCaller(Collection<CallerConfig> collection, TokenConsumerConfig tokenConsumerConfig, SecurityTokenWrapper securityTokenWrapper, SecurityTokenManagerImpl securityTokenManagerImpl, Map<Object, Object> map) {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("checkCaller(");
            ((StringBuffer)serializable).append("Collection cconfigs, TokenConsumerConfig tconfig, ");
            ((StringBuffer)serializable).append("SecurityTokenWrapper tokenWrapper[").append(securityTokenWrapper).append("], ");
            ((StringBuffer)serializable).append("SecurityTokenManagerImpl securityTokenManager, Map context)");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        if (tokenConsumerConfig != null && collection != null) {
            serializable = tokenConsumerConfig.getType();
            QName qName = securityTokenWrapper.getValueType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The value type of the token consumer configuration: " + serializable);
                Tr.debug(tc, "The value type of the token: " + qName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, collection.size() + " CallerConfigs found, so start to process it...");
            }
            for (CallerConfig callerConfig : collection) {
                boolean bl;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing a CallerConfig [" + callerConfig + "]...");
                }
                QName qName2 = callerConfig.getCallerIdentity();
                QName qName3 = callerConfig.getTrustedIdentity();
                ReferencePartConfig referencePartConfig = callerConfig.getRequiredSigningPartReference();
                boolean bl2 = qName2 != null && qName2.equals(serializable) && (referencePartConfig == null || qName3 != null);
                boolean bl3 = bl = qName3 != null && qName3.equals(serializable) && referencePartConfig == null;
                if (!bl2 && !bl) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                if (bl2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking the caller identity [" + qName2 + "]...");
                    }
                    if (qName2.equals(qName)) {
                        bl4 = true;
                    }
                }
                if (bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking the trusted identity [" + qName3 + "]...");
                    }
                    if (qName3.equals(qName)) {
                        bl5 = true;
                    }
                }
                if (!bl4 && !bl5) continue;
                AuthResult authResult = new AuthResult(securityTokenWrapper, callerConfig, bl4, bl5);
                ResultPool.add(map, authResult);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Added AuthResult[" + authResult + "] into the ResultPool.");
            }
        }
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("checkCaller(");
            ((StringBuffer)serializable).append("Set, TokenConsumerConfig, SecurityTokenWrapper, ");
            ((StringBuffer)serializable).append("SecurityTokenManagerImpl, Map)");
            Tr.exit(tc, ((StringBuffer)serializable).toString());
        }
    }

    private static void checkCaller(Map<Object, Object> map, Map<Object, Object> map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCaller(Map selectors, Map context)");
        }
        WSSConsumerComponent wSSConsumerComponent = null;
        wSSConsumerComponent = (WSSConsumerComponent)map.get(LoginProcessor.class);
        wSSConsumerComponent.invoke(null, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCaller(Map, Map)");
        }
    }

    private static void cleanSubject(SecurityTokenManagerImpl securityTokenManagerImpl, Map<Object, Object> map) throws SoapSecurityException {
        Collection<SecurityTokenWrapper> collection;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanSubject(Map context)");
        }
        if ((collection = securityTokenManagerImpl.getTokenWrappers()) != null && collection.size() > 0) {
            String string;
            Object object;
            int n;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            Result[] resultArray = ResultPool.get(map, VerificationResult.class);
            if (resultArray != null) {
                for (n = 0; n < resultArray.length; ++n) {
                    VerificationResult object22 = (VerificationResult)resultArray[n];
                    object = object22.getTokenWrapper();
                    if (object == null) continue;
                    string = ((SecurityTokenWrapper)object).getId();
                    if (hashMap.containsKey(string)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "WARNING: The token that has the same unique id [" + string + "] exists.");
                        Tr.debug(tc, "The already stored token is [" + hashMap.get(string) + "] and this is keeped.");
                        Tr.debug(tc, "A newly found token is [" + object + "] and this is ignored.");
                        continue;
                    }
                    hashMap.put(string, object);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "The token whose unique id is [" + string + "]: <<<" + object + ">>>.");
                }
            }
            if ((resultArray = ResultPool.get(map, DecryptionResult.class)) != null) {
                for (n = 0; n < resultArray.length; ++n) {
                    DecryptionResult decryptionResult = (DecryptionResult)resultArray[n];
                    object = decryptionResult.getTokenWrapper();
                    if (object == null) continue;
                    string = ((SecurityTokenWrapper)object).getId();
                    if (hashMap.containsKey(string)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "WARNING: The token that has the same unique id [" + string + "] exists.");
                        Tr.debug(tc, "The already stored token is [" + hashMap.get(string) + "] and this is keeped.");
                        Tr.debug(tc, "A newly found token is [" + object + "] and this is ignored.");
                        continue;
                    }
                    hashMap.put(string, object);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "The token whose unique id is [" + string + "]: <<<" + object + ">>>.");
                }
            }
            for (SecurityTokenWrapper securityTokenWrapper : collection) {
                if (securityTokenWrapper.getError() != null || hashMap.containsKey(object = securityTokenWrapper.getId())) continue;
                hashMap.put(object, securityTokenWrapper);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "The token whose unique id is [" + (String)object + "]: <<<" + securityTokenWrapper + ">>>.");
            }
            securityTokenManagerImpl.removeAllTokens();
            if (hashMap.size() > 0) {
                securityTokenManagerImpl.addTokenWrappers(hashMap.values());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanSubject(Map context)");
        }
    }

    private static void mapTokenToMessageContext(MessageContext messageContext, SecurityTokenManagerImpl securityTokenManagerImpl, Map<Object, Object> map) throws SoapSecurityException {
        block21: {
            SecurityToken securityToken;
            block24: {
                Result[] resultArray;
                block23: {
                    SecurityTokenWrapper securityTokenWrapper;
                    SecurityToken securityToken2;
                    Object object;
                    block22: {
                        boolean bl;
                        if (tc.isEntryEnabled()) {
                            StringBuffer stringBuffer = new StringBuffer("mapTokenToMessageContext(");
                            stringBuffer.append("MessageContext messageContext, ");
                            stringBuffer.append("SecurityTokenManagerImpl securityTokenManager, Map context)");
                            Tr.entry(tc, stringBuffer.toString());
                        }
                        int n = 0;
                        Collection<SecurityToken> collection = securityTokenManagerImpl.getTokens();
                        if (collection != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, collection.size() + " tokens found.");
                            }
                            if (collection.size() > 0) {
                                Hashtable<String, SecurityToken> hashtable = new Hashtable<String, SecurityToken>();
                                resultArray = collection.iterator();
                                while (resultArray.hasNext()) {
                                    securityToken = (SecurityToken)resultArray.next();
                                    object = securityToken.getId();
                                    if (object == null) {
                                        object = IdUtils.getInstance().makeUniqueId("Token_") + "_" + ++n;
                                    }
                                    hashtable.put((String)object, securityToken);
                                }
                                messageContext.setProperty(Constants.WSSECURITY_TOKEN_PROPERGATION, hashtable);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "A table of tokens is copied to the property in the MessageContext.");
                                }
                            }
                        }
                        if (!(bl = Axis2Util.isServiceProvider(messageContext))) break block21;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "This is server process. So the runtime is storing a signer certificate...");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking verification results...");
                        }
                        if ((resultArray = ResultPool.get(map, VerificationResult.class)) != null && resultArray.length != 0) break block22;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No signer X509 certificate was found in the request message.");
                        }
                        break block21;
                    }
                    securityToken = null;
                    if (resultArray.length != 1) break block23;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Only one verification token found.");
                    }
                    if (!((securityToken2 = (securityTokenWrapper = ((VerificationResult)(object = (VerificationResult)resultArray[0])).getTokenWrapper()).getSecurityToken()) instanceof X509Token)) break block24;
                    securityToken = (X509Token)securityToken2;
                    break block24;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "More than one verification tokens found.");
                }
                for (int i = 0; i < resultArray.length; ++i) {
                    VerificationResult verificationResult = (VerificationResult)resultArray[i];
                    SecurityTokenWrapper securityTokenWrapper = verificationResult.getTokenWrapper();
                    SecurityToken securityToken3 = securityTokenWrapper.getSecurityToken();
                    if (!(securityToken3 instanceof X509Token) || !securityTokenWrapper.isUsedToLogin()) continue;
                    securityToken = (X509Token)securityToken3;
                    break;
                }
            }
            if (securityToken == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to specify the one of X509 certificates in the request message.");
                }
            } else {
                X509Certificate x509Certificate;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The X509 token that includes a signer certificate [" + securityToken + "].");
                }
                if ((x509Certificate = securityToken.getCertificate()) == null) {
                    Tr.warning(tc, "security.wssecurity.WSSConsumer.s33");
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Signer certificate is stored in the message context [" + x509Certificate + "].");
                    }
                    messageContext.setProperty("com.ibm.xml.soapsec.RequestCert", x509Certificate);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapTokenToMessageContext(MessageContext, Map)");
        }
    }

    private static void copyContextSubjectToMessageContext(MessageContext messageContext, Map<Object, Object> map) {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("copyContextSubjectToMessageContext(");
            ((StringBuffer)serializable).append("MessageContext messageContext, Map context)");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        messageContext.setProperty(Constants.WSSECURITY_TOKEN_WSSSUBJECT, serializable);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyContextSubjectToMessageContext(MessageContext, Map)");
        }
    }

    private static void lockResults(Map<Object, Object> map, boolean bl, boolean bl2) {
        Result[] resultArray;
        if (tc.isEntryEnabled()) {
            resultArray = new StringBuffer("lockResults(");
            resultArray.append("Map context, ");
            resultArray.append("boolean signature[").append(bl).append("], ");
            resultArray.append("boolean locked[").append(bl2).append("])");
            Tr.entry(tc, resultArray.toString());
        }
        if (bl) {
            resultArray = ResultPool.get(map, VerificationResult.class);
            if (resultArray != null && resultArray.length > 0) {
                for (int i = 0; i < resultArray.length; ++i) {
                    VerificationResult verificationResult = (VerificationResult)resultArray[i];
                    verificationResult.setLocked(bl2);
                }
            }
        } else {
            resultArray = ResultPool.get(map, DecryptionResult.class);
            if (resultArray != null && resultArray.length > 0) {
                for (int i = 0; i < resultArray.length; ++i) {
                    DecryptionResult decryptionResult = (DecryptionResult)resultArray[i];
                    decryptionResult.setLocked(bl2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lockResults(Map, boolean, boolean)");
        }
    }

    private static void removeKeyInfoResults(Map<Object, Object> map) {
        Result[] resultArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeKeyInfoResults(Map context)");
        }
        if ((resultArray = ResultPool.get(map, KeyInfoResult.class)) != null && resultArray.length > 0) {
            ResultPool.remove(map, resultArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeKeyInfoResults(Map context)");
        }
    }

    private static void restoreResults(Map<Object, Object> map, boolean bl) {
        Result[] resultArray;
        if (tc.isEntryEnabled()) {
            resultArray = new StringBuffer("restoreResults(");
            resultArray.append("Map context, ");
            resultArray.append("boolean signature[").append(bl).append("])");
            Tr.entry(tc, resultArray.toString());
        }
        if (bl) {
            VerificationResult verificationResult;
            resultArray = ResultPool.get(map, VerificationResult.class);
            if (resultArray != null && resultArray.length > 0 && !(verificationResult = (VerificationResult)resultArray[resultArray.length - 1]).getLocked()) {
                List<VerificationResult.VerifiedPart> list;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Restoring a verification result [" + verificationResult + "]...");
                }
                if ((list = verificationResult.getVerifiedParts()) != null) {
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        VerificationResult.VerifiedPart verifiedPart = list.get(i);
                        if (verifiedPart.getNonce() == null && verifiedPart.getTimestamp() == null) continue;
                        if (verifiedPart.getNonceFirst()) {
                            verifiedPart.getParent().addChild(verifiedPart.getNonce());
                            if (tc.isDebugEnabled()) {
                                if (verifiedPart.getParent() instanceof OMElement) {
                                    Tr.debug(tc, "Nonce is restored into the node[" + DOMUtils.getDisplayName((OMElement)verifiedPart.getParent()) + "].");
                                } else {
                                    Tr.debug(tc, "Nonce is restored into the node[" + verifiedPart.getParent() + "].");
                                }
                            }
                            if (verifiedPart.getNonce() == null) continue;
                            verifiedPart.getParent().addChild(verifiedPart.getTimestamp());
                            if (!tc.isDebugEnabled()) continue;
                            if (verifiedPart.getParent() instanceof OMElement) {
                                Tr.debug(tc, "Timestmap is restored into the node[" + DOMUtils.getDisplayName((OMElement)verifiedPart.getParent()) + "].");
                                continue;
                            }
                            Tr.debug(tc, "Timestmap is restored into the node[" + verifiedPart.getParent() + "].");
                            continue;
                        }
                        verifiedPart.getParent().addChild(verifiedPart.getTimestamp());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Timestamp is restored into the node[" + DOMUtils.getDisplayName((OMNode)((Object)verifiedPart.getParent())) + "].");
                        }
                        if (verifiedPart.getNonce() == null) continue;
                        verifiedPart.getParent().addChild(verifiedPart.getNonce());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Nonce is restored into the node[" + DOMUtils.getDisplayName((OMNode)((Object)verifiedPart.getParent())) + "].");
                    }
                }
                ResultPool.remove(map, verificationResult);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removed the verification result.");
                }
            }
        } else {
            DecryptionResult decryptionResult;
            resultArray = ResultPool.get(map, DecryptionResult.class);
            if (resultArray != null && resultArray.length > 0 && !(decryptionResult = (DecryptionResult)resultArray[resultArray.length - 1]).getLocked()) {
                List<DecryptionResult.DecryptedPart> list;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Restoring a decryption result [" + decryptionResult + "]...");
                }
                if ((list = decryptionResult.getDecryptedParts()) != null) {
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        DecryptionResult.DecryptedPart decryptedPart = list.get(i);
                        if (decryptedPart.getNonce() == null && decryptedPart.getTimestamp() == null) continue;
                        if (decryptedPart.getNonceFirst()) {
                            decryptedPart.getParent().addChild(decryptedPart.getNonce());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Nonce is restored into the node[" + DOMUtils.getDisplayName((OMNode)((Object)decryptedPart.getParent())) + "].");
                            }
                            if (decryptedPart.getNonce() == null) continue;
                            decryptedPart.getParent().addChild(decryptedPart.getTimestamp());
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Timestmap is restored into the node[" + DOMUtils.getDisplayName((OMNode)((Object)decryptedPart.getParent())) + "].");
                            continue;
                        }
                        decryptedPart.getParent().addChild(decryptedPart.getTimestamp());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Timestamp is restored into the node[" + DOMUtils.getDisplayName((OMNode)((Object)decryptedPart.getParent())) + "].");
                        }
                        if (decryptedPart.getNonce() == null) continue;
                        decryptedPart.getParent().addChild(decryptedPart.getNonce());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Nonce is restored into the node[" + DOMUtils.getDisplayName((OMNode)((Object)decryptedPart.getParent())) + "].");
                    }
                }
                ResultPool.remove(map, decryptionResult);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removed the decryption result.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreResults(Map, boolean)");
        }
    }

    private static int getUsedFor(OMElement oMElement, OMElement oMElement2, String string, String string2) {
        Serializable serializable;
        int n;
        block10: {
            block11: {
                if (tc.isEntryEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("getUsedFor(");
                    stringBuffer.append("OMElement envelope[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
                    stringBuffer.append("OMElement security[").append(DOMUtils.getDisplayName(oMElement2)).append("], ");
                    stringBuffer.append("String nsWsse[").append(string).append("], ");
                    stringBuffer.append("String id[").append(string2).append("])");
                    Tr.entry(tc, stringBuffer.toString());
                }
                n = 0;
                if (string2 == null || string2.length() <= 0) break block10;
                string2 = "#" + string2;
                serializable = DOMUtils.getElementsByTagNameNS(oMElement2, string, "Reference");
                if (serializable != null && ((ArrayList)serializable).size() != 0) break block11;
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "No wsse:Reference element found.");
                break block10;
            }
            int n2 = ((ArrayList)serializable).size();
            if (tc.isDebugEnabled()) {
                if (n2 == 1) {
                    Tr.debug(tc, n2 + " wsse:Reference element found.");
                } else {
                    Tr.debug(tc, n2 + " wsse:Reference elements found.");
                }
            }
            for (int i = 0; i < n2; ++i) {
                OMContainer oMContainer;
                OMElement oMElement3;
                OMElement oMElement4 = (OMElement)((ArrayList)serializable).get(i);
                String string3 = oMElement4.getAttributeValue(URI_Q);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing URI [" + string3 + "]...");
                }
                if (!string2.equals(string3) || !DOMUtils.equals(oMElement3 = DOMUtils.getAncestorElement(oMElement4, string, "Security"), oMElement2)) continue;
                OMElement oMElement5 = DOMUtils.getAncestorElement(oMElement4, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "KeyInfo");
                if (oMElement5 == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "ds:KeyInfo is not found as an ancestor.");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ds:KeyInfo is found as an ancestor.");
                }
                if ((oMContainer = oMElement5.getParent()) == null || !(oMContainer instanceof OMElement)) continue;
                if (DOMUtils.equals((OMElement)oMContainer, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "Signature")) {
                    n = 1;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "The token is used for signature verification.");
                    break;
                }
                if (!DOMUtils.equals((OMElement)oMContainer, com.ibm.ws.wssecurity.common.Constants.NS_ENC, "EncryptedKey") && !DOMUtils.equals((OMElement)oMContainer, com.ibm.ws.wssecurity.common.Constants.NS_ENC, "EncryptedData")) continue;
                n = 2;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "The token is used for decryption.");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getUsedFor(");
            ((StringBuffer)serializable).append("OMElement, OMElement, String, String)");
            ((StringBuffer)serializable).append(" returns int [").append(n).append("]");
            Tr.exit(tc, ((StringBuffer)serializable).toString());
        }
        return n;
    }

    public void mapSignedPartsToMessageContext(MessageContext messageContext, Map<Object, Object> map) {
        Result[] resultArray;
        if (tc.isEntryEnabled()) {
            resultArray = new StringBuffer("mapSignedPartsToMessageContext(");
            resultArray.append("MessageContext messageContext, Map context)");
            Tr.entry(tc, resultArray.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking verification results...");
        }
        resultArray = ResultPool.get(map, VerificationResult.class);
        ArrayList<OMElement> arrayList = new ArrayList<OMElement>();
        DerivedKeyToken derivedKeyToken = null;
        if (resultArray == null || resultArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No verification results were found.");
            }
        } else {
            if (resultArray.length == 1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "Only one VerificationResult object found.");
            }
            for (int i = 0; i < resultArray.length; ++i) {
                VerificationResult verificationResult = (VerificationResult)resultArray[i];
                SecurityTokenWrapper securityTokenWrapper = verificationResult.getTokenWrapper();
                SecurityToken securityToken = securityTokenWrapper.getSecurityToken();
                if (!(securityToken instanceof DerivedKeyToken)) continue;
                derivedKeyToken = (DerivedKeyToken)securityToken;
                Iterator<VerificationResult.VerifiedPart> iterator = verificationResult.getVerifiedParts().iterator();
                VerificationResult.VerifiedPart verifiedPart = null;
                while (iterator.hasNext()) {
                    verifiedPart = iterator.next();
                    if (verifiedPart.getObject() == null) continue;
                    arrayList.add(verifiedPart.getObject());
                }
            }
            if (!arrayList.isEmpty()) {
                HashMap<String, ArrayList<OMElement>> hashMap = new HashMap<String, ArrayList<OMElement>>();
                hashMap.put(derivedKeyToken.getSecurityContextTokenTokenUUID(), arrayList);
                messageContext.setProperty("SIGNED_ELEMENTS_MAP", hashMap);
                messageContext.setProperty("SCT_USEDFOR_MS", derivedKeyToken.getSecurityContextTokenTokenUUID());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapSignedPartsToMessageContext(MessageContext, Map)");
        }
    }

    public void mapEncryptedPartsToMessageContext(MessageContext messageContext, Map<Object, Object> map) {
        Result[] resultArray;
        if (tc.isEntryEnabled()) {
            resultArray = new StringBuffer("mapEncryptedPartsToMessageContext(");
            resultArray.append("MessageContext messageContext, Map context)");
            Tr.entry(tc, resultArray.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking decryption results...");
        }
        resultArray = ResultPool.get(map, DecryptionResult.class);
        ArrayList<OMElement> arrayList = new ArrayList<OMElement>();
        DerivedKeyToken derivedKeyToken = null;
        if (resultArray == null || resultArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No decryption results were found.");
            }
        } else {
            if (resultArray.length == 1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "Only one DecryptionResult object found.");
            }
            for (int i = 0; i < resultArray.length; ++i) {
                DecryptionResult decryptionResult = (DecryptionResult)resultArray[i];
                SecurityTokenWrapper securityTokenWrapper = decryptionResult.getTokenWrapper();
                SecurityToken securityToken = securityTokenWrapper.getSecurityToken();
                if (!(securityToken instanceof DerivedKeyToken)) continue;
                derivedKeyToken = (DerivedKeyToken)securityToken;
                Iterator<DecryptionResult.DecryptedPart> iterator = decryptionResult.getDecryptedParts().iterator();
                DecryptionResult.DecryptedPart decryptedPart = null;
                while (iterator.hasNext()) {
                    decryptedPart = iterator.next();
                    if (decryptedPart.getObject() == null) continue;
                    arrayList.add(decryptedPart.getObject());
                }
            }
            if (!arrayList.isEmpty()) {
                HashMap<String, ArrayList<OMElement>> hashMap = new HashMap<String, ArrayList<OMElement>>();
                hashMap.put(derivedKeyToken.getSecurityContextTokenTokenUUID(), arrayList);
                messageContext.setProperty("DECRYPTED_ELEMENTS_MAP", hashMap);
                messageContext.setProperty("SCT_USEDFOR_MS", derivedKeyToken.getSecurityContextTokenTokenUUID());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapEncryptedPartsToMessageContext(MessageContext, Map)");
        }
    }
}

