/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestMessagePool {
    private static final TraceComponent tc = Tr.register(RequestMessagePool.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    private static void clear(Map<Object, Object> map) {
        StoredMessage storedMessage = (StoredMessage)map.get(RequestMessagePool.class);
        if (storedMessage == null) {
            return;
        }
        storedMessage.clear();
    }

    public static void addDocument(Map<Object, Object> map, OMDocument oMDocument, List<ArrayList<OMNode>> list, List<ArrayList<OMNode>> list2, boolean bl) {
        StoredMessage storedMessage;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDocument(Map context,OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "List list," + "List hlist," + "boolean cloneDoc[" + bl + "]");
        }
        if ((storedMessage = (StoredMessage)map.get(RequestMessagePool.class)) == null) {
            storedMessage = new StoredMessage();
            map.put(RequestMessagePool.class, storedMessage);
        }
        storedMessage.addDocument(oMDocument, list, list2, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDocument(Map context,OMDocument doc,List list,List hlist,boolean cloneDoc[" + bl + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addElement(Map<Object, Object> map, OMElement oMElement, OMElement oMElement2, OMElement oMElement3) {
        StoredMessage storedMessage;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addElement(Map context,OMElement objToBeEncrypted[" + DOMUtils.getDisplayName(oMElement) + "]," + "OMElement encryptedData[" + DOMUtils.getDisplayName(oMElement2) + "]," + "OMElement headerInfo[" + DOMUtils.getDisplayName(oMElement3) + "])");
        }
        if ((storedMessage = (StoredMessage)map.get(RequestMessagePool.class)) == null) {
            storedMessage = new StoredMessage();
            map.put(RequestMessagePool.class, storedMessage);
        }
        StoredMessage storedMessage2 = storedMessage;
        synchronized (storedMessage2) {
            storedMessage.addElement(oMElement, oMElement2, oMElement3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addElement(Map context,OMElement objToBeEncrypted,OMElement encryptedData,OMElement headerInfo)");
        }
    }

    public static OMDocument getDocument(Map<Object, Object> map, int n) {
        StoredMessage storedMessage;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDocument(Map context,int order[" + n + "])");
        }
        if ((storedMessage = (StoredMessage)map.get(RequestMessagePool.class)) == null) {
            storedMessage = new StoredMessage();
            map.put(RequestMessagePool.class, storedMessage);
        }
        OMDocument oMDocument = storedMessage.getDocument(n);
        if (tc.isEntryEnabled()) {
            OMElement oMElement = oMDocument == null ? null : oMDocument.getOMDocumentElement();
            Tr.exit(tc, "getDocument(Map context,int order) returns Document[" + DOMUtils.getDisplayName(oMElement) + "]");
        }
        return oMDocument;
    }

    public static EncryptedObject convertElement(Map<Object, Object> map, OMElement oMElement, int n) {
        StoredMessage storedMessage;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertElement(Map context,OMElement object[" + DOMUtils.getDisplayName(oMElement) + "]," + "int order[" + n + "])");
        }
        if ((storedMessage = (StoredMessage)map.get(RequestMessagePool.class)) == null) {
            storedMessage = new StoredMessage();
            map.put(RequestMessagePool.class, storedMessage);
        }
        EncryptedObject encryptedObject = storedMessage.convertElement(oMElement, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertElement(Map context,OMElement object,int order) returns EncryptedObject[" + encryptedObject + "]");
        }
        return encryptedObject;
    }

    public static void initialize(Map<Object, Object> map) {
        RequestMessagePool.clear(map);
    }

    public static void finalize(Map<Object, Object> map) {
        RequestMessagePool.clear(map);
        map.remove(RequestMessagePool.class);
    }

    public static class EncryptedObject {
        private OMElement _headerInfo;
        private OMElement _encryptedData;

        public OMElement getHeaderInfo() {
            return this._headerInfo;
        }

        public OMElement getEncryptedData() {
            return this._encryptedData;
        }

        public void setEncryptedData(OMElement oMElement) {
            this._encryptedData = oMElement;
        }

        public String toString() {
            return "Element headerInfo[" + DOMUtils.getDisplayName(this._headerInfo) + "]," + "Element encryptedData[" + DOMUtils.getDisplayName(this._encryptedData) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StoredMessage {
        private ArrayList<OMDocument> _messageList = new ArrayList();
        private ArrayList<Map<OMElement, OMElement>> _objectList = new ArrayList();
        private ArrayList<Map<OMElement, EncryptedObject>> _edataList = new ArrayList();

        private StoredMessage() {
        }

        private void clear() {
            this._messageList.clear();
            this._objectList.clear();
            this._edataList.clear();
        }

        private void addDocument(OMDocument oMDocument, List<ArrayList<OMNode>> list, List<ArrayList<OMNode>> list2, boolean bl) {
            OMDocument oMDocument2;
            HashMap<String, OMElement> hashMap = new HashMap<String, OMElement>();
            HashMap<OMElement, OMElement> hashMap2 = new HashMap<OMElement, OMElement>();
            if (bl) {
                long l = System.currentTimeMillis();
                String string = "Attr" + l;
                String string2 = "dummy_";
                int n = 0;
                n = this.addDummyAttributes(n, string, string2, list, hashMap);
                n = this.addDummyAttributes(n, string, string2, list2, hashMap);
                oMDocument2 = this.copyDocument(oMDocument);
                OMElement oMElement = oMDocument2.getOMDocumentElement();
                if (oMElement != null) {
                    this.putElement(oMElement, hashMap2, hashMap, string);
                }
                this.removeDummyAttributes(string, list);
                this.removeDummyAttributes(string, list2);
            } else {
                this.createObjectList(list, hashMap2);
                this.createObjectList(list2, hashMap2);
                oMDocument2 = oMDocument;
            }
            this._messageList.add(oMDocument2);
            this._objectList.add(hashMap2);
            this._edataList.add(new HashMap());
        }

        private void createObjectList(List<ArrayList<OMNode>> list, Map<OMElement, OMElement> map) {
            for (ArrayList<OMNode> arrayList : list) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    OMNode oMNode = arrayList.get(i);
                    if (oMNode.getType() == 1) {
                        OMElement oMElement = (OMElement)oMNode;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "list: el is of type " + oMElement.getClass().getName());
                        }
                        map.put(oMElement, oMElement);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Added element to be encrypted to Map: element = " + DOMUtils.getDisplayName(oMElement));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "list: node is of type " + oMNode.getClass().getName());
                }
            }
        }

        private int addDummyAttributes(int n, String string, String string2, List<ArrayList<OMNode>> list, Map<String, OMElement> map) {
            for (ArrayList<OMNode> arrayList : list) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    OMNode oMNode = arrayList.get(i);
                    if (oMNode.getType() == 1) {
                        OMElement oMElement = (OMElement)oMNode;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "list: el is of type " + oMElement.getClass().getName());
                        }
                        String string3 = string2 + n++;
                        oMElement.addAttribute(string, string3, null);
                        map.put(string3, oMElement);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Set attribute[" + string + "=" + string3 + "] to the element[" + DOMUtils.getDisplayName(oMElement) + "]");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "list: node is of type " + oMNode.getClass().getName());
                }
            }
            return n;
        }

        private void removeDummyAttributes(String string, List<ArrayList<OMNode>> list) {
            for (ArrayList<OMNode> arrayList : list) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    OMNode oMNode = arrayList.get(i);
                    if (oMNode.getType() != 1) continue;
                    OMElement oMElement = (OMElement)oMNode;
                    oMElement.removeAttribute(oMElement.getAttribute(new QName("", string)));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Removed attribute[" + string + "] from the element[" + DOMUtils.getDisplayName(oMElement) + "]");
                }
            }
        }

        private OMDocument copyDocument(OMDocument oMDocument) {
            OMFactory oMFactory = oMDocument.getOMDocumentElement().getOMFactory();
            OMDocument oMDocument2 = oMFactory.createOMDocument();
            OMElement oMElement = oMDocument.getOMDocumentElement();
            OMElement oMElement2 = oMFactory.createOMElement(oMElement.getLocalName(), oMElement.getNamespace());
            oMDocument2.addChild(oMElement2);
            Iterator iterator = oMElement.getAllDeclaredNamespaces();
            while (iterator.hasNext()) {
                oMElement2.declareNamespace((OMNamespace)iterator.next());
            }
            Iterator iterator2 = oMElement.getAllAttributes();
            while (iterator2.hasNext()) {
                oMElement2.addAttribute((OMAttribute)iterator2.next());
            }
            for (OMNode oMNode = oMElement.getFirstOMChild(); oMNode != null; oMNode = oMNode.getNextOMSibling()) {
                if (oMNode instanceof OMElement) {
                    oMElement2.addChild(((OMElement)oMNode).cloneOMElement());
                    continue;
                }
                if (!(oMNode instanceof OMText)) continue;
                oMElement2.addChild(oMFactory.createOMText(((OMText)oMNode).getText()));
            }
            return oMDocument2;
        }

        private void putElement(OMElement oMElement, Map<OMElement, OMElement> map, Map<String, OMElement> map2, String string) {
            OMElement oMElement2 = DOMUtils.getFirstElement(oMElement);
            while (oMElement2 != null) {
                String string2 = oMElement2.getAttributeValue(new QName("", string));
                if (string2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found attribute[" + string + "=" + string2 + "] at the element[" + DOMUtils.getDisplayName(oMElement2) + "]");
                    }
                    map.put(map2.get(string2), oMElement2);
                }
                this.putElement(oMElement2, map, map2, string);
                oMElement2 = DOMUtils.getNextElement(oMElement2);
            }
        }

        private void addElement(OMElement oMElement, OMElement oMElement2, OMElement oMElement3) {
            int n = this._messageList.size() - 1;
            if (n >= 0) {
                Map<OMElement, OMElement> map = this._objectList.get(n);
                Map<OMElement, EncryptedObject> map2 = this._edataList.get(n);
                OMElement oMElement4 = map.get(oMElement);
                if (oMElement4 != null) {
                    EncryptedObject encryptedObject = new EncryptedObject();
                    encryptedObject._headerInfo = oMElement3;
                    encryptedObject._encryptedData = oMElement2;
                    map2.put(oMElement4, encryptedObject);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Set EncryptedData and HeaderInfo(EncryptedKey or ReferenceList) for the element [" + DOMUtils.getDisplayName(oMElement4) + "].");
                    }
                }
            }
        }

        private OMDocument getDocument(int n) {
            OMDocument oMDocument = null;
            int n2 = this._messageList.size() - 1 - n;
            if (n2 >= 0) {
                oMDocument = this._messageList.get(n2);
            }
            return oMDocument;
        }

        private EncryptedObject convertElement(OMElement oMElement, int n) {
            EncryptedObject encryptedObject = null;
            if (n >= 0) {
                int n2 = this._messageList.size() - 1 - n;
                if (n2 >= 0) {
                    Map<OMElement, EncryptedObject> map = this._edataList.get(n2);
                    encryptedObject = map.get(oMElement);
                }
            } else {
                for (int i = this._messageList.size() - 1; i >= 0; --i) {
                    Map<OMElement, EncryptedObject> map = this._edataList.get(i);
                    Map<OMElement, OMElement> map2 = this._objectList.get(i);
                    for (OMElement oMElement2 : map2.keySet()) {
                        if (!DOMUtils.equalsc14n(oMElement2, oMElement, false)) continue;
                        encryptedObject = map.get(map2.get(oMElement2));
                        break;
                    }
                    if (encryptedObject != null) break;
                }
            }
            return encryptedObject;
        }
    }
}

