/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.wssecurity.handler.token.WSNonceManagerImpl;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.Permission;
import java.security.SecurityPermission;

public class NonceManagerFactory {
    private static final TraceComponent tc = Tr.register(NonceManagerFactory.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = NonceManagerFactory.class.getName();
    private static final Permission INIT_PERMISSION = new SecurityPermission("wssecurity.NonceManagerFactory.init");
    private static final Permission GET_INSTANCE_PERMISSION = new SecurityPermission("wssecurity.NonceManagerFactory.getInstance");
    private static boolean _initialized = false;
    private static boolean _useCache = false;
    private static String _cacheName = null;
    private static int _cacheSize = -1;
    private static int _cacheTimeout = -1;
    private static int _nonceLength = -1;
    private static boolean _cacheDistributed = false;

    private NonceManagerFactory() {
    }

    public static NonceManager getInstance() throws SoapSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GET_INSTANCE_PERMISSION);
        }
        if (!_initialized) {
            NonceManagerFactory.init(true, "NonceDistributionCacheMap", 1024, 600, 128, false);
        }
        NonceManager nonceManager = NonceInstance.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance() returns NonceManager[" + nonceManager + "]");
        }
        return nonceManager;
    }

    public static synchronized void init(boolean bl, String string, int n, int n2, int n3, boolean bl2) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("init(");
            ((StringBuffer)object).append("boolean useCache[").append(bl).append("], ");
            ((StringBuffer)object).append("String cacheName[").append(string).append("], ");
            ((StringBuffer)object).append("int cacheSize[").append(n).append("], ");
            ((StringBuffer)object).append("int cacheTimeout[").append(n2).append("], ");
            ((StringBuffer)object).append("int nonceLength[").append(n3).append("], ");
            ((StringBuffer)object).append("boolean cacheDistributed[").append(bl2).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        if ((object = System.getSecurityManager()) != null) {
            ((SecurityManager)object).checkPermission(INIT_PERMISSION);
        }
        _useCache = bl;
        _cacheName = string;
        _cacheSize = n;
        _cacheTimeout = n2;
        _nonceLength = n3;
        _cacheDistributed = bl2;
        _initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(boolean, String, int, int, int, boolean)");
        }
    }

    public String toString() {
        return clsName;
    }

    public static boolean isInitialized() {
        return _initialized;
    }

    private static class NonceInstance {
        private static boolean _instantiated = false;
        private static NonceManager _instance = null;

        private NonceInstance() {
        }

        static synchronized NonceManager getInstance() {
            if (!_instantiated) {
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("Initializing the WSNonceManagerImpl instance with ");
                    stringBuffer.append("boolean useCache[").append(_useCache).append("], ");
                    stringBuffer.append("String cacheName[").append(_cacheName).append("], ");
                    stringBuffer.append("int cacheSize[").append(_cacheSize).append("], ");
                    stringBuffer.append("int cacheTimeout[").append(_cacheTimeout).append("], ");
                    stringBuffer.append("int nonceLength[").append(_nonceLength).append("], ");
                    stringBuffer.append("boolean cacheDistributed[").append(_cacheDistributed).append("]");
                    Tr.debug(tc, stringBuffer.toString());
                }
                _instance = _useCache ? new WSNonceManagerImpl(_cacheName, _cacheSize, _cacheTimeout, _nonceLength, _cacheDistributed) : null;
                _instantiated = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSNonceManagerImpl instance initialized [" + _instance + "]");
                }
            }
            return _instance;
        }
    }
}

