/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.confimpl;

import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.core.token.TokenGeneratorComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.ConfigValidation;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Duration;
import com.ibm.ws.wssecurity.util.GetJAASConfigInfo;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrivateGeneratorConfig
extends PrivateCommonConfig
implements WSSGeneratorConfig {
    private static final TraceComponent tc = Tr.register(PrivateGeneratorConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    protected String _myActor = null;
    protected String _targetActor = null;
    protected boolean _indentation = false;
    protected final Set<String> _allowedTransforms = new HashSet<String>();
    protected final Set<String> _allowedCanonicalizationMethods = new HashSet<String>();
    protected final Set<String> _allowedSignatureMethods = new HashSet<String>();
    protected final Set<String> _allowedDigestMethods = new HashSet<String>();
    protected final Set<String> _allowedDataEncryptionMethods = new HashSet<String>();
    protected final Set<String> _allowedKeyEncryptionMethods = new HashSet<String>();
    protected final WSSAlgorithmFactory _algorithmFactory = (WSSAlgorithmFactory)WSSAlgorithmFactory.getInstance();
    protected final Set<String> _defaultKeyInfoContentGenerators = new HashSet<String>();
    protected final Set<String> _defaultTokenGenerators = new HashSet<String>();
    protected final Set<String> _defaultCallbackHandlers = new HashSet<String>();
    protected final Set<String> _defaultKeyLocators = new HashSet<String>();
    protected boolean _userDefinedComponentsUsed = false;
    protected boolean _signatureEnabled = false;
    protected boolean _encryptionEnabled = false;
    protected boolean _tokenEnabled = false;
    protected boolean _timestampEnabled = false;
    protected final List<ReferencePartConfig> _integralParts = new ArrayList<ReferencePartConfig>();
    protected final List<ReferencePartConfig> _confidentialParts = new ArrayList<ReferencePartConfig>();
    protected final List<TokenGeneratorConfig> _securityTokens = new ArrayList<TokenGeneratorConfig>();
    protected final List<Configuration> _operationGenerators = new ArrayList<Configuration>();
    protected final Set<TokenGeneratorConfig> _tokenGenerators = new HashSet<TokenGeneratorConfig>();
    protected NonceManager _nonceManager = null;
    protected Map<Object, Object> _properties = null;
    protected TimestampGeneratorConfImpl _timestampGenerator = null;
    protected final Set<String> _defaultJAASConfigs = new HashSet<String>();
    protected boolean _symmetricBinding = false;
    protected PrivateConsumerConfig _bootstrapConsumerConfig = null;
    protected PrivateGeneratorConfig _bootstrapGeneratorConfig = null;
    protected boolean _scEnabled = false;
    protected boolean _normalProcessing = false;
    protected boolean _clientSetMustUnderstand = true;
    protected boolean _serviceGetMustUnderstand = true;
    protected boolean _shouldCacheUsernameTokens = false;

    protected void processPrivateConfig(OMDocument oMDocument) throws SoapSecurityException {
        String string;
        int n;
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("processPrivateConfig(");
            ((StringBuffer)object).append("OMDocument pconfig[").append(oMDocument).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = oMDocument.getOMDocumentElement();
        boolean bl = false;
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is true; getting FIPS algorithms");
            }
            bl = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is false; getting non-FIPS algorithms");
            }
            bl = false;
        }
        ArrayList arrayList = DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "Transform");
        for (n = 0; n < arrayList.size(); ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "algorithm");
            this._allowedTransforms.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed Transforms:", new Object[]{this._allowedTransforms});
        }
        if (this._allowedTransforms.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s11");
        }
        arrayList = DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "canonicalizationMethod");
        for (n = 0; n < arrayList.size(); ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "algorithm");
            this._allowedCanonicalizationMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed canonicalizationMethods:", new Object[]{this._allowedCanonicalizationMethods});
        }
        if (this._allowedCanonicalizationMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s12");
        }
        arrayList = bl ? DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "fipsSignatureMethod") : DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "signatureMethod");
        for (n = 0; n < arrayList.size(); ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "algorithm");
            this._allowedSignatureMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed signatureMethods:", new Object[]{this._allowedSignatureMethods});
        }
        if (this._allowedSignatureMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s13");
        }
        arrayList = bl ? DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "fipsDigestMethod") : DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "digestMethod");
        for (n = 0; n < arrayList.size(); ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "algorithm");
            this._allowedDigestMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed digestMethods:", new Object[]{this._allowedDigestMethods});
        }
        if (this._allowedDigestMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s14");
        }
        arrayList = bl ? DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "fipsEncryptionMethod") : DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "encryptionMethod");
        for (n = 0; n < arrayList.size(); ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "algorithm");
            this._allowedDataEncryptionMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed encryptionMethods:", new Object[]{this._allowedDataEncryptionMethods});
        }
        if (this._allowedDataEncryptionMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s15");
        }
        arrayList = bl ? DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "fipsKeyEncryptionMethod") : DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "keyEncryptionMethod");
        for (n = 0; n < arrayList.size(); ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "algorithm");
            if (!ConfigValidation.isAlgoSupportedByRuntime(string)) continue;
            this._allowedKeyEncryptionMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed keyEncryptionMethods:", new Object[]{this._allowedKeyEncryptionMethods});
        }
        if (this._allowedKeyEncryptionMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s16");
        }
        arrayList = DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "KeyInfoContentGenerator");
        for (n = 0; n < arrayList.size(); ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "class");
            this._defaultKeyInfoContentGenerators.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default KeyInfoContentGenerator:", new Object[]{this._defaultKeyInfoContentGenerators});
        }
        if (this._defaultKeyInfoContentGenerators.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6715W");
        }
        arrayList = DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "TokenGenerator");
        for (n = 0; n < arrayList.size(); ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "class");
            this._defaultTokenGenerators.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default TokenGenerator:", new Object[]{this._defaultTokenGenerators});
        }
        if (this._defaultTokenGenerators.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6716W");
        }
        arrayList = DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "CallbackHandler");
        for (n = 0; n < arrayList.size(); ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "class");
            this._defaultCallbackHandlers.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default CallbackHandler:", new Object[]{this._defaultCallbackHandlers});
        }
        if (this._defaultCallbackHandlers.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6717W");
        }
        arrayList = DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "KeyLocator");
        for (n = 0; n < arrayList.size(); ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "class");
            this._defaultKeyLocators.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default KeyLocator:", new Object[]{this._defaultKeyLocators});
        }
        if (this._defaultKeyLocators.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6714W");
        }
        arrayList = DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "JAASConfig");
        for (n = 0; n < arrayList.size(); ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "name");
            this._defaultJAASConfigs.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default JAASConfigs:", new Object[]{this._defaultJAASConfigs});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processPrivateConfig(Document pconfig)");
        }
    }

    public PrivateGeneratorConfig getBootstrapGeneratorConfig() {
        return this._bootstrapGeneratorConfig;
    }

    public PrivateConsumerConfig getBootstrapConsumerConfig() {
        return this._bootstrapConsumerConfig;
    }

    public boolean isSCEnabled() {
        return this._scEnabled;
    }

    @Override
    public void validate() throws SoapSecurityException {
        this.validate(false, false, null);
    }

    public void validate(boolean bl, Map map) throws SoapSecurityException {
        this.validate(bl, false, map);
    }

    public void validate(boolean bl, boolean bl2, Map map) throws SoapSecurityException {
        block108: {
            block109: {
                Object object;
                Configuration configuration;
                Object object2;
                String string;
                String string2;
                PrivateCommonConfig.ReferencePartConfImpl referencePartConfImpl;
                int n;
                int n2;
                int n3;
                if (tc.isEntryEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("validate(");
                    stringBuffer.append("boolean defaultConfig[").append(bl).append("], ");
                    stringBuffer.append("boolean defaultTokenGenerator[").append(bl2).append("], ");
                    stringBuffer.append("Map nameToken[").append(map).append("])");
                    Tr.entry(tc, stringBuffer.toString());
                }
                Iterator<Configuration> iterator = this._integralParts.iterator();
                while (iterator.hasNext()) {
                    n3 = 0;
                    n2 = 0;
                    n = 0;
                    referencePartConfImpl = (PrivateCommonConfig.ReferencePartConfImpl)iterator.next();
                    referencePartConfImpl.validate();
                    for (PrivateCommonConfig.PartConfImpl partConfImpl : referencePartConfImpl._parts) {
                        partConfImpl.validate();
                        if (partConfImpl.isNonce()) {
                            ++n2;
                        } else if (partConfImpl.isTimestamp()) {
                            ++n;
                        } else {
                            ++n3;
                        }
                        string2 = partConfImpl._dialect;
                        string = partConfImpl._keyword;
                        if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(string2)) {
                            int n4 = ConfigUtil.isIntegralWASDialect(string);
                            if (n4 == 1) {
                                if (partConfImpl.isTimestamp()) {
                                    throw SoapSecurityException.format("security.wssecurity.TimestampGenerator.s02");
                                }
                                if (this._timestampGenerator == null) continue;
                                TimestampGeneratorConfImpl timestampGeneratorConfImpl = this._timestampGenerator;
                                timestampGeneratorConfImpl._signed = true;
                                continue;
                            }
                            if (n4 >= 0) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", string, partConfImpl.toString());
                        }
                        if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(string2)) {
                            if (string != null) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", "SignedElements");
                        }
                        if (com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER.equals(string2)) {
                            if (partConfImpl._headerNamespace != null) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s20", this.toString());
                        }
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", string2, partConfImpl.toString());
                    }
                    if (n2 <= 0 && n <= 0 || n3 > 0) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s36");
                }
                iterator = this._confidentialParts.iterator();
                while (iterator.hasNext()) {
                    n3 = 0;
                    n2 = 0;
                    n = 0;
                    referencePartConfImpl = (PrivateCommonConfig.ReferencePartConfImpl)iterator.next();
                    referencePartConfImpl.validate();
                    for (PrivateCommonConfig.PartConfImpl partConfImpl : referencePartConfImpl._parts) {
                        partConfImpl.validate();
                        if (partConfImpl.isNonce()) {
                            ++n2;
                        } else if (partConfImpl.isTimestamp()) {
                            ++n;
                        } else {
                            ++n3;
                        }
                        string2 = partConfImpl._dialect;
                        string = partConfImpl._keyword;
                        if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(string2)) {
                            if (ConfigUtil.isConfidentialWASDialect(string) >= 0) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", string, partConfImpl.toString());
                        }
                        if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(string2)) {
                            if (string != null) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", "EncryptedElements");
                        }
                        if (com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER.equals(string2)) {
                            if (partConfImpl._headerNamespace != null) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s20", this.toString());
                        }
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", string2, partConfImpl.toString());
                    }
                    if (n2 <= 0 && n <= 0 || n3 > 0) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s36");
                }
                for (TokenGeneratorConfImpl tokenGeneratorConfImpl : this._tokenGenerators) {
                    String string3 = GetJAASConfigInfo.isJaasConfigOurs(tokenGeneratorConfImpl.getJAASConfig());
                    if (string3 == null) continue;
                    tokenGeneratorConfImpl._properties.put("com.ibm.ws.wssecurity.token.ourLoginConfig", string3);
                }
                int n4 = 0;
                if (!WSSContextManagerFactory.getInstance().processIsServer()) {
                    n = 0;
                    for (TokenGeneratorConfImpl tokenGeneratorConfImpl : this._tokenGenerators) {
                        object2 = tokenGeneratorConfImpl.getType();
                        if (!com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(object2) && !com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(object2)) continue;
                        n = 1;
                        configuration = tokenGeneratorConfImpl.getCallbackHandler();
                        if (configuration == null || !configuration.getClassName().trim().equals("com.ibm.websphere.wssecurity.callbackhandler.UNTGUIPromptCallbackHandler")) continue;
                        configuration.getProperties().put("com.ibm.ws.wssecurity.UNTGUIPromptCallbackHandler.cacheTokens", "true");
                        if (++n4 <= 1) continue;
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "More than one UNTGUIPromptCallbackHandlers found");
                        break;
                    }
                    if (n4 == 1) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "UsernameTokens will be cached");
                        }
                        this._shouldCacheUsernameTokens = true;
                    } else if (tc.isDebugEnabled()) {
                        if (n == 0) {
                            Tr.debug(tc, "No UsernameToken generators found");
                        } else if (n4 == 0) {
                            Tr.debug(tc, "UNTGUIPromptCallbackHandler was not found");
                        }
                        Tr.debug(tc, "UsernameTokens will not be cached");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Process is running on an application server");
                    Tr.debug(tc, "UsernameTokens will not be cached");
                }
                if (n4 > 1) {
                    for (TokenGeneratorConfImpl tokenGeneratorConfImpl : this._tokenGenerators) {
                        QName qName = tokenGeneratorConfImpl.getType();
                        if (!com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(qName) && !com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(qName) || (object2 = tokenGeneratorConfImpl.getCallbackHandler()) == null) continue;
                        object2.getProperties().remove("com.ibm.ws.wssecurity.UNTGUIPromptCallbackHandler.cacheTokens");
                    }
                }
                if (bl || bl2) {
                    HashMap<QName, TokenGeneratorConfImpl> hashMap = new HashMap<QName, TokenGeneratorConfImpl>();
                    for (TokenGeneratorConfImpl tokenGeneratorConfImpl : this._tokenGenerators) {
                        hashMap.put(tokenGeneratorConfImpl.getType(), tokenGeneratorConfImpl);
                    }
                    for (TokenGeneratorConfImpl tokenGeneratorConfImpl : this._securityTokens) {
                        object2 = tokenGeneratorConfImpl.getType();
                        configuration = (TokenGeneratorConfImpl)hashMap.get(object2);
                        if (configuration == null) {
                            throw SoapSecurityException.format("security.wssecurity.WSEC6817E", tokenGeneratorConfImpl._name, ((QName)object2).toString());
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Found token generator of type [" + object2 + "].");
                    }
                } else {
                    for (TokenGeneratorConfImpl tokenGeneratorConfImpl : this._securityTokens) {
                        if (!this._tokenGenerators.contains(tokenGeneratorConfImpl)) {
                            throw SoapSecurityException.format("security.wssecurity.WSEC6818E", tokenGeneratorConfImpl._name);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Found token generator in token generator list: " + tokenGeneratorConfImpl);
                    }
                }
                int n5 = 0;
                int n6 = 0;
                boolean bl3 = false;
                boolean bl4 = false;
                ArrayList<EncryptionGeneratorConfImpl> arrayList = new ArrayList<EncryptionGeneratorConfImpl>();
                for (Configuration configuration2 : this._operationGenerators) {
                    KeyInfoContentGeneratorConfImpl keyInfoContentGeneratorConfImpl;
                    KeyInfoGeneratorConfImpl keyInfoGeneratorConfImpl;
                    Object object3;
                    Object object4;
                    if (configuration2 instanceof SignatureGeneratorConfig) {
                        SignatureGeneratorConfImpl signatureGeneratorConfImpl = (SignatureGeneratorConfImpl)configuration2;
                        signatureGeneratorConfImpl.validate(bl);
                        object = signatureGeneratorConfImpl.getSigningKeyInfo().getContentGenerator().getTokenGenerator();
                        object4 = object.getType().getLocalPart();
                        if (this._symmetricBinding) {
                            String string4;
                            if (object4 != null && this._symmetricSignatureTokenAssertion != null && !((String)object4).equals(string4 = this._symmetricSignatureTokenAssertion.getTokentType().getLocalPart())) {
                                Tr.error(tc, "Token Generator token type " + (String)object4 + " does not match Signature Token type defined in the policy.");
                                throw SoapSecurityException.format("Token Generator token type " + (String)object4 + " does not match Signature Token type defined in the policy.");
                            }
                        } else if (this._request) {
                            PrivateCommonConfig.TokenAssertion tokenAssertion = (PrivateCommonConfig.TokenAssertion)this._initiatorSignatureTokens.get(object4);
                            if (tokenAssertion == null) {
                                Tr.error(tc, "Token Generator token type " + (String)object4 + " does not match Initiator Signature Token type defined in the policy.");
                                throw SoapSecurityException.format("Token Generator token type " + (String)object4 + " does not match Initiator Signature Token type defined in the policy.");
                            }
                        } else {
                            PrivateCommonConfig.TokenAssertion tokenAssertion = (PrivateCommonConfig.TokenAssertion)this._recipientSignatureTokens.get(object4);
                            if (tokenAssertion == null) {
                                Tr.error(tc, "Token Generator token type " + (String)object4 + " does not match Recipient Signature Token type defined in the policy.");
                                throw SoapSecurityException.format("Token Generator token type " + (String)object4 + " does not match Recipient Signature Token type defined in the policy.");
                            }
                        }
                        signatureGeneratorConfImpl._inclusiveNamespaces = ConfigUtil.isTrue((String)signatureGeneratorConfImpl._properties.get(Constants.WSSECURITY_INCLUSIVE_NAMESPACES));
                        PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl = signatureGeneratorConfImpl._canonicalizationMethod;
                        if (algorithmConfImpl != null) {
                            algorithmConfImpl.validate();
                            if (!this._allowedCanonicalizationMethods.contains(algorithmConfImpl._algorithm)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s08", algorithmConfImpl._algorithm);
                            }
                        }
                        PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl2 = signatureGeneratorConfImpl._signatureMethod;
                        boolean bl5 = false;
                        object3 = null;
                        if (algorithmConfImpl2 != null) {
                            algorithmConfImpl2.validate();
                            if (!this._allowedSignatureMethods.contains(algorithmConfImpl2._algorithm)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s09", algorithmConfImpl2._algorithm);
                            }
                            object3 = algorithmConfImpl2._algorithm;
                            bl5 = ConfigUtil.isSecretKeyAlgorithm((String)object3);
                        }
                        for (PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl : signatureGeneratorConfImpl._references) {
                            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl3;
                            signingReferenceConfImpl.validate();
                            Set<ReferencePartConfig.PartConfig> set = signingReferenceConfImpl._reference.getParts();
                            if (set != null && !set.isEmpty()) {
                                for (PrivateCommonConfig.PartConfImpl partConfImpl : set) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Signing part = " + partConfImpl);
                                    }
                                    if (!com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(partConfImpl._dialect) || !IntegralDialectElementSelector.WASDIALECTS[0].equals(partConfImpl._keyword) || partConfImpl._nonce || partConfImpl._timestamp) continue;
                                    Iterator<AlgorithmConfig> iterator2 = signingReferenceConfImpl._transforms.iterator();
                                    String string5 = null;
                                    int n7 = 0;
                                    while (iterator2.hasNext()) {
                                        PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl4 = (PrivateCommonConfig.AlgorithmConfImpl)iterator2.next();
                                        string5 = algorithmConfImpl4._algorithm;
                                        ++n7;
                                    }
                                    if (n7 != true || !"http://www.w3.org/2001/10/xml-exc-c14n#".equals(string5)) continue;
                                    ++n5;
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Body is signed");
                                }
                            }
                            if ((algorithmConfImpl3 = signingReferenceConfImpl._digestMethod) != null) {
                                algorithmConfImpl3.validate();
                                if (!this._allowedDigestMethods.contains(algorithmConfImpl3._algorithm)) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s11", algorithmConfImpl3._algorithm);
                                }
                            }
                            boolean bl6 = false;
                            for (PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl5 : signingReferenceConfImpl._transforms) {
                                algorithmConfImpl5.validate();
                                if (!this._allowedTransforms.contains(algorithmConfImpl5._algorithm)) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s12", algorithmConfImpl5._algorithm);
                                }
                                if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(algorithmConfImpl5._algorithm)) {
                                    bl6 = true;
                                    continue;
                                }
                                if (!"http://www.w3.org/TR/1999/REC-xpath-19991116".equals(algorithmConfImpl5._algorithm) || (string = ConfigUtil.trim((String)algorithmConfImpl5._properties.get(Constants.WSSECURITY_XPATH_EXPRESSION))) != null && string.length() != 0) continue;
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s27");
                            }
                        }
                        keyInfoGeneratorConfImpl = signatureGeneratorConfImpl._signingKeyInfo;
                        keyInfoGeneratorConfImpl.validate();
                        keyInfoContentGeneratorConfImpl = keyInfoGeneratorConfImpl._contentGenerator;
                        keyInfoContentGeneratorConfImpl.validate();
                        if (ConfigUtil.isKeyInfoType(keyInfoContentGeneratorConfImpl._keyInfoType) < 0) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s13", keyInfoContentGeneratorConfImpl.toString());
                        }
                        if (bl5) {
                            if (ConfigUtil.isKeyInfoEmb(keyInfoContentGeneratorConfImpl._keyInfoType)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", (String)object3, keyInfoContentGeneratorConfImpl._keyInfoType);
                            }
                            if (ConfigUtil.isKeyInfoX509issuer(keyInfoContentGeneratorConfImpl._keyInfoType)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", (String)object3, keyInfoContentGeneratorConfImpl._keyInfoType);
                            }
                        }
                        for (EncryptionGeneratorConfImpl encryptionGeneratorConfImpl : arrayList) {
                            encryptionGeneratorConfImpl._sigAfterEnc = true;
                        }
                        continue;
                    }
                    if (configuration2 instanceof EncryptionGeneratorConfig) {
                        Set<ReferencePartConfig.PartConfig> set;
                        TokenGeneratorConfig tokenGeneratorConfig;
                        EncryptionGeneratorConfImpl encryptionGeneratorConfImpl;
                        encryptionGeneratorConfImpl = (EncryptionGeneratorConfImpl)configuration2;
                        encryptionGeneratorConfImpl.validate(bl);
                        object = encryptionGeneratorConfImpl.getProperties();
                        if (object != null && (object4 = (String)object.get(Constants.WSSECURITY_MTOM_OPTIMIZE_ENCRYPTED_DATA)) != null && ((String)object4).length() > 0 && ConfigUtil.isTrue((String)object4)) {
                            bl4 = true;
                        }
                        object4 = encryptionGeneratorConfImpl.getEncryptionKeyInfo();
                        String string6 = null;
                        if (object4 != null && (object3 = object4.getContentGenerator()) != null && (tokenGeneratorConfig = object3.getTokenGenerator()) != null) {
                            string6 = tokenGeneratorConfig.getType().getLocalPart();
                        }
                        if (this._symmetricBinding) {
                            if (string6 != null && this._symmetricEncryptionTokenAssertion != null && !string6.equals(object3 = this._symmetricEncryptionTokenAssertion.getTokentType().getLocalPart())) {
                                Tr.error(tc, "Token Generator token type " + string6 + " does not match Encryption Token type defined in the policy.");
                                throw SoapSecurityException.format("Token Generator token type " + string6 + " does not match Encryption Token type defined in the policy.");
                            }
                        } else if (this._request) {
                            object3 = (PrivateCommonConfig.TokenAssertion)this._recipientEncryptionTokens.get(string6);
                            if (object3 == null) {
                                Tr.error(tc, "Token Generator token type " + string6 + " does not match Recipient Encryption Token type defined in the policy.");
                                throw SoapSecurityException.format("Token Generator token type " + string6 + " does not match Recipient Encryption Token type defined in the policy.");
                            }
                        } else {
                            object3 = (PrivateCommonConfig.TokenAssertion)this._initiatorEncryptionTokens.get(string6);
                            if (object3 == null) {
                                Tr.error(tc, "Token Generator token type " + string6 + " does not match Initiator Encryption Token defined in the policy.");
                                throw SoapSecurityException.format("Token Generator token type " + string6 + " does not match Initiator Encryption Token type defined in the policy.");
                            }
                        }
                        PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl = encryptionGeneratorConfImpl._dataEncryptionMethod;
                        algorithmConfImpl.validate();
                        if (!this._allowedDataEncryptionMethods.contains(algorithmConfImpl._algorithm)) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s14", algorithmConfImpl._algorithm);
                        }
                        object3 = algorithmConfImpl._algorithm;
                        boolean bl7 = ConfigUtil.isSecretKeyAlgorithm((String)object3);
                        PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl6 = encryptionGeneratorConfImpl._keyEncryptionMethod;
                        if (algorithmConfImpl6 != null) {
                            algorithmConfImpl6.validate();
                            if (!this._allowedKeyEncryptionMethods.contains(algorithmConfImpl6._algorithm)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s15", algorithmConfImpl6._algorithm);
                            }
                            object3 = algorithmConfImpl6._algorithm;
                            bl7 = ConfigUtil.isSecretKeyAlgorithm((String)object3);
                        }
                        keyInfoGeneratorConfImpl = encryptionGeneratorConfImpl._encryptionKeyInfo;
                        keyInfoGeneratorConfImpl.validate();
                        keyInfoContentGeneratorConfImpl = keyInfoGeneratorConfImpl._contentGenerator;
                        keyInfoContentGeneratorConfImpl.validate();
                        if (ConfigUtil.isKeyInfoType(keyInfoContentGeneratorConfImpl._keyInfoType) < 0) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s13", keyInfoContentGeneratorConfImpl.toString());
                        }
                        if (bl7) {
                            if (ConfigUtil.isKeyInfoEmb(keyInfoContentGeneratorConfImpl._keyInfoType)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", (String)object3, keyInfoContentGeneratorConfImpl._keyInfoType);
                            }
                            if (ConfigUtil.isKeyInfoX509issuer(keyInfoContentGeneratorConfImpl._keyInfoType)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", (String)object3, keyInfoContentGeneratorConfImpl._keyInfoType);
                            }
                        }
                        if ((referencePartConfImpl = encryptionGeneratorConfImpl._reference) != null && (set = referencePartConfImpl._parts) != null && !set.isEmpty()) {
                            for (PrivateCommonConfig.PartConfImpl partConfImpl : set) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Encrypting part = " + partConfImpl);
                                }
                                if (!com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(partConfImpl._dialect) || !ConfidentialDialectElementSelector.WASDIALECTS[0].equals(partConfImpl._keyword) || partConfImpl._nonce || partConfImpl._timestamp) continue;
                                ++n6;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Body content is encrypted");
                                }
                                if (n5 != 1) continue;
                                bl3 = true;
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Sign, then encrypt = true");
                            }
                        }
                        arrayList.add(encryptionGeneratorConfImpl);
                        continue;
                    }
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s01", this.toString());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Sign body = " + n5 + ", encrypt body content = " + n6 + ", sign then encrypt = " + bl3 + ", MTOM = " + bl4);
                }
                if (n5 == 1 && n6 == 1 && bl3 && !bl4) {
                    this._normalProcessing = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Detected normal outbound processing (sign body, then encrypt body content, no MTOM)");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not detect normal outbound processing (sign body, then encrypt body content, no MTOM)");
                }
                for (TokenGeneratorConfImpl tokenGeneratorConfImpl : this._tokenGenerators) {
                    tokenGeneratorConfImpl.validate();
                    PrivateCommonConfig.CallbackHandlerConfImpl callbackHandlerConfImpl = tokenGeneratorConfImpl._callbackHandler;
                    if (callbackHandlerConfImpl != null) {
                        PrivateCommonConfig.KeyInformationConfImpl keyInformationConfImpl;
                        callbackHandlerConfImpl.validate();
                        PrivateCommonConfig.KeyStoreConfImpl keyStoreConfImpl = callbackHandlerConfImpl._keyStore;
                        if (keyStoreConfImpl != null) {
                            keyStoreConfImpl.validate();
                        }
                        if ((keyInformationConfImpl = callbackHandlerConfImpl._keyInformation) != null) {
                            keyInformationConfImpl.validate();
                        }
                    }
                    if (!tokenGeneratorConfImpl._standAlone) continue;
                    if (tokenGeneratorConfImpl._usedForSignature) {
                        tokenGeneratorConfImpl._standAlone = false;
                        if (!tc.isDebugEnabled()) continue;
                        object = ConfigUtil.getMessage("security.wssecurity.WSEC6815E", new String[]{tokenGeneratorConfImpl._name});
                        Tr.debug(tc, (String)object);
                        continue;
                    }
                    if (!tokenGeneratorConfImpl._usedForEncryption) continue;
                    tokenGeneratorConfImpl._standAlone = false;
                    if (!tc.isDebugEnabled()) continue;
                    object = ConfigUtil.getMessage("security.wssecurity.WSEC6816E", new String[]{tokenGeneratorConfImpl._name});
                    Tr.debug(tc, (String)object);
                }
                if (this._timestampGenerator == null) break block108;
                this._timestampGenerator.validate();
                object = (String)this._timestampGenerator._properties.get(Constants.WSSECURITY_TIMESTAMP_SOAPHEADER);
                if (object != null) {
                    this._timestampGenerator._headerAttribute = ConfigUtil.isTrue((String)object);
                    this._timestampGenerator._soapHeader = true;
                }
                if ((object = (String)this._timestampGenerator._properties.get(Constants.WSSECURITY_TIMESTAMP_DIALECT)) == null) break block108;
                if (!com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(object)) break block109;
                object = (String)this._timestampGenerator._properties.get(Constants.WSSECURITY_TIMESTAMP_KEYWORD);
                if (object == null) break block108;
                int n9 = ConfigUtil.isTimestampWASDialect((String)object);
                switch (n9) {
                    case 1: {
                        break block108;
                    }
                    case 2: 
                    case 3: {
                        this._timestampGenerator._soapHeader = true;
                    }
                    case 0: {
                        this._timestampGenerator._default = false;
                        break block108;
                    }
                    default: {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", (String)object, this._timestampGenerator.toString());
                    }
                }
            }
            this._timestampGenerator._default = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate(boolean, Map)");
        }
    }

    @Override
    public boolean getServiceGetMustUnderstand() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceGetMustUnderstand");
            Tr.exit(tc, "getServiceGetMustUnderstand=" + this._serviceGetMustUnderstand);
        }
        return this._serviceGetMustUnderstand;
    }

    @Override
    public boolean getClientSetMustUnderstand() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientSetMustUnderstand");
            Tr.exit(tc, "getClientSetMustUnderstand=" + this._clientSetMustUnderstand);
        }
        return this._clientSetMustUnderstand;
    }

    @Override
    public boolean getShouldCacheUsernameTokens() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getShouldCacheUsernameTokens");
            Tr.exit(tc, "getShouldCacheUsernameTokens=" + this._shouldCacheUsernameTokens);
        }
        return this._shouldCacheUsernameTokens;
    }

    @Override
    public String getMyActor() {
        return this._myActor;
    }

    @Override
    public String getTargetActor() {
        return this._targetActor;
    }

    @Override
    public boolean doIndentation() {
        return this._indentation;
    }

    @Override
    public void setIndentation(boolean bl) {
        this._indentation = bl;
    }

    @Override
    public Set<String> getAllowedTransforms() {
        return this._allowedTransforms;
    }

    @Override
    public Set<String> getAllowedCanonicalizationMethods() {
        return this._allowedCanonicalizationMethods;
    }

    @Override
    public Set<String> getAllowedSignatureMethods() {
        return this._allowedSignatureMethods;
    }

    @Override
    public Set<String> getAllowedDigestMethods() {
        return this._allowedDigestMethods;
    }

    @Override
    public Set<String> getAllowedDataEncryptionMethods() {
        return this._allowedDataEncryptionMethods;
    }

    @Override
    public Set<String> getAllowedKeyEncryptionMethods() {
        return this._allowedKeyEncryptionMethods;
    }

    @Override
    public WSSAlgorithmFactory getAlgorithmFactory() {
        return this._algorithmFactory;
    }

    @Override
    public boolean isSignatureEnabled() {
        return this._signatureEnabled;
    }

    @Override
    public boolean isEncryptionEnabled() {
        return this._encryptionEnabled;
    }

    @Override
    public boolean isTokenEnabled() {
        return this._tokenEnabled;
    }

    @Override
    public boolean isTimestampEnabled() {
        return this._timestampEnabled;
    }

    @Override
    public List<ReferencePartConfig> getIntegralParts() {
        return this._integralParts;
    }

    @Override
    public List<ReferencePartConfig> getConfidentialParts() {
        return this._confidentialParts;
    }

    @Override
    public List<Configuration> getOperationGenerators() {
        return this._operationGenerators;
    }

    @Override
    public Set<TokenGeneratorConfig> getTokenGenerators() {
        return this._tokenGenerators;
    }

    @Override
    public TimestampGeneratorConfig getTimestampGenerator() {
        return this._timestampGenerator;
    }

    @Override
    public NonceManager getNonceManager() {
        return this._nonceManager;
    }

    @Override
    public boolean isUserDefinedComponentsUsed() {
        return this._userDefinedComponentsUsed;
    }

    @Override
    public Map<Object, Object> getProperties() {
        return this._properties;
    }

    @Override
    public Object getProperty(Object object) {
        if (this._properties != null) {
            return this._properties.get(object);
        }
        return null;
    }

    public boolean isNormalProcessing() {
        return this._normalProcessing;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
        stringBuffer.append("myActor=[").append(this._myActor).append("], ");
        stringBuffer.append("targetActor=[").append(this._targetActor).append("], ");
        stringBuffer.append("indentation=[").append(this._indentation).append("], ");
        stringBuffer.append("allowedTransforms=[").append(this._allowedTransforms).append("], ");
        stringBuffer.append("allowedCanonicalizations=[").append(this._allowedCanonicalizationMethods).append("], ");
        stringBuffer.append("allowedSignatures=[").append(this._allowedSignatureMethods).append("], ");
        stringBuffer.append("allowedDigests=[").append(this._allowedDigestMethods).append("], ");
        stringBuffer.append("allowedDataEncryptions=[").append(this._allowedDataEncryptionMethods).append("], ");
        stringBuffer.append("allowedKeyEncryptions=[").append(this._allowedKeyEncryptionMethods).append("], ");
        stringBuffer.append("algorithmFactory=[").append(this._algorithmFactory).append("], ");
        stringBuffer.append("signatureEnabled=[").append(this._signatureEnabled).append("], ");
        stringBuffer.append("encryptionEnabled=[").append(this._encryptionEnabled).append("], ");
        stringBuffer.append("tokenEnabled=[").append(this._tokenEnabled).append("], ");
        stringBuffer.append("timestampEnabled=[").append(this._timestampEnabled).append("], ");
        stringBuffer.append("integralParts=[").append(this._integralParts).append("], ");
        stringBuffer.append("confidentialParts=[").append(this._confidentialParts).append("], ");
        stringBuffer.append("operationGenerators=[").append(this._operationGenerators).append("], ");
        stringBuffer.append("tokenGenerators=[").append(this._tokenGenerators).append("], ");
        stringBuffer.append("timestampGenerator=[").append(this._timestampGenerator).append("], ");
        stringBuffer.append("nonceManager=[").append(this._nonceManager).append("], ");
        stringBuffer.append("userDefinedComponentsUsed=[").append(this._userDefinedComponentsUsed).append("], ");
        stringBuffer.append("properties=[").append(this._properties).append("]");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyInfoContentGeneratorConfImpl
    implements KeyInfoContentGeneratorConfig {
        public String _className = null;
        public KeyInfoContentGeneratorComponent _instance = null;
        public String _keyInfoType = null;
        public String _keyName = null;
        public TokenGeneratorConfImpl _tokenGenerator = null;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();

        @Override
        public void validate() throws SoapSecurityException {
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s25", this.toString());
            }
            if (this._keyInfoType == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s26", this.toString());
            }
        }

        @Override
        public KeyInfoContentGeneratorComponent getInstance() {
            return this._instance;
        }

        @Override
        public String getKeyInfoType() {
            return this._keyInfoType;
        }

        @Override
        public String getKeyName() {
            return this._keyName;
        }

        @Override
        public TokenGeneratorConfig getTokenGenerator() {
            return this._tokenGenerator;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("className=[").append(this._className).append("], ");
            stringBuffer.append("keyInfoType=[").append(this._keyInfoType).append("], ");
            stringBuffer.append("keyName=[").append(this._keyName).append("], ");
            stringBuffer.append("tokenGenerator=[").append(this._tokenGenerator).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class KeyInfoGeneratorConfImpl
    implements KeyInfoGeneratorConfig {
        public KeyInfoContentGeneratorConfImpl _contentGenerator = null;

        public void validate() throws SoapSecurityException {
            if (this._contentGenerator == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s07", this.toString());
            }
        }

        public KeyInfoContentGeneratorConfig getContentGenerator() {
            return this._contentGenerator;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("contentGenerator=[").append(this._contentGenerator).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimestampGeneratorConfImpl
    implements TimestampGeneratorConfig {
        public String _myActor = null;
        public String _targetActor = null;
        public Duration _duration = null;
        private boolean _signed = false;
        private boolean _headerAttribute = false;
        private boolean _default = true;
        private boolean _soapHeader = false;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();

        @Override
        public void validate() throws SoapSecurityException {
        }

        @Override
        public String getMyActor() {
            return this._myActor;
        }

        @Override
        public String getTargetActor() {
            return this._targetActor;
        }

        @Override
        public Duration getDuration() {
            return this._duration;
        }

        @Override
        public boolean toBeSigned() {
            return this._signed;
        }

        public void setToBeSigned(boolean bl) {
            this._signed = bl;
        }

        @Override
        public boolean getSOAPHeaderAttribute() {
            return this._headerAttribute;
        }

        @Override
        public boolean isSOAPHeaderElement() {
            return this._soapHeader;
        }

        @Override
        public boolean isDefault() {
            return this._default;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("myActor=[").append(this._myActor).append("], ");
            stringBuffer.append("targetActor=[").append(this._targetActor).append("], ");
            stringBuffer.append("duration=[").append(this._duration).append("], ");
            stringBuffer.append("signed=[").append(this._signed).append("], ");
            stringBuffer.append("headerAttribute=[").append(this._headerAttribute).append("], ");
            stringBuffer.append("soapHeader=[").append(this._soapHeader).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TokenGeneratorConfImpl
    implements TokenGeneratorConfig {
        public String _name = null;
        public String _className = null;
        public TokenGeneratorComponent _instance = null;
        public QName _type = null;
        public boolean _standAlone = false;
        public String _jaasConfig = null;
        public final Map<Object, Object> _jaasConfigProperties = new HashMap<Object, Object>();
        public PrivateCommonConfig.CallbackHandlerConfImpl _callbackHandler = null;
        public boolean _usedForSignature = false;
        public boolean _usedForEncryption = false;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();
        private int _hash;

        public TokenGeneratorConfImpl() {
        }

        public TokenGeneratorConfImpl(TokenGeneratorConfImpl tokenGeneratorConfImpl) {
            this._name = tokenGeneratorConfImpl._name;
            this._className = tokenGeneratorConfImpl._className;
            this._instance = tokenGeneratorConfImpl._instance;
            this._type = tokenGeneratorConfImpl._type;
            this._standAlone = tokenGeneratorConfImpl._standAlone;
            this._jaasConfig = tokenGeneratorConfImpl._jaasConfig;
            tokenGeneratorConfImpl._jaasConfigProperties.putAll(this._jaasConfigProperties);
            this._callbackHandler = tokenGeneratorConfImpl._callbackHandler;
            this._usedForSignature = tokenGeneratorConfImpl._usedForSignature;
            this._usedForEncryption = tokenGeneratorConfImpl._usedForEncryption;
            this._properties.putAll(tokenGeneratorConfImpl._properties);
            this._hash = tokenGeneratorConfImpl._hash;
        }

        @Override
        public void validate() throws SoapSecurityException {
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s03", this.toString());
            }
            if (this._type == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s04", this.toString());
            }
            if (this._jaasConfig == null) {
                throw SoapSecurityException.format("security.wssecurity.WSEC6834E", this.toString());
            }
        }

        public TokenGeneratorComponent getInstance() {
            return this._instance;
        }

        @Override
        public QName getType() {
            return this._type;
        }

        @Override
        public boolean isStandAlone() {
            return this._standAlone;
        }

        @Override
        public String getJAASConfig() {
            return this._jaasConfig;
        }

        @Override
        public Map<Object, Object> getJAASConfigProperties() {
            return this._jaasConfigProperties;
        }

        @Override
        public CallbackHandlerConfig getCallbackHandler() {
            return this._callbackHandler;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public int hashCode() {
            if (this._hash == 0) {
                if (this._name != null) {
                    this._hash = this._name.hashCode();
                }
                if (this._className != null) {
                    this._hash = this._hash * 31 + this._className.hashCode();
                }
                if (this._type != null) {
                    this._hash = this._hash * 31 + this._type.hashCode();
                }
                this._hash = this._hash * 31 + (this._standAlone ? 1 : 0);
                if (this._jaasConfig != null) {
                    this._hash = this._hash * 31 + this._jaasConfig.hashCode();
                }
                this._hash = this._hash * 31 + ((Object)this._jaasConfigProperties).hashCode();
                if (this._callbackHandler != null) {
                    this._hash = this._hash * 31 + this._callbackHandler.hashCode();
                }
                this._hash = this._hash * 31 + ((Object)this._properties).hashCode();
            }
            return this._hash;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("className=[").append(this._className).append("], ");
            stringBuffer.append("type=[").append(this._type).append("], ");
            stringBuffer.append("standAlone=[").append(this._standAlone).append("], ");
            stringBuffer.append("jaasConfig=[").append(this._jaasConfig).append("], ");
            stringBuffer.append("jaasConfigProperties=[").append(this._jaasConfigProperties).append("], ");
            stringBuffer.append("callbackHandler=[").append(this._callbackHandler).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EncryptionGeneratorConfImpl
    implements EncryptionGeneratorConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _dataEncryptionMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyEncryptionMethod = null;
        public KeyInfoGeneratorConfImpl _encryptionKeyInfo = null;
        public PrivateCommonConfig.ReferencePartConfImpl _reference = null;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();
        public boolean _sigAfterEnc = false;
        public boolean _isKeyEncryption = false;

        @Override
        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean bl) throws SoapSecurityException {
            if (this._dataEncryptionMethod == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s19", this.toString());
            }
            if (this._encryptionKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s02", this.toString());
            }
            if (this._reference == null && !bl) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s21", this.toString());
            }
        }

        @Override
        public AlgorithmConfig getDataEncryptionMethod() {
            return this._dataEncryptionMethod;
        }

        @Override
        public AlgorithmConfig getKeyEncryptionMethod() {
            return this._keyEncryptionMethod;
        }

        @Override
        public KeyInfoGeneratorConfig getEncryptionKeyInfo() {
            return this._encryptionKeyInfo;
        }

        @Override
        public ReferencePartConfig getReference() {
            return this._reference;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        @Override
        public boolean remainSignatureAfterEncryption() {
            return this._sigAfterEnc;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("dataEncryptionMethod=[").append(this._dataEncryptionMethod).append("], ");
            stringBuffer.append("keyEncryptionMethod=[").append(this._keyEncryptionMethod).append("], ");
            stringBuffer.append("encryptionKeyInfo=[").append(this._encryptionKeyInfo).append("], ");
            stringBuffer.append("reference=[").append(this._reference).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("], ");
            stringBuffer.append("signatureAfterEncryption=[").append(this._sigAfterEnc).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SignatureGeneratorConfImpl
    implements SignatureGeneratorConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _canonicalizationMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _signatureMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyInfoSignature = null;
        public KeyInfoGeneratorConfImpl _signingKeyInfo = null;
        public final List<SigningReferenceConfig> _references = new ArrayList<SigningReferenceConfig>();
        public boolean _inclusiveNamespaces = true;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();

        @Override
        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean bl) throws SoapSecurityException {
            if (this._signingKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s01", this.toString());
            }
            if (this._references.isEmpty() && !bl) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s18", this.toString());
            }
        }

        @Override
        public AlgorithmConfig getCanonicalizationMethod() {
            return this._canonicalizationMethod;
        }

        @Override
        public AlgorithmConfig getSignatureMethod() {
            return this._signatureMethod;
        }

        @Override
        public AlgorithmConfig getKeyInfoSignature() {
            return this._keyInfoSignature;
        }

        @Override
        public KeyInfoGeneratorConfig getSigningKeyInfo() {
            return this._signingKeyInfo;
        }

        @Override
        public List<SigningReferenceConfig> getReferences() {
            return this._references;
        }

        @Override
        public boolean addInclusiveNamespaces() {
            return this._inclusiveNamespaces;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("canonicalizationMethod=[").append(this._canonicalizationMethod).append("], ");
            stringBuffer.append("signatureMethod=[").append(this._signatureMethod).append("], ");
            stringBuffer.append("keyInfoSignature=[").append(this._keyInfoSignature).append("], ");
            stringBuffer.append("signingKeyInfo=[").append(this._signingKeyInfo).append("], ");
            stringBuffer.append("refereces=[").append(this._references).append("], ");
            stringBuffer.append("addInclusiveNamespaces=[").append(this._inclusiveNamespaces).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

