/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.confimpl;

import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.CallerConfig;
import com.ibm.ws.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.wssecurity.core.token.TokenConsumerComponent;
import com.ibm.ws.wssecurity.dsig.VerifiedConfig;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.wssecurity.token.CertCacheManager;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.ConfigValidation;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.GetJAASConfigInfo;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrivateConsumerConfig
extends PrivateCommonConfig
implements WSSConsumerConfig {
    private static final TraceComponent tc = Tr.register(PrivateConsumerConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    protected String _myActor = null;
    protected boolean _ultimateReceiver = false;
    protected boolean _nonceCacheDistributed = false;
    protected final Set<String> _allowedTransforms = new HashSet<String>();
    protected final Set<String> _allowedCanonicalizationMethods = new HashSet<String>();
    protected final Set<String> _allowedSignatureMethods = new HashSet<String>();
    protected final Set<String> _allowedDigestMethods = new HashSet<String>();
    protected final Set<String> _allowedDataEncryptionMethods = new HashSet<String>();
    protected final Set<String> _allowedKeyEncryptionMethods = new HashSet<String>();
    protected final WSSAlgorithmFactory _algorithmFactory = (WSSAlgorithmFactory)WSSAlgorithmFactory.getInstance();
    protected final Set<String> _defaultKeyInfoContentConsumers = new HashSet<String>();
    protected final Set<String> _defaultTokenConsumers = new HashSet<String>();
    protected final Set<String> _defaultJAASConfigs = new HashSet<String>();
    protected final Set<String> _defaultKeyLocators = new HashSet<String>();
    protected boolean _userDefinedComponentsUsed = false;
    protected boolean _verificationRequired = false;
    protected boolean _decryptionRequired = false;
    protected boolean _tokenRequired = false;
    protected boolean _loginRequired = false;
    protected boolean _timestampRequired = false;
    protected final Set<ReferencePartConfig> _requiredIntegralParts = new HashSet<ReferencePartConfig>();
    protected final Set<ReferencePartConfig> _requiredConfidentialParts = new HashSet<ReferencePartConfig>();
    protected final Set<TokenConsumerConfig> _requiredSecurityTokens = new HashSet<TokenConsumerConfig>();
    protected final Set<CallerConfig> _callers = new HashSet<CallerConfig>();
    protected final Set<SignatureConsumerConfig> _signatureConsumers = new HashSet<SignatureConsumerConfig>();
    protected final Set<EncryptionConsumerConfig> _encryptionConsumers = new HashSet<EncryptionConsumerConfig>();
    protected final Set<TokenConsumerConfig> _tokenConsumers = new HashSet<TokenConsumerConfig>();
    protected TimestampConsumerConfImpl _timestampConsumer = null;
    protected NonceManager _nonceManager = null;
    protected CertCacheManager _certManager = null;
    protected int _timestampMaxAge = -1;
    protected int _timestampClockSkew = -1;
    protected Map<Object, Object> _properties = null;
    protected final Set _defaultCallbackHandlers = new HashSet();
    protected boolean _symmetricBinding = false;
    protected boolean _untOptimize = false;
    protected boolean _useStandardFaultCodes = false;

    protected void processPrivateConfig(OMDocument oMDocument) throws SoapSecurityException {
        String string;
        int n;
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("processPrivateConfig(");
            ((StringBuffer)object).append("OMDocument pconfig[").append(oMDocument).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = oMDocument.getOMDocumentElement();
        boolean bl = false;
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is true; getting FIPS algorithms");
            }
            bl = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is false; getting non-FIPS algorithms");
            }
            bl = false;
        }
        ArrayList arrayList = DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "Transform");
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "algorithm");
            this._allowedTransforms.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed Transforms:", new Object[]{this._allowedTransforms});
        }
        if (this._allowedTransforms.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s11");
        }
        arrayList = DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "canonicalizationMethod");
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "algorithm");
            this._allowedCanonicalizationMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed canonicalizationMethods:", new Object[]{this._allowedCanonicalizationMethods});
        }
        if (this._allowedCanonicalizationMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s12");
        }
        arrayList = bl ? DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "fipsSignatureMethod") : DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "signatureMethod");
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "algorithm");
            this._allowedSignatureMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed signatureMethods:", new Object[]{this._allowedSignatureMethods});
        }
        if (this._allowedSignatureMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s13");
        }
        arrayList = bl ? DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "fipsDigestMethod") : DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "digestMethod");
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "algorithm");
            this._allowedDigestMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed digestMethods:", new Object[]{this._allowedDigestMethods});
        }
        if (this._allowedDigestMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s14");
        }
        arrayList = bl ? DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "fipsEncryptionMethod") : DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "encryptionMethod");
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "algorithm");
            this._allowedDataEncryptionMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed encryptionMethods:", new Object[]{this._allowedDataEncryptionMethods});
        }
        if (this._allowedDataEncryptionMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s15");
        }
        arrayList = bl ? DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "fipsKeyEncryptionMethod") : DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "keyEncryptionMethod");
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "algorithm");
            if (!ConfigValidation.isAlgoSupportedByRuntime(string)) continue;
            this._allowedKeyEncryptionMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed keyEncryptionMethods:", new Object[]{this._allowedKeyEncryptionMethods});
        }
        if (this._allowedKeyEncryptionMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s16");
        }
        arrayList = DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "KeyInfoContentConsumer");
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "class");
            this._defaultKeyInfoContentConsumers.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default KeyInfoContentConsumer:", new Object[]{this._defaultKeyInfoContentConsumers});
        }
        if (this._defaultKeyInfoContentConsumers.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6711W");
        }
        arrayList = DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "TokenConsumer");
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "class");
            this._defaultTokenConsumers.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default TokenConsumer:", new Object[]{this._defaultTokenConsumers});
        }
        if (this._defaultTokenConsumers.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6712W");
        }
        arrayList = DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "JAASConfig");
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "name");
            this._defaultJAASConfigs.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default JAAS configuration:", new Object[]{this._defaultJAASConfigs});
        }
        if (this._defaultJAASConfigs.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6713W");
        }
        arrayList = DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "CallbackHandler");
        for (n = 0; n < arrayList.size(); ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "class");
            this._defaultCallbackHandlers.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default CallbackHandler:", new Object[]{this._defaultCallbackHandlers});
        }
        if (this._defaultCallbackHandlers.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6717W");
        }
        arrayList = DOMUtil.getElementsByTagNameNS((OMNode)object, "http://www.ibm.com/xml/soapsec/config", "KeyLocator");
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            string = DOMUtils.getAttribute((OMElement)arrayList.get(n), "class");
            this._defaultKeyLocators.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default KeyLocator:", new Object[]{this._defaultKeyLocators});
        }
        if (this._defaultKeyLocators.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6714W");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processPrivateConfig(Document pconfig)");
        }
    }

    @Override
    public void validate() throws SoapSecurityException {
        this.validate(false, false, null);
    }

    public void validate(boolean bl, Map map) throws SoapSecurityException {
        this.validate(bl, false, map);
    }

    public void validate(boolean bl, boolean bl2, Map map) throws SoapSecurityException {
        KeyInfoConsumerConfImpl keyInfoConsumerConfImpl;
        Object object;
        String string;
        Object object2;
        Object object3;
        String string2;
        String string3;
        PrivateCommonConfig.ReferencePartConfImpl referencePartConfImpl;
        int n;
        int string4;
        int n2;
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("validate(");
            stringBuffer.append("boolean defaultConfig[").append(bl).append("], ");
            stringBuffer.append("boolean defaultTokenConsumer[").append(bl2).append("], ");
            stringBuffer.append("Map nameToken[").append(map).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        Iterator<Configuration> iterator = this._requiredIntegralParts.iterator();
        while (iterator.hasNext()) {
            n2 = 0;
            string4 = 0;
            n = 0;
            referencePartConfImpl = (PrivateCommonConfig.ReferencePartConfImpl)iterator.next();
            referencePartConfImpl.validate();
            for (PrivateCommonConfig.PartConfImpl partConfImpl : referencePartConfImpl._parts) {
                partConfImpl.validate();
                if (partConfImpl.isNonce()) {
                    ++string4;
                } else if (partConfImpl.isTimestamp()) {
                    ++n;
                } else {
                    ++n2;
                }
                string3 = partConfImpl._dialect;
                string2 = partConfImpl._keyword;
                if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(string3)) {
                    int n4 = ConfigUtil.isIntegralWASDialect(string2);
                    if (n4 == 1) {
                        if (!partConfImpl.isTimestamp()) continue;
                        throw new SoapSecurityException("security.wssecurity.TimestampGenerator.s02");
                    }
                    if (n4 >= 0) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", string2, partConfImpl.toString());
                }
                if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(string3)) {
                    if (string2 != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", "SignedElements");
                }
                if (com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER.equals(string3)) {
                    if (partConfImpl._headerNamespace != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s20", this.toString());
                }
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", string3, partConfImpl.toString());
            }
            if (string4 <= 0 && n <= 0 || n2 > 0) continue;
            throw new SoapSecurityException("security.wssecurity.PrivateConsumerConfig.s36");
        }
        iterator = this._requiredConfidentialParts.iterator();
        while (iterator.hasNext()) {
            n2 = 0;
            string4 = 0;
            n = 0;
            referencePartConfImpl = (PrivateCommonConfig.ReferencePartConfImpl)iterator.next();
            referencePartConfImpl.validate();
            for (PrivateCommonConfig.PartConfImpl partConfImpl : referencePartConfImpl._parts) {
                partConfImpl.validate();
                if (partConfImpl.isNonce()) {
                    ++string4;
                } else if (partConfImpl.isTimestamp()) {
                    ++n;
                } else {
                    ++n2;
                }
                string3 = partConfImpl._dialect;
                string2 = partConfImpl._keyword;
                if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(string3)) {
                    if (ConfigUtil.isConfidentialWASDialect(string2) >= 0) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", string2, partConfImpl.toString());
                }
                if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(string3)) {
                    if (string2 != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", "EncryptedElements");
                }
                if (com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER.equals(string3)) {
                    if (partConfImpl._headerNamespace != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s20", this.toString());
                }
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", string3, partConfImpl.toString());
            }
            if (string4 <= 0 && n <= 0 || n2 > 0) continue;
            throw new SoapSecurityException("security.wssecurity.PrivateConsumerConfig.s36");
        }
        for (TokenConsumerConfImpl tokenConsumerConfImpl : this._tokenConsumers) {
            String string5 = GetJAASConfigInfo.isJaasConfigOurs(tokenConsumerConfImpl.getJAASConfig());
            if (string5 == null) continue;
            tokenConsumerConfImpl._properties.put("com.ibm.ws.wssecurity.token.ourLoginConfig", string5);
        }
        boolean bl3 = false;
        n = 0;
        for (TokenConsumerConfImpl tokenConsumerConfImpl : this._tokenConsumers) {
            QName qName = tokenConsumerConfImpl.getType();
            if (!com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(qName) && !com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(qName) || tokenConsumerConfImpl.getProperties().get("com.ibm.ws.wssecurity.token.ourLoginConfig") == null) continue;
            object3 = (String)tokenConsumerConfImpl.getCallbackHandler().getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
            if (ConfigUtil.isTrue((String)object3)) {
                tokenConsumerConfImpl._properties.put("com.ibm.ws.wssecurity.token.isUntIdaConsumer", "true");
                n = 1;
                continue;
            }
            bl3 = true;
        }
        if (n != 0 && bl3) {
            this._untOptimize = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_untOptimize=" + this._untOptimize);
        }
        if (bl || bl2) {
            HashMap<QName, TokenConsumerConfImpl> hashMap = new HashMap<QName, TokenConsumerConfImpl>();
            for (TokenConsumerConfImpl tokenConsumerConfImpl : this._tokenConsumers) {
                hashMap.put(tokenConsumerConfImpl.getType(), tokenConsumerConfImpl);
            }
            for (TokenConsumerConfImpl tokenConsumerConfImpl : this._requiredSecurityTokens) {
                object3 = tokenConsumerConfImpl.getType();
                object2 = (TokenConsumerConfImpl)hashMap.get(object3);
                if (object2 == null) {
                    throw SoapSecurityException.format("security.wssecurity.WSEC6819E", tokenConsumerConfImpl._name, ((QName)object3).toString());
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Found token consumer of type [" + object3 + "].");
            }
        } else {
            for (TokenConsumerConfImpl tokenConsumerConfImpl : this._requiredSecurityTokens) {
                if (this._tokenConsumers.contains(tokenConsumerConfImpl)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could NOT find token consumer [" + tokenConsumerConfImpl + "].");
                }
                throw SoapSecurityException.format("security.wssecurity.WSEC6820E", tokenConsumerConfImpl._name);
            }
        }
        for (SignatureConsumerConfImpl signatureConsumerConfImpl : this._signatureConsumers) {
            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl;
            int n3;
            signatureConsumerConfImpl.validate(bl);
            List<KeyInfoContentConsumerConfig> list = signatureConsumerConfImpl.getSigningKeyInfo().getContentConsumers();
            if (list != null) {
                for (n3 = 0; n3 < list.size(); ++n3) {
                    TokenConsumerConfig tokenConsumerConfig;
                    object2 = list.get(n3);
                    if (object2 == null || (tokenConsumerConfig = object2.getTokenConsumer()) == null) continue;
                    string = tokenConsumerConfig.getType().getLocalPart();
                    if (this._symmetricBinding) {
                        if (this._symmetricSignatureTokenAssertion == null || string == null || string.equals(object = this._symmetricSignatureTokenAssertion.getTokentType().getLocalPart())) continue;
                        Tr.error(tc, "Token Consumer token type defined in bindings," + string + ", does not match Signature Token type" + " defined in the policy.");
                        throw SoapSecurityException.format("Token Consumer token type defined in bindings," + string + ", does not match Signature Token type" + " defined in the policy.");
                    }
                    if (this._request) {
                        object = (PrivateCommonConfig.TokenAssertion)this._initiatorSignatureTokens.get(string);
                        if (object != null) continue;
                        Tr.error(tc, "Token Consumer token type defined in bindings," + string + ", does not match Initiator Signature Token type" + " defined in the policy.");
                        throw SoapSecurityException.format("Token Consumer token type defined in bindings," + string + ", does not match Initiator Signature Token type" + " defined in the policy.");
                    }
                    object = (PrivateCommonConfig.TokenAssertion)this._recipientSignatureTokens.get(string);
                    if (object != null) continue;
                    Tr.error(tc, "Token Consumer token type defined in bindings," + string + ", does not match Initiator Signature Token type" + " defined in the policy.");
                    throw SoapSecurityException.format("Token Consumer token type defined in bindings," + string + ", does not match Initiator Signature Token type" + " defined in the policy.");
                }
            }
            if ((algorithmConfImpl = signatureConsumerConfImpl._canonicalizationMethod) != null) {
                algorithmConfImpl.validate();
                if (!this._allowedCanonicalizationMethods.contains(algorithmConfImpl._algorithm)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s08", algorithmConfImpl._algorithm);
                }
            }
            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl2 = signatureConsumerConfImpl._signatureMethod;
            n3 = 0;
            object2 = null;
            if (algorithmConfImpl2 != null) {
                algorithmConfImpl2.validate();
                if (!this._allowedSignatureMethods.contains(algorithmConfImpl2._algorithm)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s09", algorithmConfImpl2._algorithm);
                }
                object2 = algorithmConfImpl2._algorithm;
                n3 = ConfigUtil.isSecretKeyAlgorithm((String)object2) ? 1 : 0;
            }
            for (PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl : signatureConsumerConfImpl.getReferences()) {
                signingReferenceConfImpl.validate();
                PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl3 = signingReferenceConfImpl._digestMethod;
                if (algorithmConfImpl3 != null) {
                    algorithmConfImpl3.validate();
                    if (!this._allowedDigestMethods.contains(algorithmConfImpl3._algorithm)) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s11", algorithmConfImpl3._algorithm);
                    }
                }
                boolean bl4 = false;
                for (PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl4 : signingReferenceConfImpl.getTransforms()) {
                    algorithmConfImpl4.validate();
                    if (!this._allowedTransforms.contains(algorithmConfImpl4._algorithm)) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s12", algorithmConfImpl4._algorithm);
                    }
                    if ("http://www.w3.org/2002/07/decrypt#XML".equals(algorithmConfImpl4._algorithm)) {
                        signatureConsumerConfImpl._isDecryptionXformEnabled = true;
                        continue;
                    }
                    if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(algorithmConfImpl4._algorithm)) continue;
                    bl4 = true;
                }
            }
            keyInfoConsumerConfImpl = signatureConsumerConfImpl._signingKeyInfo;
            keyInfoConsumerConfImpl.validate();
            for (KeyInfoContentConsumerConfImpl keyInfoContentConsumerConfImpl : keyInfoConsumerConfImpl._contentConsumers) {
                keyInfoContentConsumerConfImpl.validate();
            }
            this.checkIdentity(signatureConsumerConfImpl, this._signatureConsumers);
        }
        int n4 = this._signatureConsumers.size();
        if (n4 > 1) {
            for (SignatureConsumerConfImpl signatureConsumerConfImpl : this._signatureConsumers) {
                keyInfoConsumerConfImpl = signatureConsumerConfImpl._signingKeyInfo;
                for (SignatureConsumerConfImpl signatureConsumerConfImpl2 : this._signatureConsumers) {
                    if (signatureConsumerConfImpl.equals(signatureConsumerConfImpl2)) continue;
                    keyInfoConsumerConfImpl._otherContentConsumers.addAll(signatureConsumerConfImpl2._signingKeyInfo._contentConsumers);
                }
            }
        }
        for (EncryptionConsumerConfImpl encryptionConsumerConfImpl : this._encryptionConsumers) {
            encryptionConsumerConfImpl.validate(bl);
            List<KeyInfoContentConsumerConfig> list = encryptionConsumerConfImpl.getEncryptionKeyInfo().getContentConsumers();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    TokenConsumerConfig tokenConsumerConfig;
                    object2 = list.get(i);
                    if (object2 == null || (tokenConsumerConfig = object2.getTokenConsumer()) == null) continue;
                    string = tokenConsumerConfig.getType().getLocalPart();
                    if (this._symmetricBinding) {
                        if (this._symmetricEncryptionTokenAssertion == null || string == null || string.equals(object = this._symmetricEncryptionTokenAssertion.getTokentType().getLocalPart())) continue;
                        Tr.error(tc, "Token Consumer token type defined in bindings," + string + ", does not match Encryption Token type" + " defined in the policy.");
                        throw SoapSecurityException.format("Token Consumer token type defined in bindings," + string + ", does not match Encryption Token type" + " defined in the policy.");
                    }
                    if (this._request) {
                        object = (PrivateCommonConfig.TokenAssertion)this._recipientEncryptionTokens.get(string);
                        if (object != null) continue;
                        Tr.error(tc, "Token Consumer token type defined in bindings," + string + ", does not match Initiator Encryption Token type " + "defined in the policy.");
                        throw SoapSecurityException.format("Token Consumer token type defined in bindings," + string + ", does not match Initiator Encryption Token type " + "defined in the policy.");
                    }
                    object = (PrivateCommonConfig.TokenAssertion)this._initiatorEncryptionTokens.get(string);
                    if (object != null) continue;
                    Tr.error(tc, "Token Consumer token type defined in bindings," + string + ", does not match Initiator Encryption Token type defined in the policy.");
                    throw SoapSecurityException.format("Token Consumer token type defined in bindings," + string + ", does not match Initiator Encryption Token type defined in the policy.");
                }
            }
            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl = encryptionConsumerConfImpl._dataEncryptionMethod;
            algorithmConfImpl.validate();
            if (!this._allowedDataEncryptionMethods.contains(algorithmConfImpl._algorithm)) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s14", algorithmConfImpl._algorithm);
            }
            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl5 = encryptionConsumerConfImpl._keyEncryptionMethod;
            if (algorithmConfImpl5 != null) {
                algorithmConfImpl5.validate();
                if (!this._allowedKeyEncryptionMethods.contains(algorithmConfImpl5._algorithm)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s15", algorithmConfImpl5._algorithm);
                }
            }
            keyInfoConsumerConfImpl = encryptionConsumerConfImpl._encryptionKeyInfo;
            keyInfoConsumerConfImpl.validate();
            for (KeyInfoContentConsumerConfImpl keyInfoContentConsumerConfImpl : keyInfoConsumerConfImpl._contentConsumers) {
                keyInfoContentConsumerConfImpl.validate();
            }
            this.checkIdentity(encryptionConsumerConfImpl, this._encryptionConsumers);
        }
        n4 = this._encryptionConsumers.size();
        if (n4 > 1) {
            for (EncryptionConsumerConfImpl encryptionConsumerConfImpl : this._encryptionConsumers) {
                keyInfoConsumerConfImpl = encryptionConsumerConfImpl._encryptionKeyInfo;
                for (EncryptionConsumerConfImpl encryptionConsumerConfImpl2 : this._encryptionConsumers) {
                    if (encryptionConsumerConfImpl.equals(encryptionConsumerConfImpl2)) continue;
                    keyInfoConsumerConfImpl._otherContentConsumers.addAll(encryptionConsumerConfImpl2._encryptionKeyInfo._contentConsumers);
                }
            }
        }
        for (TokenConsumerConfImpl tokenConsumerConfImpl : this._tokenConsumers) {
            tokenConsumerConfImpl.validate();
            PrivateCommonConfig.CallbackHandlerConfImpl callbackHandlerConfImpl = tokenConsumerConfImpl._callbackHandler;
            if (callbackHandlerConfImpl != null) {
                PrivateCommonConfig.KeyInformationConfImpl keyInformationConfImpl;
                callbackHandlerConfImpl.validate();
                PrivateCommonConfig.KeyStoreConfImpl keyStoreConfImpl = callbackHandlerConfImpl._keyStore;
                if (keyStoreConfImpl != null) {
                    keyStoreConfImpl.validate();
                }
                if ((keyInformationConfImpl = callbackHandlerConfImpl._keyInformation) != null) {
                    keyInformationConfImpl.validate();
                }
                if ((keyStoreConfImpl = callbackHandlerConfImpl._trustAnchor) != null) {
                    keyStoreConfImpl.validate();
                }
            }
            if (!this._requiredSecurityTokens.contains(tokenConsumerConfImpl)) continue;
            if (tokenConsumerConfImpl._usedForVerification) {
                throw SoapSecurityException.format("security.wssecurity.WSEC6821E", tokenConsumerConfImpl._name);
            }
            if (!tokenConsumerConfImpl._usedForDecryption) continue;
            throw SoapSecurityException.format("security.wssecurity.WSEC6822E", tokenConsumerConfImpl._name);
        }
        if (this._timestampConsumer != null) {
            int n7;
            String string6;
            this._timestampConsumer.validate();
            String string7 = (String)this._timestampConsumer._properties.get(Constants.WSSECURITY_TIMESTAMP_DIALECT);
            if (string7 != null && com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(string7) && (string6 = (String)this._timestampConsumer._properties.get(Constants.WSSECURITY_TIMESTAMP_KEYWORD)) != null && (n7 = ConfigUtil.isTimestampWASDialect(string6)) < 0) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", string6, this._timestampConsumer.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate(boolean, Map)");
        }
    }

    @Override
    public String getMyActor() {
        return this._myActor;
    }

    @Override
    public boolean isUltimateReceiver() {
        return this._ultimateReceiver;
    }

    @Override
    public boolean isNonceCacheDistributed() {
        return this._nonceCacheDistributed;
    }

    @Override
    public Set<String> getAllowedTransforms() {
        return this._allowedTransforms;
    }

    @Override
    public Set<String> getAllowedCanonicalizationMethods() {
        return this._allowedCanonicalizationMethods;
    }

    @Override
    public Set<String> getAllowedSignatureMethods() {
        return this._allowedSignatureMethods;
    }

    @Override
    public Set<String> getAllowedDigestMethods() {
        return this._allowedDigestMethods;
    }

    @Override
    public Set<String> getAllowedDataEncryptionMethods() {
        return this._allowedDataEncryptionMethods;
    }

    @Override
    public Set<String> getAllowedKeyEncryptionMethods() {
        return this._allowedKeyEncryptionMethods;
    }

    @Override
    public WSSAlgorithmFactory getAlgorithmFactory() {
        return this._algorithmFactory;
    }

    @Override
    public boolean isVerificationRequired() {
        return this._verificationRequired;
    }

    @Override
    public boolean isDecryptionRequired() {
        return this._decryptionRequired;
    }

    @Override
    public boolean isTokenRequired() {
        return this._tokenRequired;
    }

    @Override
    public boolean isLoginRequired() {
        return this._loginRequired;
    }

    @Override
    public boolean isTimestampRequired() {
        return this._timestampRequired;
    }

    @Override
    public Set<ReferencePartConfig> getRequiredIntegralParts() {
        return this._requiredIntegralParts;
    }

    @Override
    public Set<ReferencePartConfig> getRequiredConfidentialParts() {
        return this._requiredConfidentialParts;
    }

    @Override
    public Set<TokenConsumerConfig> getRequiredSecurityTokens() {
        return this._requiredSecurityTokens;
    }

    @Override
    public Set<CallerConfig> getCallers() {
        return this._callers;
    }

    @Override
    public Set<SignatureConsumerConfig> getSignatureConsumers() {
        return this._signatureConsumers;
    }

    @Override
    public Set<EncryptionConsumerConfig> getEncryptionConsumers() {
        return this._encryptionConsumers;
    }

    @Override
    public Set<TokenConsumerConfig> getTokenConsumers() {
        return this._tokenConsumers;
    }

    @Override
    public TimestampConsumerConfig getTimestampConsumer() {
        return this._timestampConsumer;
    }

    @Override
    public NonceManager getNonceManager() {
        return this._nonceManager;
    }

    @Override
    public CertCacheManager getCertManager() {
        return this._certManager;
    }

    @Override
    public int getTimestampMaxAge() {
        return this._timestampMaxAge;
    }

    @Override
    public int getTimestampClockSkew() {
        return this._timestampClockSkew;
    }

    @Override
    public boolean isUserDefinedComponentsUsed() {
        return this._userDefinedComponentsUsed;
    }

    @Override
    public boolean getUntOptimize() {
        return this._untOptimize;
    }

    @Override
    public boolean getUseStandardFaultCodes() {
        return this._useStandardFaultCodes;
    }

    @Override
    public Map<Object, Object> getProperties() {
        return this._properties;
    }

    @Override
    public Object getProperty(Object object) {
        if (this._properties != null) {
            return this._properties.get(object);
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
        stringBuffer.append("myActor=[").append(this._myActor).append("], ");
        stringBuffer.append("ultimateReceiver=[").append(this._ultimateReceiver).append("], ");
        stringBuffer.append("nonceCacheDistributed=[").append(this._nonceCacheDistributed).append("], ");
        stringBuffer.append("allowedTransforms=[").append(this._allowedTransforms).append("], ");
        stringBuffer.append("allowedCanonicalizations=[").append(this._allowedCanonicalizationMethods).append("], ");
        stringBuffer.append("allowedSignatures=[").append(this._allowedSignatureMethods).append("], ");
        stringBuffer.append("allowedDigests=[").append(this._allowedDigestMethods).append("], ");
        stringBuffer.append("allowedDataEncryptions=[").append(this._allowedDataEncryptionMethods).append("], ");
        stringBuffer.append("allowedKeyEncryptions=[").append(this._allowedKeyEncryptionMethods).append("], ");
        stringBuffer.append("algorithmFactory=[").append(this._algorithmFactory).append("], ");
        stringBuffer.append("verificationRequired=[").append(this._verificationRequired).append("], ");
        stringBuffer.append("decryptionRequired=[").append(this._decryptionRequired).append("], ");
        stringBuffer.append("tokenRequired=[").append(this._tokenRequired).append("], ");
        stringBuffer.append("timestampRequired=[").append(this._timestampRequired).append("], ");
        stringBuffer.append("requiredIntegralParts=[").append(this._requiredIntegralParts).append("], ");
        stringBuffer.append("requiredConfidentialParts=[").append(this._requiredConfidentialParts).append("], ");
        stringBuffer.append("callers=[").append(this._callers).append("], ");
        stringBuffer.append("signatureConsumers=[").append(this._signatureConsumers).append("], ");
        stringBuffer.append("encryptionConsumers=[").append(this._encryptionConsumers).append("], ");
        stringBuffer.append("tokenConsumers=[").append(this._tokenConsumers).append("], ");
        stringBuffer.append("timestampConsumer=[").append(this._timestampConsumer).append("], ");
        stringBuffer.append("nonceManager=[").append(this._nonceManager).append("], ");
        stringBuffer.append("timestampMaxAge=[").append(this._timestampMaxAge).append("], ");
        stringBuffer.append("timestampClockSkew=[").append(this._timestampClockSkew).append("], ");
        stringBuffer.append("userDefinedComponentsUsed=[").append(this._userDefinedComponentsUsed).append("], ");
        stringBuffer.append("untOptimize=[").append(this._untOptimize).append("], ");
        stringBuffer.append("properties=[").append(this._properties).append("]");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void checkIdentity(SignatureConsumerConfImpl signatureConsumerConfImpl, Set<SignatureConsumerConfig> set) {
        if (set.size() > 1) {
            String string = signatureConsumerConfImpl._canonicalizationMethod._algorithm;
            String string2 = signatureConsumerConfImpl._signatureMethod._algorithm;
            List<SigningReferenceConfig> list = signatureConsumerConfImpl._references;
            for (SignatureConsumerConfImpl signatureConsumerConfImpl2 : set) {
                if (signatureConsumerConfImpl2.equals(signatureConsumerConfImpl) || !string.equals(signatureConsumerConfImpl2._canonicalizationMethod._algorithm) || !string2.equals(signatureConsumerConfImpl2._signatureMethod._algorithm)) continue;
                for (PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl : list) {
                    List<VerifiedConfig> list2 = signatureConsumerConfImpl._identity.get(signingReferenceConfImpl);
                    if (list2 == null) {
                        list2 = new ArrayList<VerifiedConfig>();
                        signatureConsumerConfImpl._identity.put(signingReferenceConfImpl, list2);
                    }
                    String string3 = signingReferenceConfImpl._digestMethod._algorithm;
                    HashSet<String> hashSet = new HashSet<String>();
                    for (PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl : signingReferenceConfImpl._transforms) {
                        hashSet.add(algorithmConfImpl._algorithm);
                    }
                    for (PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl2 : signatureConsumerConfImpl2._references) {
                        if (!string3.equals(signingReferenceConfImpl2._digestMethod._algorithm)) continue;
                        boolean bl = true;
                        for (PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl : signingReferenceConfImpl2._transforms) {
                            if (hashSet.contains(algorithmConfImpl._algorithm)) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                        list2.add(new VerifiedConfig(signatureConsumerConfImpl2, signingReferenceConfImpl2));
                    }
                }
            }
        }
    }

    private void checkIdentity(EncryptionConsumerConfImpl encryptionConsumerConfImpl, Set<EncryptionConsumerConfig> set) {
        if (set.size() > 1) {
            String string = encryptionConsumerConfImpl._dataEncryptionMethod._algorithm;
            String string2 = encryptionConsumerConfImpl._keyEncryptionMethod == null ? null : encryptionConsumerConfImpl._keyEncryptionMethod._algorithm;
            for (EncryptionConsumerConfImpl encryptionConsumerConfImpl2 : set) {
                if (encryptionConsumerConfImpl2.equals(encryptionConsumerConfImpl) || !string.equals(encryptionConsumerConfImpl2._dataEncryptionMethod._algorithm)) continue;
                PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl = encryptionConsumerConfImpl2._keyEncryptionMethod;
                if (string2 == null ? algorithmConfImpl != null : algorithmConfImpl == null || !string2.equals(algorithmConfImpl._algorithm)) continue;
                encryptionConsumerConfImpl._identity.add(encryptionConsumerConfImpl2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyInfoContentConsumerConfImpl
    implements KeyInfoContentConsumerConfig {
        public String _className = null;
        public KeyInfoContentConsumerComponent _instance = null;
        public String _keyName = null;
        public TokenConsumerConfImpl _tokenConsumer = null;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();

        @Override
        public void validate() throws SoapSecurityException {
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s25", this.toString());
            }
        }

        @Override
        public KeyInfoContentConsumerComponent getInstance() {
            return this._instance;
        }

        @Override
        public String getKeyName() {
            return this._keyName;
        }

        @Override
        public TokenConsumerConfig getTokenConsumer() {
            return this._tokenConsumer;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("className=[").append(this._className).append("], ");
            stringBuffer.append("tokenConsumer=[").append(this._tokenConsumer).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyInfoConsumerConfImpl
    implements KeyInfoConsumerConfig {
        public List<KeyInfoContentConsumerConfig> _contentConsumers = null;
        public final List<KeyInfoContentConsumerConfig> _otherContentConsumers = new ArrayList<KeyInfoContentConsumerConfig>();

        @Override
        public void validate() throws SoapSecurityException {
            if (this._contentConsumers == null || this._contentConsumers.isEmpty()) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s24", this.toString());
            }
        }

        @Override
        public List<KeyInfoContentConsumerConfig> getContentConsumers() {
            return this._contentConsumers;
        }

        @Override
        public List<KeyInfoContentConsumerConfig> getOtherContentConsumers() {
            return this._otherContentConsumers;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("contentConsumers=[").append(this._contentConsumers).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimestampConsumerConfImpl
    implements TimestampConsumerConfig {
        public String _actor = null;
        public int _timestampMaxAge = 300;
        public int _timestampClockSkew = 180;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();

        @Override
        public void validate() throws SoapSecurityException {
        }

        @Override
        public String getActor() {
            return this._actor;
        }

        @Override
        public int getTimestampMaxAge() {
            return this._timestampMaxAge;
        }

        @Override
        public int getTimestampClockSkew() {
            return this._timestampClockSkew;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("actor=[").append(this._actor).append("], ");
            stringBuffer.append("timestampMaxAge=[").append(this._timestampMaxAge).append("], ");
            stringBuffer.append("timestampClockSkew=[").append(this._timestampClockSkew).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TokenConsumerConfImpl
    implements TokenConsumerConfig {
        public String _name = null;
        public String _className = null;
        public TokenConsumerComponent _instance = null;
        public QName _type = null;
        public String _jaasConfig = null;
        public final Map<Object, Object> _jaasConfigProperties = new HashMap<Object, Object>();
        public PrivateCommonConfig.CallbackHandlerConfImpl _callbackHandler = null;
        public boolean _usedForVerification = false;
        public boolean _usedForDecryption = false;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();
        private int _hash;

        public TokenConsumerConfImpl() {
        }

        public TokenConsumerConfImpl(TokenConsumerConfImpl tokenConsumerConfImpl) {
            this._name = tokenConsumerConfImpl._name;
            this._className = tokenConsumerConfImpl._className;
            this._instance = tokenConsumerConfImpl._instance;
            this._type = tokenConsumerConfImpl._type;
            this._jaasConfig = tokenConsumerConfImpl._jaasConfig;
            tokenConsumerConfImpl._jaasConfigProperties.putAll(this._jaasConfigProperties);
            this._callbackHandler = tokenConsumerConfImpl._callbackHandler;
            this._usedForVerification = tokenConsumerConfImpl._usedForVerification;
            this._usedForDecryption = tokenConsumerConfImpl._usedForDecryption;
            this._properties.putAll(tokenConsumerConfImpl._properties);
            this._hash = tokenConsumerConfImpl._hash;
        }

        @Override
        public void validate() throws SoapSecurityException {
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s22", this.toString());
            }
            if (this._type == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s23", this.toString());
            }
            if (this._jaasConfig == null) {
                throw SoapSecurityException.format("security.wssecurity.WSEC6834E", this.toString());
            }
        }

        public TokenConsumerComponent getInstance() {
            return this._instance;
        }

        @Override
        public QName getType() {
            return this._type;
        }

        @Override
        public String getJAASConfig() {
            return this._jaasConfig;
        }

        @Override
        public Map<Object, Object> getJAASConfigProperties() {
            return this._jaasConfigProperties;
        }

        @Override
        public CallbackHandlerConfig getCallbackHandler() {
            return this._callbackHandler;
        }

        @Override
        public boolean isUsedForVerification() {
            return this._usedForVerification;
        }

        @Override
        public boolean isUsedForDecryption() {
            return this._usedForDecryption;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public int hashCode() {
            if (this._hash == 0) {
                if (this._name != null) {
                    this._hash = this._name.hashCode();
                }
                if (this._className != null) {
                    this._hash = this._hash * 31 + this._className.hashCode();
                }
                if (this._type != null) {
                    this._hash = this._hash * 31 + this._type.hashCode();
                }
                if (this._jaasConfig != null) {
                    this._hash = this._hash * 31 + this._jaasConfig.hashCode();
                }
                this._hash = this._hash * 31 + ((Object)this._jaasConfigProperties).hashCode();
                if (this._callbackHandler != null) {
                    this._hash = this._hash * 31 + this._callbackHandler.hashCode();
                }
                this._hash = this._hash * 31 + (this._usedForVerification ? 1 : 0);
                this._hash = this._hash * 31 + (this._usedForDecryption ? 1 : 0);
                this._hash = this._hash * 31 + ((Object)this._properties).hashCode();
            }
            return this._hash;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("className=[").append(this._className).append("], ");
            stringBuffer.append("type=[").append(this._type).append("], ");
            stringBuffer.append("jaasConfig=[").append(this._jaasConfig).append("], ");
            stringBuffer.append("jaasConfigProperties=[").append(this._jaasConfigProperties).append("], ");
            stringBuffer.append("callbackHandler=[").append(this._callbackHandler).append("], ");
            stringBuffer.append("usedForVerification=[").append(this._usedForVerification).append("], ");
            stringBuffer.append("usedForDecryption=[").append(this._usedForDecryption).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EncryptionConsumerConfImpl
    implements EncryptionConsumerConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _dataEncryptionMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyEncryptionMethod = null;
        public KeyInfoConsumerConfImpl _encryptionKeyInfo = null;
        public PrivateCommonConfig.ReferencePartConfImpl _reference = null;
        public boolean _isKeyDecryption = false;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();
        public final List<EncryptionConsumerConfig> _identity = new ArrayList<EncryptionConsumerConfig>();

        @Override
        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean bl) throws SoapSecurityException {
            if (this._dataEncryptionMethod == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s19", this.toString());
            }
            if (this._encryptionKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s20", this.toString());
            }
            if (this._reference == null && !bl) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s21", this.toString());
            }
        }

        @Override
        public AlgorithmConfig getDataEncryptionMethod() {
            return this._dataEncryptionMethod;
        }

        @Override
        public AlgorithmConfig getKeyEncryptionMethod() {
            return this._keyEncryptionMethod;
        }

        @Override
        public KeyInfoConsumerConfig getEncryptionKeyInfo() {
            return this._encryptionKeyInfo;
        }

        @Override
        public ReferencePartConfig getReference() {
            return this._reference;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        @Override
        public List<EncryptionConsumerConfig> getIdentityList() {
            return this._identity;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("dataEncryptionMethod=[").append(this._dataEncryptionMethod).append("], ");
            stringBuffer.append("keyEncryptionMethod=[").append(this._keyEncryptionMethod).append("], ");
            stringBuffer.append("encryptionKeyInfo=[").append(this._encryptionKeyInfo).append("], ");
            stringBuffer.append("reference=[").append(this._reference).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SignatureConsumerConfImpl
    implements SignatureConsumerConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _canonicalizationMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _signatureMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyInfoSignature = null;
        public KeyInfoConsumerConfImpl _signingKeyInfo = null;
        public final List<SigningReferenceConfig> _references = new ArrayList<SigningReferenceConfig>();
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();
        public final Map<SigningReferenceConfig, List<VerifiedConfig>> _identity = new HashMap<SigningReferenceConfig, List<VerifiedConfig>>();
        private boolean _isDecryptionXformEnabled = false;

        @Override
        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean bl) throws SoapSecurityException {
            if (this._signingKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s17", this.toString());
            }
            if (this._references.isEmpty() && !bl) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s18", this.toString());
            }
        }

        @Override
        public AlgorithmConfig getCanonicalizationMethod() {
            return this._canonicalizationMethod;
        }

        @Override
        public AlgorithmConfig getSignatureMethod() {
            return this._signatureMethod;
        }

        @Override
        public AlgorithmConfig getKeyInfoSignature() {
            return this._keyInfoSignature;
        }

        @Override
        public KeyInfoConsumerConfig getSigningKeyInfo() {
            return this._signingKeyInfo;
        }

        @Override
        public List<SigningReferenceConfig> getReferences() {
            return this._references;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        @Override
        public Map<SigningReferenceConfig, List<VerifiedConfig>> getIdentityMap() {
            return this._identity;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("canonicalizationMethod=[").append(this._canonicalizationMethod).append("], ");
            stringBuffer.append("signatureMethod=[").append(this._signatureMethod).append("], ");
            stringBuffer.append("keyInfoSignature=[").append(this._keyInfoSignature).append("], ");
            stringBuffer.append("signingKeyInfo=[").append(this._signingKeyInfo).append("], ");
            stringBuffer.append("refereces=[").append(this._references).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("], ");
            stringBuffer.append("isDecryptionXformEnabled=[").append(this._isDecryptionXformEnabled).append("], ");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        @Override
        public boolean isDecryptionTransformEnabled() {
            return this._isDecryptionXformEnabled;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CallerConfImpl
    implements CallerConfig {
        public String _jaasConfig = null;
        public final Map<Object, Object> _jaasConfigProperties = new HashMap<Object, Object>();
        public PrivateCommonConfig.CallbackHandlerConfImpl _callbackHandler = null;
        public boolean _identityAssertion = false;
        public boolean _anyTrustedIdentity = false;
        public QName _callerIdentity = null;
        public QName _trustedIdentity = null;
        public PrivateCommonConfig.ReferencePartConfImpl _requiredSigningPartReference = null;

        @Override
        public void validate() throws SoapSecurityException {
            if (this._jaasConfig == null) {
                throw SoapSecurityException.format("security.wssecurity.WSEC6834E", this.toString());
            }
            if (this._callerIdentity == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s16", this.toString());
            }
        }

        @Override
        public String getJAASConfig() {
            return this._jaasConfig;
        }

        @Override
        public Map<Object, Object> getJAASConfigProperties() {
            return this._jaasConfigProperties;
        }

        @Override
        public CallbackHandlerConfig getCallbackHandler() {
            return this._callbackHandler;
        }

        @Override
        public boolean useIdentityAssertion() {
            return this._identityAssertion;
        }

        @Override
        public boolean trustAnyTrustedIdentity() {
            return this._anyTrustedIdentity;
        }

        @Override
        public QName getCallerIdentity() {
            return this._callerIdentity;
        }

        @Override
        public QName getTrustedIdentity() {
            return this._trustedIdentity;
        }

        @Override
        public ReferencePartConfig getRequiredSigningPartReference() {
            return this._requiredSigningPartReference;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("jaasConfig=[").append(this._jaasConfig).append("], ");
            stringBuffer.append("jaasConfigProperties=[").append(this._jaasConfigProperties).append("], ");
            stringBuffer.append("callbackHandler=[").append(this._callbackHandler).append("], ");
            stringBuffer.append("useIdentityAssertion=[").append(this._identityAssertion).append("], ");
            stringBuffer.append("trustAnyTrustedIdentity=[").append(this._anyTrustedIdentity).append("], ");
            stringBuffer.append("callerIdentity=[").append(this._callerIdentity).append("], ");
            stringBuffer.append("trustedIdentity=[").append(this._trustedIdentity).append("], ");
            stringBuffer.append("requiredSigningPartReference=[").append(this._requiredSigningPartReference).append("], ");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

