/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.confimpl;

import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.AlgorithmMappingConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.KeyInformationConfig;
import com.ibm.wsspi.wssecurity.core.config.KeyStoreConfig;
import java.security.Provider;
import java.security.cert.CertStore;
import java.security.cert.PKIXBuilderParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.xmlsoap.schemas.ws._2004._08.addressing.EndpointReferenceType;

public abstract class PrivateCommonConfig {
    private static final String comp = "security.wssecurity";
    protected boolean _signatureConfirmationRequired = false;
    protected boolean _request = false;
    protected Map<String, TokenAssertion> _initiatorTokens = null;
    protected Map<String, TokenAssertion> _recipientTokens = null;
    protected Map<String, TokenAssertion> _initiatorSignatureTokens = null;
    protected Map<String, TokenAssertion> _recipientSignatureTokens = null;
    protected Map<String, TokenAssertion> _initiatorEncryptionTokens = null;
    protected Map<String, TokenAssertion> _recipientEncryptionTokens = null;
    protected TokenAssertion _symmetricProtectionTokenAssertion = null;
    protected TokenAssertion _symmetricEncryptionTokenAssertion = null;
    protected TokenAssertion _symmetricSignatureTokenAssertion = null;
    protected String _layout = null;

    public String getLayout() {
        return this._layout;
    }

    public boolean isSignatureConfirmationRequired() {
        return this._signatureConfirmationRequired;
    }

    public boolean isRequest() {
        return this._request;
    }

    public static class TokenAssertion {
        public String _includeToken = null;
        public EndpointReferenceType _issuer = null;
        public QName _tokenType = null;
        public boolean _hasBootStrap = false;
        public boolean _requireDerivedKeys = false;
        public boolean _requireExplicitDerivedKeys = false;
        public boolean _requireImplicitDerivedKeys = false;
        public boolean _requireExternalUriReference = false;

        public EndpointReferenceType getIssuer() {
            return this._issuer;
        }

        public String getIncludeTokenName() {
            return this._includeToken;
        }

        public QName getTokentType() {
            return this._tokenType;
        }

        public boolean requireDerivedKeys() {
            return this._requireDerivedKeys;
        }

        public boolean requireExplicitDerivedKeys() {
            return this._requireExplicitDerivedKeys;
        }

        public boolean requireImplicitDerivedKeys() {
            return this._requireImplicitDerivedKeys;
        }

        public boolean requireExternalUriReference() {
            return this._requireExternalUriReference;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CallbackHandlerConfImpl
    implements CallbackHandlerConfig {
        public String _className = null;
        public CallbackHandler _instance = null;
        public KeyStoreConfImpl _keyStore;
        public KeyInformationConfImpl _keyInformation;
        public boolean _trustAnyCertificate = false;
        public KeyStoreConfImpl _trustAnchor;
        public Provider _provider = null;
        public List<CertStore> _certStores = null;
        public PKIXBuilderParameters _pkixBuilderParams = null;
        public String _userId = null;
        public char[] _userPassword = null;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();

        @Override
        public void validate() throws SoapSecurityException {
            if (this._className == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s05", this.toString());
            }
            if (this._userId == null && this._userPassword != null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s06", this.toString());
            }
        }

        @Override
        public String getClassName() {
            return this._className;
        }

        @Override
        public CallbackHandler getInstance() {
            return this._instance;
        }

        @Override
        public void setInstance(CallbackHandler callbackHandler) {
            this._instance = callbackHandler;
        }

        @Override
        public KeyStoreConfig getResolvingKeyStore() {
            return this._keyStore;
        }

        @Override
        public KeyInformationConfig getKeyInformation() {
            return this._keyInformation;
        }

        @Override
        public boolean isTrustAnyCertificate() {
            return this._trustAnyCertificate;
        }

        @Override
        public KeyStoreConfig getTrustAnchor() {
            return this._trustAnchor;
        }

        @Override
        public Provider getProvider() {
            return this._provider;
        }

        @Override
        public List<CertStore> getCertStores() {
            return this._certStores;
        }

        @Override
        public PKIXBuilderParameters getPKIXBuilderParameters() {
            return this._pkixBuilderParams;
        }

        @Override
        public String getUserId() {
            return this._userId;
        }

        @Override
        public char[] getUserPassword() {
            return this._userPassword;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("className=[").append(this._className).append("], ");
            stringBuffer.append("keyStore=[").append(this._keyStore).append("], ");
            stringBuffer.append("keyInformation=[").append(this._keyInformation).append("], ");
            stringBuffer.append("trustAnyCertificate=[").append(this._trustAnyCertificate).append("], ");
            stringBuffer.append("provider=[").append(this._provider).append("], ");
            stringBuffer.append("pkixBuilderParams=[").append(this._pkixBuilderParams).append("], ");
            stringBuffer.append("userId=[").append(this._userId).append("], ");
            stringBuffer.append("userPassword=[XXXXXXXX], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class KeyInformationConfImpl
    implements KeyInformationConfig {
        public String _alias = null;
        public String _keypass = null;
        public String _name = null;

        public void validate() throws SoapSecurityException {
            if (this._alias == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s16", this.toString());
            }
            if (this._name == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s17", this.toString());
            }
        }

        public String getAlias() {
            return this._alias;
        }

        public String getKeyPass() {
            return this._keypass;
        }

        public String getName() {
            return this._name;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("alias=[").append(this._alias).append("], ");
            stringBuffer.append("keypass=[XXXXXXXX], ");
            stringBuffer.append("name=[").append(this._name).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class KeyStoreConfImpl
    implements KeyStoreConfig {
        public String _type = null;
        public String _path = null;
        public String _password = null;
        public String _ksRef = null;

        public void validate() throws SoapSecurityException {
            if (this._ksRef == null) {
                if (this._type == null) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s13", this.toString());
                }
                if (this._path == null) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s14", this.toString());
                }
                if (this._password == null) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s15", this.toString());
                }
            } else {
                if (this._type != null || this._path != null || this._password != null) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s19", this.toString());
                }
                if (!ConfigUtil.isValidWSKeyStore(this._ksRef)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s18", this.toString());
                }
            }
        }

        public String getType() {
            return this._type;
        }

        public String getPath() {
            return this._path;
        }

        public String getPassword() {
            return this._password;
        }

        public String getKsRef() {
            return this._ksRef;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("type=[").append(this._type).append("], ");
            stringBuffer.append("path=[").append(this._path).append("], ");
            stringBuffer.append("password=[XXXXXXXX]");
            stringBuffer.append("keyStoreRef=[").append(this._ksRef).append("], ");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class PartConfImpl
    implements ReferencePartConfig.PartConfig {
        public boolean _timestamp = false;
        public boolean _nonce = false;
        public String _dialect = null;
        public String _keyword = null;
        public String _headerName = null;
        public String _headerNamespace = null;

        public void copyAttributesForTimestamp(PartConfImpl partConfImpl) {
            this.copyAttributesForTimestampOrNonce(partConfImpl, true, false);
        }

        public void copyAttributesForNonce(PartConfImpl partConfImpl) {
            this.copyAttributesForTimestampOrNonce(partConfImpl, false, true);
        }

        private void copyAttributesForTimestampOrNonce(PartConfImpl partConfImpl, boolean bl, boolean bl2) {
            if (partConfImpl != null) {
                this._dialect = ConfigUtil.trim(partConfImpl.getDialect());
                this._keyword = ConfigUtil.trim(partConfImpl.getKeyword());
                this._headerName = ConfigUtil.trim(partConfImpl.getHeaderName());
                this._headerNamespace = ConfigUtil.trim(partConfImpl.getHeaderNamespace());
                this._timestamp = bl;
                this._nonce = bl2;
            }
        }

        public void validate() throws SoapSecurityException {
            if (this._dialect == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s09", this.toString());
            }
        }

        public boolean isTimestamp() {
            return this._timestamp;
        }

        public boolean isNonce() {
            return this._nonce;
        }

        public String getDialect() {
            return this._dialect;
        }

        public String getKeyword() {
            return this._keyword;
        }

        public String getHeaderName() {
            return this._headerName;
        }

        public String getHeaderNamespace() {
            return this._headerNamespace;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("timestamp=[").append(this._timestamp).append("], ");
            stringBuffer.append("nonce=[").append(this._nonce).append("], ");
            stringBuffer.append("dialect=[").append(this._dialect).append("], ");
            stringBuffer.append("keyword=[").append(this._keyword).append("], ");
            stringBuffer.append("headerName=[").append(this._headerName).append("], ");
            stringBuffer.append("headerNamespace=[").append(this._headerNamespace).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReferencePartConfImpl
    implements ReferencePartConfig {
        public final Set<Object> _bindings = new HashSet<Object>();
        public final Set<ReferencePartConfig.PartConfig> _parts = new HashSet<ReferencePartConfig.PartConfig>();
        public int _order = -1;
        public boolean _oneOfIntegralParts = false;
        public boolean _callerRequired = false;
        public boolean _trustMethodRequired = false;

        @Override
        public void validate() throws SoapSecurityException {
            if (this._parts.isEmpty()) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s07", this.toString());
            }
            if (this._order < 0) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s08", this.toString());
            }
        }

        @Override
        public Set<Object> getBindings() {
            return this._bindings;
        }

        @Override
        public Set<ReferencePartConfig.PartConfig> getParts() {
            return this._parts;
        }

        @Override
        public int getOrder() {
            return this._order;
        }

        @Override
        public boolean isOneOfIntegralParts() {
            return this._oneOfIntegralParts;
        }

        @Override
        public boolean isCallerRequired() {
            return this._callerRequired;
        }

        @Override
        public boolean isTrustMethodRequired() {
            return this._trustMethodRequired;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("parts=[").append(this._parts).append("], ");
            stringBuffer.append("order=[").append(this._order).append("], ");
            stringBuffer.append("oneOfIntegralParts=[").append(this._oneOfIntegralParts).append("], ");
            stringBuffer.append("callerRequired=[").append(this._callerRequired).append("], ");
            stringBuffer.append("trustMethodRequired=[").append(this._trustMethodRequired).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SigningReferenceConfImpl
    implements SigningReferenceConfig {
        public ReferencePartConfImpl _reference = null;
        public AlgorithmConfImpl _digestMethod = null;
        public final List<AlgorithmConfig> _transforms = new ArrayList<AlgorithmConfig>();
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();

        @Override
        public void validate() throws SoapSecurityException {
            if (this._reference == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s04", this.toString());
            }
            if (this._digestMethod == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s05", this.toString());
            }
            if (this._transforms.isEmpty()) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s06", this.toString());
            }
        }

        @Override
        public ReferencePartConfig getReference() {
            return this._reference;
        }

        @Override
        public AlgorithmConfig getDigestMethod() {
            return this._digestMethod;
        }

        @Override
        public List<AlgorithmConfig> getTransforms() {
            return this._transforms;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("reference=[").append(this._reference).append("], ");
            stringBuffer.append("digestMethod=[").append(this._digestMethod).append("], ");
            stringBuffer.append("transforms=[").append(this._transforms).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AlgorithmMappingConfImpl
    implements AlgorithmMappingConfig {
        public String _factoryName = null;
        public final Set<String> _algorithmURIs = new HashSet<String>();
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();

        @Override
        public void validate() throws SoapSecurityException {
            if (this._factoryName == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s02", this.toString());
            }
            if (this._algorithmURIs.isEmpty()) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s03", this.toString());
            }
        }

        @Override
        public String getFactoryName() {
            return this._factoryName;
        }

        @Override
        public Set<String> getAlgorithmURIs() {
            return this._algorithmURIs;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("factoryName=[").append(this._factoryName).append("], ");
            stringBuffer.append("algorithmURIs=[").append(this._algorithmURIs).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AlgorithmConfImpl
    implements AlgorithmConfig {
        public String _algorithm = null;
        public String _type = null;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();

        @Override
        public void validate() throws SoapSecurityException {
            if (this._algorithm == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s01", this.toString());
            }
        }

        @Override
        public String getAlgorithm() {
            return this._algorithm;
        }

        @Override
        public String getType() {
            return this._type;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("algorithm=[").append(this._algorithm).append("], ");
            stringBuffer.append("type=[").append(this._type).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

