/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands.result;

import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Identity;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityList;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityPart;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class STSTrustAuthenticationRule
implements Serializable {
    private static final long serialVersionUID = 3114328468867164184L;
    private String requiredTokenType;
    private String jaasConfigName;
    private String callbackHandler;
    private Properties[] identities;

    public STSTrustAuthenticationRule(TokenTypeRule tokenTypeRule) {
        this.requiredTokenType = tokenTypeRule.getRequiredTokenTypeURI();
        this.jaasConfigName = tokenTypeRule.getJAASConfigName();
        this.callbackHandler = tokenTypeRule.getCallbackHandler();
        IdentityList identityList = tokenTypeRule.getIdentityList();
        if (identityList == null) {
            this.identities = new Properties[0];
        } else {
            List<Identity> list = identityList.getIdentity();
            this.identities = new Properties[list.size()];
            Iterator<Identity> iterator = list.iterator();
            int n = -1;
            while (iterator.hasNext()) {
                Identity identity = iterator.next();
                Properties properties = new Properties();
                List<IdentityPart> list2 = identity.getIdentityPart();
                for (IdentityPart identityPart : list2) {
                    properties.setProperty(identityPart.getName(), identityPart.getValue());
                }
                this.identities[++n] = properties;
            }
        }
    }

    public String getRequiredTokenType() {
        return this.requiredTokenType;
    }

    public String getJAASConfigName() {
        return this.jaasConfigName;
    }

    public String getCallbackHandler() {
        return this.callbackHandler;
    }

    public Properties[] getIdentities() {
        return this.identities;
    }

    public String toString() {
        String string = "";
        string = string + "RequiredTokenTypeURI: " + this.requiredTokenType + "\n";
        string = string + "JAASConfigName: " + this.jaasConfigName + "\n";
        string = string + "CallbackHandler: " + this.callbackHandler + "\n";
        string = string + "IdentityList:\n";
        for (Properties properties : this.identities) {
            string = string + "  " + properties + "\n";
        }
        return string;
    }
}

