/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.admin.sts.commands.Constants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSCommandProvider
extends CommandProvider {
    public static final String FFDC_ID_1 = "FFDC-1";
    public static final String FFDC_ID_2 = "FFDC-2";
    public static final String FFDC_ID_3 = "FFDC-3";
    public static final String FFDC_ID_4 = "FFDC-4";
    public static final String FFDC_ID_5 = "FFDC-5";
    public static final String FFDC_ID_6 = "FFDC-6";
    public static final String FFDC_ID_7 = "FFDC-7";
    private static HashMap<String, Class> classMap;
    private static HashMap<String, Constructor> creationMap;
    private static HashMap<String, Constructor> loadMap;
    private static TraceComponent tc;
    private static String className;

    @Override
    public AbstractAdminCommand createCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        String string = commandMetadata.getName();
        String string2 = className + ".createCommand(commandName=" + string + ")";
        STSCommandProvider.trEntry(string2);
        Constructor constructor = creationMap.get(string);
        if (constructor == null) {
            STSCommandProvider.trExit(string2);
            STSCommandProvider.trError(new CommandException(AbstractSTSCommand.getMessage("wssecurity.admin.sts.CWWSI9053W")), string, "WSEC0002E", new String[]{string}, FFDC_ID_1);
        }
        AbstractAdminCommand abstractAdminCommand = null;
        try {
            abstractAdminCommand = (AbstractAdminCommand)constructor.newInstance(commandMetadata);
        }
        catch (Exception exception) {
            STSCommandProvider.trExit(string2);
            STSCommandProvider.trError(exception, string, "WSEC0002E", new String[]{string}, FFDC_ID_2);
        }
        STSCommandProvider.trExit(string2);
        return abstractAdminCommand;
    }

    @Override
    public AbstractAdminCommand loadCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        String string = commandData.getName();
        String string2 = className + ".loadCommand(commandName=" + string + ")";
        STSCommandProvider.trEntry(string2);
        Constructor constructor = loadMap.get(string);
        if (constructor == null) {
            STSCommandProvider.trExit(string2);
            STSCommandProvider.trError(new CommandException(AbstractSTSCommand.getMessage("wssecurity.admin.sts.CWWSI9053W")), string, "WSEC0002E", new String[]{string}, FFDC_ID_3);
        }
        AbstractAdminCommand abstractAdminCommand = null;
        try {
            abstractAdminCommand = (AbstractAdminCommand)constructor.newInstance(commandData);
        }
        catch (Exception exception) {
            STSCommandProvider.trExit(string2);
            STSCommandProvider.trError(exception, string, "WSEC0002E", new String[]{string}, FFDC_ID_4);
        }
        STSCommandProvider.trExit(string2);
        return abstractAdminCommand;
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }

    private static void trError(Throwable throwable, String string, String string2, String[] stringArray, String string3) throws CommandNotFoundException {
        if (throwable != null) {
            Tr.processException(throwable, className, string3);
        }
        Tr.error(tc, string2, stringArray);
        throw new CommandNotFoundException(string);
    }

    private static void initialize() {
        className = STSCommandProvider.class.getName();
        tc = Tr.register(STSCommandProvider.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        String string = className + ".initialize()";
        STSCommandProvider.trEntry(string);
        classMap = STSCommandProvider.initializeClassMap();
        creationMap = new HashMap();
        loadMap = new HashMap();
        Set<Map.Entry<String, Class>> set = classMap.entrySet();
        for (Map.Entry<String, Class> entry : set) {
            Constructor constructor;
            String string2 = entry.getKey();
            Class clazz = entry.getValue();
            try {
                constructor = clazz.getConstructor(CommandMetadata.class);
                creationMap.put(string2, constructor);
            }
            catch (Exception exception) {
                STSCommandProvider.trDebug("Failed to access constructor(CommandMetadata) for " + string2);
                FFDCFilter.processException((Throwable)exception, className, "WSEC0002E", FFDC_ID_5);
            }
            try {
                constructor = clazz.getConstructor(CommandData.class);
                loadMap.put(string2, constructor);
            }
            catch (Exception exception) {
                STSCommandProvider.trDebug("Failed to access constructor(CommandData) for " + string2);
                FFDCFilter.processException((Throwable)exception, className, "WSEC0002E", FFDC_ID_6);
            }
        }
        STSCommandProvider.trExit(string);
    }

    private static HashMap<String, Class> initializeClassMap() {
        Object object;
        String string = "initializeClassMap";
        STSCommandProvider.trEntry(string);
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        Field[] fieldArray = Constants.class.getFields();
        HashMap<String, Field> hashMap2 = new HashMap<String, Field>();
        HashMap<String, Field> hashMap3 = new HashMap<String, Field>();
        for (Field field : fieldArray) {
            object = field.getName();
            if (((String)object).startsWith("COMMAND_")) {
                hashMap2.put(((String)object).substring("COMMAND_".length()), field);
                continue;
            }
            if (!((String)object).startsWith("CLASS_")) continue;
            hashMap3.put(((String)object).substring("CLASS_".length()), field);
        }
        Set set = hashMap2.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Field field;
            String string2 = (String)iterator.next();
            field = (Field)hashMap3.get(string2);
            if (field == null) continue;
            object = (Field)hashMap2.get(string2);
            try {
                hashMap.put((String)((Field)object).get(null), (Class)field.get(null));
            }
            catch (Exception exception) {
                STSCommandProvider.trDebug("Could not retrieve fields for command class: " + field.getName());
                FFDCFilter.processException((Throwable)exception, className, "WSEC0002E", FFDC_ID_7);
            }
        }
        STSCommandProvider.trExit(string);
        return hashMap;
    }

    static {
        STSCommandProvider.initialize();
    }
}

