/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSTrustAuthenticationCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.DefaultIssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Identity;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityList;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;

public class RemoveSTSEndpointTrustAuthenticationRule
extends AbstractSTSTrustAuthenticationCommand {
    private static final TraceComponent tc = Tr.register(RemoveSTSEndpointTrustAuthenticationRule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public RemoveSTSEndpointTrustAuthenticationRule(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public RemoveSTSEndpointTrustAuthenticationRule(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        Object object;
        boolean bl;
        String string = "execute";
        RemoveSTSEndpointTrustAuthenticationRule.trEntry(string);
        String string2 = (String)this.getTargetObject();
        RemoveSTSEndpointTrustAuthenticationRule.trDebug("Command target (endpointURI) - " + string2);
        String string3 = null;
        String string4 = null;
        Properties properties = null;
        boolean bl2 = false;
        try {
            string3 = (String)this.getParameter("issuer");
            string4 = (String)this.getParameter("tokenTypeURI");
            properties = (Properties)this.getParameter("identity");
            bl2 = (Boolean)this.getParameter("nullIssuer");
        }
        catch (Exception exception) {
            this.processError(exception);
            RemoveSTSEndpointTrustAuthenticationRule.trExit(string);
            return;
        }
        RemoveSTSEndpointTrustAuthenticationRule.trDebug("Command arg (issuerURI) - " + string3);
        RemoveSTSEndpointTrustAuthenticationRule.trDebug("Command arg (tokenTypeURI) - " + string4);
        RemoveSTSEndpointTrustAuthenticationRule.trDebug("Command arg (identity) - " + properties);
        RemoveSTSEndpointTrustAuthenticationRule.trDebug("Command arg (nullIssuer) - " + bl2);
        boolean bl3 = string3 == null;
        boolean bl4 = string4 == null;
        boolean bl5 = bl = properties == null;
        if (!bl2 && bl3) {
            RemoveSTSEndpointTrustAuthenticationRule.trDebug("Either nullIssuer must be true or issuerURI must be specified.");
            this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9066W"));
            RemoveSTSEndpointTrustAuthenticationRule.trExit(string);
            return;
        }
        if (bl4 && !bl) {
            RemoveSTSEndpointTrustAuthenticationRule.trDebug("tokenTypeURI must be specified if identity is specified.");
            this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9064W"));
            RemoveSTSEndpointTrustAuthenticationRule.trExit(string);
            return;
        }
        STSTargetMap sTSTargetMap = null;
        try {
            sTSTargetMap = this.loadTargets();
        }
        catch (Exception exception) {
            this.processError(exception);
            RemoveSTSEndpointTrustAuthenticationRule.trExit(string);
            return;
        }
        Target target = null;
        try {
            target = this.findTarget(sTSTargetMap, string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            RemoveSTSEndpointTrustAuthenticationRule.trDebug("Specified endpoint not found: " + noSuchElementException.getLocalizedMessage());
            this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException(noSuchElementException.getMessage()));
            RemoveSTSEndpointTrustAuthenticationRule.trExit(string);
            return;
        }
        Identity identity = null;
        List<Identity> list = null;
        TokenTypeRule tokenTypeRule = null;
        List<TokenTypeRule> list2 = null;
        IssuerRule issuerRule = null;
        if (!bl2) {
            RemoveSTSEndpointTrustAuthenticationRule.trDebug("Searching for IssuerRule: " + string3);
            try {
                issuerRule = this.findIssuerRule(sTSTargetMap, target, null, string3);
            }
            catch (NoSuchElementException noSuchElementException) {
                RemoveSTSEndpointTrustAuthenticationRule.trDebug("Could not find IssuerRule with issuerURI: " + string3);
                this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException(noSuchElementException.getMessage()));
                RemoveSTSEndpointTrustAuthenticationRule.trExit(string);
                return;
            }
            list2 = issuerRule.getTokenTypeRule();
        } else {
            RemoveSTSEndpointTrustAuthenticationRule.trDebug("issuerURI not specified. Using DefaultIssuerRule.");
            object = target.getDefaultIssuerRule();
            if (object == null) {
                RemoveSTSEndpointTrustAuthenticationRule.trDebug("Could not find DefaultIssuerRule under target: " + string2);
                this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9071W"));
                RemoveSTSEndpointTrustAuthenticationRule.trExit(string);
                return;
            }
            list2 = ((DefaultIssuerRule)object).getTokenTypeRule();
        }
        if (!bl4) {
            RemoveSTSEndpointTrustAuthenticationRule.trDebug("Searching for TokenTypeRule: " + string4);
            try {
                tokenTypeRule = this.findRule(sTSTargetMap, list2, null, null, string4);
            }
            catch (NoSuchElementException noSuchElementException) {
                RemoveSTSEndpointTrustAuthenticationRule.trDebug("Could not find TokenTypeRule with tokenTypeURI: " + string4);
                this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException(noSuchElementException.getMessage()));
                RemoveSTSEndpointTrustAuthenticationRule.trExit(string);
                return;
            }
            object = tokenTypeRule.getIdentityList();
            if (object == null) {
                RemoveSTSEndpointTrustAuthenticationRule.trDebug("IdentityList not found for TokenTypeRule: " + string4);
                this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9071W"));
                RemoveSTSEndpointTrustAuthenticationRule.trExit(string);
                return;
            }
            list = ((IdentityList)object).getIdentity();
        }
        if (!bl) {
            RemoveSTSEndpointTrustAuthenticationRule.trDebug("Searching for Identity: " + properties);
            try {
                identity = this.findIdentity(sTSTargetMap, tokenTypeRule, null, null, null, properties);
            }
            catch (NoSuchElementException noSuchElementException) {
                RemoveSTSEndpointTrustAuthenticationRule.trDebug("Could not find Identity: " + properties);
                this.processError(RemoveSTSEndpointTrustAuthenticationRule.instantiateCommandException(noSuchElementException.getMessage()));
                RemoveSTSEndpointTrustAuthenticationRule.trExit(string);
                return;
            }
        }
        int n = (bl ? 0 : 1) + (bl4 ? 0 : 1);
        switch (n) {
            case 2: {
                RemoveSTSEndpointTrustAuthenticationRule.trDebug("Removing specified Identity.");
                list.remove(identity);
                if (!list.isEmpty()) break;
                RemoveSTSEndpointTrustAuthenticationRule.trDebug("IdentityList is empty. Remove containing TokenTypeRule.");
            }
            case 1: {
                RemoveSTSEndpointTrustAuthenticationRule.trDebug("Removing specified TokenTypeRule.");
                list2.remove(tokenTypeRule);
                if (!list2.isEmpty()) break;
                RemoveSTSEndpointTrustAuthenticationRule.trDebug("TokenTypeRule list is empty. Remove containing (Default)IssuerRule.");
            }
            case 0: {
                if (issuerRule == null) {
                    RemoveSTSEndpointTrustAuthenticationRule.trDebug("Removing DefaultIssuerRule.");
                    target.setDefaultIssuerRule(null);
                    break;
                }
                RemoveSTSEndpointTrustAuthenticationRule.trDebug("Removing specified IssuerRule.");
                List<IssuerRule> list3 = target.getIssuerRule();
                list3.remove(issuerRule);
                break;
            }
            default: {
                RemoveSTSEndpointTrustAuthenticationRule.trDebug("Control flow should not have reached here.");
                this.processError(new Exception());
                RemoveSTSEndpointTrustAuthenticationRule.trExit(string);
                return;
            }
        }
        try {
            this.updateTargets(sTSTargetMap);
        }
        catch (Exception exception) {
            this.processError(exception);
            RemoveSTSEndpointTrustAuthenticationRule.trExit(string);
            return;
        }
        this.setResult(RemoveSTSEndpointTrustAuthenticationRule.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        RemoveSTSEndpointTrustAuthenticationRule.trExit(string);
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

