/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class RemoveSTSConfigurationProperty
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(RemoveSTSConfigurationProperty.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public RemoveSTSConfigurationProperty(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public RemoveSTSConfigurationProperty(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        String string = "execute";
        RemoveSTSConfigurationProperty.trEntry(string);
        String[] stringArray = (String[])this.getTargetObject();
        STSConfigGroup sTSConfigGroup = null;
        try {
            sTSConfigGroup = this.loadConfig();
        }
        catch (Exception exception) {
            this.processError(exception);
            RemoveSTSConfigurationProperty.trExit(string);
            return;
        }
        STSConfigGroup sTSConfigGroup2 = sTSConfigGroup;
        if (stringArray != null && (sTSConfigGroup2 = RemoveSTSConfigurationProperty.getConfiguration(sTSConfigGroup, stringArray)) == null) {
            this.processError(RemoveSTSConfigurationProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9054W"));
            RemoveSTSConfigurationProperty.trExit(string);
            return;
        }
        String string2 = null;
        String string3 = null;
        try {
            string2 = (String)this.getParameter("propertyName");
            string3 = (String)this.getParameter("propertyType");
        }
        catch (InvalidParameterNameException invalidParameterNameException) {
            this.processError(invalidParameterNameException);
            RemoveSTSConfigurationProperty.trExit(string);
            return;
        }
        List<STSProperty> list = sTSConfigGroup2.getSTSProperty();
        Iterator<STSProperty> iterator = list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            STSProperty sTSProperty = iterator.next();
            String string4 = sTSProperty.getType();
            if (!Pattern.matches(string2, sTSProperty.getName()) || !Pattern.matches(string3, string4 == null ? "" : string4)) continue;
            iterator.remove();
            bl = true;
        }
        if (!bl) {
            this.processError(RemoveSTSConfigurationProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9059W"));
            RemoveSTSConfigurationProperty.trExit(string);
            return;
        }
        try {
            this.updateConfig(sTSConfigGroup);
        }
        catch (Exception exception) {
            this.processError(exception);
            RemoveSTSConfigurationProperty.trExit(string);
            return;
        }
        this.setResult(RemoveSTSConfigurationProperty.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        RemoveSTSConfigurationProperty.trExit(string);
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }
}

