/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;

public class RefreshSTS
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(RefreshSTS.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public RefreshSTS(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public RefreshSTS(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        Set set;
        String string = "execute()";
        RefreshSTS.trEntry(string);
        AdminService adminService = AdminServiceFactory.getAdminService();
        try {
            set = adminService.queryNames(new ObjectName("WebSphere:*,type=SecurityTokenServiceAdmin"), null);
        }
        catch (Exception exception) {
            this.processError(new AdminException(exception));
            RefreshSTS.trExit(string);
            return;
        }
        Iterator iterator = set.iterator();
        boolean bl = true;
        try {
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                RefreshSTS.trDebug(" Invoking mBean: " + objectName.toString());
                bl = bl && (Boolean)adminService.invoke(objectName, "refresh", new Object[0], new String[0]) != false;
            }
        }
        catch (Exception exception) {
            this.processError(exception);
            RefreshSTS.trExit(string);
            return;
        }
        if (bl) {
            this.setResult(RefreshSTS.getMessage("wssecurity.admin.sts.CWWSI9076I"));
        } else {
            this.setResult(RefreshSTS.getMessage("wssecurity.admin.sts.CWWSI9077W"));
        }
        RefreshSTS.trExit(string);
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

