/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSTrustAuthenticationCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.DefaultIssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.util.ArrayList;
import java.util.List;

public class ListSTSTrustAuthenticationConfiguredEndpoints
extends AbstractSTSTrustAuthenticationCommand {
    private static final TraceComponent tc = Tr.register(ListSTSTrustAuthenticationConfiguredEndpoints.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public ListSTSTrustAuthenticationConfiguredEndpoints(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public ListSTSTrustAuthenticationConfiguredEndpoints(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        String string = "execute";
        ListSTSTrustAuthenticationConfiguredEndpoints.trEntry(string);
        STSTargetMap sTSTargetMap = null;
        try {
            sTSTargetMap = this.loadTargets();
        }
        catch (Exception exception) {
            this.processError(exception);
            ListSTSTrustAuthenticationConfiguredEndpoints.trExit(string);
            return;
        }
        ListSTSTrustAuthenticationConfiguredEndpoints.trDebug("Searching through configuration for targets configured with trust authentication rules.");
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Target> list = sTSTargetMap.getTarget();
        block2: for (Target stringArray2 : list) {
            String string2 = stringArray2.getAppliesTo();
            ListSTSTrustAuthenticationConfiguredEndpoints.trDebug("Found target with endpointURI: " + string2);
            if (string2 == null) {
                ListSTSTrustAuthenticationConfiguredEndpoints.trDebug("Found target with null appliesTo attribute, which is required. Skipping entry.");
                continue;
            }
            List<IssuerRule> list2 = stringArray2.getIssuerRule();
            DefaultIssuerRule defaultIssuerRule = stringArray2.getDefaultIssuerRule();
            if (defaultIssuerRule != null) {
                ListSTSTrustAuthenticationConfiguredEndpoints.trDebug("Found DefaultIssuerRule.");
                List<TokenTypeRule> list3 = defaultIssuerRule.getTokenTypeRule();
                if (list3 == null || list3.isEmpty()) {
                    ListSTSTrustAuthenticationConfiguredEndpoints.trDebug("No TokenTypeRule elements found.");
                } else {
                    ListSTSTrustAuthenticationConfiguredEndpoints.trDebug("Found trust authentication configured endpoint: " + string2);
                    arrayList.add(string2);
                    continue;
                }
            }
            if (list2 == null) continue;
            ListSTSTrustAuthenticationConfiguredEndpoints.trDebug("Iterating over issuer rules.");
            for (IssuerRule issuerRule : list2) {
                String string3 = issuerRule.getIssuerURI();
                ListSTSTrustAuthenticationConfiguredEndpoints.trDebug("Found IssuerRule with issuerURI: " + string3);
                if (string3 == null) {
                    ListSTSTrustAuthenticationConfiguredEndpoints.trDebug("Found IssuerRule with null IssuerURI, which is required. Skipping entry.");
                    continue;
                }
                List<TokenTypeRule> list4 = issuerRule.getTokenTypeRule();
                if (list4 == null || list4.isEmpty()) {
                    ListSTSTrustAuthenticationConfiguredEndpoints.trDebug("No TokenTypeRule elements found.");
                    continue;
                }
                ListSTSTrustAuthenticationConfiguredEndpoints.trDebug("Found trust authentication configured endpoint: " + string2);
                arrayList.add(string2);
                continue block2;
            }
        }
        String[] stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        this.setResult(stringArray2);
        ListSTSTrustAuthenticationConfiguredEndpoints.trExit(string);
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

