/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.admin.sts.commands.result.STSPropertyList;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;

public class EditSTSConfigurationProperty
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(EditSTSConfigurationProperty.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public EditSTSConfigurationProperty(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public EditSTSConfigurationProperty(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        String string = "execute";
        EditSTSConfigurationProperty.trEntry(string);
        String[] stringArray = (String[])this.getTargetObject();
        STSConfigGroup sTSConfigGroup = null;
        try {
            sTSConfigGroup = this.loadConfig();
        }
        catch (Exception exception) {
            this.processError(exception);
            EditSTSConfigurationProperty.trExit(string);
            return;
        }
        STSConfigGroup sTSConfigGroup2 = sTSConfigGroup;
        if (stringArray != null && (sTSConfigGroup2 = EditSTSConfigurationProperty.getConfiguration(sTSConfigGroup, stringArray)) == null) {
            CommandException commandException = EditSTSConfigurationProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9055W");
            this.processError(commandException);
            EditSTSConfigurationProperty.trDebug(commandException.getMessage());
            EditSTSConfigurationProperty.trExit(string);
            return;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        try {
            string2 = (String)this.getParameter("propertyName");
            string3 = (String)this.getParameter("propertyType");
            string4 = (String)this.getParameter("newPropertyName");
            string5 = (String)this.getParameter("newPropertyType");
            string6 = (String)this.getParameter("newPropertyValue");
            bl = (Boolean)this.getParameter("nullPropertyType");
        }
        catch (InvalidParameterNameException invalidParameterNameException) {
            this.processError(invalidParameterNameException);
            EditSTSConfigurationProperty.trExit(string);
            return;
        }
        EditSTSConfigurationProperty.trDebug("propertyName to match: " + string2);
        EditSTSConfigurationProperty.trDebug("propertyType to match: " + (bl ? null : string3));
        List<STSProperty> list = sTSConfigGroup2.getSTSProperty();
        Iterator<STSProperty> iterator = list.iterator();
        Vector<UniqueKey> vector = new Vector<UniqueKey>();
        while (iterator.hasNext()) {
            STSProperty sTSProperty = iterator.next();
            vector.add(new UniqueKey(sTSProperty.getName(), sTSProperty.getType()));
        }
        boolean bl2 = string4 == null;
        boolean bl3 = string5 == null;
        iterator = list.iterator();
        int n = 0;
        boolean bl4 = false;
        while (iterator.hasNext()) {
            STSProperty sTSProperty = iterator.next();
            String string7 = sTSProperty.getName();
            String string8 = sTSProperty.getType();
            EditSTSConfigurationProperty.trDebug("Attempting to match property: " + new STSPropertyList(new STSProperty[]{sTSProperty}));
            if (Pattern.matches(string2, string7) && (bl ? string8 == null : Pattern.matches(string3, string8 == null ? "" : string8))) {
                EditSTSConfigurationProperty.trDebug("Property matched.");
                bl4 = true;
                if (bl2 && bl3) {
                    EditSTSConfigurationProperty.trDebug("No new name and no new type are provided. OK to edit property.");
                    if (string6 != null) {
                        sTSProperty.setValue(string6);
                    }
                } else {
                    UniqueKey uniqueKey = new UniqueKey(bl2 ? string7 : string4, bl3 ? string8 : string5);
                    if (vector.contains(uniqueKey)) {
                        CommandException commandException = EditSTSConfigurationProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9060W");
                        this.processError(commandException);
                        EditSTSConfigurationProperty.trDebug(commandException.getMessage());
                        EditSTSConfigurationProperty.trExit(string);
                        return;
                    }
                    EditSTSConfigurationProperty.trDebug("No conflict detected. OK to edit property.");
                    vector.set(n, uniqueKey);
                    if (!bl2) {
                        sTSProperty.setName(string4);
                    }
                    if (!bl3) {
                        sTSProperty.setType(string5);
                    }
                    if (string6 != null) {
                        sTSProperty.setValue(string6);
                    }
                }
            } else {
                EditSTSConfigurationProperty.trDebug("Property not matched.");
            }
            ++n;
        }
        if (!bl4) {
            this.processError(EditSTSConfigurationProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9059W"));
            EditSTSConfigurationProperty.trExit(string);
            return;
        }
        try {
            this.updateConfig(sTSConfigGroup);
        }
        catch (Exception exception) {
            this.processError(exception);
            EditSTSConfigurationProperty.trExit(string);
            return;
        }
        this.setResult(EditSTSConfigurationProperty.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        EditSTSConfigurationProperty.trExit(string);
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }

    private static class UniqueKey {
        private String key1;
        private String key2;

        public UniqueKey(String string, String string2) {
            this.key1 = string;
            this.key2 = string2;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof UniqueKey) {
                bl = true;
                UniqueKey uniqueKey = (UniqueKey)object;
                if (this.key1 == null) {
                    bl = bl && uniqueKey.key1 == null;
                } else {
                    boolean bl2 = bl = bl && this.key1.equals(uniqueKey.key1);
                }
                bl = this.key2 == null ? bl && uniqueKey.key2 == null : bl && this.key2.equals(uniqueKey.key2);
            }
            return bl;
        }
    }
}

