/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSTrustAuthenticationCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.DefaultIssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Identity;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityList;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityPart;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;

public class AddSTSEndpointTrustAuthenticationRule
extends AbstractSTSTrustAuthenticationCommand {
    private static final TraceComponent tc = Tr.register(AddSTSEndpointTrustAuthenticationRule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public AddSTSEndpointTrustAuthenticationRule(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public AddSTSEndpointTrustAuthenticationRule(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        Object object;
        String string = "execute";
        AddSTSEndpointTrustAuthenticationRule.trEntry(string);
        String string2 = (String)this.getTargetObject();
        AddSTSEndpointTrustAuthenticationRule.trDebug("Command target (endpointURI) - " + string2);
        try {
            new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.processError(AddSTSEndpointTrustAuthenticationRule.instantiateCommandException("WSEC0003E", new String[]{malformedURLException.toString()}));
            AddSTSEndpointTrustAuthenticationRule.trExit(string);
            return;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Properties properties = null;
        try {
            string3 = (String)this.getParameter("issuer");
            string4 = (String)this.getParameter("tokenTypeURI");
            string5 = (String)this.getParameter("jaasConfigName");
            string6 = (String)this.getParameter("callbackHandler");
            properties = (Properties)this.getParameter("identity");
        }
        catch (InvalidParameterNameException invalidParameterNameException) {
            this.processError(invalidParameterNameException);
            AddSTSEndpointTrustAuthenticationRule.trExit(string);
            return;
        }
        AddSTSEndpointTrustAuthenticationRule.trDebug("Command arg (issuer) - " + string3);
        AddSTSEndpointTrustAuthenticationRule.trDebug("Command arg (tokenTypeURI) - " + string4);
        AddSTSEndpointTrustAuthenticationRule.trDebug("Command arg (jaasConfigName) - " + string5);
        AddSTSEndpointTrustAuthenticationRule.trDebug("Command arg (callbackHandler) - " + string6);
        AddSTSEndpointTrustAuthenticationRule.trDebug("Command arg (identity) - " + properties);
        if (properties.isEmpty()) {
            AddSTSEndpointTrustAuthenticationRule.trDebug("Identity parameter should not be empty.");
            this.processError(AddSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9068W"));
            AddSTSEndpointTrustAuthenticationRule.trExit(string);
            return;
        }
        STSTargetMap sTSTargetMap = null;
        try {
            sTSTargetMap = this.loadTargets();
        }
        catch (Exception exception) {
            this.processError(exception);
            AddSTSEndpointTrustAuthenticationRule.trExit(string);
            return;
        }
        Target target = null;
        try {
            target = this.findTarget(sTSTargetMap, string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            AddSTSEndpointTrustAuthenticationRule.trDebug("Target does not exist. Creating.");
            target = new Target();
            object = sTSTargetMap.getTarget();
            object.add((Target)target);
        }
        List<TokenTypeRule> list = null;
        if (string3 == null) {
            AddSTSEndpointTrustAuthenticationRule.trDebug("Issuer is null. Finding rules in DefaultIssuerRule.");
            object = null;
            try {
                object = this.findDefaultIssuerRule(sTSTargetMap, target, null);
            }
            catch (NoSuchElementException noSuchElementException) {
                AddSTSEndpointTrustAuthenticationRule.trDebug("DefaultIssuerRule does not exist. Creating.");
                object = new DefaultIssuerRule();
                target.setDefaultIssuerRule((DefaultIssuerRule)object);
            }
            list = ((DefaultIssuerRule)object).getTokenTypeRule();
        } else {
            AddSTSEndpointTrustAuthenticationRule.trDebug("Checking rules in specified IssuerRule.");
            object = null;
            try {
                object = this.findIssuerRule(sTSTargetMap, target, null, string3);
            }
            catch (NoSuchElementException noSuchElementException) {
                AddSTSEndpointTrustAuthenticationRule.trDebug("Specified IssuerRule not found. Creating.");
                object = new IssuerRule();
                ((IssuerRule)object).setIssuerURI(string3);
                List<IssuerRule> list2 = target.getIssuerRule();
                list2.add((IssuerRule)object);
            }
            list = ((IssuerRule)object).getTokenTypeRule();
        }
        object = null;
        try {
            object = this.findRule(sTSTargetMap, list, null, null, string4);
        }
        catch (NoSuchElementException noSuchElementException) {
            AddSTSEndpointTrustAuthenticationRule.trDebug("TokenTypeRule does not exist. Creating.");
            if (string5 == null) {
                this.processError(AddSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9063W"));
                AddSTSEndpointTrustAuthenticationRule.trExit(string);
                return;
            }
            object = new TokenTypeRule();
            AddSTSEndpointTrustAuthenticationRule.trDebug("Setting requiredTokenTypeURI to " + string4);
            ((TokenTypeRule)object).setRequiredTokenTypeURI(string4);
            AddSTSEndpointTrustAuthenticationRule.trDebug("Setting jaasConfigName to " + string5);
            ((TokenTypeRule)object).setJAASConfigName(string5);
            if (string6 != null) {
                AddSTSEndpointTrustAuthenticationRule.trDebug("Setting callbackHandler to " + string6);
                ((TokenTypeRule)object).setCallbackHandler(string6);
            }
            list.add((TokenTypeRule)object);
        }
        AddSTSEndpointTrustAuthenticationRule.trDebug("Searching rule for identities.");
        Identity identity = null;
        try {
            identity = this.findIdentity(sTSTargetMap, (TokenTypeRule)object, null, null, null, properties);
            AddSTSEndpointTrustAuthenticationRule.trDebug("Specified identity already exists.");
            this.processError(AddSTSEndpointTrustAuthenticationRule.instantiateCommandException("wssecurity.admin.sts.CWWSI9070W"));
            AddSTSEndpointTrustAuthenticationRule.trExit(string);
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            AddSTSEndpointTrustAuthenticationRule.trDebug("Creating Identity element.");
            identity = new Identity();
            IdentityList identityList = ((TokenTypeRule)object).getIdentityList();
            if (identityList == null) {
                identityList = new IdentityList();
                ((TokenTypeRule)object).setIdentityList(identityList);
            }
            List<Identity> list3 = identityList.getIdentity();
            list3.add(identity);
            List<IdentityPart> list4 = identity.getIdentityPart();
            Set<Object> set = properties.keySet();
            for (String string7 : set) {
                String string8 = properties.getProperty(string7);
                AddSTSEndpointTrustAuthenticationRule.trDebug("Adding IdentityPart with name: " + string7 + " and value: " + string8);
                IdentityPart identityPart = new IdentityPart();
                identityPart.setName(string7);
                identityPart.setValue(string8);
                list4.add(identityPart);
            }
            try {
                this.updateTargets(sTSTargetMap);
            }
            catch (Exception exception) {
                this.processError(exception);
                AddSTSEndpointTrustAuthenticationRule.trExit(string);
                return;
            }
            this.setResult(AddSTSEndpointTrustAuthenticationRule.getMessage("wssecurity.admin.sts.CWWSI9075I"));
            AddSTSEndpointTrustAuthenticationRule.trExit(string);
            return;
        }
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

