/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.DefaultIssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Identity;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityList;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityPart;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSTSTrustAuthenticationCommand
extends AbstractSTSCommand {
    private static final TraceComponent tc = Tr.register(AbstractSTSTrustAuthenticationCommand.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public AbstractSTSTrustAuthenticationCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public AbstractSTSTrustAuthenticationCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected Target findTarget(STSTargetMap sTSTargetMap, String string) throws NoSuchElementException {
        String string2 = "findTarget";
        AbstractSTSTrustAuthenticationCommand.trEntry(string2);
        if (sTSTargetMap == null || string == null) {
            AbstractSTSTrustAuthenticationCommand.trDebug("map and endpointURI parameters must not be null.");
            throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9079W"));
        }
        AbstractSTSTrustAuthenticationCommand.trDebug("Searching configuration for specified target: " + string);
        List<Target> list = sTSTargetMap.getTarget();
        Iterator<Target> iterator = list.iterator();
        Target target = null;
        while (iterator.hasNext()) {
            Target target2 = iterator.next();
            String string3 = target2.getAppliesTo();
            AbstractSTSTrustAuthenticationCommand.trDebug("Found target with endpointURI: " + string3);
            if (string3 == null) {
                AbstractSTSTrustAuthenticationCommand.trDebug("Found target with a null appliesTo attribute, which is required. Skipping entry.");
                continue;
            }
            if (!string3.equals(string)) continue;
            AbstractSTSTrustAuthenticationCommand.trDebug("Match found.");
            target = target2;
            break;
        }
        if (target == null) {
            AbstractSTSTrustAuthenticationCommand.trDebug("Specified target not found.");
            throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9045W"));
        }
        AbstractSTSTrustAuthenticationCommand.trExit(string2);
        return target;
    }

    protected DefaultIssuerRule findDefaultIssuerRule(STSTargetMap sTSTargetMap, Target target, String string) throws NoSuchElementException {
        String string2 = "findDefaultIssuerRule";
        AbstractSTSTrustAuthenticationCommand.trEntry(string2);
        DefaultIssuerRule defaultIssuerRule = null;
        if (target != null) {
            AbstractSTSTrustAuthenticationCommand.trDebug("Start Target was provided. Searching for DefaultIssuerRule in the specified Target.");
            string = target.getAppliesTo();
        } else {
            AbstractSTSTrustAuthenticationCommand.trDebug("Start Target not provided. Searching from the beginning.");
            target = this.findTarget(sTSTargetMap, string);
        }
        defaultIssuerRule = target.getDefaultIssuerRule();
        if (defaultIssuerRule == null) {
            String string3 = "DefaultIssuerRule was not found for specified endpoint: " + string;
            AbstractSTSTrustAuthenticationCommand.trDebug(string3);
            throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9080W", new String[]{string}));
        }
        AbstractSTSTrustAuthenticationCommand.trDebug("Successfully extracted DefaultIssuerRule from target: " + string);
        AbstractSTSTrustAuthenticationCommand.trExit(string2);
        return defaultIssuerRule;
    }

    protected IssuerRule findIssuerRule(STSTargetMap sTSTargetMap, Target target, String string, String string2) throws NoSuchElementException {
        String string3 = "findIssuerRule";
        AbstractSTSTrustAuthenticationCommand.trEntry(string3);
        if (target != null) {
            AbstractSTSTrustAuthenticationCommand.trDebug("Start Target was provided. Searching for IssuerRule in the specified Target.");
            string = target.getAppliesTo();
        } else {
            AbstractSTSTrustAuthenticationCommand.trDebug("Start Target not provided. Searching from the beginning.");
            target = this.findTarget(sTSTargetMap, string);
        }
        IssuerRule issuerRule = null;
        List<IssuerRule> list = target.getIssuerRule();
        for (IssuerRule issuerRule2 : list) {
            String string4 = issuerRule2.getIssuerURI();
            AbstractSTSTrustAuthenticationCommand.trDebug("Found IssuerRule with IssuerURI: " + string4);
            if (string4 == null) {
                AbstractSTSTrustAuthenticationCommand.trDebug("Found issuerRule with null issuerURI attribute, which is required. Skipping entry.");
                continue;
            }
            if (!string4.equals(string2)) continue;
            AbstractSTSTrustAuthenticationCommand.trDebug("Match found.");
            issuerRule = issuerRule2;
            break;
        }
        if (issuerRule == null) {
            AbstractSTSTrustAuthenticationCommand.trDebug("Specified IssuerRule not found: " + string2);
            throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9081W", new String[]{string, string2}));
        }
        AbstractSTSTrustAuthenticationCommand.trDebug("Successfully found specified IssuerRule.");
        AbstractSTSTrustAuthenticationCommand.trExit(string3);
        return issuerRule;
    }

    protected TokenTypeRule findRule(STSTargetMap sTSTargetMap, List<TokenTypeRule> list, String string, String string2, String string3) throws NoSuchElementException {
        String string4 = "findRules";
        AbstractSTSTrustAuthenticationCommand.trEntry(string4);
        if (string3 == null) {
            AbstractSTSTrustAuthenticationCommand.trDebug("tokenTypeURI parameter must not be null.");
            throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9082W"));
        }
        if (list == null) {
            Iterator<TokenTypeRule> iterator;
            AbstractSTSTrustAuthenticationCommand.trDebug("Rules were not provided. Searching from beginning.");
            if (string2 == null) {
                iterator = this.findDefaultIssuerRule(sTSTargetMap, null, string);
                list = ((DefaultIssuerRule)((Object)iterator)).getTokenTypeRule();
            } else {
                iterator = this.findIssuerRule(sTSTargetMap, null, string, string2);
                list = ((IssuerRule)((Object)iterator)).getTokenTypeRule();
            }
        }
        AbstractSTSTrustAuthenticationCommand.trDebug("Searching configuration for specified token type: " + string3);
        for (TokenTypeRule tokenTypeRule : list) {
            String string5 = tokenTypeRule.getRequiredTokenTypeURI();
            AbstractSTSTrustAuthenticationCommand.trDebug("Found TokenTypeRule with requiredTokenTypeURI: " + string5);
            if (string5 == null) {
                AbstractSTSTrustAuthenticationCommand.trDebug("Found tokenTypeRule with null requiredTokenTypeURI attribute, which is required. Skipping entry.");
                continue;
            }
            if (!string5.equals(string3)) continue;
            AbstractSTSTrustAuthenticationCommand.trDebug("Successfully found specified TokenTypeRule.");
            AbstractSTSTrustAuthenticationCommand.trExit(string4);
            return tokenTypeRule;
        }
        AbstractSTSTrustAuthenticationCommand.trDebug("TokenTypeRule not found.");
        throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9083W", new String[]{string, string3}));
    }

    protected Identity findIdentity(STSTargetMap sTSTargetMap, TokenTypeRule tokenTypeRule, String string, String string2, String string3, Properties properties) throws NoSuchElementException {
        String string4 = "findIdentity";
        AbstractSTSTrustAuthenticationCommand.trEntry(string4);
        if (tokenTypeRule == null) {
            AbstractSTSTrustAuthenticationCommand.trDebug("Searching for TokenTypeRule.");
            tokenTypeRule = this.findRule(sTSTargetMap, null, string, string2, string3);
        }
        AbstractSTSTrustAuthenticationCommand.trDebug("Searching through identities.");
        Identity identity = null;
        IdentityList identityList = tokenTypeRule.getIdentityList();
        if (identityList == null) {
            AbstractSTSTrustAuthenticationCommand.trDebug("IdentityList is null.");
            throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9084W", new String[]{string}));
        }
        List<Identity> list = identityList.getIdentity();
        for (Identity identity2 : list) {
            List<IdentityPart> list2 = identity2.getIdentityPart();
            if (list2.size() != properties.size()) {
                AbstractSTSTrustAuthenticationCommand.trDebug("Identity rule does not contain the same number of parts as that specified. Skipping.");
                continue;
            }
            Iterator<IdentityPart> iterator = list2.iterator();
            boolean bl = true;
            AbstractSTSTrustAuthenticationCommand.trDebug("Found Identity with parts:");
            while (iterator.hasNext()) {
                IdentityPart identityPart = iterator.next();
                String string5 = identityPart.getName();
                String string6 = identityPart.getValue();
                AbstractSTSTrustAuthenticationCommand.trDebug("  Name: " + string5);
                AbstractSTSTrustAuthenticationCommand.trDebug("  Value: " + string6);
                if (string5 == null || string6 == null) {
                    AbstractSTSTrustAuthenticationCommand.trDebug("Found an IdentityPart element with a null Name or null Value attribute, both of which are required. Skipping entry.");
                    continue;
                }
                String string7 = properties.getProperty(string5);
                if (string7 != null && string7.equals(string6)) continue;
                AbstractSTSTrustAuthenticationCommand.trDebug("Not a match. Continuing with next Identity rule.");
                bl = false;
                break;
            }
            if (!bl) continue;
            AbstractSTSTrustAuthenticationCommand.trDebug("Found a match.");
            identity = identity2;
            break;
        }
        if (identity == null) {
            AbstractSTSTrustAuthenticationCommand.trDebug("Could not find specified identity.");
            throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9084W", new String[]{string}));
        }
        AbstractSTSTrustAuthenticationCommand.trDebug("Successfully found specified Identity.");
        AbstractSTSTrustAuthenticationCommand.trExit(string4);
        return identity;
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

