/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.wssecurity.admin.sts.commands.Constants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSTSCommand
extends AbstractAdminCommand {
    public static final String FFDC_ID_1 = "FFDC-1";
    public static final String FFDC_ID_2 = "FFDC-2";
    public static final String FFDC_ID_3 = "FFDC-3";
    public static final String FFDC_ID_4 = "FFDC-4";
    public static final String FFDC_ID_5 = "FFDC-5";
    public static final String FFDC_ID_6 = "FFDC-6";
    public static final String FFDC_ID_7 = "FFDC-7";
    private RepositoryContext repContext;
    private boolean isSetup;
    private boolean repContextLoaded;
    private static HashSet<String> defaultPropertyNames;
    private static final TraceComponent tc;
    private static final String CLASS_NAME;
    private static final ResourceBundle resourceBundle;

    public AbstractSTSCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
        this.reset();
    }

    public AbstractSTSCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        this.reset();
    }

    public static String getMessage(String string) {
        String string2 = string;
        if (resourceBundle != null) {
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = string;
            }
        }
        return string2;
    }

    public static String getMessage(String string, String[] stringArray) {
        String string2 = AbstractSTSCommand.getMessage(string);
        if (stringArray != null && stringArray.length > 0) {
            string2 = MessageFormat.format(string2, stringArray);
        }
        return string2;
    }

    protected void setup() {
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        this.isSetup = true;
    }

    protected void reset() {
        this.repContext = null;
        this.isSetup = false;
        this.repContextLoaded = false;
    }

    protected void processError(Throwable throwable) {
        if (throwable instanceof InvalidParameterNameException) {
            this.processError(throwable, "WSEC0003E", new String[]{throwable.getMessage()}, FFDC_ID_1);
        } else if (throwable instanceof CommandException) {
            this.processError(throwable, "WSEC0003E", new String[]{throwable.getMessage()}, FFDC_ID_2);
        } else if (throwable instanceof NoSuchElementException) {
            this.processError(throwable, "WSEC0004E", new String[]{throwable.getMessage()}, FFDC_ID_7);
        } else if (throwable instanceof FileNotFoundException) {
            this.processError(throwable, "WSEC0004E", new String[]{throwable.getMessage()}, FFDC_ID_3);
        } else if (throwable instanceof JAXBException) {
            this.processError(throwable, "WSEC0004E", new String[]{throwable.getMessage()}, FFDC_ID_4);
        } else if (throwable instanceof WorkSpaceException) {
            this.processError(throwable, "WSEC0004E", new String[]{throwable.getMessage()}, FFDC_ID_5);
        } else {
            this.processError(throwable, "WSEC0005E", new String[]{throwable.getMessage()}, FFDC_ID_6);
        }
    }

    protected void processError(Throwable throwable, String string, String[] stringArray, String string2) {
        if (!this.isSetup) {
            this.setup();
        }
        CommandResultImpl commandResultImpl = (CommandResultImpl)this.getCommandResult();
        commandResultImpl.setException(throwable);
        AbstractSTSCommand.trError(throwable, string, stringArray, string2);
    }

    protected void setResult(Object object) {
        if (!this.isSetup) {
            this.setup();
        }
        CommandResultImpl commandResultImpl = (CommandResultImpl)this.getCommandResult();
        commandResultImpl.setResult(object);
    }

    protected STSExtensionMap loadPlugins() throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        String string = CLASS_NAME + ".loadPlugins()";
        AbstractSTSCommand.trEntry(string);
        String string2 = this.extractFileFromWorkspace(Constants.PATH_FROM_CELL + "stsplugins.xml");
        Unmarshaller unmarshaller = this.getUnmarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins");
        STSExtensionMap sTSExtensionMap = (STSExtensionMap)unmarshaller.unmarshal(new File(string2));
        AbstractSTSCommand.trExit(string);
        return sTSExtensionMap;
    }

    protected STSTargetMap loadTargets() throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        String string = CLASS_NAME + ".loadTargets()";
        AbstractSTSCommand.trEntry(string);
        String string2 = this.extractFileFromWorkspace(Constants.PATH_FROM_CELL + "ststargets.xml");
        Unmarshaller unmarshaller = this.getUnmarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets");
        STSTargetMap sTSTargetMap = (STSTargetMap)unmarshaller.unmarshal(new File(string2));
        AbstractSTSCommand.trExit(string);
        return sTSTargetMap;
    }

    protected STSConfigGroup loadConfig() throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        String string = "loadConfig";
        AbstractSTSCommand.trEntry(string);
        String string2 = this.extractFileFromWorkspace(Constants.PATH_FROM_CELL + "stsconfig.xml");
        Unmarshaller unmarshaller = this.getUnmarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice");
        STSConfigGroup sTSConfigGroup = (STSConfigGroup)unmarshaller.unmarshal(new File(string2));
        AbstractSTSCommand.trExit(string);
        return sTSConfigGroup;
    }

    protected void udpatePlugins(STSExtensionMap sTSExtensionMap) throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        String string = CLASS_NAME + ".updatePlugins(" + STSExtensionMap.class.getName() + ")";
        AbstractSTSCommand.trEntry(string);
        String string2 = Constants.PATH_FROM_CELL + "stsplugins.xml";
        String string3 = this.extractFileFromWorkspace(string2);
        Marshaller marshaller = this.getMarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins");
        marshaller.marshal((Object)sTSExtensionMap, new FileOutputStream(string3));
        this.updateFileInWorkspace(string2);
        AbstractSTSCommand.trExit(string);
    }

    protected void updateTargets(STSTargetMap sTSTargetMap) throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        String string = CLASS_NAME + ".updateTargets(" + STSExtensionMap.class.getName() + ")";
        AbstractSTSCommand.trEntry(string);
        String string2 = Constants.PATH_FROM_CELL + "ststargets.xml";
        String string3 = this.extractFileFromWorkspace(string2);
        Marshaller marshaller = this.getMarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets");
        marshaller.marshal((Object)sTSTargetMap, new FileOutputStream(string3));
        this.updateFileInWorkspace(string2);
        AbstractSTSCommand.trExit(string);
    }

    protected void updateConfig(STSConfigGroup sTSConfigGroup) throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        String string = "updateConfig";
        AbstractSTSCommand.trEntry(string);
        String string2 = Constants.PATH_FROM_CELL + "stsconfig.xml";
        String string3 = this.extractFileFromWorkspace(string2);
        Marshaller marshaller = this.getMarshaller("com.ibm.xmlns.prod.websphere._200608.securitytokenservice");
        marshaller.marshal((Object)sTSConfigGroup, new FileOutputStream(string3));
        this.updateFileInWorkspace(string2);
        AbstractSTSCommand.trExit(string);
    }

    protected boolean isDefaultProperty(String string) {
        if (defaultPropertyNames == null) {
            this.loadDefaultPropertyNames();
        }
        return defaultPropertyNames.contains(string);
    }

    protected static STSConfigGroup getConfiguration(STSConfigGroup sTSConfigGroup, String[] stringArray) {
        String string = "getConfiguration";
        AbstractSTSCommand.trEntry(string);
        if (sTSConfigGroup == null) {
            AbstractSTSCommand.trDebug("Root element is null.");
            AbstractSTSCommand.trExit(string);
            return null;
        }
        for (String string2 : stringArray) {
            Pattern pattern = Pattern.compile(string2);
            List<STSConfigGroup> list = sTSConfigGroup.getSTSConfigGroup();
            Iterator<STSConfigGroup> iterator = list.iterator();
            sTSConfigGroup = null;
            while (iterator.hasNext()) {
                STSConfigGroup sTSConfigGroup2 = iterator.next();
                Matcher matcher = pattern.matcher(sTSConfigGroup2.getName());
                if (!matcher.matches()) continue;
                sTSConfigGroup = sTSConfigGroup2;
                break;
            }
            if (sTSConfigGroup != null) continue;
            AbstractSTSCommand.trDebug(string2 + " was not found in the configuration path.");
            AbstractSTSCommand.trExit(string);
            return null;
        }
        AbstractSTSCommand.trExit(string);
        return sTSConfigGroup;
    }

    protected static List<STSProperty> getProperties(STSConfigGroup sTSConfigGroup, String[] stringArray) {
        STSConfigGroup sTSConfigGroup2 = AbstractSTSCommand.getConfiguration(sTSConfigGroup, stringArray);
        if (sTSConfigGroup2 == null) {
            return null;
        }
        return sTSConfigGroup2.getSTSProperty();
    }

    protected static CommandException instantiateCommandException(String string) {
        return new CommandException(AbstractSTSCommand.getMessage(string));
    }

    protected static CommandException instantiateCommandException(String string, String[] stringArray) {
        return new CommandException(AbstractSTSCommand.getMessage(string, stringArray));
    }

    private Unmarshaller getUnmarshaller(String string) throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance(string);
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        return unmarshaller;
    }

    private Marshaller getMarshaller(String string) throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance(string);
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        return marshaller;
    }

    private String extractFileFromWorkspace(String string) throws WorkSpaceException, FileNotFoundException {
        if (!this.repContextLoaded) {
            this.loadRepositoryContext(this.getConfigSession());
        }
        if (this.repContext.isAvailable(string)) {
            if (!this.repContext.isExtracted(string)) {
                this.repContext.extract(string, true);
            }
        } else {
            throw new FileNotFoundException(string);
        }
        return AbstractSTSCommand.constructAbsolutePath(this.repContext, string);
    }

    private void updateFileInWorkspace(String string) throws WorkSpaceException, FileNotFoundException {
        if (!this.repContextLoaded) {
            this.loadRepositoryContext(this.getConfigSession());
        }
        if (this.repContext.isAvailable(string)) {
            this.repContext.notifyChanged(1, string);
        }
    }

    private void loadRepositoryContext(Session session) throws WorkSpaceException {
        String string = CLASS_NAME + ".getRepositoryContext(" + Session.class.getName() + "=" + session.toString() + ")";
        AbstractSTSCommand.trEntry(string);
        WorkSpace workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
        RepositoryMetaData repositoryMetaData = workSpace.getMetaData();
        RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("cells");
        Collection collection = workSpace.findContext(repositoryContextType);
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            throw new WorkSpaceException("Cannot find cell repository context.");
        }
        this.repContext = (RepositoryContext)iterator.next();
        this.repContextLoaded = true;
        AbstractSTSCommand.trExit(string);
    }

    private void loadDefaultPropertyNames() {
        Field[] fieldArray;
        defaultPropertyNames = new HashSet();
        for (Field field : fieldArray = Constants.class.getFields()) {
            if (!field.getName().startsWith("DEFAULT_PROPERTY_")) continue;
            try {
                defaultPropertyNames.add((String)field.get(null));
            }
            catch (Exception exception) {
                AbstractSTSCommand.trDebug("Could not read in default property: " + field.getName());
            }
        }
    }

    private static String constructAbsolutePath(RepositoryContext repositoryContext, String string) {
        return repositoryContext.getPath() + File.separator + string;
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }

    private static void trError(Throwable throwable, String string, String[] stringArray, String string2) {
        if (throwable != null) {
            Tr.processException(throwable, CLASS_NAME, string2);
        }
        Tr.error(tc, string, stringArray);
    }

    static {
        tc = Tr.register(AbstractSTSCommand.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        CLASS_NAME = AbstractSTSCommand.class.getName();
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    }
}

