/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sc;

import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class WSSCCacheCommandProvider
extends CommandProvider {
    private static TraceComponent tc = Tr.register(WSSCCacheCommandProvider.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static String className = WSSCCacheCommandProvider.class.getName();
    private HashMap classMap = new HashMap();
    public static final String FFDC_ID_1 = "FFDC-1";
    public static final String FFDC_ID_2 = "FFDC-2";
    public static final String FFDC_ID_3 = "FFDC-3";
    public static final String FFDC_ID_4 = "FFDC-4";

    public WSSCCacheCommandProvider() {
        this.classMap.put("querySCClientCacheConfiguration", "com.ibm.ws.wssecurity.admin.sc.QuerySCClientCacheConfiguration");
        this.classMap.put("querySCClientCacheCustomConfiguration", "com.ibm.ws.wssecurity.admin.sc.QuerySCClientCacheCustomConfiguration");
        this.classMap.put("updateSCClientCacheConfiguration", "com.ibm.ws.wssecurity.admin.sc.UpdateSCClientCacheConfiguration");
        this.classMap.put("updateSCClientCacheCustomConfiguration", "com.ibm.ws.wssecurity.admin.sc.UpdateSCClientCacheCustomConfiguration");
        this.classMap.put("deleteSCClientCacheConfigurationCustomProperties", "com.ibm.ws.wssecurity.admin.sc.DeleteSCClientCacheConfigurationCustomProperties");
    }

    public AbstractAdminCommand createCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommand", commandMetadata.getName());
        }
        String string = commandMetadata.getName();
        AbstractAdminCommand abstractAdminCommand = null;
        try {
            String string2 = (String)this.classMap.get(string);
            Class<?> clazz = Class.forName(string2);
            Class[] classArray = new Class[]{Class.forName("com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata")};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{commandMetadata};
            abstractAdminCommand = (AbstractAdminCommand)constructor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to create Command:" + string, throwable);
            }
            FFDCFilter.processException(throwable, className, FFDC_ID_1);
            Tr.error(tc, "WSEC0002E", string);
            throw new CommandNotFoundException(throwable.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCommand", commandMetadata.getName());
        }
        return abstractAdminCommand;
    }

    public AbstractAdminCommand loadCommand(CommandData commandData) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCommand", commandData.getName());
        }
        String string = commandData.getName();
        AbstractAdminCommand abstractAdminCommand = null;
        try {
            String string2 = (String)this.classMap.get(string);
            Class<?> clazz = Class.forName(string2);
            Class[] classArray = new Class[]{Class.forName("com.ibm.websphere.management.cmdframework.commanddata.CommandData")};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{commandData};
            abstractAdminCommand = (AbstractAdminCommand)constructor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to load command:" + string, throwable);
            }
            FFDCFilter.processException(throwable, className, FFDC_ID_2);
            Tr.error(tc, "WSEC0002E", throwable);
            throw new CommandNotFoundException(throwable.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCommand", commandData.getName());
        }
        return abstractAdminCommand;
    }
}

