/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sc;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Configuration;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.SCClientCache;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public abstract class SCCommonCommandProvider
extends AbstractAdminCommand {
    private static final String SCConfigFile = "WSSCCache.xml";
    private static final String Package_Namespace = "com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache";
    protected static final String RESULT_MSG_SUCCESS_UPDATED = "The configuration was successfully updated. Use $AdminConfig save to commit the changes.";
    public static final String FFDC_ID_1 = "FFDC-1";
    public static final String FFDC_ID_2 = "FFDC-2";
    public static final String FFDC_ID_3 = "FFDC-3";
    public static final String FFDC_ID_4 = "FFDC-4";
    public static final String FFDC_ID_5 = "FFDC-5";
    public static final String FFDC_ID_6 = "FFDC-6";
    private RepositoryContext repContext;
    private boolean isSetup;
    private boolean repContextLoaded;
    protected static final String[] preDefinedProps = new String[]{"renewIntervalBeforeTimeoutMinutes", "minutesInCacheAfterTimeout", "DistributedCache"};
    private static final TraceComponent tc = Tr.register(SCCommonCommandProvider.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public SCCommonCommandProvider(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
        this.reset();
    }

    public SCCommonCommandProvider(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        this.reset();
    }

    protected void setup() {
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        this.isSetup = true;
    }

    protected void reset() {
        this.repContext = null;
        this.isSetup = false;
        this.repContextLoaded = false;
    }

    protected void setResult(Object object) {
        if (!this.isSetup) {
            this.setup();
        }
        CommandResultImpl commandResultImpl = (CommandResultImpl)this.getCommandResult();
        commandResultImpl.setResult(object);
    }

    protected Configuration loadConfiguration() throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfiguration()");
        }
        String string = this.extractFileFromWorkspace(SCConfigFile);
        Unmarshaller unmarshaller = this.getUnmarshaller(Package_Namespace);
        SCClientCache sCClientCache = (SCClientCache)unmarshaller.unmarshal(new File(string));
        Configuration configuration = sCClientCache.getConfiguration().get(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfiguration()");
        }
        return configuration;
    }

    protected void udpateConfiguration(Configuration configuration) throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "udpateConfiguration");
        }
        String string = this.extractFileFromWorkspace(SCConfigFile);
        Marshaller marshaller = this.getMarshaller(Package_Namespace);
        SCClientCache sCClientCache = new SCClientCache();
        sCClientCache.getConfiguration().add(configuration);
        marshaller.marshal((Object)sCClientCache, new FileOutputStream(string));
        this.updateFileInWorkspace(SCConfigFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "udpateConfiguration");
        }
    }

    private Unmarshaller getUnmarshaller(String string) throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance(string);
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        return unmarshaller;
    }

    private Marshaller getMarshaller(String string) throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance(string);
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        return marshaller;
    }

    private String extractFileFromWorkspace(String string) throws WorkSpaceException, FileNotFoundException {
        if (!this.repContextLoaded) {
            this.loadRepositoryContext(this.getConfigSession());
        }
        if (this.repContext.isAvailable(string)) {
            if (!this.repContext.isExtracted(string)) {
                this.repContext.extract(string, true);
            }
        } else {
            throw new FileNotFoundException(string);
        }
        return SCCommonCommandProvider.constructAbsolutePath(this.repContext, string);
    }

    private void updateFileInWorkspace(String string) throws WorkSpaceException, FileNotFoundException {
        if (!this.repContextLoaded) {
            this.loadRepositoryContext(this.getConfigSession());
        }
        if (this.repContext.isAvailable(string)) {
            this.repContext.notifyChanged(1, string);
        }
    }

    private void loadRepositoryContext(Session session) throws WorkSpaceException {
        RepositoryContextType repositoryContextType;
        WorkSpace workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
        Collection collection = workSpace.findContext(repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("cells"));
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            throw new WorkSpaceException("Cannot find cell repository context.");
        }
        this.repContext = (RepositoryContext)iterator.next();
        this.repContextLoaded = true;
    }

    private static String constructAbsolutePath(RepositoryContext repositoryContext, String string) {
        return repositoryContext.getPath() + File.separator + string;
    }

    protected void processError(Throwable throwable) {
        if (throwable instanceof InvalidParameterNameException) {
            this.processError(throwable, "WSEC0003E", new String[]{throwable.getMessage()}, FFDC_ID_1);
        } else if (throwable instanceof CommandException) {
            this.processError(throwable, "WSEC0003E", new String[]{throwable.getMessage()}, FFDC_ID_2);
        } else if (throwable instanceof FileNotFoundException) {
            this.processError(throwable, "WSEC0004E", new String[]{throwable.getMessage()}, FFDC_ID_3);
        } else if (throwable instanceof JAXBException) {
            this.processError(throwable, "WSEC0004E", new String[]{throwable.getMessage()}, FFDC_ID_4);
        } else if (throwable instanceof WorkSpaceException) {
            this.processError(throwable, "WSEC0004E", new String[]{throwable.getMessage()}, FFDC_ID_5);
        } else {
            this.processError(throwable, "WSEC0005E", new String[]{throwable.getMessage()}, FFDC_ID_6);
        }
    }

    protected void processError(Throwable throwable, String string, String[] stringArray, String string2) {
        if (!this.isSetup) {
            this.setup();
        }
        CommandResultImpl commandResultImpl = (CommandResultImpl)this.getCommandResult();
        commandResultImpl.setException(throwable);
        Tr.error(tc, string, stringArray);
    }
}

