/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sc;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sc.SCCommonCommandProvider;
import com.ibm.ws.wssecurity.admin.sc.WSSCCacheCommandProvider;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Configuration;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Property;
import java.util.Iterator;
import java.util.List;

public class DeleteSCClientCacheConfigurationCustomProperties
extends SCCommonCommandProvider {
    private static TraceComponent tc = Tr.register(WSSCCacheCommandProvider.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public DeleteSCClientCacheConfigurationCustomProperties(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public DeleteSCClientCacheConfigurationCustomProperties(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        Configuration configuration = null;
        try {
            configuration = this.loadConfiguration();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to load SC Cache configuration.", exception);
            }
            Tr.error(tc, "Fail to load SC Ccahe configuration.", exception);
            return;
        }
        if (configuration == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no SC Cache configuration.");
            }
            Tr.error(tc, "Could not find SC Cache configuration.");
            return;
        }
        String[] stringArray = null;
        try {
            stringArray = (String[])this.getParameter("propertyNames");
        }
        catch (InvalidParameterNameException invalidParameterNameException) {
            Tr.error(tc, "Could not find SC Cache custom configuration.");
            return;
        }
        Configuration configuration2 = new Configuration();
        List<Property> list = configuration.getProperty();
        Iterator<Property> iterator = list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Property property = iterator.next();
            String string = property.getName();
            String string2 = property.getValue();
            bl = false;
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!string.equalsIgnoreCase(stringArray[i]) || preDefinedProps[0].equalsIgnoreCase(string) || preDefinedProps[1].equalsIgnoreCase(string) || preDefinedProps[2].equalsIgnoreCase(string)) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            Property property2 = new Property();
            property2.setName(string);
            property2.setValue(string2);
            configuration2.getProperty().add(property2);
        }
        try {
            this.udpateConfiguration(configuration2);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to update SC Cache configuration.", exception);
            }
            this.processError(exception);
            return;
        }
        this.setResult("The configuration was successfully updated. Use $AdminConfig save to commit the changes.");
    }
}

