/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.SecureConversationToken;
import com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class Token
implements PolicyAttributesConstants {
    protected String _name = null;
    private String _includeToken = null;
    private List _modifiers = new ArrayList();
    private SecureConversationToken sctAssertion = null;
    private WssCustomToken wssCT = null;
    private static TraceComponent tc = Tr.register(Token.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");

    Token() {
    }

    static Token getInstance(String string, TokenAssertionType tokenAssertionType) {
        Token token = new Token();
        token._name = string;
        token._includeToken = tokenAssertionType.getIncludeToken();
        List<Object> list = tokenAssertionType.getAny();
        if (!list.isEmpty()) {
            Policy policy = (Policy)list.get(0);
            List<Object> list2 = policy.getPolicyOrAllOrExactlyOne();
            for (int i = 0; i < list2.size(); ++i) {
                Object object = list2.get(i);
                if (object instanceof JAXBElement) {
                    token._modifiers.add(((JAXBElement)object).getName().getLocalPart());
                    continue;
                }
                if (object instanceof WssCustomToken) {
                    token.wssCT = (WssCustomToken)object;
                    continue;
                }
                Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{object.getClass().getName(), string});
            }
        }
        return token;
    }

    static Token getInstance(String string, SecureConversationTokenType secureConversationTokenType) {
        Token token = new Token();
        token._name = string;
        token._includeToken = secureConversationTokenType.getIncludeToken();
        token.sctAssertion = SecureConversationToken.getInstance(secureConversationTokenType);
        return token;
    }

    String getName() {
        return this._name;
    }

    AttributeList getAttributes() {
        return this.getAttributes(-1);
    }

    AttributeList getAttributes(int n) {
        AttributeList attributeList = new AttributeList();
        AttributeList attributeList2 = new AttributeList();
        if (this.sctAssertion != null) {
            attributeList2 = this.sctAssertion.getAttributes();
        }
        if (n < 0) {
            attributeList.add(new Attribute(this._name, attributeList2));
        } else {
            attributeList.add(new Attribute(this._name + "_" + n, attributeList2));
        }
        if (this._includeToken != null) {
            attributeList2.add(new Attribute("IncludeToken", this._includeToken));
        }
        for (int i = 0; i < this._modifiers.size(); ++i) {
            attributeList2.add(new Attribute((String)this._modifiers.get(i), "true"));
        }
        if (this.wssCT != null) {
            AttributeList attributeList3 = new AttributeList();
            attributeList2.add(new Attribute("WssCustomToken", attributeList3));
            if (this.wssCT.getUri() != null) {
                attributeList3.add(new Attribute("uri", this.wssCT.getUri()));
            }
            if (this.wssCT.getLocalname() != null) {
                attributeList3.add(new Attribute("localname", this.wssCT.getLocalname()));
            }
        }
        return attributeList;
    }
}

