/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.AsymmetricBinding;
import com.ibm.ws.wssecurity.admin.BindingAssertion;
import com.ibm.ws.wssecurity.admin.Token;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class SymmetricBinding
extends BindingAssertion
implements PolicyAttributesConstants {
    private static TraceComponent tc = Tr.register(AsymmetricBinding.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private Token _signatureToken = null;
    private Token _encryptionToken = null;
    private Token _protectionToken = null;
    public static final String[] supportedTokes = new String[]{"SignatureToken", "EncryptionToken", "ProtectionToken"};

    SymmetricBinding() {
    }

    void parsePolicy(Policy policy, boolean bl) {
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        for (Object object : list) {
            if (object instanceof JAXBElement) {
                String string = ((JAXBElement)object).getName().getLocalPart();
                if ("IncludeTimestamp".equals(string) || "AlgorithmSuite".equals(string) || "Layout".equals(string)) {
                    this.parseObject((JAXBElement)object);
                    continue;
                }
                NestedPolicyType nestedPolicyType = (NestedPolicyType)((JAXBElement)object).getValue();
                List<Object> list2 = nestedPolicyType.getPolicy().getPolicyOrAllOrExactlyOne();
                if (SymmetricBinding.hasErrorInSymBinding(list2, bl)) continue;
                JAXBElement jAXBElement = (JAXBElement)list2.get(0);
                Token token = null;
                if (jAXBElement.getValue() instanceof SecureConversationTokenType) {
                    token = Token.getInstance(jAXBElement.getName().getLocalPart(), (SecureConversationTokenType)jAXBElement.getValue());
                } else if (jAXBElement.getValue() instanceof TokenAssertionType) {
                    token = Token.getInstance(jAXBElement.getName().getLocalPart(), (TokenAssertionType)jAXBElement.getValue());
                } else {
                    Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{string, "SymmetricBinding"});
                    continue;
                }
                if ("SignatureToken".equals(string)) {
                    this._signatureToken = token;
                    continue;
                }
                if ("EncryptionToken".equals(string)) {
                    this._encryptionToken = token;
                    continue;
                }
                if ("ProtectionToken".equals(string)) {
                    this._protectionToken = token;
                    continue;
                }
                Tr.warning(tc, "CWWSI9002W", (Object)new Object[]{string, "SymmetricBinding"});
                continue;
            }
            Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{object.getClass().getName(), "SymmetricBinding"});
        }
    }

    AttributeList getAttributes() {
        AttributeList attributeList = new AttributeList();
        if (this._signatureToken != null || this._encryptionToken != null) {
            if (this._signatureToken != null) {
                attributeList.add(new Attribute("SignatureToken", this._signatureToken.getAttributes()));
            }
            if (this._encryptionToken != null) {
                attributeList.add(new Attribute("EncryptionToken", this._encryptionToken.getAttributes()));
            }
        } else if (this._protectionToken != null) {
            attributeList.add(new Attribute("ProtectionToken", this._protectionToken.getAttributes()));
        }
        attributeList.addAll(super.getAttributes());
        return attributeList;
    }

    static boolean hasErrorInSymBinding(List list, boolean bl) {
        JAXBElement jAXBElement;
        if (list.isEmpty()) {
            Tr.warning(tc, "CWWSI9003W", (Object)new Object[]{"SymmetricBinding"});
            return true;
        }
        if (list.size() > 1) {
            Tr.warning(tc, "CWWSI9004W", (Object)new Object[]{"SymmetricBinding"});
            return true;
        }
        if (!(list.get(0) instanceof JAXBElement)) {
            Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{list.get(0).getClass().getName(), "SymmetricBinding"});
            return true;
        }
        if (!bl && (jAXBElement = (JAXBElement)list.get(0)).getValue() instanceof SecureConversationTokenType) {
            Tr.warning(tc, "CWWSI9011W");
            return true;
        }
        return false;
    }
}

