/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.wssecurity.admin.AttributesValidation;
import com.ibm.ws.wssecurity.admin.BindingReader;
import com.ibm.ws.wssecurity.admin.BindingWriter;
import com.ibm.ws.wssecurity.admin.NamespacePrefixMapperImpl;
import com.ibm.ws.wssecurity.admin.ObjectModelHelper;
import com.ibm.ws.wssecurity.admin.PolicyBean;
import com.ibm.ws.wssecurity.admin.PolicyValidation;
import com.ibm.ws.wssecurity.admin.SecureConversationTokenHelper;
import com.ibm.ws.wssecurity.handler.PolicyInboundConfig;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

public class SecurityPolicyProvider
implements PolicyAttributesConstants,
PolicyTypeProvider {
    private static TraceComponent tc = Tr.register(SecurityPolicyProvider.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private Policy _policy = null;
    private static ObjectModelHelper policyHelper = ObjectModelHelper.getInstance();
    private static SecureConversationTokenHelper sctHelper = SecureConversationTokenHelper.getInstance();
    protected String className = this.getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";

    public String getType() {
        return "WSSecurity";
    }

    public Properties getAttributes(String string, Properties properties) throws Exception {
        this.loadPolicy(string);
        if (properties == null) {
            properties = new Properties();
        }
        PolicyBean policyBean = new PolicyBean();
        policyBean.init(this._policy, properties, true);
        AttributeList attributeList = policyBean.getAttributes(properties);
        Properties properties2 = PolicyAttributesUtil.getInstance().attributeListToProperties(attributeList, properties);
        return properties2;
    }

    public boolean setAttributes(String string, Properties properties, boolean bl) throws Exception {
        if (properties == null || properties.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setAttributes, attribute list is empty");
            }
            return false;
        }
        Properties properties2 = null;
        properties2 = bl ? new Properties() : this.getAttributes(string, new Properties());
        SecurityPolicyProvider.handleDeleteItems(properties2, properties);
        properties2.putAll((Map<?, ?>)properties);
        AttributesValidation attributesValidation = new AttributesValidation();
        if (!attributesValidation.validateProperties(properties2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateProperties returns false");
            }
            return false;
        }
        AttributeList attributeList = PolicyAttributesUtil.getInstance().propertiesToAttributeList(properties2);
        this._policy = new Policy();
        ObjectModelHelper.getInstance().setAttributes(this._policy, attributeList);
        this.savePolicy(string);
        return true;
    }

    public Properties getBinding(String string, Properties properties) throws Exception {
        BindingReader bindingReader = new BindingReader();
        return bindingReader.getBinding(string, properties);
    }

    public boolean setBinding(String string, Properties properties, boolean bl) throws Exception {
        BindingWriter bindingWriter = new BindingWriter();
        return bindingWriter.setBinding(string, properties, bl);
    }

    public boolean validate(String string, String string2, Session session) throws Exception {
        this.loadPolicy(string2);
        return PolicyValidation.getInstance().validateFullPolicy(this._policy, true);
    }

    protected boolean loadPolicy(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPolicy fileName=" + string);
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        JAXBContext jAXBContext = JAXBContext.newInstance("org.oasis_open.docs.ws_sx.ws_securitypolicy._200512:org.xmlsoap.schemas.ws._2004._09.policy:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext", PolicyInboundConfig.class.getClassLoader());
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        Object object = unmarshaller.unmarshal(fileInputStream);
        this._policy = null;
        if (!(object instanceof Policy)) {
            Tr.error(tc, "CWWSI9034E", string);
            throw new SoapSecurityException("Unmarshalled obj is NOT a Policy object");
        }
        this._policy = (Policy)object;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadPolicy returns true");
        }
        return true;
    }

    protected int savePolicy(String string) throws JAXBException, FileNotFoundException, IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "savePolicy fileName=" + string);
        }
        int n = 0;
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance("org.xmlsoap.schemas.ws._2004._09.policy:org.oasis_open.docs.ws_sx.ws_securitypolicy._200512:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext");
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            Marshaller marshaller = jAXBContext.createMarshaller();
            try {
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", new NamespacePrefixMapperImpl());
                marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            }
            catch (PropertyException propertyException) {
                // empty catch block
            }
            marshaller.marshal((Object)this._policy, fileOutputStream);
        }
        catch (JAXBException jAXBException) {
            FFDCFilter.processException(jAXBException, this.getClass().getName(), FFDC_ID_3);
            Tr.error(tc, "CWWSI9032E", jAXBException);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "savePolicy - caught JAXBException while writing file");
                jAXBException.printStackTrace();
            }
            throw jAXBException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException(fileNotFoundException, this.className, FFDC_ID_4);
            Tr.error(tc, "CWWSI9032E", fileNotFoundException);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "savePolicy - caught FileNotFoundException while writing file");
                fileNotFoundException.printStackTrace();
            }
            throw fileNotFoundException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException(illegalArgumentException, this.className, FFDC_ID_5);
            Tr.error(tc, "CWWSI9032E", illegalArgumentException);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "savePolicy - caught IllegalArgumentException while writing file");
                illegalArgumentException.printStackTrace();
            }
            throw illegalArgumentException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "savePolicy for file " + string);
        }
        return n;
    }

    public Policy getPolicyObject() {
        return this._policy;
    }

    protected static void handleDeleteItems(Properties properties, Properties properties2) {
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (((String)properties2.get(string)).length() != 0) continue;
            Enumeration<Object> enumeration2 = properties.keys();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                if (!string2.startsWith(string)) continue;
                properties.remove(string2);
            }
            properties2.remove(string);
        }
    }
}

