/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.ObjectModelHelper;
import com.ibm.ws.wssecurity.admin.PolicyValidationConstants;
import com.ibm.ws.wssecurity.admin.SymmetricBinding;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.xmlsoap.schemas.ws._2004._08.addressing.AttributedURI;
import org.xmlsoap.schemas.ws._2004._08.addressing.EndpointReferenceType;
import org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

public class SecureConversationTokenHelper
implements PolicyAttributesConstants,
PolicyValidationConstants {
    private static TraceComponent tc = Tr.register(SecureConversationTokenHelper.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private static SecureConversationTokenHelper helper = new SecureConversationTokenHelper();
    public static final String JAXBELEMENT_CLASS_NAME = "javax.xml.bind.JAXBElement";

    public static SecureConversationTokenHelper getInstance() {
        return helper;
    }

    public SecureConversationTokenType getSecureConversationToken(Policy policy) {
        return this.getSecureConversationToken(policy, null);
    }

    public SecureConversationTokenType getSecureConversationToken(Policy policy, List list) {
        ArrayList arrayList = new ArrayList();
        List<Object> list2 = policy.getPolicyOrAllOrExactlyOne();
        for (int i = 0; i < list2.size(); ++i) {
            JAXBElement jAXBElement;
            Object object = list2.get(i);
            if (!(object instanceof JAXBElement) || !"SymmetricBinding".equals((jAXBElement = (JAXBElement)object).getName().getLocalPart())) continue;
            NestedPolicyType nestedPolicyType = (NestedPolicyType)jAXBElement.getValue();
            List<Object> list3 = nestedPolicyType.getPolicy().getPolicyOrAllOrExactlyOne();
            for (int j = 0; j < list3.size(); ++j) {
                JAXBElement jAXBElement2;
                Object object2 = list3.get(j);
                if (!(object2 instanceof JAXBElement)) continue;
                Object t = ((JAXBElement)object2).getValue();
                if (!(t instanceof NestedPolicyType)) {
                    Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{t.getClass().getName(), ((JAXBElement)object2).getName().getLocalPart()});
                    continue;
                }
                NestedPolicyType nestedPolicyType2 = (NestedPolicyType)t;
                List<Object> list4 = nestedPolicyType2.getPolicy().getPolicyOrAllOrExactlyOne();
                if (SymmetricBinding.hasErrorInSymBinding(list4, true) || !((jAXBElement2 = (JAXBElement)list4.get(0)).getValue() instanceof SecureConversationTokenType)) continue;
                arrayList.add(jAXBElement2.getValue());
            }
            if (arrayList.size() > 1) {
                Tr.warning(tc, "CWWSI9005W", (Object)new Object[]{"SymmetricBinding"});
                if (list != null) {
                    list.add(new Boolean(false));
                }
                return null;
            }
            if (arrayList.size() == 1) {
                return (SecureConversationTokenType)arrayList.get(0);
            }
            return null;
        }
        return null;
    }

    public boolean setSCTAttributes(SecureConversationTokenType secureConversationTokenType, AttributeList attributeList) throws Exception {
        if (attributeList.size() == 0) {
            return false;
        }
        Attribute attribute = null;
        boolean bl = false;
        boolean bl2 = false;
        AttributeList attributeList2 = null;
        for (int i = 0; i < attributeList.size(); ++i) {
            attribute = (Attribute)attributeList.get(i);
            if ("IncludeToken".equals(attribute.getName())) {
                secureConversationTokenType.setIncludeToken((String)attribute.getValue());
                continue;
            }
            if ("Issuer".equals(attribute.getName())) {
                this.setIssuer(secureConversationTokenType, (AttributeList)attribute.getValue());
                continue;
            }
            if (attribute.getName().equals("BootstrapPolicy")) {
                bl = true;
                attributeList2 = (AttributeList)attribute.getValue();
                continue;
            }
            bl2 = true;
        }
        if (bl2) {
            List<Object> list = secureConversationTokenType.getAny();
            Policy policy = new Policy();
            list.add(policy);
            ObjectModelHelper.getInstance().addList(policy.getPolicyOrAllOrExactlyOne(), attributeList, "IncludeToken");
        }
        if (bl) {
            this.setBootstrapPolicy(secureConversationTokenType, attributeList2);
        }
        return true;
    }

    private void setIssuer(SecureConversationTokenType secureConversationTokenType, AttributeList attributeList) throws Exception {
        if (attributeList.isEmpty() && secureConversationTokenType.getIssuer() == null) {
            return;
        }
        if (secureConversationTokenType.getIssuer() == null) {
            secureConversationTokenType.setIssuer(new EndpointReferenceType());
        }
        List<Object> list = secureConversationTokenType.getIssuer().getAny();
        JAXBElement<EndpointReferenceType> jAXBElement = new JAXBElement<EndpointReferenceType>(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "EndpointReference"), Class.forName(JAXBELEMENT_CLASS_NAME), new EndpointReferenceType());
        list.add(jAXBElement);
        EndpointReferenceType endpointReferenceType = jAXBElement.getValue();
        Attribute attribute = (Attribute)attributeList.get(0);
        String string = (String)attribute.getValue();
        if ("Address".equals(attribute.getName())) {
            if (endpointReferenceType.getAddress() == null) {
                endpointReferenceType.setAddress(new AttributedURI());
            }
            endpointReferenceType.getAddress().setValue((String)attribute.getValue());
        }
    }

    private void setBootstrapPolicy(SecureConversationTokenType secureConversationTokenType, AttributeList attributeList) throws Exception {
        List<Object> list = secureConversationTokenType.getAny();
        OperatorContentType operatorContentType = null;
        if (!list.isEmpty()) {
            operatorContentType = (Policy)list.get(0);
        }
        if (operatorContentType == null) {
            operatorContentType = new Policy();
            list.add(operatorContentType);
        }
        List<Object> list2 = operatorContentType.getPolicyOrAllOrExactlyOne();
        NestedPolicyType nestedPolicyType = new NestedPolicyType();
        nestedPolicyType.setPolicy(new Policy());
        list2.add(new JAXBElement<NestedPolicyType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "BootstrapPolicy"), Class.forName(JAXBELEMENT_CLASS_NAME), nestedPolicyType));
        ObjectModelHelper.getInstance().setAttributes(nestedPolicyType.getPolicy(), attributeList);
    }
}

