/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.PolicyBean;
import com.ibm.ws.wssecurity.admin.SecureConversationTokenHelper;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.xmlsoap.schemas.ws._2004._08.addressing.EndpointReferenceType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class SecureConversationToken
implements PolicyAttributesConstants {
    private String issuer_address = null;
    private PolicyBean bootstrap = null;
    private ArrayList assertions = new ArrayList();
    private static TraceComponent tc = Tr.register(SecureConversationTokenHelper.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");

    SecureConversationToken() {
    }

    static SecureConversationToken getInstance(SecureConversationTokenType secureConversationTokenType) {
        Object object;
        SecureConversationToken secureConversationToken = new SecureConversationToken();
        EndpointReferenceType endpointReferenceType = secureConversationTokenType.getIssuer();
        if (endpointReferenceType != null && !endpointReferenceType.getAny().isEmpty() && (endpointReferenceType = (EndpointReferenceType)((JAXBElement)(object = (JAXBElement)endpointReferenceType.getAny().get(0))).getValue()).getAddress() != null) {
            secureConversationToken.issuer_address = endpointReferenceType.getAddress().getValue();
        }
        object = secureConversationTokenType.getAny();
        Object object2 = null;
        JAXBElement jAXBElement = null;
        for (int i = 0; i < object.size(); ++i) {
            object2 = object.get(i);
            if (object2 instanceof Policy) {
                List<Object> list = ((Policy)object2).getPolicyOrAllOrExactlyOne();
                for (int j = 0; j < list.size(); ++j) {
                    if (list.get(j) instanceof JAXBElement) {
                        jAXBElement = (JAXBElement)list.get(j);
                        if (jAXBElement.getValue() instanceof NestedPolicyType) {
                            if ("BootstrapPolicy".equals(jAXBElement.getName().getLocalPart())) {
                                NestedPolicyType nestedPolicyType = (NestedPolicyType)jAXBElement.getValue();
                                secureConversationToken.bootstrap = new PolicyBean();
                                secureConversationToken.bootstrap.init(nestedPolicyType.getPolicy(), null, false);
                                continue;
                            }
                            Tr.warning(tc, "CWWSI9002W", (Object)new Object[]{jAXBElement.getName().getLocalPart(), "SecureConversationToken"});
                            continue;
                        }
                        secureConversationToken.assertions.add(jAXBElement.getName().getLocalPart());
                        continue;
                    }
                    Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{list.get(j).getClass().getName(), "SecureConversationToken policy assertion"});
                }
                continue;
            }
            Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{object2.getClass().getName(), "SecureConversationToken"});
        }
        return secureConversationToken;
    }

    AttributeList getAttributes() {
        AttributeList attributeList = new AttributeList();
        if (this.issuer_address != null) {
            AttributeList attributeList2 = new AttributeList();
            attributeList2.add(new Attribute("Address", this.issuer_address));
            attributeList.add(new Attribute("Issuer", attributeList2));
        }
        if (this.bootstrap != null) {
            attributeList.add(new Attribute("BootstrapPolicy", this.bootstrap.getAttributes(null)));
        }
        for (int i = 0; i < this.assertions.size(); ++i) {
            attributeList.add(new Attribute((String)this.assertions.get(i), "true"));
        }
        return attributeList;
    }
}

