/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.EncryptionProtectionAssertion;
import com.ibm.ws.wssecurity.admin.PartsElement;
import com.ibm.ws.wssecurity.admin.PartsType;
import com.ibm.ws.wssecurity.admin.SignatureProtectionAssertion;
import com.ibm.ws.wssecurity.admin.Token;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SePartsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class ProtectionAssertion
implements PolicyAttributesConstants {
    private static TraceComponent tc = Tr.register(Token.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private String _id = null;
    private String _typeName = null;
    private PartsType _partsType = null;
    private String _elementName = null;
    private PartsElement _partsElement = null;

    ProtectionAssertion() {
    }

    public String getId() {
        return this._id;
    }

    public void setId(String string) {
        this._id = string;
    }

    public PartsElement getPartsElement() {
        return this._partsElement;
    }

    public void setPartsElement(PartsElement partsElement) {
        this._partsElement = partsElement;
    }

    public PartsType getPartsType() {
        return this._partsType;
    }

    public void setPartsType(PartsType partsType) {
        this._partsType = partsType;
    }

    AttributeList getAttributes() {
        AttributeList attributeList = new AttributeList();
        AttributeList attributeList2 = new AttributeList();
        attributeList.add(new Attribute(this._id, attributeList2));
        if (this._partsType != null) {
            attributeList2.add(new Attribute(this._typeName, this._partsType.getAttributes()));
        }
        if (this._partsElement != null) {
            attributeList2.add(new Attribute(this._elementName, this._partsElement.getAttributes()));
        }
        return attributeList;
    }

    static ProtectionAssertion getInstance(Policy policy) {
        ProtectionAssertion protectionAssertion = null;
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        if (!list.isEmpty()) {
            JAXBElement jAXBElement = (JAXBElement)list.get(0);
            if (jAXBElement.getName().getLocalPart().startsWith("Signed")) {
                protectionAssertion = new SignatureProtectionAssertion();
            } else if (jAXBElement.getName().getLocalPart().startsWith("Encrypted")) {
                protectionAssertion = new EncryptionProtectionAssertion();
            } else {
                Tr.warning(tc, "CWWSI9002W", (Object)new Object[]{jAXBElement.getName().getLocalPart(), "Protection assertion"});
                return null;
            }
            protectionAssertion.setId(policy.getId());
            for (Object object : list) {
                if (object instanceof JAXBElement) {
                    jAXBElement = (JAXBElement)object;
                    String string = jAXBElement.getName().getLocalPart();
                    if (string.endsWith("Parts")) {
                        protectionAssertion._typeName = string;
                        protectionAssertion._partsType = PartsType.getInstance((SePartsType)jAXBElement.getValue());
                        continue;
                    }
                    if (string.endsWith("Elements")) {
                        protectionAssertion._elementName = string;
                        protectionAssertion._partsElement = PartsElement.getInstance((SerElementsType)jAXBElement.getValue());
                        continue;
                    }
                    Tr.warning(tc, "CWWSI9002W", (Object)new Object[]{string, "Protection assertion"});
                    continue;
                }
                Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{object.getClass().getName(), "Protection assertion"});
            }
        }
        return protectionAssertion;
    }
}

