/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.admin.AttributesValidation;
import com.ibm.ws.wssecurity.admin.PolicyValidationConstants;
import com.ibm.ws.wssecurity.admin.SecureConversationTokenHelper;
import com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.HeaderType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SePartsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class PolicyValidation
implements PolicyAttributesConstants,
PolicyValidationConstants {
    private static PolicyValidation instance = new PolicyValidation();
    private static TraceComponent tc = Tr.register(PolicyValidation.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    protected String className = this.getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";

    PolicyValidation() {
    }

    public static PolicyValidation getInstance() {
        return instance;
    }

    public boolean validateFullPolicy(Policy policy, boolean bl) {
        boolean bl2 = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = true;
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        for (Object object : list) {
            if (object instanceof Policy) {
                bl3 = this.validateProtection((Policy)object);
            } else if (object instanceof JAXBElement) {
                String string = ((JAXBElement)object).getName().getLocalPart();
                if ((object = ((JAXBElement)object).getValue()) instanceof NestedPolicyType) {
                    if ("AsymmetricBinding".equals(string)) {
                        bl3 = this.validateBinding((NestedPolicyType)object, string, asymbinding_supportedTokens, false);
                        ++n;
                    } else if ("SymmetricBinding".equals(string)) {
                        bl3 = this.validateBinding((NestedPolicyType)object, string, symbinding_supportedTokens, bl);
                        ++n;
                        ArrayList arrayList = new ArrayList();
                        SecureConversationTokenType secureConversationTokenType = SecureConversationTokenHelper.getInstance().getSecureConversationToken(policy, arrayList);
                        if (!arrayList.isEmpty()) {
                            bl3 = false;
                        } else if (secureConversationTokenType != null && !this.validateSCT(secureConversationTokenType)) {
                            bl3 = false;
                        }
                    } else if ("Wss10".equals(string)) {
                        bl3 = this.validateWssOrTrust(((NestedPolicyType)object).getPolicy(), string, wss10_supportedAssertions);
                        ++n2;
                    } else if ("Wss11".equals(string)) {
                        bl3 = this.validateWssOrTrust(((NestedPolicyType)object).getPolicy(), string, wss11_supportedAssertions);
                        ++n3;
                    } else if ("Trust10".equals(string)) {
                        bl3 = this.validateWssOrTrust(((NestedPolicyType)object).getPolicy(), string, trust10_supportedAssertions);
                        ++n4;
                    } else if ("SupportingTokens".equals(string)) {
                        bl3 = this.validateSupportTokens(((NestedPolicyType)object).getPolicy());
                    } else {
                        Tr.warning(tc, "CWWSI9002W", (Object)new Object[]{string, "Top level assertions"});
                        bl2 = false;
                    }
                } else {
                    Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{object.getClass().getName(), string});
                    bl2 = false;
                }
            } else {
                Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{object.getClass().getName(), "Top level assertions"});
                bl2 = false;
            }
            if (bl3) continue;
            bl2 = false;
        }
        if (n > 1) {
            Tr.warning(tc, "CWWSI9019W");
            bl2 = false;
        }
        if (n2 > 1) {
            Tr.warning(tc, "CWWSI9020W", (Object)new Object[]{"Wss10"});
            bl2 = false;
        }
        if (n3 > 1) {
            Tr.warning(tc, "CWWSI9020W", (Object)new Object[]{"Wss11"});
            bl2 = false;
        }
        if (n4 > 1) {
            Tr.warning(tc, "CWWSI9020W", (Object)new Object[]{"Trust10"});
            bl2 = false;
        }
        return bl2;
    }

    private boolean validateProtection(Policy policy) {
        boolean bl = true;
        try {
            if (!this.validateID(policy.getId(), "Protection assertion")) {
                bl = false;
            }
            List<Object> list = policy.getPolicyOrAllOrExactlyOne();
            JAXBElement jAXBElement = null;
            String string = null;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) instanceof JAXBElement) {
                    jAXBElement = (JAXBElement)list.get(i);
                    string = jAXBElement.getName().getLocalPart();
                    if (!AttributesValidation.isSupported(string, supportedProtectionTokens)) {
                        Tr.warning(tc, "CWWSI9002W", (Object)new Object[]{string, "Protection assertion"});
                        bl = false;
                        continue;
                    }
                    if (string.endsWith("Parts")) {
                        if (!(jAXBElement.getValue() instanceof SePartsType)) {
                            Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{jAXBElement.getValue().getClass().getName(), string});
                            bl = false;
                            continue;
                        }
                        bl &= this.validateHeaderValue((SePartsType)jAXBElement.getValue(), policy.getId());
                        continue;
                    }
                    if (!string.endsWith("Elements")) continue;
                    if (!(jAXBElement.getValue() instanceof SerElementsType)) {
                        Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{jAXBElement.getValue().getClass().getName(), string});
                        bl = false;
                        continue;
                    }
                    bl &= this.validateXPathValue((SerElementsType)jAXBElement.getValue(), policy.getId());
                    continue;
                }
                Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{list.get(i).getClass().getName(), "Protection assertion"});
                bl = false;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.className + ".validateProtection", FFDC_ID_1);
            Tr.error(tc, "CWWSI9033E", exception);
            bl = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateProtection returns " + bl);
        }
        return bl;
    }

    private boolean validateHeaderValue(SePartsType sePartsType, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateHeaderValue for " + string);
        }
        boolean bl = true;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        List<HeaderType> list = sePartsType.getHeader();
        HeaderType headerType = null;
        String string2 = null;
        StringBuffer stringBuffer = null;
        for (int i = 0; i < list.size(); ++i) {
            headerType = list.get(i);
            stringBuffer = new StringBuffer();
            stringBuffer.append("Namespace=").append(headerType.getNamespace());
            if (headerType.getName() != null) {
                stringBuffer.append(", Name=").append(headerType.getName());
            }
            if (hashMap.containsKey(string2 = stringBuffer.toString())) {
                Integer n = (Integer)hashMap.get(string2);
                Tr.warning(tc, "CWWSI9030W", "Header_" + n + " and Header_" + i + " have same value: " + string2 + ", under id " + string);
                bl = false;
                continue;
            }
            hashMap.put(string2, new Integer(i));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateHeaderValue returns " + bl);
        }
        return bl;
    }

    private boolean validateXPathValue(SerElementsType serElementsType, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateXPathValue for " + string);
        }
        boolean bl = true;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        List<String> list = serElementsType.getXPath();
        String string2 = null;
        for (int i = 0; i < list.size(); ++i) {
            string2 = list.get(i);
            if (hashMap.containsKey(string2)) {
                Integer n = (Integer)hashMap.get(string2);
                Tr.warning(tc, "CWWSI9029W", "XPath_" + n + " and XPath_" + i + " have same value " + string2 + ", under id " + string);
                bl = false;
                continue;
            }
            hashMap.put(string2, new Integer(i));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateXPathValue returns " + bl);
        }
        return bl;
    }

    private boolean validateWssOrTrust(Policy policy, String string, String[] stringArray) {
        boolean bl = true;
        try {
            List<Object> list = policy.getPolicyOrAllOrExactlyOne();
            bl = this.validateJAXBElementList(list, string, stringArray, false);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.className + ".validateWssOrTrust", FFDC_ID_2);
            Tr.error(tc, "CWWSI9033E", exception);
            bl = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateWssOrTrust returns " + bl);
        }
        return bl;
    }

    private boolean validateSupportTokens(Policy policy) {
        boolean bl = true;
        try {
            List<Object> list;
            if (!this.validateID(policy.getId(), "SupportingToken")) {
                bl = false;
            }
            if (this.validateJAXBElementList(list = policy.getPolicyOrAllOrExactlyOne(), "SupportingTokens", supportingTokens_supportedSubTokens, true)) {
                JAXBElement jAXBElement = (JAXBElement)list.get(0);
                if (!this.validateTokenAssertion(jAXBElement.getValue(), jAXBElement.getName().getLocalPart(), null)) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            FFDCFilter.processException(exception, this.className + ".validateSupportTokens", FFDC_ID_3);
            Tr.error(tc, "CWWSI9033E", exception);
            bl = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateSupportTokens returns " + bl);
        }
        return bl;
    }

    private boolean validateBinding(NestedPolicyType nestedPolicyType, String string, String[] stringArray, boolean bl) {
        boolean bl2 = true;
        try {
            boolean bl3 = false;
            if ("SymmetricBinding".equals(string)) {
                bl3 = true;
            }
            List<Object> list = nestedPolicyType.getPolicy().getPolicyOrAllOrExactlyOne();
            JAXBElement jAXBElement = null;
            String string2 = null;
            NestedPolicyType nestedPolicyType2 = null;
            List<Object> list2 = null;
            if (!this.validateJAXBElementList(list, string, stringArray, false)) {
                bl2 = false;
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof JAXBElement)) continue;
                    jAXBElement = (JAXBElement)list.get(i);
                    string2 = jAXBElement.getName().getLocalPart();
                    if ("AlgorithmSuite".equals(string2)) {
                        nestedPolicyType2 = (NestedPolicyType)jAXBElement.getValue();
                        list2 = nestedPolicyType2.getPolicy().getPolicyOrAllOrExactlyOne();
                        if (this.validateJAXBElementList(list2, "AlgorithmSuite", algorithmSuite_supportedValues, false)) continue;
                        bl2 = false;
                        continue;
                    }
                    if ("Layout".equals(string2)) {
                        nestedPolicyType2 = (NestedPolicyType)jAXBElement.getValue();
                        list2 = nestedPolicyType2.getPolicy().getPolicyOrAllOrExactlyOne();
                        if (this.validateJAXBElementList(list2, "Layout", layout_supportedValues, true)) continue;
                        bl2 = false;
                        continue;
                    }
                    if ("IncludeTimestamp".equals(string2) || this.validateSubTokens((NestedPolicyType)jAXBElement.getValue(), string, string2, bl3, bl)) continue;
                    bl2 = false;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.className + ".validateBinding", FFDC_ID_4);
            Tr.error(tc, "CWWSI9033E", exception);
            bl2 = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateBinding returns " + bl2);
        }
        return bl2;
    }

    private boolean validateSubTokens(NestedPolicyType nestedPolicyType, String string, String string2, boolean bl, boolean bl2) {
        boolean bl3 = true;
        try {
            String[] stringArray = null;
            HashMap hashMap = null;
            if ("SymmetricBinding".equals(string)) {
                stringArray = symbinding_supportedSubTokens;
            } else {
                stringArray = asymbinding_supportedSubTokens;
                hashMap = new HashMap();
            }
            List<Object> list = nestedPolicyType.getPolicy().getPolicyOrAllOrExactlyOne();
            if (!this.validateJAXBElementList(list, string2, stringArray, bl)) {
                bl3 = false;
            } else {
                JAXBElement jAXBElement = null;
                String string3 = null;
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof JAXBElement)) continue;
                    jAXBElement = (JAXBElement)list.get(i);
                    string3 = jAXBElement.getName().getLocalPart();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "validateSubTokens, type=" + string + ", subToken=" + string2 + ", name=" + string3);
                    }
                    if ("SecureConversationToken".equals(string3)) {
                        if (bl2 || !"SymmetricBinding".equals(string)) continue;
                        Tr.warning(tc, "CWWSI9011W");
                        bl3 = false;
                        continue;
                    }
                    if (this.validateTokenAssertion(jAXBElement.getValue(), string3, hashMap)) continue;
                    bl3 = false;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.className + ".validateSubTokens", FFDC_ID_6);
            Tr.error(tc, "CWWSI9033E", exception);
            bl3 = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateSubTokens returns " + bl3 + " type=" + string + ", subTokne=" + string2);
        }
        return bl3;
    }

    private boolean validateSCT(SecureConversationTokenType secureConversationTokenType) {
        boolean bl = true;
        try {
            List<Object> list = secureConversationTokenType.getAny();
            Object object = null;
            JAXBElement jAXBElement = null;
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                if (object instanceof Policy) {
                    List<Object> list2 = ((Policy)object).getPolicyOrAllOrExactlyOne();
                    if (!this.validateJAXBElementList(list2, "SecureConversationToken", sct_supportedSubAssertions, false)) {
                        bl = false;
                    }
                    for (int j = 0; j < list2.size(); ++j) {
                        if (!(list2.get(j) instanceof JAXBElement) || !((jAXBElement = (JAXBElement)list2.get(j)).getValue() instanceof NestedPolicyType)) continue;
                        if ("BootstrapPolicy".equals(jAXBElement.getName().getLocalPart())) {
                            NestedPolicyType nestedPolicyType = (NestedPolicyType)jAXBElement.getValue();
                            if (this.validateFullPolicy(nestedPolicyType.getPolicy(), false)) continue;
                            bl = false;
                            continue;
                        }
                        Tr.warning(tc, "CWWSI9002W", (Object)new Object[]{jAXBElement.getName().getLocalPart(), "SecureConversationToken"});
                        bl = false;
                    }
                    continue;
                }
                Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{object.getClass().getName(), "SecureConversationToken"});
                bl = false;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.className + ".validateSecureConversationTokens", FFDC_ID_5);
            Tr.error(tc, "CWWSI9033E", exception);
            bl = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateSCT returns " + bl);
        }
        return bl;
    }

    private boolean validateID(String string, String string2) {
        if (string == null || !string.startsWith("request:") && !string.startsWith("response:")) {
            Tr.warning(tc, "CWWSI9009W", (Object)new Object[]{string, string2});
            return false;
        }
        return true;
    }

    private boolean validateJAXBElementList(List list, String string, String[] stringArray, boolean bl) {
        boolean bl2 = true;
        if (list.isEmpty()) {
            Tr.warning(tc, "CWWSI9003W", (Object)new Object[]{string});
            bl2 = false;
        } else if (bl && list.size() > 1) {
            Tr.warning(tc, "CWWSI9004W", (Object)new Object[]{string});
            bl2 = false;
        }
        Object object = null;
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object instanceof JAXBElement) {
                String string2 = ((JAXBElement)object).getName().getLocalPart();
                if (stringArray == null || AttributesValidation.isSupported(string2, stringArray)) continue;
                Tr.warning(tc, "CWWSI9002W", (Object)new Object[]{string2, string});
                bl2 = false;
                continue;
            }
            Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{object.getClass().getName(), string});
            bl2 = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateJAXBElementList returns " + bl2 + " for " + string);
        }
        return bl2;
    }

    private boolean validateTokenAssertion(Object object, String string, HashMap hashMap) {
        boolean bl = true;
        if (!(object instanceof TokenAssertionType)) {
            Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{string + ".TokenAssertionType"});
            bl = false;
        } else {
            List<Object> list;
            TokenAssertionType tokenAssertionType = (TokenAssertionType)object;
            String string2 = tokenAssertionType.getIncludeToken();
            if (!AttributesValidation.isSupported(string2, includeToken_supportedValues)) {
                Tr.warning(tc, "CWWSI9010W", (Object)new Object[]{"IncludeToken", string});
                bl = false;
            }
            if ((list = tokenAssertionType.getAny()).isEmpty()) {
                if (!"LTPAToken".equals(string) && !"LTPAPropagationToken".equals(string)) {
                    Tr.warning(tc, "CWWSI9003W", string);
                    bl = false;
                }
            } else {
                List<Object> list2 = ((Policy)list.get(0)).getPolicyOrAllOrExactlyOne();
                if ("CustomToken".equals(string)) {
                    if (list2.isEmpty()) {
                        Tr.warning(tc, "CWWSI9003W", string);
                        bl = false;
                    } else if (!(list2.get(0) instanceof WssCustomToken)) {
                        Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{"CustomToken"});
                        bl = false;
                    }
                } else if ("UsernameToken".equals(string)) {
                    if (!this.validateJAXBElementList(list2, string, usernameToken_supportedSubAssertions, false)) {
                        bl = false;
                    }
                } else if ("X509Token".equals(string)) {
                    if (!this.validateJAXBElementList(list2, string, x509Token_supportedSubAssertions, false)) {
                        bl = false;
                    }
                    if (hashMap != null && !list2.isEmpty()) {
                        String string3 = null;
                        if (list2.get(0) instanceof JAXBElement) {
                            string3 = ((JAXBElement)list2.get(0)).getName().getLocalPart();
                            if (hashMap.containsKey(string3)) {
                                Tr.warning(tc, "CWWSI9020W", (Object)new Object[]{string3, string});
                                bl = false;
                            } else {
                                hashMap.put(string3, string3);
                            }
                        }
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateTokenAssertion returns " + bl + " for " + string);
        }
        return bl;
    }
}

