/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.admin.BindingAssertion;
import com.ibm.ws.wssecurity.admin.EncryptionProtectionAssertion;
import com.ibm.ws.wssecurity.admin.ProtectionAssertion;
import com.ibm.ws.wssecurity.admin.SignatureProtectionAssertion;
import com.ibm.ws.wssecurity.admin.SupportingTokens;
import com.ibm.ws.wssecurity.admin.Trust10Assertion;
import com.ibm.ws.wssecurity.admin.Wss10Assertion;
import com.ibm.ws.wssecurity.admin.Wss11Assertion;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class PolicyBean
implements PolicyAttributesConstants {
    private static TraceComponent tc = Tr.register(PolicyBean.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private Policy _policy = null;
    private BindingAssertion _bindingAssertion = null;
    private Wss10Assertion _wss10Assertion = null;
    private Wss11Assertion _wss11Assertion = null;
    private Trust10Assertion _trust10Assertion = null;
    private List _signatureProtectionAssertions = new ArrayList();
    private List _encryptionProtectionAssertions = new ArrayList();
    private List _supportingTokens = new ArrayList();
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String className = this.getClass().getName();

    PolicyBean() {
    }

    void init(Policy policy, Properties properties, boolean bl) {
        this._policy = policy;
        this.parseObjects(properties, bl);
    }

    AttributeList getAttributes(Properties properties) {
        AttributeList attributeList = new AttributeList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAttributes: _bindingAssertion=" + this._bindingAssertion);
        }
        if (this._bindingAssertion != null) {
            attributeList.add(new Attribute(this._bindingAssertion.getName(), this._bindingAssertion.getAttributes()));
        }
        if (this._wss10Assertion != null) {
            attributeList.add(new Attribute("Wss10", this._wss10Assertion.getAttributes()));
        }
        if (this._wss11Assertion != null) {
            attributeList.add(new Attribute("Wss11", this._wss11Assertion.getAttributes()));
        }
        if (this._trust10Assertion != null) {
            attributeList.add(new Attribute("Trust10", this._trust10Assertion.getAttributes()));
        }
        Iterator iterator = this._signatureProtectionAssertions.iterator();
        while (iterator.hasNext()) {
            attributeList.add(new Attribute("SignatureProtection", ((ProtectionAssertion)iterator.next()).getAttributes()));
        }
        iterator = this._encryptionProtectionAssertions.iterator();
        while (iterator.hasNext()) {
            attributeList.add(new Attribute("EncryptionProtection", ((ProtectionAssertion)iterator.next()).getAttributes()));
        }
        iterator = this._supportingTokens.iterator();
        while (iterator.hasNext()) {
            attributeList.add(new Attribute("SupportingTokens", ((SupportingTokens)iterator.next()).getAttributes()));
        }
        return attributeList;
    }

    void parseObjects(Properties properties, boolean bl) {
        boolean[] blArray = new boolean[TOP_ASSERTION_TYPES.length];
        this.setRequestedArray(blArray, properties);
        List<Object> list = this._policy.getPolicyOrAllOrExactlyOne();
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                Object object;
                Object object2 = iterator.next();
                if (object2 instanceof Policy) {
                    object = ProtectionAssertion.getInstance((Policy)object2);
                    if (object != null && object instanceof SignatureProtectionAssertion) {
                        if (!this.isRequested("SignatureProtection", blArray)) continue;
                        this._signatureProtectionAssertions.add(object);
                        continue;
                    }
                    if (object == null || !(object instanceof EncryptionProtectionAssertion) || !this.isRequested("EncryptionProtection", blArray)) continue;
                    this._encryptionProtectionAssertions.add(object);
                    continue;
                }
                if (object2 instanceof JAXBElement) {
                    object = ((JAXBElement)object2).getName().getLocalPart();
                    if (!this.isRequested((String)object, blArray)) continue;
                    if ((object2 = ((JAXBElement)object2).getValue()) instanceof NestedPolicyType) {
                        if ("AsymmetricBinding".equals(object)) {
                            this._bindingAssertion = BindingAssertion.getInstance((String)object, (NestedPolicyType)object2, false);
                            continue;
                        }
                        if ("SymmetricBinding".equals(object)) {
                            this._bindingAssertion = BindingAssertion.getInstance((String)object, (NestedPolicyType)object2, bl);
                            continue;
                        }
                        if ("Wss10".equals(object)) {
                            this._wss10Assertion = Wss10Assertion.getInstance(((NestedPolicyType)object2).getPolicy());
                            continue;
                        }
                        if ("Wss11".equals(object)) {
                            this._wss11Assertion = Wss11Assertion.getInstance(((NestedPolicyType)object2).getPolicy());
                            continue;
                        }
                        if ("Trust10".equals(object)) {
                            this._trust10Assertion = Trust10Assertion.getInstance(((NestedPolicyType)object2).getPolicy());
                            continue;
                        }
                        if ("SupportingTokens".equals(object)) {
                            this._supportingTokens.add(SupportingTokens.getInstance(((NestedPolicyType)object2).getPolicy()));
                            continue;
                        }
                        Tr.warning(tc, "CWWSI9002W", (Object)new Object[]{object, "Top level assertions"});
                        continue;
                    }
                    Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{object2.getClass().getName(), object});
                    continue;
                }
                Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{object2.getClass().getName(), "Top level assertions"});
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    exception.printStackTrace();
                }
                FFDCFilter.processException(exception, this.className + ".parsePolicy", FFDC_ID_1);
                Tr.error(tc, "CWWSI9033E", exception);
            }
        }
    }

    private void setRequestedArray(boolean[] blArray, Properties properties) {
        if (properties == null || properties.size() == 0) {
            for (int i = 0; i < TOP_ASSERTION_TYPES.length; ++i) {
                blArray[i] = true;
            }
        } else {
            for (int i = 0; i < TOP_ASSERTION_TYPES.length; ++i) {
                blArray[i] = false;
            }
            Enumeration<?> enumeration = properties.propertyNames();
            String string = null;
            block2: while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                for (int i = 0; i < TOP_ASSERTION_TYPES.length; ++i) {
                    if (!string.startsWith(TOP_ASSERTION_TYPES[i])) continue;
                    blArray[i] = true;
                    continue block2;
                }
            }
        }
    }

    private boolean isRequested(String string, boolean[] blArray) {
        for (int i = 0; i < TOP_ASSERTION_TYPES.length; ++i) {
            if (!TOP_ASSERTION_TYPES[i].equals(string)) continue;
            return blArray[i];
        }
        Tr.warning(tc, "CWWSI9033E", (Object)new Object[]{string, "Top level assertions"});
        return false;
    }
}

