/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.PolicyValidationConstants;
import com.ibm.ws.wssecurity.admin.SecureConversationTokenHelper;
import com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.EmptyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.HeaderType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.QNameAssertionType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SePartsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

public class ObjectModelHelper
implements PolicyAttributesConstants,
PolicyValidationConstants {
    private static TraceComponent tc = Tr.register(ObjectModelHelper.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private static ObjectModelHelper helper = new ObjectModelHelper();
    private SecureConversationTokenHelper sctHelper = SecureConversationTokenHelper.getInstance();
    public static final String JAXBELEMENT_CLASS_NAME = "javax.xml.bind.JAXBElement";

    public static ObjectModelHelper getInstance() {
        return helper;
    }

    protected boolean setAttributes(Policy policy, AttributeList attributeList) throws Exception {
        Attribute attribute = null;
        String string = null;
        Attribute attribute2 = null;
        AttributeList attributeList2 = null;
        AttributeList attributeList3 = null;
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        for (int i = 0; i < attributeList.size(); ++i) {
            attribute = (Attribute)attributeList.get(i);
            string = attribute.getName();
            if (string.equals("SupportingTokens") || string.equals("EncryptionProtection") || string.equals("SignatureProtection")) {
                attributeList2 = (AttributeList)attribute.getValue();
                for (int j = 0; j < attributeList2.size(); ++j) {
                    attribute2 = (Attribute)attributeList2.get(j);
                    attributeList3 = new AttributeList();
                    attributeList3.add(attribute2);
                    list.add(this.createObject(new Attribute(string, attributeList3)));
                }
                continue;
            }
            list.add(this.createObject(attribute));
        }
        return true;
    }

    public Object createObject(Attribute attribute) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createObject, " + attribute.getName());
        }
        Object object = null;
        String string = attribute.getName();
        AttributeList attributeList = (AttributeList)attribute.getValue();
        if ("AsymmetricBinding".equals(string) || "SymmetricBinding".equals(string)) {
            object = this.createBinding(attribute, string);
        } else if ("Wss10".equals(string) || "Wss11".equals(string) || "Trust10".equals(string)) {
            object = this.createWssOrTrust(attribute, string);
        } else if ("SignatureProtection".equals(string) || "EncryptionProtection".equals(string)) {
            object = this.createProtection(attribute);
        } else if ("SupportingTokens".equals(string)) {
            object = this.createSupportingTokens(attribute);
        } else {
            Tr.warning(tc, "CWWSI9014W", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createObject, " + object);
        }
        return object;
    }

    private Object createWssOrTrust(Attribute attribute, String string) throws ClassNotFoundException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createWssOrTrust type=" + string);
        }
        NestedPolicyType nestedPolicyType = new NestedPolicyType();
        nestedPolicyType.setPolicy(new Policy());
        JAXBElement<NestedPolicyType> jAXBElement = new JAXBElement<NestedPolicyType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", string), Class.forName(JAXBELEMENT_CLASS_NAME), nestedPolicyType);
        this.addList(nestedPolicyType.getPolicy().getPolicyOrAllOrExactlyOne(), (AttributeList)attribute.getValue(), "");
        return jAXBElement;
    }

    private Object createProtection(Attribute attribute) throws ClassNotFoundException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createProtection");
        }
        AttributeList attributeList = (AttributeList)attribute.getValue();
        Attribute attribute2 = (Attribute)attributeList.get(0);
        String string = attribute2.getName();
        AttributeList attributeList2 = (AttributeList)attribute2.getValue();
        Policy policy = new Policy();
        policy.setId(string);
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        for (int i = 0; i < attributeList2.size(); ++i) {
            attribute2 = (Attribute)attributeList2.get(i);
            if (attribute2.getName().equals("EncryptedParts") || attribute2.getName().equals("SignedParts")) {
                this.setSePartsType(list, attribute2);
                continue;
            }
            if (!attribute2.getName().equals("EncryptedElements") && !attribute2.getName().equals("SignedElements")) continue;
            this.setSerElementsType(list, attribute2);
        }
        return policy;
    }

    private void setSePartsType(List list, Attribute attribute) throws ClassNotFoundException {
        AttributeList attributeList = (AttributeList)attribute.getValue();
        Attribute attribute2 = null;
        SePartsType sePartsType = null;
        sePartsType = new SePartsType();
        list.add(new JAXBElement<SePartsType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", attribute.getName()), Class.forName(JAXBELEMENT_CLASS_NAME), sePartsType));
        for (int i = 0; i < attributeList.size(); ++i) {
            attribute2 = (Attribute)attributeList.get(i);
            if (!attribute2.getName().equals("Body")) continue;
            sePartsType.setBody(new EmptyType());
            break;
        }
        this.addNoKeyList(sePartsType.getHeader(), attributeList);
    }

    private void setSerElementsType(List list, Attribute attribute) throws ClassNotFoundException {
        AttributeList attributeList = (AttributeList)attribute.getValue();
        Attribute attribute2 = null;
        SerElementsType serElementsType = null;
        serElementsType = new SerElementsType();
        list.add(new JAXBElement<SerElementsType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", attribute.getName()), Class.forName(JAXBELEMENT_CLASS_NAME), serElementsType));
        for (int i = 0; i < attributeList.size(); ++i) {
            attribute2 = (Attribute)attributeList.get(i);
            if (!attribute2.getName().equals("XPathVersion")) continue;
            serElementsType.setXPathVersion((String)attribute2.getValue());
            break;
        }
        this.addNoKeyList(serElementsType.getXPath(), attributeList);
    }

    private Object createSupportingTokens(Attribute attribute) throws Exception {
        AttributeList attributeList = (AttributeList)attribute.getValue();
        NestedPolicyType nestedPolicyType = new NestedPolicyType();
        nestedPolicyType.setPolicy(new Policy());
        JAXBElement<NestedPolicyType> jAXBElement = new JAXBElement<NestedPolicyType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SupportingTokens"), Class.forName(JAXBELEMENT_CLASS_NAME), nestedPolicyType);
        Attribute attribute2 = (Attribute)attributeList.get(0);
        AttributeList attributeList2 = (AttributeList)attribute2.getValue();
        nestedPolicyType.getPolicy().setId(attribute2.getName());
        this.setSubTokenAttributes(nestedPolicyType.getPolicy().getPolicyOrAllOrExactlyOne(), (Attribute)attributeList2.get(0), "SupportingTokens");
        return jAXBElement;
    }

    private Object createBinding(Attribute attribute, String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createBinding, type=" + string);
        }
        NestedPolicyType nestedPolicyType = new NestedPolicyType();
        nestedPolicyType.setPolicy(new Policy());
        JAXBElement<NestedPolicyType> jAXBElement = new JAXBElement<NestedPolicyType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", string), Class.forName(JAXBELEMENT_CLASS_NAME), nestedPolicyType);
        List<Object> list = nestedPolicyType.getPolicy().getPolicyOrAllOrExactlyOne();
        AttributeList attributeList = (AttributeList)attribute.getValue();
        Attribute attribute2 = null;
        for (int i = 0; i < attributeList.size(); ++i) {
            attribute2 = (Attribute)attributeList.get(i);
            if (attribute2.getName().endsWith("Token")) {
                this.setBindingToken(list, attribute2, string);
                continue;
            }
            this.setBindingInfo(list, attribute2);
        }
        return jAXBElement;
    }

    private void setBindingToken(List list, Attribute attribute, String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBindingToken, attr=" + attribute.getName());
        }
        AttributeList attributeList = (AttributeList)attribute.getValue();
        AttributeList attributeList2 = this.getSortedAttrList(attributeList);
        NestedPolicyType nestedPolicyType = new NestedPolicyType();
        nestedPolicyType.setPolicy(new Policy());
        JAXBElement<NestedPolicyType> jAXBElement = new JAXBElement<NestedPolicyType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", attribute.getName()), Class.forName(JAXBELEMENT_CLASS_NAME), nestedPolicyType);
        list.add(jAXBElement);
        nestedPolicyType = jAXBElement.getValue();
        for (int i = 0; i < attributeList2.size(); ++i) {
            this.setSubTokenAttributes(nestedPolicyType.getPolicy().getPolicyOrAllOrExactlyOne(), (Attribute)attributeList2.get(i), string);
        }
    }

    private boolean setSubTokenAttributes(List list, Attribute attribute, String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setSubTokenAttributes, attr=" + attribute.getName());
        }
        AttributeList attributeList = (AttributeList)attribute.getValue();
        String string2 = attribute.getName();
        TokenAssertionType tokenAssertionType = null;
        if (list.size() > 0 && !"AsymmetricBinding".equals(string)) {
            Tr.warning(tc, "CWWSI9007W", (Object)new Object[]{string});
            return false;
        }
        JAXBElement<Object> jAXBElement = null;
        jAXBElement = "SecureConversationToken".equals(string2) ? new JAXBElement<SecureConversationTokenType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", string2), Class.forName(JAXBELEMENT_CLASS_NAME), new SecureConversationTokenType()) : ("UsernameToken".equals(string2) ? new JAXBElement<TokenAssertionType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", string2), Class.forName(JAXBELEMENT_CLASS_NAME), new TokenAssertionType()) : (string2.startsWith("X509Token") ? new JAXBElement<TokenAssertionType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "X509Token"), Class.forName(JAXBELEMENT_CLASS_NAME), new TokenAssertionType()) : (string2.startsWith("CustomToken") ? new JAXBElement<TokenAssertionType>(new QName("http://www.ibm.com/xmlns/prod/websphere/200605/ws-securitypolicy-ext", "CustomToken"), Class.forName(JAXBELEMENT_CLASS_NAME), new TokenAssertionType()) : new JAXBElement<TokenAssertionType>(new QName("http://www.ibm.com/xmlns/prod/websphere/200605/ws-securitypolicy-ext", string2), Class.forName(JAXBELEMENT_CLASS_NAME), new TokenAssertionType()))));
        list.add(jAXBElement);
        if ("SecureConversationToken".equals(string2)) {
            SecureConversationTokenType secureConversationTokenType = (SecureConversationTokenType)jAXBElement.getValue();
            this.sctHelper.setSCTAttributes(secureConversationTokenType, attributeList);
        } else {
            List<Object> list2;
            tokenAssertionType = (TokenAssertionType)jAXBElement.getValue();
            Attribute attribute2 = null;
            for (int i = 0; i < attributeList.size(); ++i) {
                attribute2 = (Attribute)attributeList.get(i);
                if (!attribute2.getName().equals("IncludeToken")) continue;
                tokenAssertionType.setIncludeToken((String)attribute2.getValue());
                break;
            }
            if ((list2 = tokenAssertionType.getAny()).size() == 0) {
                list2.add(new Policy());
            }
            List<Object> list3 = ((Policy)list2.get(0)).getPolicyOrAllOrExactlyOne();
            if (string2.startsWith("CustomToken")) {
                this.setCustomToken(list3, attributeList);
            } else if (!"LTPAToken".equals(string2) && !"LTPAPropagationToken".equals(string2)) {
                this.addList(list3, attributeList, "IncludeToken");
            }
        }
        return true;
    }

    private void setCustomToken(List list, AttributeList attributeList) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setCustomToken");
        }
        Attribute attribute = null;
        Attribute attribute2 = null;
        AttributeList attributeList2 = null;
        WssCustomToken wssCustomToken = null;
        for (int i = 0; i < attributeList.size(); ++i) {
            attribute = (Attribute)attributeList.get(i);
            if (!"WssCustomToken".equals(attribute.getName())) continue;
            attributeList2 = (AttributeList)attribute.getValue();
            list.add(new WssCustomToken());
            wssCustomToken = (WssCustomToken)list.get(0);
            for (int j = 0; j < attributeList2.size(); ++j) {
                attribute2 = (Attribute)attributeList2.get(j);
                if ("uri".equals(attribute2.getName())) {
                    wssCustomToken.setUri((String)attribute2.getValue());
                }
                if (!"localname".equals(attribute2.getName())) continue;
                wssCustomToken.setLocalname((String)attribute2.getValue());
            }
        }
    }

    private boolean setBindingInfo(List list, Attribute attribute) throws ClassNotFoundException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBindingInfo attr name=" + attribute.getName());
        }
        String string = attribute.getName();
        NestedPolicyType nestedPolicyType = null;
        if ("AlgorithmSuite".equals(string)) {
            nestedPolicyType = new NestedPolicyType();
            nestedPolicyType.setPolicy(new Policy());
            list.add(new JAXBElement<NestedPolicyType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", string), Class.forName(JAXBELEMENT_CLASS_NAME), nestedPolicyType));
            this.addList(nestedPolicyType.getPolicy().getPolicyOrAllOrExactlyOne(), (AttributeList)attribute.getValue(), "");
        } else if ("Layout".equals(string)) {
            nestedPolicyType = new NestedPolicyType();
            nestedPolicyType.setPolicy(new Policy());
            list.add(new JAXBElement<NestedPolicyType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", string), Class.forName(JAXBELEMENT_CLASS_NAME), nestedPolicyType));
            List<Object> list2 = nestedPolicyType.getPolicy().getPolicyOrAllOrExactlyOne();
            list2.add(new JAXBElement<QNameAssertionType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", (String)attribute.getValue()), Class.forName(JAXBELEMENT_CLASS_NAME), new QNameAssertionType()));
        } else if ("IncludeTimestamp".equals(string)) {
            list.add(new JAXBElement<QNameAssertionType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", string), Class.forName(JAXBELEMENT_CLASS_NAME), new QNameAssertionType()));
        }
        return true;
    }

    protected void addList(List list, AttributeList attributeList, String string) throws ClassNotFoundException {
        Attribute attribute = null;
        for (int i = 0; i < attributeList.size(); ++i) {
            attribute = (Attribute)attributeList.get(i);
            if (!(attribute.getValue() instanceof String) || attribute.getName().equals(string)) continue;
            list.add(new JAXBElement<QNameAssertionType>(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", attribute.getName()), Class.forName(JAXBELEMENT_CLASS_NAME), new QNameAssertionType()));
        }
    }

    private void addNoKeyList(List list, AttributeList attributeList) throws ClassNotFoundException {
        list.clear();
        Attribute attribute = null;
        String string = null;
        HeaderType headerType = null;
        AttributeList attributeList2 = null;
        Attribute attribute2 = null;
        AttributeList attributeList3 = this.getSortedAttrList(attributeList);
        for (int i = 0; i < attributeList3.size(); ++i) {
            int n;
            String string2;
            attribute = (Attribute)attributeList3.get(i);
            string = attribute.getName();
            if (string.startsWith("Header")) {
                string2 = string.substring(string.lastIndexOf(95) + 1);
                n = new Integer(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addNoKeyList, name=" + string + ", headerCnt=" + n);
                }
                headerType = new HeaderType();
                list.add(headerType);
                attributeList2 = (AttributeList)attribute.getValue();
                for (int j = 0; j < attributeList2.size(); ++j) {
                    attribute2 = (Attribute)attributeList2.get(j);
                    if (attribute2.getName().equals("Name")) {
                        headerType.setName(new QName(null, (String)attribute2.getValue()));
                        continue;
                    }
                    if (!attribute2.getName().equals("Namespace")) continue;
                    headerType.setNamespace((String)attribute2.getValue());
                }
                continue;
            }
            if (!string.startsWith("XPath") || string.equals("XPathVersion")) continue;
            string2 = string.substring(string.lastIndexOf(95) + 1);
            n = new Integer(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addNoKeyList, name=" + string + ", xpathCnt=" + n);
            }
            list.add((String)attribute.getValue());
        }
    }

    private AttributeList getSortedAttrList(AttributeList attributeList) {
        AttributeList attributeList2 = new AttributeList();
        Attribute attribute = null;
        String string = null;
        int n = -1;
        for (int i = 0; i < attributeList.size(); ++i) {
            attribute = (Attribute)attributeList.get(i);
            string = attribute.getName();
            n = -1;
            for (int j = 0; j < attributeList2.size(); ++j) {
                Attribute attribute2 = (Attribute)attributeList2.get(j);
                String string2 = attribute2.getName();
                if (string.compareTo(string2) >= 0 && string.length() >= string2.length()) continue;
                n = j;
                break;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getSortedAttrList, add name=" + string + ", index=" + n);
            }
            if (n == -1) {
                attributeList2.add(attribute);
                continue;
            }
            attributeList2.add(n, attribute);
        }
        return attributeList2;
    }
}

