/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.admin.BindingReader;
import com.ibm.ws.wssecurity.admin.BindingValidation;
import com.ibm.ws.wssecurity.handler.PolicyInboundConfig;
import com.ibm.ws.wssecurity.platform.util.PasswordUtilFactory;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBinding;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings;
import java.io.FileOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;

public class BindingWriter
implements PolicyAttributesConstants {
    private static TraceComponent tc = Tr.register(BindingWriter.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    protected String className = this.getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static final String FFDC_ID_8 = "FFDC-8";
    private static final String FFDC_ID_9 = "FFDC-9";
    private static final String FFDC_ID_10 = "FFDC-10";
    private static final String FFDC_ID_11 = "FFDC-11";
    private static final String FFDC_ID_12 = "FFDC-12";
    private static final String FFDC_ID_13 = "FFDC-13";
    private static final String FFDC_ID_14 = "FFDC-14";
    private static final String FFDC_ID_15 = "FFDC-15";
    private static final String FFDC_ID_16 = "FFDC-16";
    private SecurityBindings _binding = null;
    private SecurityBinding _applicationBinding = null;
    private SecurityBinding _bootstrapBinding = null;

    public boolean setBinding(String string, Properties properties, boolean bl) throws Exception {
        Object object;
        this._binding = new SecurityBindings();
        Properties properties2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            properties2 = new Properties();
        } else {
            object = new BindingReader();
            properties2 = ((BindingReader)object).getBinding(string, new Properties());
        }
        object = properties.propertyNames();
        while (object.hasMoreElements()) {
            String string2 = object.nextElement().toString();
            if (!string2.endsWith(".order")) continue;
            arrayList.add(string2);
            break;
        }
        if (!arrayList.isEmpty()) {
            this.resolveOrder(properties2, properties, arrayList);
        }
        this.handleDeleteItems(properties2, properties);
        properties2.putAll((Map<?, ?>)properties);
        this.checkIfPassword(properties2);
        object = this.propertiesToAttributeList(properties2);
        return this.setBinding(string, (AttributeList)object);
    }

    private void resolveOrder(Properties properties, Properties properties2, List list) {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        Properties properties3 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            if (!string2.endsWith(".order")) continue;
            string = properties.getProperty(string2);
            hashMap.put(string, string2);
            properties3.setProperty(string2, string);
        }
        for (String string2 : list) {
            int n;
            string = properties2.getProperty(string2);
            String string3 = properties3.getProperty(string2);
            if (string3 == null || string == null) continue;
            int n2 = Integer.parseInt(string);
            if (n2 != (n = Integer.parseInt(string3))) {
                String string4;
                boolean bl;
                int n3;
                if (n2 < n) {
                    for (n3 = n; n3 > n2; --n3) {
                        bl = false;
                        string4 = (String)hashMap.get(Integer.toString(n3 - 1));
                        if (string4 == null) continue;
                        if (hashMap2.get(string4) != null && n3 - 1 < n2) {
                            while (hashMap2.get(string4) != null && n3 - 1 > n2) {
                                bl = hashMap2.get(string4 = (String)hashMap.get(Integer.toString(--n3 - 1))) != null;
                            }
                        } else {
                            bl = true;
                        }
                        if (bl) {
                            hashMap.put(Integer.toString(n3), string4);
                            properties3.setProperty(string4, Integer.toString(n3));
                            properties2.setProperty(string4, Integer.toString(n3));
                            continue;
                        }
                        if (bl) continue;
                        string4 = (String)hashMap.get(Integer.toString(--n3));
                        hashMap.put(string3, string4);
                        properties3.setProperty(string4, string3);
                        properties2.setProperty(string4, string3);
                    }
                } else if (n2 > n) {
                    for (n3 = n; n3 < n2; ++n3) {
                        bl = false;
                        string4 = (String)hashMap.get(Integer.toString(n3 + 1));
                        if (string4 == null) continue;
                        if (hashMap2.get(string4) != null && n3 + 1 < n2) {
                            while (hashMap2.get(string4) != null && n3 + 1 < n2) {
                                bl = hashMap2.get(string4 = (String)hashMap.get(Integer.toString(++n3 + 1))) != null;
                            }
                        } else {
                            bl = true;
                        }
                        if (bl) {
                            hashMap.put(Integer.toString(n3), string4);
                            properties3.setProperty(string4, Integer.toString(n3));
                            properties2.setProperty(string4, Integer.toString(n3));
                            continue;
                        }
                        if (bl) continue;
                        string4 = (String)hashMap.get(Integer.toString(++n3));
                        hashMap.put(string3, string4);
                        properties3.setProperty(string4, string3);
                        properties2.setProperty(string4, string3);
                    }
                }
            }
            hashMap.put(string, string2);
            properties3.setProperty(string2, string);
            properties2.setProperty(string2, string);
            hashMap2.put(string2, string);
        }
    }

    private void handleDeleteItems(Properties properties, Properties properties2) {
        Iterator<Object> iterator = properties2.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)properties2.get(string);
            if ((string2 = this.trim(string, string2)).length() != 0) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string3 : properties.keySet()) {
                if (!string3.startsWith(string)) continue;
                arrayList.add(string3);
            }
            for (String string4 : arrayList) {
                properties.remove(string4);
            }
            iterator.remove();
        }
    }

    private String trim(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        string2 = string2.trim();
        while (string2.startsWith("\"")) {
            string2 = string2.substring(1);
        }
        while (string2.endsWith("\"")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n = string.lastIndexOf(46);
        String string3 = string.substring(n + 1);
        if ((string3.equalsIgnoreCase("nonce") || string3.equalsIgnoreCase("timestamp") || string3.equalsIgnoreCase("trustanycertificate")) && !string2.equalsIgnoreCase("true")) {
            string2 = "";
        }
        return string2;
    }

    private void checkIfPassword(Properties properties) {
        for (String string : properties.keySet()) {
            String string2;
            if (!string.contains("password") && !string.contains("storepass") && !string.contains("keypass") || (string2 = properties.getProperty(string)) == null || string2.length() <= 0) continue;
            properties.put(string, PasswordUtilFactory.getInstance().passwordEncode(string2));
        }
    }

    private boolean setBinding(String string, AttributeList attributeList) throws Exception {
        boolean bl = true;
        for (Attribute attribute : attributeList) {
            if (attribute.getName().equals("application")) {
                this.setBindingName("application", (AttributeList)attribute.getValue());
                this._applicationBinding = new SecurityBinding();
                bl &= this.setBinding(attribute.getName(), this._applicationBinding, (AttributeList)attribute.getValue());
                this._binding.getSecurityBinding().add(this._applicationBinding);
                continue;
            }
            if (attribute.getName().equals("bootstrap")) {
                this.setBindingName("bootstrap", (AttributeList)attribute.getValue());
                this._bootstrapBinding = new SecurityBinding();
                bl &= this.setBinding(attribute.getName(), this._bootstrapBinding, (AttributeList)attribute.getValue());
                this._binding.getSecurityBinding().add(this._bootstrapBinding);
                continue;
            }
            Tr.warning(tc, "CWWSI9031W", (Object)new Object[]{attribute.getName()});
            bl = false;
        }
        bl = (bl &= this.validate(this._binding)) && this.write(string);
        return bl;
    }

    private void setBindingName(String string, AttributeList attributeList) {
        Attribute attribute = new Attribute("name", string);
        if (!attributeList.contains(attribute)) {
            attributeList.add(attribute);
        }
    }

    private boolean validate(SecurityBindings securityBindings) {
        return BindingValidation.getInstance().validate(securityBindings);
    }

    private boolean setBinding(String string, Object object, AttributeList attributeList) {
        boolean bl = true;
        for (Attribute attribute : attributeList) {
            Object object2;
            boolean bl2;
            String string2 = attribute.getName();
            Object object3 = attribute.getValue();
            if (string2.equalsIgnoreCase("nonce") || string2.equalsIgnoreCase("timestamp") || string2.equalsIgnoreCase("trustanycertificate")) {
                if (((String)object3).equalsIgnoreCase("true")) {
                    object3 = new AttributeList();
                } else {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Value for " + string + "." + string2 + " of \"" + object3 + "\" is not recognized and will be treated as false");
                    continue;
                }
            }
            if (object3 instanceof String) {
                if (this.setChildObject(object, string2, object3)) continue;
                Tr.warning(tc, "CWWSI9031W", (Object)new Object[]{string + "." + string2});
                bl = false;
                continue;
            }
            if (!(object3 instanceof AttributeList)) continue;
            int n = string2.lastIndexOf("_");
            int n2 = 0;
            boolean bl3 = bl2 = n != -1;
            if (bl2) {
                n2 = Integer.parseInt(string2.substring(n + 1));
                string2 = string2.substring(0, n);
            }
            if ((object2 = this.getObject(object, string2)) != null) {
                bl &= this.setBinding(string + "." + attribute.getName(), object2, (AttributeList)object3);
                if (!bl2) {
                    if (this.setChildObject(object, string2, object2)) continue;
                    Tr.warning(tc, "CWWSI9024W", (Object)new Object[]{string2, object.getClass().getName()});
                    bl = false;
                    continue;
                }
                List list = this.getList(object, string2);
                if (list != null) {
                    list.add(object2);
                    continue;
                }
                Tr.warning(tc, "CWWSI9026W", (Object)new Object[]{attribute.getName(), object.getClass().getName()});
                bl = false;
                continue;
            }
            Tr.warning(tc, "CWWSI9031W", (Object)new Object[]{string + "." + string2});
            bl = false;
        }
        return bl;
    }

    private List getList(Object object, String string) {
        List list = null;
        Method method = this.getMethodFromName(object, string, true);
        if (method != null) {
            try {
                list = (List)method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException(illegalAccessException, this.getClass().getName(), FFDC_ID_2);
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException(invocationTargetException.getCause(), this.getClass().getName(), FFDC_ID_3);
            }
        }
        return list;
    }

    private boolean setChildObject(Object object, String string, Object object2) {
        boolean bl = false;
        Method method = this.getMethodFromName(object, string, false);
        if (method != null) {
            Object[] objectArray = new Object[]{object2};
            try {
                method.invoke(object, objectArray);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException(illegalArgumentException, this.getClass().getName(), FFDC_ID_4);
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException(illegalAccessException, this.getClass().getName(), FFDC_ID_5);
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException(invocationTargetException.getCause(), this.getClass().getName(), FFDC_ID_6);
            }
        }
        return bl;
    }

    private Method getMethodFromName(Object object, String string, boolean bl) {
        int n;
        Method method = null;
        Class<?> clazz = object.getClass();
        String string2 = (bl ? "get" : "set") + string;
        Method[] methodArray = clazz.getDeclaredMethods();
        for (n = 0; n < methodArray.length; ++n) {
            if (!methodArray[n].getName().equalsIgnoreCase(string2)) continue;
            method = methodArray[n];
            break;
        }
        if (method == null) {
            for (n = 0; n < methodArray.length; ++n) {
                int n2 = methodArray[n].getName().toLowerCase().indexOf(string.toLowerCase());
                if (n2 == -1 || !methodArray[n].getName().startsWith("get")) continue;
                method = methodArray[n];
                break;
            }
        }
        return method;
    }

    private Object getObject(Object object, String string) {
        Object var3_3 = null;
        Class<?> clazz = object.getClass();
        String string2 = "get" + string;
        Method method = null;
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equalsIgnoreCase(string2)) continue;
            method = methodArray[i];
            break;
        }
        if (method != null) {
            Object object2;
            Class<?> clazz2 = method.getReturnType();
            if (clazz2.isInstance(new ArrayList())) {
                object2 = method.getName().substring(3);
                try {
                    clazz2 = Class.forName("com.ibm.xmlns.prod.websphere._200608.ws_securitybinding." + (String)object2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException(classNotFoundException, this.getClass().getName(), FFDC_ID_7);
                    clazz2 = null;
                }
            }
            if (clazz2 != null) {
                try {
                    object2 = clazz2.getConstructor(new Class[0]);
                    var3_3 = ((Constructor)object2).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    FFDCFilter.processException(noSuchMethodException, this.getClass().getName(), FFDC_ID_8);
                }
                catch (InstantiationException instantiationException) {
                    FFDCFilter.processException(instantiationException, this.getClass().getName(), FFDC_ID_9);
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException(illegalAccessException, this.getClass().getName(), FFDC_ID_10);
                }
                catch (InvocationTargetException invocationTargetException) {
                    FFDCFilter.processException(invocationTargetException.getCause(), this.getClass().getName(), FFDC_ID_11);
                }
            }
        } else {
            String string3 = null;
            for (int i = 0; i < methodArray.length; ++i) {
                int n = methodArray[i].getName().toLowerCase().indexOf(string.toLowerCase());
                if (n == -1) continue;
                string3 = methodArray[i].getName().substring(n, n + string.length());
                break;
            }
            if (string3 != null) {
                try {
                    Class<?> clazz3 = Class.forName("com.ibm.xmlns.prod.websphere._200608.ws_securitybinding." + string3);
                    Constructor<?> constructor = clazz3.getConstructor(new Class[0]);
                    var3_3 = constructor.newInstance(new Object[0]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException(classNotFoundException, this.getClass().getName(), FFDC_ID_12);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    FFDCFilter.processException(noSuchMethodException, this.getClass().getName(), FFDC_ID_13);
                }
                catch (InstantiationException instantiationException) {
                    FFDCFilter.processException(instantiationException, this.getClass().getName(), FFDC_ID_14);
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException(illegalAccessException, this.getClass().getName(), FFDC_ID_15);
                }
                catch (InvocationTargetException invocationTargetException) {
                    FFDCFilter.processException(invocationTargetException.getCause(), this.getClass().getName(), FFDC_ID_16);
                }
            }
        }
        return var3_3;
    }

    private boolean write(FileOutputStream fileOutputStream) throws Exception {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance("com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", PolicyInboundConfig.class.getClassLoader());
            Marshaller marshaller = jAXBContext.createMarshaller();
            try {
                marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            }
            catch (PropertyException propertyException) {
                // empty catch block
            }
            marshaller.marshal((Object)this._binding, fileOutputStream);
        }
        catch (JAXBException jAXBException) {
            FFDCFilter.processException(jAXBException, this.getClass().getName(), FFDC_ID_1);
            Tr.error(tc, "CWWSI9036E", jAXBException);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BindingReader.load - caught JAXBException while reading bindings file");
                jAXBException.printStackTrace();
            }
            throw jAXBException;
        }
        return true;
    }

    private boolean write(String string) throws Exception {
        return this.write(new FileOutputStream(string));
    }

    private AttributeList propertiesToAttributeList(Properties properties) {
        AttributeList attributeList = new AttributeList();
        for (String string : properties.keySet()) {
            AttributeList attributeList2 = attributeList;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = this.indexOf(attributeList2, string2);
                if (n == -1) {
                    int n2 = this.getIndexInSortedList(attributeList2, string2);
                    if (stringTokenizer.hasMoreTokens()) {
                        AttributeList attributeList3 = new AttributeList();
                        if (n2 == -1) {
                            attributeList2.add(new Attribute(string2, attributeList3));
                        } else {
                            attributeList2.add(n2, new Attribute(string2, attributeList3));
                        }
                        attributeList2 = attributeList3;
                        continue;
                    }
                    if (n2 == -1) {
                        attributeList2.add(new Attribute(string2, properties.get(string)));
                        continue;
                    }
                    attributeList2.add(n2, new Attribute(string2, properties.get(string)));
                    continue;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    Attribute attribute = (Attribute)attributeList2.get(n);
                    attributeList2 = (AttributeList)attribute.getValue();
                    continue;
                }
                attributeList2.add(new Attribute(string2, properties.get(string)));
            }
        }
        return attributeList;
    }

    private int getIndexInSortedList(AttributeList attributeList, String string) {
        Attribute attribute = null;
        String string2 = null;
        int n = -1;
        int n2 = string.lastIndexOf("_");
        int n3 = 0;
        String string3 = string;
        if (n2 != -1) {
            n3 = Integer.parseInt(string.substring(n2 + 1));
            string3 = string.substring(0, n2);
        }
        for (int i = 0; i < attributeList.size(); ++i) {
            attribute = (Attribute)attributeList.get(i);
            string2 = attribute.getName();
            n2 = string2.lastIndexOf("_");
            int n4 = -1;
            if (n2 != -1) {
                n4 = Integer.parseInt(string2.substring(n2 + 1));
                string2 = string2.substring(0, n2);
            }
            if (string3.compareTo(string2) >= 0 && (!string3.equals(string2) || n3 >= n4)) continue;
            n = i;
            break;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getIndexInSortedList, add name=" + string + ", index=" + n);
        }
        return n;
    }

    private int indexOf(AttributeList attributeList, String string) {
        int n = -1;
        for (int i = 0; i < attributeList.size(); ++i) {
            Attribute attribute = (Attribute)attributeList.get(i);
            if (!attribute.getName().equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }
}

