/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.BasicAuth;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CRL;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CallbackHandler;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Caller;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CallerIdentity;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertPathSettings;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertStoreList;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertStoreRef;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CollectionCertStores;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Consumerbindingref;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.DataEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.EncryptionInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.EncryptionPartReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Generatorbindingref;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.JAASConfig;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Key;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyStore;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.LdapCertStores;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.LdapServer;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Properties;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.RequiredSigningPartReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBinding;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityInboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityOutboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityTokenReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningPartReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TimestampExpires;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenConsumer;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenGenerator;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Transform;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TrustAnchor;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TrustAnchorRef;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TrustedIdentity;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.ValueType;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.X509Certificates;
import java.util.HashMap;
import java.util.Iterator;

public class BindingValidation
implements PolicyAttributesConstants {
    private static BindingValidation instance = new BindingValidation();
    private static TraceComponent tc = Tr.register(BindingValidation.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    protected String className = this.getClass().getName();
    private HashMap orderMap = new HashMap();

    public static BindingValidation getInstance() {
        return instance;
    }

    public boolean validate(SecurityBindings securityBindings) {
        boolean bl = true;
        if (securityBindings.getSecurityBinding().isEmpty()) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"securityBinding", "SecurityBindings"});
            bl = false;
        }
        Iterator<SecurityBinding> iterator = securityBindings.getSecurityBinding().iterator();
        while (iterator.hasNext()) {
            bl &= this.validate(iterator.next());
        }
        return bl;
    }

    private boolean validate(SecurityBinding securityBinding) {
        boolean bl = true;
        bl &= securityBinding.getSecurityInboundBindingConfig() == null || this.validate(securityBinding.getSecurityInboundBindingConfig());
        return bl &= securityBinding.getSecurityOutboundBindingConfig() == null || this.validate(securityBinding.getSecurityOutboundBindingConfig());
    }

    private boolean validate(SecurityOutboundBindingConfig securityOutboundBindingConfig) {
        Iterator<Object> iterator;
        boolean bl = true;
        this.orderMap.clear();
        if (securityOutboundBindingConfig.getGeneratorbindingref() != null) {
            bl &= this.validate(securityOutboundBindingConfig.getGeneratorbindingref());
            if (!(securityOutboundBindingConfig.getSigningInfo().isEmpty() && securityOutboundBindingConfig.getEncryptionInfo().isEmpty() && securityOutboundBindingConfig.getKeyInfo().isEmpty() && securityOutboundBindingConfig.getTokenGenerator().isEmpty() && securityOutboundBindingConfig.getCertStoreList() == null && securityOutboundBindingConfig.getTimestampExpires() == null && securityOutboundBindingConfig.getProperties().isEmpty())) {
                Tr.warning(tc, "CWWSI9016W", (Object)new Object[]{"signingInfo", "generatorbindingref"});
                bl = false;
            }
        } else {
            iterator = securityOutboundBindingConfig.getSigningInfo().iterator();
            while (iterator.hasNext()) {
                bl &= this.validate(iterator.next(), true);
            }
            iterator = securityOutboundBindingConfig.getEncryptionInfo().iterator();
            while (iterator.hasNext()) {
                bl &= this.validate((EncryptionInfo)iterator.next(), true);
            }
            iterator = securityOutboundBindingConfig.getKeyInfo().iterator();
            while (iterator.hasNext()) {
                bl &= this.validate((KeyInfo)iterator.next(), false);
            }
            iterator = securityOutboundBindingConfig.getTokenGenerator().iterator();
            while (iterator.hasNext()) {
                bl &= this.validate((TokenGenerator)iterator.next());
            }
            bl &= securityOutboundBindingConfig.getCertStoreList() == null || this.validate(securityOutboundBindingConfig.getCertStoreList());
            bl &= securityOutboundBindingConfig.getTimestampExpires() == null || this.validate(securityOutboundBindingConfig.getTimestampExpires());
        }
        iterator = securityOutboundBindingConfig.getProperties().iterator();
        while (iterator.hasNext()) {
            bl &= this.validate((Properties)iterator.next());
        }
        return bl;
    }

    private boolean validate(Generatorbindingref generatorbindingref) {
        boolean bl = true;
        if (generatorbindingref.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"name", "Generatorbindingref"});
            bl = false;
        }
        if (generatorbindingref.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"reference", "Generatorbindingref"});
            bl = false;
        }
        Iterator<Properties> iterator = generatorbindingref.getProperties().iterator();
        while (iterator.hasNext()) {
            bl &= this.validate(iterator.next());
        }
        return bl;
    }

    private boolean validate(SigningInfo signingInfo, boolean bl) {
        Object object;
        boolean bl2 = true;
        if (signingInfo.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"name", "signingInfo"});
            bl2 = false;
        }
        if (bl) {
            object = signingInfo.getOrder();
            if (object != null) {
                if (this.orderMap.get(object) == null) {
                    this.orderMap.put(object, signingInfo.getName());
                } else {
                    Tr.warning(tc, "SigningInfo " + signingInfo.getName() + " has order number " + object + ". This is the same order number than " + (String)this.orderMap.get(object) + ". Duplicate order numbers are not allowed.");
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
        }
        object = signingInfo.getSigningKeyInfo().iterator();
        while (object.hasNext()) {
            bl2 &= this.validate((SigningKeyInfo)object.next());
        }
        object = signingInfo.getSigningPartReference().iterator();
        while (object.hasNext()) {
            bl2 &= this.validate(object.next());
        }
        object = signingInfo.getProperties().iterator();
        while (object.hasNext()) {
            bl2 &= this.validate((Properties)object.next());
        }
        return bl2;
    }

    private boolean validate(EncryptionInfo encryptionInfo, boolean bl) {
        Object object;
        boolean bl2 = true;
        if (encryptionInfo.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"name", "encryptionInfo"});
            bl2 = false;
        }
        if (bl) {
            object = encryptionInfo.getOrder();
            if (object != null) {
                if (this.orderMap.get(object) == null) {
                    this.orderMap.put(object, encryptionInfo.getName());
                } else {
                    Tr.warning(tc, "EncryptionInfo " + encryptionInfo.getName() + " has order number " + object + ". This is the same order number than " + (String)this.orderMap.get(object) + ". Duplicate order numbers are not allowed.");
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
        }
        bl2 &= encryptionInfo.getEncryptionPartReference() == null || this.validate(encryptionInfo.getEncryptionPartReference());
        object = encryptionInfo.getKeyEncryptionKeyInfo().iterator();
        while (object.hasNext()) {
            bl2 &= this.validate((KeyEncryptionKeyInfo)object.next());
        }
        object = encryptionInfo.getProperties().iterator();
        while (object.hasNext()) {
            bl2 &= this.validate(object.next());
        }
        return bl2;
    }

    private boolean validate(EncryptionPartReference encryptionPartReference) {
        boolean bl = true;
        Iterator<DataEncryptionKeyInfo> iterator = encryptionPartReference.getDataEncryptionKeyInfo().iterator();
        while (iterator.hasNext()) {
            bl &= this.validate(iterator.next());
        }
        return bl;
    }

    private boolean validate(KeyEncryptionKeyInfo keyEncryptionKeyInfo) {
        boolean bl = true;
        if (keyEncryptionKeyInfo.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"reference", "KeyEncryptionKeyInfo"});
            bl = false;
        }
        return bl;
    }

    private boolean validate(DataEncryptionKeyInfo dataEncryptionKeyInfo) {
        boolean bl = true;
        if (dataEncryptionKeyInfo.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"reference", "DataEncryptionKeyInfo"});
            bl = false;
        }
        return bl;
    }

    private boolean validate(KeyInfo keyInfo, boolean bl) {
        boolean bl2 = true;
        if (keyInfo.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"name", "KeyInfo"});
            bl2 = false;
        }
        if (keyInfo.getType() == null) {
            if (!bl) {
                Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"type", "KeyInfo"});
                bl2 = false;
            }
        } else if (!(keyInfo.getType().equals("EMB") || keyInfo.getType().equals("THUMBPRINT") || keyInfo.getType().equals("KEYID") || keyInfo.getType().equals("STRREF") || keyInfo.getType().equals("X509ISSUER"))) {
            Tr.warning(tc, "CWWSI9010W", (Object)new Object[]{"Type", "KeyInfo"});
            bl2 = false;
        }
        if (keyInfo.getClassname() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"classname", "KeyInfo"});
            bl2 = false;
        }
        bl2 &= keyInfo.getTokenReference() == null || this.validate(keyInfo.getTokenReference());
        Iterator<Properties> iterator = keyInfo.getProperties().iterator();
        while (iterator.hasNext()) {
            bl2 &= this.validate(iterator.next());
        }
        return bl2;
    }

    private boolean validate(TokenReference tokenReference) {
        boolean bl = true;
        if (tokenReference.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"reference", "TokenReference"});
            bl = false;
        }
        return bl;
    }

    private boolean validate(TokenGenerator tokenGenerator) {
        boolean bl = true;
        if (tokenGenerator.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"name", "TokenGenerator"});
            bl = false;
        }
        if (tokenGenerator.getValueType() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"valueType", "TokenGenerator"});
            bl = false;
        } else {
            bl &= this.validate(tokenGenerator.getValueType());
        }
        bl &= tokenGenerator.getSecurityTokenReference() == null || this.validate(tokenGenerator.getSecurityTokenReference());
        if (tokenGenerator.getJAASConfig() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"jAASConfig", "TokenGenerator"});
            bl = false;
        } else {
            bl &= this.validate(tokenGenerator.getJAASConfig());
        }
        if (tokenGenerator.getCallbackHandler() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"callbackHandler", "TokenGenerator"});
            bl = false;
        } else {
            bl &= this.validate(tokenGenerator.getCallbackHandler());
        }
        Iterator<Properties> iterator = tokenGenerator.getProperties().iterator();
        while (iterator.hasNext()) {
            bl &= this.validate(iterator.next());
        }
        return bl;
    }

    private boolean validate(ValueType valueType) {
        boolean bl = true;
        if (valueType.getLocalName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"localName", "ValueType"});
            bl = false;
        }
        return bl;
    }

    private boolean validate(SecurityTokenReference securityTokenReference) {
        boolean bl = true;
        if (securityTokenReference.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"reference", "SecurityTokenReference"});
            bl = false;
        }
        return bl;
    }

    private boolean validate(JAASConfig jAASConfig) {
        boolean bl = true;
        if (jAASConfig.getConfigName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"configName", "JAASConfig"});
            bl = false;
        }
        Iterator<Properties> iterator = jAASConfig.getProperties().iterator();
        while (iterator.hasNext()) {
            bl &= this.validate(iterator.next());
        }
        return bl;
    }

    private boolean validate(CallbackHandler callbackHandler) {
        boolean bl = true;
        if (callbackHandler.getClassname() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"classname", "CallbackHandler"});
            bl = false;
        }
        bl &= callbackHandler.getKeyStore() == null || this.validate(callbackHandler.getKeyStore());
        bl &= callbackHandler.getKey() == null || this.validate(callbackHandler.getKey());
        bl &= callbackHandler.getCertPathSettings() == null || this.validate(callbackHandler.getCertPathSettings());
        bl &= callbackHandler.getBasicAuth() == null || this.validate(callbackHandler.getBasicAuth());
        Iterator<Properties> iterator = callbackHandler.getProperties().iterator();
        while (iterator.hasNext()) {
            bl &= this.validate(iterator.next());
        }
        return bl;
    }

    private boolean validate(KeyStore keyStore) {
        boolean bl = true;
        if (keyStore.getKeyStoreRef() == null && keyStore.getPath() == null && keyStore.getStorepass() == null && keyStore.getType() == null) {
            Tr.warning(tc, "CWWSI9028W");
            bl = false;
        }
        return bl;
    }

    private boolean validate(Key key) {
        boolean bl = true;
        if (key.getAlias() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"alias", "Key"});
            bl = false;
        }
        if (key.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"name", "Key"});
            bl = false;
        }
        return bl;
    }

    private boolean validate(CertPathSettings certPathSettings) {
        boolean bl = true;
        bl &= certPathSettings.getTrustAnchorRef() == null || this.validate(certPathSettings.getTrustAnchorRef());
        return bl &= certPathSettings.getCertStoreRef() == null || this.validate(certPathSettings.getCertStoreRef());
    }

    private boolean validate(TrustAnchorRef trustAnchorRef) {
        boolean bl = true;
        if (trustAnchorRef.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"reference", "TrustAnchorRef"});
            bl = false;
        }
        return bl;
    }

    private boolean validate(CertStoreRef certStoreRef) {
        boolean bl = true;
        if (certStoreRef.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"reference", "CertStoreRef"});
            bl = false;
        }
        return bl;
    }

    private boolean validate(BasicAuth basicAuth) {
        boolean bl = true;
        if (basicAuth.getUserid() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"userid", "BasicAuth"});
            bl = false;
        }
        return bl;
    }

    private boolean validate(CertStoreList certStoreList) {
        boolean bl = true;
        for (Object object : certStoreList.getLdapCertStoresOrCollectionCertStores()) {
            if (object instanceof LdapCertStores) {
                bl &= this.validate((LdapCertStores)object);
                continue;
            }
            if (!(object instanceof CollectionCertStores)) continue;
            bl &= this.validate((CollectionCertStores)object);
        }
        return bl;
    }

    private boolean validate(LdapCertStores ldapCertStores) {
        boolean bl = true;
        if (ldapCertStores.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"name", "LdapCertStores"});
            bl = false;
        }
        if (ldapCertStores.getProvider() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"provider", "LdapCertStores"});
            bl = false;
        }
        if (ldapCertStores.getLdapServer() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"ldapServer", "LdapCertStores"});
            bl = false;
        } else {
            bl &= this.validate(ldapCertStores.getLdapServer());
        }
        return bl;
    }

    private boolean validate(LdapServer ldapServer) {
        boolean bl = true;
        if (ldapServer.getHost() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"host", "LdapServer"});
            bl = false;
        }
        if (ldapServer.getPort() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"port", "LdapServer"});
            bl = false;
        }
        Iterator<Properties> iterator = ldapServer.getProperties().iterator();
        while (iterator.hasNext()) {
            bl &= this.validate(iterator.next());
        }
        return bl;
    }

    private boolean validate(Properties properties) {
        boolean bl = true;
        if (properties.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"name", "Properties"});
            bl = false;
        }
        if (properties.getValue() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"value", "Properties"});
            bl = false;
        }
        return bl;
    }

    private boolean validate(CollectionCertStores collectionCertStores) {
        boolean bl = true;
        if (collectionCertStores.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"name", "CollectionCertStores"});
            bl = false;
        }
        if (collectionCertStores.getProvider() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"provider", "CollectionCertStores"});
            bl = false;
        }
        for (Object object : collectionCertStores.getX509CertificatesOrCRL()) {
            if (object instanceof X509Certificates) {
                bl &= this.validate((X509Certificates)object);
                continue;
            }
            if (!(object instanceof CRL)) continue;
            bl &= this.validate((CRL)object);
        }
        return bl;
    }

    private boolean validate(X509Certificates x509Certificates) {
        boolean bl = true;
        if (x509Certificates.getPath() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"Path", "X509Certificates"});
            bl = false;
        }
        return bl;
    }

    private boolean validate(CRL cRL) {
        boolean bl = true;
        if (cRL.getPath() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"Path", "CRL"});
            bl = false;
        }
        return bl;
    }

    private boolean validate(TimestampExpires timestampExpires) {
        boolean bl = true;
        Iterator<Properties> iterator = timestampExpires.getProperties().iterator();
        while (iterator.hasNext()) {
            bl &= this.validate(iterator.next());
        }
        return bl;
    }

    private boolean validate(SigningKeyInfo signingKeyInfo) {
        boolean bl = true;
        if (signingKeyInfo.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"reference", "SigningKeyInfo"});
            bl = false;
        }
        return bl;
    }

    private boolean validate(SigningPartReference signingPartReference) {
        boolean bl = true;
        Iterator<Transform> iterator = signingPartReference.getTransform().iterator();
        while (iterator.hasNext()) {
            bl &= this.validate(iterator.next());
        }
        return bl;
    }

    private boolean validate(Transform transform) {
        boolean bl = true;
        if (transform.getAlgorithm() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"Algorithm", "Transform"});
            bl = false;
        }
        Iterator<Properties> iterator = transform.getProperties().iterator();
        while (iterator.hasNext()) {
            bl &= this.validate(iterator.next());
        }
        return bl;
    }

    private boolean validate(SecurityInboundBindingConfig securityInboundBindingConfig) {
        Iterator<Object> iterator;
        boolean bl = true;
        if (securityInboundBindingConfig.getConsumerbindingref() != null) {
            bl &= this.validate(securityInboundBindingConfig.getConsumerbindingref());
            if (!(securityInboundBindingConfig.getSigningInfo().isEmpty() && securityInboundBindingConfig.getEncryptionInfo().isEmpty() && securityInboundBindingConfig.getKeyInfo().isEmpty() && securityInboundBindingConfig.getTokenConsumer().isEmpty() && securityInboundBindingConfig.getTrustAnchor().isEmpty() && securityInboundBindingConfig.getCertStoreList() == null && securityInboundBindingConfig.getCaller() == null && securityInboundBindingConfig.getProperties().isEmpty())) {
                Tr.warning(tc, "CWWSI9016W", (Object)new Object[]{"signingInfo", "consumerbindingref"});
                bl = false;
            }
        } else {
            iterator = securityInboundBindingConfig.getSigningInfo().iterator();
            while (iterator.hasNext()) {
                bl &= this.validate(iterator.next(), false);
            }
            iterator = securityInboundBindingConfig.getEncryptionInfo().iterator();
            while (iterator.hasNext()) {
                bl &= this.validate((EncryptionInfo)iterator.next(), false);
            }
            iterator = securityInboundBindingConfig.getKeyInfo().iterator();
            while (iterator.hasNext()) {
                bl &= this.validate((KeyInfo)iterator.next(), true);
            }
            iterator = securityInboundBindingConfig.getTokenConsumer().iterator();
            while (iterator.hasNext()) {
                bl &= this.validate((TokenConsumer)iterator.next());
            }
            iterator = securityInboundBindingConfig.getTrustAnchor().iterator();
            while (iterator.hasNext()) {
                bl &= this.validate((TrustAnchor)iterator.next());
            }
            bl &= securityInboundBindingConfig.getCertStoreList() == null || this.validate(securityInboundBindingConfig.getCertStoreList());
            iterator = securityInboundBindingConfig.getCaller().iterator();
            while (iterator.hasNext()) {
                bl &= this.validate((Caller)iterator.next());
            }
        }
        iterator = securityInboundBindingConfig.getProperties().iterator();
        while (iterator.hasNext()) {
            bl &= this.validate((Properties)iterator.next());
        }
        return bl;
    }

    private boolean validate(Consumerbindingref consumerbindingref) {
        boolean bl = true;
        if (consumerbindingref.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"Name", "Consumerbindingref"});
            bl = false;
        }
        if (consumerbindingref.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"reference", "Consumerbindingref"});
            bl = false;
        }
        Iterator<Properties> iterator = consumerbindingref.getProperties().iterator();
        while (iterator.hasNext()) {
            bl &= this.validate(iterator.next());
        }
        return bl;
    }

    private boolean validate(TokenConsumer tokenConsumer) {
        boolean bl = true;
        if (tokenConsumer.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"name", "tokenConsumer"});
            bl = false;
        }
        if (tokenConsumer.getValueType() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"valueType", "TokenConsumer"});
            bl = false;
        } else {
            bl &= this.validate(tokenConsumer.getValueType());
        }
        bl &= tokenConsumer.getSecurityTokenReference() == null || this.validate(tokenConsumer.getSecurityTokenReference());
        if (tokenConsumer.getJAASConfig() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"jAASConfig", "TokenConsumer"});
            bl = false;
        } else {
            bl &= this.validate(tokenConsumer.getJAASConfig());
        }
        bl &= tokenConsumer.getCallbackHandler() == null || this.validate(tokenConsumer.getCallbackHandler());
        Iterator<Properties> iterator = tokenConsumer.getProperties().iterator();
        while (iterator.hasNext()) {
            bl &= this.validate(iterator.next());
        }
        return bl;
    }

    private boolean validate(TrustAnchor trustAnchor) {
        boolean bl = true;
        if (trustAnchor.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"Name", "TrustAnchor"});
            bl = false;
        }
        if (trustAnchor.getKeyStore() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"KeyStore", "TrustAnchor"});
            bl = false;
        } else {
            bl &= this.validate(trustAnchor.getKeyStore());
        }
        return bl;
    }

    private boolean validate(Caller caller) {
        boolean bl = true;
        if (caller.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"Name", "caller"});
            bl = false;
        }
        if (caller.getJAASConfig() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"jAASConfig", "caller"});
            bl = false;
        } else {
            bl &= this.validate(caller.getJAASConfig());
        }
        bl &= caller.getCallbackHandler() == null || this.validate(caller.getCallbackHandler());
        if (caller.getCallerIdentity() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"callerIdentity", "caller"});
            bl = false;
        } else {
            bl &= this.validate(caller.getCallerIdentity());
        }
        bl &= caller.getTrustedIdentity() == null || this.validate(caller.getTrustedIdentity());
        return bl &= caller.getRequiredSigningPartReference() == null || this.validate(caller.getRequiredSigningPartReference());
    }

    private boolean validate(CallerIdentity callerIdentity) {
        boolean bl = true;
        if (callerIdentity.getLocalName() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"localName", "caller"});
            bl = false;
        }
        return bl;
    }

    private boolean validate(TrustedIdentity trustedIdentity) {
        boolean bl = true;
        return bl;
    }

    private boolean validate(RequiredSigningPartReference requiredSigningPartReference) {
        boolean bl = true;
        if (requiredSigningPartReference.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", (Object)new Object[]{"reference", "requiredSigningPartReference"});
            bl = false;
        }
        return bl;
    }
}

