/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.handler.PolicyInboundConfig;
import com.ibm.ws.wssecurity.platform.util.PasswordUtilFactory;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBinding;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class BindingReader
implements PolicyAttributesConstants {
    private static TraceComponent tc = Tr.register(BindingReader.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    protected String className = this.getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private SecurityBindings _binding = null;
    private SecurityBinding _applicationBinding = null;
    private SecurityBinding _bootstrapBinding = null;

    private AttributeList getAttributes(Object object) {
        AttributeList attributeList = new AttributeList();
        boolean bl = false;
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Object object2;
            String string = methodArray[i].getName();
            if (!string.startsWith("get")) continue;
            bl = true;
            Object object3 = null;
            try {
                object3 = methodArray[i].invoke(object, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException(invocationTargetException.getCause(), this.getClass().getName(), FFDC_ID_2);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "BindingReader.getAttributes() - caught InvocationTargetException while creating AttributeList");
                invocationTargetException.getCause().printStackTrace();
                continue;
            }
            if (object3 == null) continue;
            boolean bl2 = false;
            if (string.equals("getPassword") || string.equals("getStorepass") || string.equals("getKeypass")) {
                bl2 = true;
            }
            if (object3 instanceof String) {
                object2 = string.substring(3).toLowerCase();
                if (bl2) {
                    object3 = PasswordUtilFactory.getInstance().passwordDecode(object3.toString());
                }
                attributeList.add(new Attribute((String)object2, object3));
                continue;
            }
            if (object3 instanceof List) {
                attributeList.addAll(this.getAttributes(string.substring(3).toLowerCase(), (List)object3));
                continue;
            }
            object2 = this.getAttributes(object3);
            if (object2 == null) continue;
            Object object4 = null;
            object4 = ((ArrayList)object2).isEmpty() ? "true" : object2;
            attributeList.add(new Attribute(string.substring(3).toLowerCase(), object4));
        }
        if (attributeList.isEmpty() && bl) {
            attributeList = null;
        }
        return attributeList;
    }

    private AttributeList getAttributes(String string, List list) {
        AttributeList attributeList = new AttributeList();
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!string.equalsIgnoreCase(e.getClass().getSimpleName())) {
                string = e.getClass().getSimpleName().toLowerCase();
            }
            attributeList.add(new Attribute(string + "_" + n, this.getAttributes(e)));
            ++n;
        }
        return attributeList;
    }

    public Properties getBinding(String string, Properties properties) throws Exception {
        AttributeList attributeList = new AttributeList();
        this.load(string);
        if (this._applicationBinding != null) {
            attributeList.add(new Attribute("application", this.getAttributes(this._applicationBinding)));
        }
        if (this._bootstrapBinding != null) {
            attributeList.add(new Attribute("bootstrap", this.getAttributes(this._bootstrapBinding)));
        }
        return PolicyAttributesUtil.getInstance().attributeListToProperties(attributeList, properties);
    }

    private boolean load(InputStream inputStream) throws Exception {
        block10: {
            if (this._binding == null) {
                try {
                    JAXBContext jAXBContext = JAXBContext.newInstance("com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", PolicyInboundConfig.class.getClassLoader());
                    Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                    Object object = unmarshaller.unmarshal(inputStream);
                    this._binding = null;
                    if (object instanceof SecurityBindings) {
                        this._binding = (SecurityBindings)object;
                        for (SecurityBinding securityBinding : this._binding.getSecurityBinding()) {
                            if (securityBinding.getName() == null) {
                                securityBinding.setName("application");
                            }
                            if (securityBinding.getName().equals("application")) {
                                this._applicationBinding = securityBinding;
                                continue;
                            }
                            if (!securityBinding.getName().equals("bootstrap")) continue;
                            this._bootstrapBinding = securityBinding;
                        }
                        break block10;
                    }
                    throw new SoapSecurityException("BindingReader: Unmarshalled obj is NOT a SecurityBindings object");
                }
                catch (JAXBException jAXBException) {
                    FFDCFilter.processException(jAXBException, this.getClass().getName(), FFDC_ID_3);
                    Tr.error(tc, "CWWSI9036E", jAXBException);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "BindingReader.load - caught JAXBException while reading bindings file");
                        jAXBException.printStackTrace();
                    }
                    throw jAXBException;
                }
                catch (SoapSecurityException soapSecurityException) {
                    FFDCFilter.processException(soapSecurityException, this.getClass().getName(), FFDC_ID_1);
                    Tr.error(tc, "CWWSI9036E", soapSecurityException);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "BindingReader.load() - caught exception while read and parsing security bindings");
                        soapSecurityException.printStackTrace();
                    }
                    throw soapSecurityException;
                }
            }
        }
        return true;
    }

    private boolean load(String string) throws Exception {
        File file = new File(string);
        if (file.length() == 0L) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BindingReader.load(String) - binding file is empty, returning without trying to load");
            }
            return true;
        }
        return this.load(new FileInputStream(string));
    }
}

