/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.AsymmetricBinding;
import com.ibm.ws.wssecurity.admin.PolicyValidation;
import com.ibm.ws.wssecurity.admin.PolicyValidationConstants;
import com.ibm.ws.wssecurity.admin.SymmetricBinding;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.QNameAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

abstract class BindingAssertion
implements PolicyAttributesConstants,
PolicyValidationConstants {
    private static PolicyValidation instance = new PolicyValidation();
    private static TraceComponent tc = Tr.register(BindingAssertion.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private String _name = null;
    private List _algorithmSuite = new ArrayList();
    private List _layout = new ArrayList();
    protected boolean _includeTimestamp = false;

    BindingAssertion() {
    }

    static BindingAssertion getInstance(String string, NestedPolicyType nestedPolicyType, boolean bl) {
        BindingAssertion bindingAssertion = null;
        if ("AsymmetricBinding".equals(string)) {
            bindingAssertion = new AsymmetricBinding();
        } else if ("SymmetricBinding".equals(string)) {
            bindingAssertion = new SymmetricBinding();
        } else {
            Tr.warning(tc, "CWWSI9002W", (Object)new Object[]{string, "Top level assertions"});
            return null;
        }
        bindingAssertion.parsePolicy(nestedPolicyType.getPolicy(), bl);
        bindingAssertion.setName(string);
        return bindingAssertion;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    abstract void parsePolicy(Policy var1, boolean var2);

    void parseObject(JAXBElement jAXBElement) {
        Object t = jAXBElement.getValue();
        if (t instanceof QNameAssertionType) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse include time stamp");
            }
            if ("IncludeTimestamp".equals(jAXBElement.getName().getLocalPart())) {
                this._includeTimestamp = true;
            }
        } else if (t instanceof NestedPolicyType) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse algorithm suite and layout");
            }
            String string = jAXBElement.getName().getLocalPart();
            NestedPolicyType nestedPolicyType = (NestedPolicyType)jAXBElement.getValue();
            List<Object> list = nestedPolicyType.getPolicy().getPolicyOrAllOrExactlyOne();
            Object object2 = null;
            for (Object object2 : list) {
                if (object2 instanceof JAXBElement) {
                    JAXBElement jAXBElement2 = (JAXBElement)object2;
                    String string2 = jAXBElement2.getName().getLocalPart();
                    if ("AlgorithmSuite".equals(string)) {
                        this._algorithmSuite.add(string2);
                        continue;
                    }
                    if (!"Layout".equals(string)) continue;
                    this._layout.add(string2);
                    continue;
                }
                Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{object2.getClass().getName(), this._name});
            }
        } else {
            Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{t.getClass().getName(), this._name});
        }
    }

    AttributeList getAttributes() {
        AttributeList attributeList = new AttributeList();
        if (!this._algorithmSuite.isEmpty()) {
            AttributeList attributeList2 = new AttributeList();
            Iterator iterator = this._algorithmSuite.iterator();
            while (iterator.hasNext()) {
                attributeList2.add(new Attribute((String)iterator.next(), "true"));
            }
            attributeList.add(new Attribute("AlgorithmSuite", attributeList2));
        }
        if (!this._layout.isEmpty()) {
            attributeList.add(new Attribute("Layout", this._layout.get(0)));
        }
        if (this._includeTimestamp) {
            attributeList.add(new Attribute("IncludeTimestamp", "true"));
        }
        return attributeList;
    }
}

