/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.admin.PolicyValidationConstants;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class AttributesValidation
implements PolicyAttributesConstants,
PolicyValidationConstants {
    private List invalidValueList = new ArrayList();
    private List invalidNameList = new ArrayList();
    private List invalidIDList = new ArrayList();
    private List duplicateSCTList = new ArrayList();
    private List duplicateBindingList = new ArrayList();
    private List duplicateXpathValueList = new ArrayList();
    private List duplicateHeaderValueList = new ArrayList();
    private static TraceComponent tc = Tr.register(AttributesValidation.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.wssecurity.admin.resources.wssadminmsgs", Locale.getDefault());
    protected String className = this.getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";

    public boolean validateProperties(Properties properties) throws Exception {
        this.validateSingleBinding(properties);
        Properties properties2 = new Properties();
        Properties properties3 = new Properties();
        this.splitSCTProps(properties, properties2, properties3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateProperties, before validateNames: nonSctProps=" + properties3);
            Tr.debug(tc, "validateProperties, before validationNames: sctProps=" + properties2);
        }
        this.validatePropertyNames(properties3);
        this.validateSCTPropertyNames(properties2);
        this.validateXPathAndHeaderValue(properties3, properties2);
        this.reportErrors();
        return this.invalidValueList.isEmpty() && this.invalidNameList.isEmpty() && this.invalidIDList.isEmpty() && this.duplicateSCTList.isEmpty() && this.duplicateBindingList.isEmpty() && this.duplicateXpathValueList.isEmpty() && this.duplicateHeaderValueList.isEmpty();
    }

    public void reportErrors() {
        this.printErrorForList(this.invalidValueList, "CWWSI9013W");
        this.printErrorForList(this.invalidNameList, "CWWSI9014W");
        this.printErrorForList(this.invalidIDList, "CWWSI9015W");
        this.printErrorForList(this.duplicateSCTList, "CWWSI9018W");
        this.printErrorForList(this.duplicateBindingList, "CWWSI9012W");
        this.printErrorForList(this.duplicateXpathValueList, "CWWSI9029W");
        this.printErrorForList(this.duplicateHeaderValueList, "CWWSI9030W");
    }

    private void printErrorForList(List list, String string) {
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Tr.warning(tc, string, (Object)new Object[]{list.get(i)});
            }
        }
    }

    public void validatePropertyNames(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        String string = null;
        StringTokenizer stringTokenizer = null;
        ArrayList<String> arrayList = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringTokenizer = new StringTokenizer(string, ".");
            arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            this.validateOneProperty(properties, string, arrayList);
        }
    }

    public void validateSCTPropertyNames(Properties properties) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration<Object> enumeration = properties.keys();
        String string = null;
        String string2 = null;
        StringTokenizer stringTokenizer = null;
        ArrayList<String> arrayList = null;
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = properties.getProperty(string);
            stringTokenizer = new StringTokenizer(string, ".");
            arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            if (arrayList.size() >= 3 && "SymmetricBinding".equals((String)arrayList.get(0))) {
                hashMap.put((String)arrayList.get(1), "SymmetricBinding." + (String)arrayList.get(1));
            }
            if (hashMap.size() > 1) break;
            if (arrayList.size() < 3) {
                this.invalidNameList.add(string + "=" + string2);
                properties.remove(string);
                continue;
            }
            if (!("SymmetricBinding".equals((String)arrayList.get(0)) && AttributesValidation.isSupported((String)arrayList.get(1), symbinding_supportedTokens) && "SecureConversationToken".equals((String)arrayList.get(2)))) {
                this.invalidNameList.add(string + "=" + string2);
                properties.remove(string);
                continue;
            }
            if (arrayList.size() == 3) {
                this.handleNonLeafProperty(properties, string, string2);
                continue;
            }
            if (arrayList.size() == 4) {
                string3 = (String)arrayList.get(3);
                if ("IncludeToken".equals(string3)) {
                    if (AttributesValidation.isSupported(string2, includeToken_supportedValues)) continue;
                    this.invalidValueList.add(string + "=" + string2);
                    properties.remove(string);
                    continue;
                }
                if ("Issuer".equals(string3) || "BootstrapPolicy".equals(string3)) {
                    this.handleNonLeafProperty(properties, string, string2);
                    continue;
                }
                if (AttributesValidation.isSupported(string3, sct_supportedSubAssertions) || AttributesValidation.isSupported(string3, sct_derivedKeyAssertions)) continue;
                this.invalidNameList.add(string + "=" + string2);
                properties.remove(string);
                continue;
            }
            if (arrayList.size() <= 4) continue;
            string3 = (String)arrayList.get(3);
            if ("BootstrapPolicy".equals(string3)) {
                this.validateBootstrap(properties, string);
                continue;
            }
            if ("Issuer".equals(string3) && "Address".equals((String)arrayList.get(4))) continue;
            this.invalidNameList.add(string + "=" + string2);
            properties.remove(string);
        }
        if (hashMap.size() > 1) {
            enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                string2 = properties.getProperty(string);
                this.duplicateSCTList.add(string + "=" + string2);
            }
            properties.clear();
        }
    }

    private void validateBootstrap(Properties properties, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateBootstrap, name=" + string);
        }
        String string2 = string.substring(string.indexOf("BootstrapPolicy") + "BootstrapPolicy".length() + 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.validateOneProperty(properties, string, arrayList);
    }

    private void validateOneProperty(Properties properties, String string, List list) {
        String string2 = (String)list.get(0);
        if ("AsymmetricBinding".equals(string2)) {
            this.validateBindingProps(properties, string, list, asymbinding_supportedTokens, false);
        } else if ("SymmetricBinding".equals(string2)) {
            this.validateBindingProps(properties, string, list, symbinding_supportedTokens, true);
        } else if ("Wss10".equals(string2)) {
            this.validateWssOrTrustProps(properties, string, list, wss10_supportedAssertions);
        } else if ("Wss11".equals(string2)) {
            this.validateWssOrTrustProps(properties, string, list, wss11_supportedAssertions);
        } else if ("Trust10".equals(string2)) {
            this.validateWssOrTrustProps(properties, string, list, trust10_supportedAssertions);
        } else if ("SupportingTokens".equals(string2)) {
            this.validateSupportingTokens(properties, string, list, supportingTokens_supportedSubTokens);
        } else if ("EncryptionProtection".equals(string2)) {
            this.validateProtection(properties, string, list, supportedEncryptedProtections);
        } else if ("SignatureProtection".equals(string2)) {
            this.validateProtection(properties, string, list, supportedSignedProtections);
        } else {
            this.invalidNameList.add(string + "=" + properties.getProperty(string));
            properties.remove(string);
        }
    }

    private void validateSingleBinding(Properties properties) {
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.startsWith("AsymmetricBinding")) {
                bl = true;
                continue;
            }
            if (!string.startsWith("SymmetricBinding")) continue;
            bl2 = true;
        }
        Enumeration<Object> enumeration2 = properties.keys();
        while (enumeration2.hasMoreElements()) {
            string = (String)enumeration2.nextElement();
            if ((!bl || !string.startsWith("SymmetricBinding")) && (!bl2 || !string.startsWith("AsymmetricBinding"))) continue;
            this.duplicateBindingList.add(string + "=" + properties.getProperty(string));
            properties.remove(string);
        }
    }

    private void validateWssOrTrustProps(Properties properties, String string, List list, String[] stringArray) {
        String string2 = properties.getProperty(string);
        if (list.size() == 1) {
            this.handleNonLeafProperty(properties, string, string2);
        } else if (list.size() == 2 && !AttributesValidation.isSupported((String)list.get(1), stringArray)) {
            this.invalidNameList.add(string + "=" + string2);
            properties.remove(string);
        }
    }

    private void validateBindingProps(Properties properties, String string, List list, String[] stringArray, boolean bl) {
        String string2 = properties.getProperty(string);
        if (list.size() == 1) {
            this.handleNonLeafProperty(properties, string, string2);
        } else if (list.size() == 2) {
            if ("Layout".equals((String)list.get(1))) {
                if (!AttributesValidation.isSupported(string2, layout_supportedValues)) {
                    this.invalidValueList.add(string + "=" + string2);
                    properties.remove(string);
                }
            } else if (!"IncludeTimestamp".equals((String)list.get(1))) {
                this.handleNonLeafProperty(properties, string, string2);
            }
        } else if (list.size() == 3) {
            if ("AlgorithmSuite".equals((String)list.get(1))) {
                if (!AttributesValidation.isSupported((String)list.get(2), algorithmSuite_supportedValues)) {
                    this.invalidNameList.add(string + "=" + string2);
                    properties.remove(string);
                }
            } else {
                this.handleNonLeafProperty(properties, string, string2);
            }
        } else if (list.size() > 5 || list.size() == 5 && !((String)list.get(2)).startsWith("CustomToken")) {
            this.invalidNameList.add(string + "=" + string2);
            properties.remove(string);
        } else {
            if (list.size() >= 2 && !AttributesValidation.isSupported((String)list.get(1), stringArray)) {
                this.invalidNameList.add(string + "=" + string2);
                properties.remove(string);
                return;
            }
            if (list.size() >= 3) {
                String[] stringArray2 = null;
                stringArray2 = bl ? symbinding_supportedSubTokens : asymbinding_supportedSubTokens;
                String string3 = (String)list.get(2);
                if (!bl && string3.startsWith("X509Token")) {
                    if (!this.isAttrWithNumberValid(string3, "X509Token")) {
                        this.invalidNameList.add(string + "=" + string2);
                        properties.remove(string);
                    }
                } else if (!bl && string3.startsWith("CustomToken")) {
                    if (!this.isAttrWithNumberValid(string3, "CustomToken")) {
                        this.invalidNameList.add(string + "=" + string2);
                        properties.remove(string);
                    }
                } else if (!AttributesValidation.isSupported(string3, stringArray2)) {
                    this.invalidNameList.add(string + "=" + string2);
                    properties.remove(string);
                    return;
                }
            }
            if (list.size() >= 4) {
                this.validateSubAssertion(properties, string, list);
            }
        }
    }

    private void validateProtection(Properties properties, String string, List list, String[] stringArray) {
        String string2;
        String string3 = properties.getProperty(string);
        if (list.size() >= 2 && !(string2 = (String)list.get(1)).startsWith("request:") && !string2.startsWith("response:")) {
            this.invalidIDList.add(string + "=" + string3);
            properties.remove(string);
        }
        if (list.size() <= 3) {
            this.handleNonLeafProperty(properties, string, string3);
        }
        if (list.size() > 5) {
            this.invalidNameList.add(string + "=" + string3);
            properties.remove(string);
        } else if (list.size() == 5 && !string.contains("Header")) {
            this.invalidNameList.add(string + "=" + string3);
            properties.remove(string);
        } else {
            if (list.size() >= 3 && !AttributesValidation.isSupported((String)list.get(2), stringArray)) {
                this.invalidNameList.add(string + "=" + string3);
                properties.remove(string);
                return;
            }
            if (list.size() == 4) {
                string2 = (String)list.get(2);
                String string4 = (String)list.get(3);
                if (string2.endsWith("Parts")) {
                    if (!string4.equals("Body")) {
                        this.invalidNameList.add(string + "=" + string3);
                        properties.remove(string);
                    }
                } else if (string2.endsWith("Elements")) {
                    if (!string4.equals("XPathVersion") && !this.isAttrWithNumberValid(string4, "XPath")) {
                        this.invalidNameList.add(string + "=" + string3);
                        properties.remove(string);
                    }
                } else {
                    this.invalidNameList.add(string + "=" + string3);
                    properties.remove(string);
                }
            } else if (list.size() == 5) {
                string2 = (String)list.get(2);
                String string5 = (String)list.get(3);
                String string6 = (String)list.get(4);
                if (string2.endsWith("Parts")) {
                    if (!this.isAttrWithNumberValid(string5, "Header") || !string6.equals("Name") && !string6.equals("Namespace")) {
                        this.invalidNameList.add(string + "=" + string3);
                        properties.remove(string);
                    }
                } else {
                    this.invalidNameList.add(string + "=" + string3);
                    properties.remove(string);
                }
            }
        }
    }

    private boolean isAttrWithNumberValid(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isAttrWithNumberValid, attrName=" + string + ", prefix=" + string2);
        }
        if (!string.startsWith(string2 + "_")) {
            return false;
        }
        try {
            String string3 = string.substring(string.lastIndexOf(95) + 1);
            int n = new Integer(string3);
            if (n < 0) {
                Tr.warning(tc, "CWWSI9023W", (Object)new Object[]{string});
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                exception.printStackTrace();
            }
            FFDCFilter.processException(exception, this.className + ".isAttrWithNumberValid", FFDC_ID_1);
            Tr.error(tc, "CWWSI9033E", exception);
            return false;
        }
    }

    private void validateSupportingTokens(Properties properties, String string, List list, String[] stringArray) {
        String string2 = properties.getProperty(string);
        if (list.size() >= 2) {
            String string3 = (String)list.get(1);
            if (!string3.startsWith("request:") && !string3.startsWith("response:")) {
                this.invalidIDList.add(string + "=" + string2);
                properties.remove(string);
            }
        } else if (list.size() <= 3) {
            this.handleNonLeafProperty(properties, string, string2);
        } else if (list.size() > 5 || list.size() > 4 && !"CustomToken".equals((String)list.get(2))) {
            this.invalidNameList.add(string + "=" + string2);
            properties.remove(string);
        } else {
            if (list.size() >= 3 && !AttributesValidation.isSupported((String)list.get(2), stringArray)) {
                this.invalidNameList.add(string + "=" + string2);
                properties.remove(string);
                return;
            }
            if (list.size() >= 4) {
                this.validateSubAssertion(properties, string, list);
            }
        }
    }

    private void validateSubAssertion(Properties properties, String string, List list) {
        if (list.size() != 4) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateSubAssertion is called in a wrong way, tokenList size is " + list);
            }
            return;
        }
        String string2 = (String)list.get(2);
        String string3 = (String)list.get(3);
        String string4 = properties.getProperty(string);
        if ("IncludeToken".equals(string3)) {
            if (!AttributesValidation.isSupported(string4, includeToken_supportedValues)) {
                this.invalidValueList.add(string + "=" + string4);
                properties.remove(string);
            }
        } else if ("UsernameToken".equals(string2)) {
            if (!AttributesValidation.isSupported(string3, usernameToken_supportedSubAssertions)) {
                this.invalidNameList.add(string + "=" + string4);
                properties.remove(string);
            }
        } else if (string2.startsWith("X509Token")) {
            if (!AttributesValidation.isSupported(string3, x509Token_supportedSubAssertions)) {
                this.invalidNameList.add(string + "=" + string4);
                properties.remove(string);
            }
        } else if (string2.startsWith("CustomToken")) {
            if (!AttributesValidation.isSupported(string3, customToken_supportedSubAssertions)) {
                this.invalidNameList.add(string + "=" + string4);
                properties.remove(string);
            } else if (list.size() == 4) {
                this.handleNonLeafProperty(properties, string, string4);
            }
        } else if ("LTPAToken".equals(string2) || "LTPAPropagationToken".equals(string2)) {
            this.invalidNameList.add(string + "=" + string4);
            properties.remove(string);
        } else {
            this.invalidNameList.add(string + "=" + string4);
            properties.remove(string);
        }
    }

    public static boolean isSupported(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private void handleNonLeafProperty(Properties properties, String string, String string2) {
        if (!"".equals(string2)) {
            this.invalidValueList.add(string + "=" + string2);
            properties.remove(string);
        }
    }

    private void splitSCTProps(Properties properties, Properties properties2, Properties properties3) {
        if (properties == null || properties.size() == 0) {
            return;
        }
        Enumeration<Object> enumeration = properties.keys();
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.contains("SecureConversationToken")) {
                properties2.put(string, properties.getProperty(string));
                continue;
            }
            properties3.put(string, properties.getProperty(string));
        }
    }

    private void validateXPathAndHeaderValue(Properties properties, Properties properties2) {
        try {
            Properties properties3 = new Properties();
            properties3.putAll((Map<?, ?>)properties);
            properties3.putAll((Map<?, ?>)properties2);
            Enumeration<?> enumeration = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string = null;
            enumeration = properties3.propertyNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.contains("XPath_")) {
                    arrayList.add(string);
                    continue;
                }
                if (!string.contains("Header_") || !string.endsWith("Namespace")) continue;
                arrayList2.add(string);
            }
            this.validateXPathValue(properties3, properties, properties2, arrayList);
            this.validateHeaderValue(properties3, properties, properties2, arrayList2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void validateXPathValue(Properties properties, Properties properties2, Properties properties3, ArrayList arrayList) {
        int n = -1;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        StringBuffer stringBuffer = null;
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            string2 = (String)arrayList.get(i);
            n = string2.lastIndexOf("_");
            string = string2.substring(0, n + 1);
            string4 = properties.getProperty(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateXPathValue, key=" + string2 + ", prefix=" + string + ", value=" + string4);
            }
            for (int j = i + 1; j < arrayList.size(); ++j) {
                string3 = (String)arrayList.get(j);
                if (!string3.startsWith(string) || !string4.equals(string5 = properties.getProperty(string3))) continue;
                stringBuffer = new StringBuffer();
                stringBuffer.append(string2).append("=").append(string4).append(", ").append(string3).append("=").append(string5);
                this.duplicateXpathValueList.add(stringBuffer.toString());
                if (string2.contains("SecureConversationToken")) {
                    properties3.remove(string2);
                    properties3.remove(string3);
                    continue block0;
                }
                properties2.remove(string2);
                properties2.remove(string3);
                continue block0;
            }
        }
    }

    private void validateHeaderValue(Properties properties, Properties properties2, Properties properties3, ArrayList arrayList) {
        int n = -1;
        String string = null;
        StringBuffer stringBuffer = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            string2 = (String)arrayList.get(i);
            string3 = properties.getProperty(string2);
            n = string2.lastIndexOf("_");
            string = string2.substring(0, n + 1);
            n = string2.lastIndexOf(".Namespace");
            string6 = string2.substring(0, n + 1) + "Name";
            string8 = properties.getProperty(string6);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateHeaderValue, validate header value: prefix=" + string + ", nameKey=" + string6 + ", nameValue=" + string8 + ", namespaceKey=" + string2 + ", namespaceValue=" + string3);
            }
            for (int j = i + 1; j < arrayList.size(); ++j) {
                string4 = (String)arrayList.get(j);
                if (!string4.startsWith(string) || !string3.equals(string5 = properties.getProperty(string4))) continue;
                n = string4.lastIndexOf(".Namespace");
                string7 = string4.substring(0, n + 1) + "Name";
                string9 = properties.getProperty(string7);
                if ((string8 != null || string9 != null) && (string8 == null || !string8.equals(string9))) continue;
                stringBuffer = new StringBuffer();
                stringBuffer.append(string2).append("=").append(string3);
                if (string8 != null) {
                    stringBuffer.append(", ").append(string6).append("=").append(string8);
                }
                stringBuffer.append(", ").append(string4).append("=").append(string5);
                if (string9 != null) {
                    stringBuffer.append(", ").append(string7).append("=").append(string9);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "validateHeaderValue, find duplicate value for " + stringBuffer.toString());
                }
                this.duplicateHeaderValueList.add(stringBuffer.toString());
                if (string2.contains("SecureConversationToken")) {
                    properties3.remove(string2);
                    properties3.remove(string4);
                    properties3.remove(string6);
                    properties3.remove(string7);
                    continue block0;
                }
                properties2.remove(string2);
                properties2.remove(string4);
                properties2.remove(string6);
                properties2.remove(string7);
                continue block0;
            }
        }
    }

    private String getFormattedMessage(ResourceBundle resourceBundle, String string, Object[] objectArray, String string2) {
        String string3 = null;
        try {
            String string4 = resourceBundle.getString(string);
            string3 = string4 == null ? string2 : MessageFormat.format(string4, objectArray);
        }
        catch (Throwable throwable) {
            string3 = string2;
        }
        return string3;
    }
}

