/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.BindingAssertion;
import com.ibm.ws.wssecurity.admin.Token;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class AsymmetricBinding
extends BindingAssertion
implements PolicyAttributesConstants {
    private static TraceComponent tc = Tr.register(AsymmetricBinding.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private List _initiatorSignatureToken = new ArrayList();
    private List _initiatorEncryptionToken = new ArrayList();
    private List _recipientSignatureToken = new ArrayList();
    private List _recipientEncryptionToken = new ArrayList();
    private List _initiatorToken = new ArrayList();
    private List _recipientToken = new ArrayList();
    public static final String[] supportedTokes = new String[]{"InitiatorSignatureToken", "InitiatorEncryptionToken", "RecipientSignatureToken", "RecipientEncryptionToken", "InitiatorToken", "RecipientToken"};

    AsymmetricBinding() {
    }

    void parsePolicy(Policy policy, boolean bl) {
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        for (Object object : list) {
            if (object instanceof JAXBElement) {
                String string = ((JAXBElement)object).getName().getLocalPart();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parsePolicy, name=" + string);
                }
                if ("IncludeTimestamp".equals(string) || "AlgorithmSuite".equals(string) || "Layout".equals(string)) {
                    this.parseObject((JAXBElement)object);
                    continue;
                }
                NestedPolicyType nestedPolicyType = (NestedPolicyType)((JAXBElement)object).getValue();
                if (nestedPolicyType == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "parsePolicy, NestedPolicy is null");
                    }
                    return;
                }
                List<Object> list2 = nestedPolicyType.getPolicy().getPolicyOrAllOrExactlyOne();
                Object object2 = null;
                Iterator<Object> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    if (!(object2 instanceof JAXBElement)) {
                        Tr.warning(tc, "CWWSI9001W", (Object)new Object[]{iterator.next().getClass().getName(), "Top level assertions"});
                        continue;
                    }
                    JAXBElement jAXBElement = (JAXBElement)object2;
                    Token token = Token.getInstance(jAXBElement.getName().getLocalPart(), (TokenAssertionType)jAXBElement.getValue());
                    if ("InitiatorSignatureToken".equals(string)) {
                        this._initiatorSignatureToken.add(token);
                        continue;
                    }
                    if ("InitiatorEncryptionToken".equals(string)) {
                        this._initiatorEncryptionToken.add(token);
                        continue;
                    }
                    if ("RecipientSignatureToken".equals(string)) {
                        this._recipientSignatureToken.add(token);
                        continue;
                    }
                    if ("RecipientEncryptionToken".equals(string)) {
                        this._recipientEncryptionToken.add(token);
                        continue;
                    }
                    if ("InitiatorToken".equals(string)) {
                        this._initiatorToken.add(token);
                        continue;
                    }
                    if ("RecipientToken".equals(string)) {
                        this._recipientToken.add(token);
                        continue;
                    }
                    Tr.warning(tc, "CWWSI9002W", (Object)new Object[]{string, "AsymmetricBinding"});
                }
                continue;
            }
            if (object instanceof Policy) continue;
            Tr.warning(tc, "CWWSI9002W", (Object)new Object[]{object.getClass().getName(), "AsymmetricBinding"});
        }
    }

    private AttributeList getAttributeListForTokenType(List list) {
        int n = 0;
        int n2 = 0;
        Token token = null;
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < list.size(); ++i) {
            token = (Token)list.get(i);
            if ("X509Token".equals(token._name)) {
                attributeList.addAll(token.getAttributes(n++));
                continue;
            }
            if ("CustomToken".equals(token._name)) {
                attributeList.addAll(token.getAttributes(n2++));
                continue;
            }
            attributeList.addAll(token.getAttributes(-1));
        }
        return attributeList;
    }

    AttributeList getAttributes() {
        AttributeList attributeList = new AttributeList();
        if (!this._initiatorSignatureToken.isEmpty()) {
            attributeList.add(new Attribute("InitiatorSignatureToken", this.getAttributeListForTokenType(this._initiatorSignatureToken)));
        }
        if (!this._initiatorEncryptionToken.isEmpty()) {
            attributeList.add(new Attribute("InitiatorEncryptionToken", this.getAttributeListForTokenType(this._initiatorEncryptionToken)));
        }
        if (!this._recipientSignatureToken.isEmpty()) {
            attributeList.add(new Attribute("RecipientSignatureToken", this.getAttributeListForTokenType(this._recipientSignatureToken)));
        }
        if (!this._recipientEncryptionToken.isEmpty()) {
            attributeList.add(new Attribute("RecipientEncryptionToken", this.getAttributeListForTokenType(this._recipientEncryptionToken)));
        }
        if (!this._initiatorToken.isEmpty()) {
            attributeList.add(new Attribute("InitiatorToken", this.getAttributeListForTokenType(this._initiatorToken)));
        }
        if (!this._recipientToken.isEmpty()) {
            attributeList.add(new Attribute("RecipientToken", this.getAttributeListForTokenType(this._recipientToken)));
        }
        attributeList.addAll(super.getAttributes());
        return attributeList;
    }
}

