/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.urimap.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.jaxws.urimap.security.SecurityHelper;
import com.ibm.ws.wsaddressing.jaxws.urimap.security.SecurityHelperImpl;
import com.ibm.ws.wsaddressing.jaxws.urimap.security.SecurityInfo;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.UserDataConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;

public abstract class SecurityHelperFactory {
    private static final String CLASSNAME = SecurityHelperFactory.class.getName();
    private static TraceComponent _tc = Tr.register(CLASSNAME, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);

    public static SecurityHelper createSecurityHelper(MetaData metaData, DeployedObject deployedObject) {
        block22: {
            if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                Tr.entry(_tc, "createSecurityHelper", new Object[]{metaData, deployedObject});
            }
            try {
                Object object;
                WebAppConfig webAppConfig = null;
                WebApp webApp = null;
                if (metaData instanceof WebModuleMetaData && deployedObject instanceof DeployedModule && deployedObject.getModuleFile().isWARFile()) {
                    object = (DeployedModule)deployedObject;
                    webApp = (WebApp)object.getDeploymentDescriptor();
                    webAppConfig = ((WebModuleMetaData)((Object)metaData)).getConfiguration();
                }
                if (webApp == null || webAppConfig == null) {
                    if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                        Tr.exit(_tc, "createSecurityHelper", null);
                    }
                    return null;
                }
                object = webApp.getConstraints();
                EList eList = null;
                SecurityHelperImpl securityHelperImpl = new SecurityHelperImpl();
                if (object != null && SecurityContext.isSecurityEnabled()) {
                    if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                        Tr.debug(_tc, "createSecurityHelper found some Contraints");
                    }
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                            Tr.debug(_tc, "createSecurityHelper processing a Contraints");
                        }
                        SecurityConstraint securityConstraint = (SecurityConstraint)iterator.next();
                        UserDataConstraint userDataConstraint = securityConstraint.getUserDataConstraint();
                        int n = 0;
                        if (userDataConstraint != null) {
                            if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                                Tr.debug(_tc, "createSecurityHelper found a UserConstraint");
                            }
                            if (userDataConstraint.isSetTransportGuarantee()) {
                                n = userDataConstraint.getTransportGuarantee().getValue();
                            }
                        }
                        eList = securityConstraint.getWebResourceCollections();
                        Iterator iterator2 = eList.iterator();
                        while (iterator2.hasNext()) {
                            if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                                Tr.debug(_tc, "createSecurityHelper processing a WebResourceCollection");
                            }
                            WebResourceCollection webResourceCollection = (WebResourceCollection)iterator2.next();
                            EList eList2 = webResourceCollection.getHttpMethod();
                            Iterator iterator3 = eList2.iterator();
                            boolean bl = false;
                            if (eList2.size() == 0) {
                                bl = true;
                            }
                            while (iterator3.hasNext() && !bl) {
                                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "createSecurityHelper processing an HTTPMethod");
                                }
                                if (1 != ((HTTPMethodTypeEnum)iterator3.next()).getValue()) continue;
                                bl = true;
                            }
                            if (!bl) continue;
                            EList eList3 = webResourceCollection.getUrlPattern();
                            SecurityInfo securityInfo = new SecurityInfo(eList3, n);
                            securityHelperImpl.addSecurityInfo(securityInfo);
                            if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) continue;
                            Tr.debug(_tc, "createSecurityHelper found POST - added SInfo to Table");
                        }
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "createSecurityHelper", securityHelperImpl);
                }
                return securityHelperImpl;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:167:1.3");
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "createSecurityHelper caught Exception " + exception);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, CLASSNAME, "1:173:1.3");
                if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) break block22;
                Tr.debug(_tc, "createSecurityHelper caught Throwable " + throwable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSecurityHelper", null);
        }
        return null;
    }
}

