/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.urimap.moduledata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.jaxws.urimap.moduledata.ModuleData;
import com.ibm.ws.wsaddressing.jaxws.urimap.moduledata.Prefix;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ModuleDataImpl
implements ModuleData {
    private static TraceComponent TRACE_COMPONENT = Tr.register(ModuleDataImpl.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    public static final String TRANSPORT_HTTP = "http";
    public static final String TRANSPORT_HTTPS = "https";
    public static final String TRANSPORT_JMS = "jms";
    public static final String TRANSPORT_EJB = "ejb";
    private String name;
    private String defaultPrefix;
    private String virtualHostName;
    private String contextRoot;
    private String applicationName;
    private boolean intermediaryPresent = false;
    private List prefixList = new LinkedList();
    private Set virtualHostPorts = new HashSet();
    private Set virtualHostAliases = new HashSet();

    ModuleDataImpl() {
    }

    public boolean isIntermediaryPresent() {
        return this.intermediaryPresent;
    }

    void setVirtualHost(VirtualHost virtualHost) {
        Object object;
        if (virtualHost != null) {
            this.virtualHostName = virtualHost.getName();
            object = virtualHost.getAliases();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2 = (HostAlias)iterator.next();
                this.virtualHostPorts.add(object2.getPort());
                this.virtualHostAliases.add(object2);
            }
        } else {
            this.virtualHostName = "";
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            object = "null";
            if (virtualHost != null) {
                object = virtualHost.getName();
            }
            Tr.debug(TRACE_COMPONENT, "setVirtualHost: for module \"" + this.name + "\" the virtualHost is \"" + (String)object + "\" and its ports are:");
            for (Object object2 : this.virtualHostPorts) {
                Tr.debug(TRACE_COMPONENT, (String)object2);
            }
        }
    }

    boolean addPrefix(Prefix prefix) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addPrefix", prefix);
        }
        boolean bl = false;
        String string = prefix.getHost();
        String string2 = prefix.getPort();
        Iterator iterator = this.virtualHostAliases.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = true;
            HostAlias hostAlias = (HostAlias)iterator.next();
            String string3 = hostAlias.getHostname();
            String string4 = hostAlias.getPort();
            if (!string3.equals("*")) {
                bl2 = string3.equals(string);
            }
            if (bl2 && !string4.equals("*")) {
                bl2 = string4.equals(string2);
            }
            if (!bl2) continue;
            bl = true;
            this.prefixList.add(prefix);
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addPrefix", new Boolean(bl));
        }
        return bl;
    }

    List getPrefixList() {
        if (this.prefixList.size() == 0) {
            this.prefixList.add(new Prefix("", "", ""));
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.prefixList.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((Prefix)iterator.next()).toString());
        }
        return linkedList;
    }

    String getDefaultPrefix() {
        if (this.defaultPrefix == null) {
            this.defaultPrefix = "";
            if (this.prefixList != null) {
                for (Prefix prefix : this.prefixList) {
                    this.defaultPrefix = prefix.toString();
                    if (!prefix.protocol.equals(TRANSPORT_HTTP)) continue;
                    break;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "default http prefix is: " + this.defaultPrefix);
        }
        return this.defaultPrefix;
    }

    void setDefaultPrefix(String string) {
        this.defaultPrefix = string;
    }

    public String getContextRoot() {
        return this.trimSlash(this.contextRoot);
    }

    private String trimSlash(String string) {
        if (string == null) {
            return string;
        }
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    void setContextRoot(String string) {
        this.contextRoot = string;
    }

    void setName(String string) {
        this.name = string;
    }

    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append(this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + "\n");
        stringBuffer.append("applicationName=").append(this.applicationName).append("\n");
        stringBuffer.append("name=").append(this.name).append("\n");
        stringBuffer.append("defaultPrefix=").append(this.defaultPrefix).append("\n");
        stringBuffer.append("virtuaHostName=").append(this.virtualHostName).append("\n");
        stringBuffer.append("contextRoot=").append(this.contextRoot).append("\n");
        stringBuffer.append("prefixList contains:\n");
        Iterator iterator = this.prefixList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t").append(iterator.next()).append("\n");
        }
        stringBuffer.append("virtualHostPorts contains:\n");
        iterator = this.virtualHostPorts.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append("\n");
        }
        return stringBuffer.toString();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    void setApplicationName(String string) {
        this.applicationName = string;
    }

    void setIntermediary(boolean bl) {
        this.intermediaryPresent = bl;
    }

    public String getHTTPPrefix() {
        return this.getDefaultPrefix();
    }

    public String getHTTPSPrefix() {
        String string = null;
        if (this.defaultPrefix != null && this.defaultPrefix.toLowerCase().startsWith("https://")) {
            string = this.defaultPrefix;
        }
        Iterator iterator = this.prefixList.iterator();
        while (iterator.hasNext() && string == null) {
            Prefix prefix = (Prefix)iterator.next();
            String string2 = prefix.getProtocol();
            if ("".equals(string2) || !string2.equals(TRANSPORT_HTTPS)) continue;
            string = prefix.toString();
        }
        return string;
    }
}

