/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.urimap.moduledata;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.webservices.WebModels;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.jaxws.component.WSAddressingComponentImpl;
import com.ibm.ws.wsaddressing.jaxws.urimap.moduledata.MetaDataChannelHelper;
import com.ibm.ws.wsaddressing.jaxws.urimap.moduledata.ModuleData;
import com.ibm.ws.wsaddressing.jaxws.urimap.moduledata.ModuleDataImpl;
import com.ibm.ws.wsaddressing.jaxws.urimap.moduledata.Prefix;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;

public class MetaDataLoader {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.jaxws.urimap.MetaDataLoader";
    private static TraceComponent TRACE_COMPONENT = Tr.register(MetaDataLoader.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private Map nodeHostNames;
    private RepositoryContext appDeployCtx;
    private RepositoryContext applicationContext;
    private RepositoryContext cellContext;
    private List moduleDataList;
    private String earFileLocation;
    private EARFile earFile;
    private ApplicationDeployment appDeployment = null;
    private WebModels webModels = null;
    private List deployedModules;
    private ModuleFile intendedModule = null;

    public MetaDataLoader(RepositoryContext repositoryContext, String string, ModuleFile moduleFile) {
        this.appDeployCtx = repositoryContext;
        this.earFileLocation = string;
        this.nodeHostNames = new HashMap();
        this.moduleDataList = new LinkedList();
        this.intendedModule = moduleFile;
    }

    List getModuleDataList() {
        return this.moduleDataList;
    }

    public ModuleData getModuleData() {
        if (!this.moduleDataList.isEmpty()) {
            return (ModuleData)this.moduleDataList.get(0);
        }
        return null;
    }

    public void cleanup() {
        this.nodeHostNames.clear();
        this.moduleDataList.clear();
        this.deployedModules = null;
        this.appDeployCtx = null;
        this.applicationContext = null;
        this.appDeployment = null;
        this.cellContext = null;
        if (this.earFile != null) {
            this.earFile.close();
        }
    }

    public void load() throws Exception {
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ObjectName objectName = (ObjectName)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    MetaDataLoader.this._load();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException(privilegedActionException, CLASSNAME, "1:173:1.6");
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, CLASSNAME, "1:177:1.6");
        }
    }

    private void _load() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "load");
        }
        RepositoryContext repositoryContext = this.getCellContext();
        List list = this.getDeployedModules();
        EARFile eARFile = this.getEAR(this.applicationContext);
        if (eARFile == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "load: no EARFile found");
            }
            return;
        }
        Application application = eARFile.getDeploymentDescriptor();
        for (int i = 0; i < list.size(); ++i) {
            Module module;
            ModuleDeployment moduleDeployment = (ModuleDeployment)list.get(i);
            Module module2 = module = moduleDeployment.getAltDD() != null ? application.getModuleHavingAltDD(moduleDeployment.getAltDD()) : application.getModule(moduleDeployment.getUri(), null);
            if (module == null) continue;
            ModuleData moduleData = null;
            if (module.isWebModule()) {
                ModuleFile moduleFile = eARFile.getModuleRef(module).getModuleFile();
                if (moduleFile.getAbsolutePath().equals(this.intendedModule.getAbsolutePath())) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "load: calling loadModuleData for web module " + moduleFile.getName());
                    }
                    WebModule webModule = (WebModule)module;
                    moduleData = this.loadModuleData(repositoryContext, eARFile, moduleFile, moduleDeployment, webModule, application.getDisplayName());
                } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "_load: Skipping module - Path does not match that of intended module");
                }
            } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "_load: Skipping non-web module", module);
            }
            if (moduleData == null) continue;
            this.moduleDataList.add(moduleData);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "load");
        }
    }

    private RepositoryContext getApplicationContext() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getApplicationContext");
        }
        if (this.applicationContext == null) {
            this.applicationContext = this.appDeployCtx.getParent();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getApplicationContext", this.applicationContext);
        }
        return this.applicationContext;
    }

    private RepositoryContext getCellContext() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getCellContext");
        }
        if (this.cellContext == null) {
            this.cellContext = this.getApplicationContext().getParent();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getCellContext", this.cellContext);
        }
        return this.cellContext;
    }

    private ApplicationDeployment getApplicationDeploymentFromContext() {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "getApplicationDeploymentFromContext");
            }
            if (this.appDeployment == null) {
                try {
                    Deployment deployment;
                    Resource resource;
                    ResourceSet resourceSet;
                    if (this.appDeployCtx != null && (resourceSet = this.appDeployCtx.getResourceSet()) != null && (resource = resourceSet.getResource(URI.createURI("deployment.xml"), true)) != null && (deployment = (Deployment)resource.getContents().get(0)) != null) {
                        this.appDeployment = (ApplicationDeployment)deployment.getDeployedObject();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, CLASSNAME, "1:309:1.6");
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break block6;
                    Tr.debug(TRACE_COMPONENT, "getApplicationDeploymentFromContext: caught exception ", exception);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getApplicationDeploymentFromContext", this.appDeployment);
        }
        return this.appDeployment;
    }

    private List getDeployedModules() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getDeployedModules");
        }
        if (this.deployedModules == null) {
            block8: {
                try {
                    ApplicationDeployment applicationDeployment = this.getApplicationDeploymentFromContext();
                    if (applicationDeployment != null) {
                        this.deployedModules = applicationDeployment.getModules();
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, CLASSNAME, "1:339:1.6");
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break block8;
                    Tr.debug(TRACE_COMPONENT, "getDeploymentModules: caught exception ", exception);
                }
            }
            if (this.deployedModules == null) {
                this.deployedModules = new ArrayList();
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "getDeploymentModules: no modules found");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getDeployedModules", this.deployedModules);
        }
        return this.deployedModules;
    }

    private EARFile getEAR(RepositoryContext repositoryContext) {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "getEAR");
            }
            if (this.earFile == null) {
                ApplicationDeployment applicationDeployment = this.getApplicationDeploymentFromContext();
                if (applicationDeployment == null) {
                    return this.earFile;
                }
                boolean bl = applicationDeployment.isZeroBinaryCopy();
                boolean bl2 = applicationDeployment.isZeroEarCopy();
                if (bl || bl2) {
                    return this.earFile;
                }
                if (this.earFileLocation == null) {
                    String string = repositoryContext.getName();
                    String string2 = repositoryContext.getURI();
                    Properties properties = ConfigRepositoryFactory.getConfigRepository().getConfig();
                    String string3 = (String)properties.get("was.repository.root");
                    this.earFileLocation = string3 + File.separator + string2 + File.separator + string;
                }
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "ear file location: ", this.earFileLocation);
                }
                try {
                    CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore").getEFactoryInstance();
                    ArchiveOptions archiveOptions = new ArchiveOptions();
                    archiveOptions.setIsReadOnly(true);
                    archiveOptions.setUseJavaReflection(false);
                    this.earFile = commonarchiveFactory.openEARFile(archiveOptions, this.earFileLocation);
                    this.earFile.getDeploymentDescriptor();
                    this.earFile.getBindings();
                    this.earFile.getExtensions();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, CLASSNAME, "1:421:1.6");
                    if (this.earFile == null) break block9;
                    this.earFile.close();
                    this.earFile = null;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getEAR");
        }
        return this.earFile;
    }

    private ModuleData loadModuleData(RepositoryContext repositoryContext, EARFile eARFile, ModuleFile moduleFile, ModuleDeployment moduleDeployment, WebModule webModule, String string) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "loadModuleData for ", moduleDeployment.getUri() + ", application: " + eARFile.getName());
        }
        ModuleDataImpl moduleDataImpl = new ModuleDataImpl();
        moduleDataImpl.setApplicationName(eARFile.getName());
        moduleDataImpl.setName(moduleDeployment.getUri());
        this.extractVirtualHost(repositoryContext, eARFile, webModule, moduleDataImpl);
        this.extractPrefixes(repositoryContext, moduleDeployment, moduleDataImpl);
        this.extractMappedPrefix(moduleFile, moduleDeployment, moduleDataImpl, string);
        this.extractContextRoot(webModule, moduleDataImpl);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "loadModuleData", moduleDataImpl);
        }
        return moduleDataImpl;
    }

    private void extractMappedPrefix(ModuleFile moduleFile, ModuleDeployment moduleDeployment, ModuleDataImpl moduleDataImpl, String string) throws Exception {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "extractMappedPrefix", new Object[]{moduleFile, moduleDeployment, moduleDataImpl});
        }
        HashMap hashMap = null;
        Repository repository = (Repository)WsServiceRegistry.getService(this, Repository.class);
        String string2 = System.getProperty("file.separator");
        ConfigRoot configRoot = repository.getConfigRoot();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(configRoot.getConfigRootPath());
        stringBuffer.append(this.appDeployCtx.getURI());
        stringBuffer.append(string2);
        stringBuffer.append(moduleDeployment.getUri());
        stringBuffer.append(string2);
        stringBuffer.append("WEB-INF");
        stringBuffer.append(string2);
        stringBuffer.append("URLPrefixMap");
        String string3 = stringBuffer.toString();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "extractMappedPrefix: used filename " + string3);
        }
        if (string3 != null && ((File)(object = new File(string3))).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream((File)object);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                hashMap = (HashMap)objectInputStream.readObject();
                fileInputStream.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:518:1.6");
            }
        }
        if (hashMap != null && !hashMap.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "extractMappedPrefix: found persistent prefix " + hashMap.toString());
            }
            object = null;
            object = (String)hashMap.get("http");
            if (object != null && !((String)object).equals("")) {
                moduleDataImpl.setDefaultPrefix((String)object);
            }
            if ((object = (String)hashMap.get("https")) != null && !((String)object).equals("")) {
                moduleDataImpl.setDefaultPrefix((String)object);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "extractMappedPrefix: found no persistent prefix store.");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "extractMappedPrefix");
        }
    }

    private void extractContextRoot(WebModule webModule, ModuleDataImpl moduleDataImpl) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "extractContextRoot", new Object[]{webModule, moduleDataImpl});
        }
        if (webModule == null) {
            moduleDataImpl.setContextRoot("");
        } else {
            String string = webModule.getContextRoot();
            moduleDataImpl.setContextRoot(string);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "extractContextRoot");
        }
    }

    private void extractPrefixes(RepositoryContext repositoryContext, ModuleDeployment moduleDeployment, ModuleDataImpl moduleDataImpl) {
        EList eList;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "extractPrefixes", new Object[]{repositoryContext, moduleDeployment, moduleDataImpl});
        }
        if ((eList = moduleDeployment.getTargetMappings()).isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "extractPrefixes", "targets.isEmpty() returned true");
            }
        } else {
            Prefix prefix2;
            List list = MetaDataChannelHelper.getProxyPortList(repositoryContext);
            for (Prefix prefix2 : list) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Prefix " + prefix2.toString() + " is a known proxy.  Setting intermediary flag");
                }
                moduleDataImpl.setIntermediary(true);
                moduleDataImpl.addPrefix(prefix2);
            }
            DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)eList.get(0);
            prefix2 = deploymentTargetMapping.getTarget();
            Server server = WSAddressingComponentImpl.getServer();
            if (prefix2 instanceof ServerTarget) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Deployment Target " + prefix2.getName() + " is a server");
                }
                if (server.getName().equals(prefix2.getName())) {
                    this.addPortListFromHelperToModuleData(repositoryContext, moduleDataImpl);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Deployment Target (cluster)" + prefix2.getName() + " is a cluster");
                }
                if (server.getClusterName().equals(prefix2.getName())) {
                    this.addPortListFromHelperToModuleData(repositoryContext, moduleDataImpl);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "extractPrefixes");
        }
    }

    private void addPortListFromHelperToModuleData(RepositoryContext repositoryContext, ModuleDataImpl moduleDataImpl) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addPortListFromHelperToModuleData", new Object[]{repositoryContext, moduleDataImpl});
        }
        List list = MetaDataChannelHelper.getWebContainerPortList(repositoryContext);
        for (Prefix prefix : list) {
            moduleDataImpl.addPrefix(prefix);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addPortListFromHelperToModuleData");
        }
    }

    private void extractVirtualHost(RepositoryContext repositoryContext, EARFile eARFile, WebModule webModule, ModuleDataImpl moduleDataImpl) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "extractVirtualHost", new Object[]{repositoryContext, eARFile, webModule, moduleDataImpl});
        }
        if (webModule == null) {
            moduleDataImpl.setVirtualHost(null);
        } else {
            if (this.webModels == null) {
                this.webModels = new WebModels();
            }
            WebAppBinding webAppBinding = this.webModels.getWebAppBinding(this.appDeployCtx, eARFile, webModule);
            String string = webAppBinding.getVirtualHostName();
            ResourceSet resourceSet = repositoryContext.getResourceSet();
            Tr.debug(TRACE_COMPONENT, "extractVirtualHost", resourceSet.getResources());
            Resource resource = resourceSet.getResource(URI.createURI("virtualhosts.xml"), true);
            if (resource != null) {
                EList eList = resource.getContents();
                for (VirtualHost virtualHost : eList) {
                    if (!virtualHost.getName().equals(string)) continue;
                    moduleDataImpl.setVirtualHost(virtualHost);
                    break;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "extractVirtualHost");
        }
    }
}

