/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.sm.validation.ValidationHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.jaxws.Constants;
import com.ibm.ws.wsaddressing.jaxws.urimap.EndpointMapImpl;
import com.ibm.ws.wsaddressing.jaxws.urimap.moduledata.MetaDataLoader;
import com.ibm.ws.wsaddressing.jaxws.urimap.moduledata.ModuleData;
import com.ibm.ws.wsaddressing.jaxws.urimap.security.SecurityHelper;
import com.ibm.ws.wsaddressing.jaxws.urimap.security.SecurityHelperFactory;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.runtime.JAXWSMetaDataListener;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class EndpointMappingListener
implements JAXWSMetaDataListener {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointMappingListener.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private static final String CLASSNAME = EndpointMappingListener.class.toString();
    EndpointMapImpl endpointInformationMap = null;

    public EndpointMappingListener(EndpointMapImpl endpointMapImpl) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "EndpointMappingListener<init>", endpointMapImpl);
        }
        this.endpointInformationMap = endpointMapImpl;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "EndpointMappingListener<init>");
        }
    }

    private OMElement createFragileIdentityReferenceParameter() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createFragileIdentityReferenceParameter");
        }
        OMElement oMElement = null;
        try {
            Server server = (Server)WsServiceRegistry.getService(this, Server.class);
            final String string = server.getCellName();
            final String string2 = server.getNodeName();
            final String string3 = server.getName();
            if (string != null && string2 != null && string3 != null) {
                String string4;
                Identity identity = (Identity)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return IdentityMapping.getServerInstanceCluster(string, string2, string3);
                    }
                });
                if (identity != null && (string4 = this.getClusterIdAsString(identity)) != null) {
                    OMElement oMElement2 = OMAbstractFactory.getOMFactory().createOMElement(Constants.FRAGILE_ROUTING_KEY.getLocalPart(), Constants.FRAGILE_ROUTING_KEY.getNamespaceURI(), Constants.FRAGILE_ROUTING_KEY.getPrefix());
                    oMElement2.setText(string4);
                    oMElement = OMAbstractFactory.getOMFactory().createOMElement(Constants.ROUTING_INFORMATION_QNAME.getLocalPart(), Constants.ROUTING_INFORMATION_QNAME.getNamespaceURI(), Constants.ROUTING_INFORMATION_QNAME.getPrefix());
                    oMElement.addChild(oMElement2);
                }
            } else if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "createFragileIdentityReferenceParameter", "Unable to obtain clusterId. Either the cellName or the nodeName or the processName was null. cellName=" + string + " nodeName=" + string2 + " processName=" + string3);
            }
        }
        catch (Exception exception) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "createFragileIdentityReferenceParameter", "Unable to obtain clusterId :" + exception);
            }
            FFDCFilter.processException(exception, CLASSNAME, "1:136:1.11");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createFragileIdentityReferenceParameter", oMElement);
        }
        return oMElement;
    }

    private String getClusterIdAsString(Identity identity) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getClusterIdAsString", identity);
        }
        String string = null;
        ClusterService clusterService = ClusterServiceFactory.getClusterService();
        if (clusterService == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.error(TRACE_COMPONENT, "Unable to acquire cluster Service");
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getClusterIdAsString", null);
            }
            return null;
        }
        string = clusterService.identityToString(identity);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getClusterIdAsString", string);
        }
        return string;
    }

    private OMElement createVirtualHostName(String string) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createVirtualHostName", new Object[]{string});
        }
        OMElement oMElement = OMAbstractFactory.getOMFactory().createOMElement(Constants.VIRTUAL_HOST_QNAME.getLocalPart(), Constants.VIRTUAL_HOST_QNAME.getNamespaceURI(), Constants.VIRTUAL_HOST_QNAME.getPrefix());
        oMElement.setText(string);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createVirtualHostName");
        }
        return oMElement;
    }

    private OMElement createIntermediaryPresent() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createIntermediaryPresent");
        }
        OMElement oMElement = OMAbstractFactory.getOMFactory().createOMElement(Constants.INTERMEDIARY_PRESENT_QNAME.getLocalPart(), Constants.INTERMEDIARY_PRESENT_QNAME.getNamespaceURI(), Constants.INTERMEDIARY_PRESENT_QNAME.getPrefix());
        oMElement.setText("1");
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createIntermediaryPresent");
        }
        return oMElement;
    }

    public void metaDataCreated(MetaDataEvent metaDataEvent, ConfigurationContext configurationContext) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "metaDataCreated", new Object[]{metaDataEvent, configurationContext});
        }
        configurationContext.setProperty("disableAddressingForOutMessages", Boolean.TRUE);
        MetaData metaData = metaDataEvent.getMetaData();
        DeployedObject deployedObject = metaDataEvent.getDeployedObject();
        ModuleFile moduleFile = deployedObject.getModuleFile();
        SecurityHelper securityHelper = SecurityHelperFactory.createSecurityHelper(metaData, deployedObject);
        if (securityHelper != null) {
            ModuleMetaData moduleMetaData;
            String string;
            ModuleData moduleData;
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "metaDataCreated", "Security info generated for module: " + securityHelper);
            }
            if ((moduleData = this.loadModuleData(string = (moduleMetaData = (ModuleMetaData)metaData).getApplicationMetaData().getName(), moduleFile)) != null) {
                this.processEndpoints(string, configurationContext, securityHelper, moduleData);
                OMElement oMElement = this.createFragileIdentityReferenceParameter();
                configurationContext.setProperty("fragileIdentityReferenceParameter", oMElement);
                OMElement oMElement2 = this.createVirtualHostName(moduleData.getVirtualHostName());
                configurationContext.setProperty("virtualHostNameReferenceParameter", oMElement2);
                OMElement oMElement3 = this.createIntermediaryPresent();
                configurationContext.setProperty("intermediaryPresentReferenceParameter", oMElement3);
            } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "No ModuleData generated");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "metaDataCreated");
        }
    }

    private void processEndpoints(String string, ConfigurationContext configurationContext, SecurityHelper securityHelper, ModuleData moduleData) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "processEndpoints", new Object[]{string, configurationContext, securityHelper, moduleData});
        }
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        HashMap hashMap = axisConfiguration.getServices();
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AxisService axisService = (AxisService)hashMap.get(iterator.next());
            this.endpointInformationMap.addEndpointMapping(string, axisService, securityHelper, moduleData);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "processEndpoints");
        }
    }

    public void metaDataDestroyed(MetaDataEvent metaDataEvent, ConfigurationContext configurationContext) {
        MetaData metaData;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "metaDataCreated", new Object[]{metaDataEvent, configurationContext});
        }
        if ((metaData = metaDataEvent.getMetaData()) instanceof ModuleMetaData) {
            ModuleMetaData moduleMetaData = (ModuleMetaData)metaData;
            String string = moduleMetaData.getApplicationMetaData().getName();
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "metaDataDestroyed", "Module contains JAX-WS Web Services. Removing Mappings. ApplicationName=" + string);
            }
            this.endpointInformationMap.removeEndpointMappings(string);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "metaDataCreated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleData loadModuleData(String string, ModuleFile moduleFile) {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "loadModuleData", new Object[]{string, moduleFile});
        }
        String string2 = null;
        try {
            string2 = moduleFile.getEARFile().getAbsolutePath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException(fileNotFoundException, CLASSNAME, "1:320:1.11");
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "Can not determine path to binary", fileNotFoundException);
            }
            return null;
        }
        MetaDataLoader metaDataLoader = null;
        WorkSpace workSpace = null;
        try {
            ModuleData moduleData;
            workSpace = EndpointMappingListener.getWorkSpace();
            String string3 = AdminServiceFactory.getAdminService().getCellName();
            object = "cells/" + string3 + "/applications/" + string + ".ear/deployments/" + string;
            RepositoryContext repositoryContext = workSpace.findContext((String)object);
            if (repositoryContext == null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "Can not determine appDeployContext");
                }
                ModuleData moduleData2 = null;
                return moduleData2;
            }
            metaDataLoader = new MetaDataLoader(repositoryContext, string2, moduleFile);
            metaDataLoader.load();
            ModuleData moduleData3 = moduleData = metaDataLoader.getModuleData();
            return moduleData3;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, CLASSNAME, "1:357:1.11");
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "can not load the application metadata", exception);
            }
        }
        finally {
            block24: {
                try {
                    if (metaDataLoader != null) {
                        metaDataLoader.cleanup();
                    }
                    WorkSpaceManager workSpaceManager = WorkSpaceManagerFactory.getManager();
                    object = ValidationHelper.getRegistry();
                    object.release(workSpace);
                    workSpaceManager.removeWorkSpace(workSpace.getUserName());
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, CLASSNAME, "1:372:1.11");
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break block24;
                    Tr.debug(TRACE_COMPONENT, "unable to clean up resources", exception);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "loadModuleData");
        }
        return null;
    }

    private static WorkSpace getWorkSpace() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getWorkSpace");
        }
        WorkSpace workSpace = null;
        int n = 0;
        while (workSpace == null) {
            block7: {
                Properties properties = new Properties();
                String string = "sample" + System.currentTimeMillis();
                properties.setProperty("workspace.user.id", string);
                try {
                    WorkSpaceManager workSpaceManager = WorkSpaceManagerFactory.getManager();
                    workSpace = workSpaceManager.getWorkSpace(properties);
                }
                catch (Exception exception) {
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break block7;
                    Tr.debug(TRACE_COMPONENT, "Unable to create a unique workspace", exception);
                }
            }
            if (workSpace != null) continue;
            ++n;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "Woken from sleep", interruptedException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getWorkSpace", workSpace);
        }
        return workSpace;
    }
}

