/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.wsaddressing.integration.EndpointMap;
import com.ibm.ws.wsaddressing.jaxws.urimap.EndpointData;
import com.ibm.ws.wsaddressing.jaxws.urimap.EndpointKey;
import com.ibm.ws.wsaddressing.jaxws.urimap.moduledata.ModuleData;
import com.ibm.ws.wsaddressing.jaxws.urimap.security.SecurityHelper;
import com.ibm.wsspi.wsaddressing.URIGenerationException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisService;

public class EndpointMapImpl
implements EndpointMap {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointMapImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private HashMap applicationNameToKeyListMap = new HashMap();
    private HashMap applicationNameToDataListMap = new HashMap();
    private HashMap keyToDataListMap = new HashMap();

    public synchronized void addEndpointMapping(String string, AxisService axisService, SecurityHelper securityHelper, ModuleData moduleData) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addEndpointMapping", new Object[]{string, axisService, securityHelper, moduleData});
        }
        EndpointData endpointData = new EndpointData(string, axisService, securityHelper, moduleData);
        this.putToListMap(string, endpointData.getEndpointKey(), this.applicationNameToKeyListMap);
        this.putToListMap(string, endpointData, this.applicationNameToDataListMap);
        this.putToListMap(endpointData.getEndpointKey(), endpointData, this.keyToDataListMap);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addEndpointMapping");
        }
    }

    public synchronized void removeEndpointMappings(String string) {
        List list;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeEndpointMappings", string);
        }
        if ((list = (List)this.applicationNameToDataListMap.get(string)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "removeEndpointMappings", "No pairs found");
            }
            return;
        }
        for (EndpointData endpointData : list) {
            List list2 = (List)this.keyToDataListMap.get(endpointData.getEndpointKey());
            list2.remove(endpointData);
            if (!list2.isEmpty()) continue;
            this.keyToDataListMap.remove(endpointData.getEndpointKey());
        }
        this.applicationNameToKeyListMap.remove(string);
        this.applicationNameToDataListMap.remove(string);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeEndpointMappings");
        }
    }

    private EndpointData getEndpointData(String string, QName qName) throws MultipleEntriesException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getEndpointInformation", new Object[]{string, qName});
        }
        EndpointData endpointData = null;
        QName qName2 = new QName(qName.getNamespaceURI(), string);
        List list = (List)this.keyToDataListMap.get(new EndpointKey(qName2, qName.getLocalPart()));
        if (list == null || list.size() == 0) {
            endpointData = null;
        } else if (list.size() == 1) {
            try {
                endpointData = (EndpointData)list.get(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "getEndpointInformation", "List modified by another thread so will return null.");
                }
            }
        } else {
            MultipleEntriesException multipleEntriesException = new MultipleEntriesException();
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getEndpointInformation", multipleEntriesException);
            }
            throw multipleEntriesException;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getEndpointInformation", endpointData);
        }
        return endpointData;
    }

    private void putToListMap(Object object, Object object2, Map map) {
        ArrayList<Object> arrayList;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "putToListMap", new Object[]{object, object2, map});
        }
        if ((arrayList = (ArrayList<Object>)map.get(object)) == null) {
            arrayList = new ArrayList<Object>();
            map.put(object, arrayList);
        }
        arrayList.add(object2);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "putToListMap");
        }
    }

    public URI getSOAPAddressForPort(String string, QName qName) throws URIGenerationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPAddressForPort", new Object[]{string, qName});
        }
        try {
            EndpointData endpointData = this.getEndpointData(string, qName);
            if (endpointData == null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getSOAPAddressForPort", null);
                }
                return null;
            }
            URI uRI = new URI(endpointData.getAddress());
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getSOAPAddressForPort", uRI);
            }
            return uRI;
        }
        catch (MultipleEntriesException multipleEntriesException) {
            throw new URIGenerationException(nls.getFormattedMessage("MULTIPLE_ENTRIES_CWWAR0201", new Object[]{string, qName}, null), multipleEntriesException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new URIGenerationException(nls.getString("INVALID_ADDRESS_CWWAR0200"), uRISyntaxException);
        }
    }

    public String getVirtualHostForPort(String string, QName qName) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getVirtualHostForPort", new Object[]{string, qName});
        }
        try {
            EndpointData endpointData = this.getEndpointData(string, qName);
            if (endpointData == null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getVirtualHostForPort", null);
                }
                return null;
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getVirtualHostForPort", endpointData.getVirtualHost());
            }
            return endpointData.getVirtualHost();
        }
        catch (MultipleEntriesException multipleEntriesException) {
            throw new EndpointReferenceCreationException(nls.getFormattedMessage("MULTIPLE_ENTRIES_CWWAR0201", new Object[]{string, qName}, null), multipleEntriesException);
        }
    }

    public boolean intermediaryConfigured(String string, QName qName) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "intermediaryConfigured", new Object[]{string, qName});
        }
        try {
            EndpointData endpointData = this.getEndpointData(string, qName);
            if (endpointData == null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "intermediaryConfigured", Boolean.FALSE);
                }
                return false;
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "intermediaryConfigured", new Boolean(endpointData.isIntermediaryPresent()));
            }
            return endpointData.isIntermediaryPresent();
        }
        catch (MultipleEntriesException multipleEntriesException) {
            throw new EndpointReferenceCreationException(nls.getFormattedMessage("MULTIPLE_ENTRIES_CWWAR0201", new Object[]{string, qName}, null), multipleEntriesException);
        }
    }

    public boolean workLoadManaged(String string, QName qName) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "workLoadManaged", new Object[]{string, qName});
        }
        EndpointData endpointData = null;
        try {
            endpointData = this.getEndpointData(string, qName);
        }
        catch (MultipleEntriesException multipleEntriesException) {
            throw new EndpointReferenceCreationException(nls.getFormattedMessage("MULTIPLE_ENTRIES_CWWAR0201", new Object[]{string, qName}, null), multipleEntriesException);
        }
        if (endpointData == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "workLoadManaged", Boolean.FALSE);
            }
            return true;
        }
        boolean bl = endpointData.isWLMable();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "workLoadManaged", bl);
        }
        return bl;
    }

    private class MultipleEntriesException
    extends Exception {
        private MultipleEntriesException() {
        }
    }
}

