/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.jaxws.urimap.EndpointKey;
import com.ibm.ws.wsaddressing.jaxws.urimap.moduledata.ModuleData;
import com.ibm.ws.wsaddressing.jaxws.urimap.security.SecurityHelper;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;

class EndpointData {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointData.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    String appName;
    String address;
    EndpointKey ek;
    private AxisService axisService;
    private SecurityHelper securityHelper;
    private ModuleData moduleData;

    EndpointData(String string, AxisService axisService, SecurityHelper securityHelper, ModuleData moduleData) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "EndpointData<init>", new Object[]{string, axisService, securityHelper, moduleData});
        }
        this.appName = string;
        this.axisService = axisService;
        this.securityHelper = securityHelper;
        this.moduleData = moduleData;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "EndpointData<init>");
        }
    }

    String getApplicationName() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getApplicationName", this.appName);
        }
        return this.appName;
    }

    synchronized EndpointKey getEndpointKey() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getEndpointKey");
        }
        if (this.ek == null) {
            QName qName = Axis2Utils.getServiceQName(this.axisService);
            String string = Axis2Utils.getPortName(this.axisService);
            this.ek = new EndpointKey(qName, string);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getEndpointKey", this.ek);
        }
        return this.ek;
    }

    synchronized String getAddress() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAddress");
        }
        if (this.address == null) {
            this.buildEndpointURL();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAddress", this.address);
        }
        return this.address;
    }

    String getVirtualHost() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getVirtualHost", this.moduleData.getVirtualHostName());
        }
        return this.moduleData.getVirtualHostName();
    }

    boolean isIntermediaryPresent() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "isIntermediaryPresent", new Boolean(this.moduleData.isIntermediaryPresent()));
        }
        return this.moduleData.isIntermediaryPresent();
    }

    synchronized boolean isWLMable() {
        boolean bl;
        Parameter parameter;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isWLMable");
        }
        if ((parameter = this.axisService.getParameter("preventWLM")) == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "isWLMable", "Retrieved parameter not found.  Return true");
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "isWLMable", "true");
            }
            return true;
        }
        String string = (String)parameter.getValue();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "isWLMable", "Retrieved parameter " + string);
        }
        boolean bl2 = bl = Boolean.valueOf(string) == false;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isWLMable", bl);
        }
        return bl;
    }

    private void buildEndpointURL() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "buildEndpointURL");
        }
        this.address = "";
        String string = this.moduleData.getHTTPPrefix();
        String string2 = this.moduleData.getHTTPSPrefix();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "buildEndpointURL: Prefixes", new Object[]{string, string2});
        }
        boolean bl = string != null;
        boolean bl2 = string2 != null;
        String string3 = this.moduleData.getContextRoot();
        String string4 = Axis2Utils.getURLPattern(this.axisService);
        boolean bl3 = this.securityHelper.isSSLEnabled(string4);
        if (bl && !bl3) {
            this.address = string + "/" + string3 + string4;
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "buildEndpointURL: HTTP URL Constructed", this.address);
            }
        }
        if (bl2 && bl3) {
            this.address = string2 + "/" + string3 + string4;
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "buildEndpointURL: HTTPS URL Constructed", this.address);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "buildEndpointURL");
        }
    }
}

